/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ClusteredHashTableEntry
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    static final long serialVersionUID = 5L;
    public static final int ENTRY_AUTHORITY_ANY_USER = 1;
    public static final int ENTRY_AUTHORITY_LAST_USER = 0;
    public static final int DUPLICATE_KEY_UPDATE = 1;
    public static final int DUPLICATE_KEY_FAIL = 0;
    public static final int ENTRY_STATUS_CONSISTENT = 0;
    public static final int ENTRY_STATUS_INCONSISTENT = 1;
    public static final int MAX_USER_DATA_LENGTH = 61000;
    private byte[] userData_ = null;
    private int entryAuthority_ = 0;
    private int entryStatus_ = 0;
    private int entryUpdateOption_ = 0;
    private byte[] key_ = null;
    private int timeToLive_ = 60;
    private String ownerProfile_ = null;
    private String modifyProfile_ = null;
    private transient PropertyChangeSupport changes_ = new PropertyChangeSupport(this);

    public ClusteredHashTableEntry() {
    }

    public ClusteredHashTableEntry(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException("key");
        }
        if (byArray2 == null) {
            throw new NullPointerException("userData");
        }
        if (byArray2.length < 1 || byArray2.length > 61000) {
            throw new ExtendedIllegalArgumentException("userData", 1);
        }
        if (n != -1 && n < 60 || n > 31536000) {
            throw new ExtendedIllegalArgumentException("timeToLive", 4);
        }
        if (n2 != 0 && n2 != 1) {
            throw new ExtendedIllegalArgumentException("entryAuthority", 2);
        }
        if (n3 != 0 && n3 != 1) {
            throw new ExtendedIllegalArgumentException("updateOption", 2);
        }
        this.key_ = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.key_, 0, byArray.length);
        this.userData_ = new byte[byArray2.length];
        System.arraycopy(byArray2, 0, this.userData_, 0, byArray2.length);
        this.timeToLive_ = n;
        this.entryAuthority_ = n2;
        this.entryUpdateOption_ = n3;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public int getEntryStatus() {
        return this.entryStatus_;
    }

    public int getEntryAuthority() {
        return this.entryAuthority_;
    }

    public byte[] getKey() {
        if (this.key_ == null) {
            return null;
        }
        byte[] byArray = new byte[this.key_.length];
        System.arraycopy(this.key_, 0, byArray, 0, this.key_.length);
        return byArray;
    }

    public int getTimeToLive() {
        return this.timeToLive_;
    }

    public int getUpdateOption() {
        return this.entryUpdateOption_;
    }

    public byte[] getUserData() {
        if (this.userData_ == null) {
            return null;
        }
        byte[] byArray = new byte[this.userData_.length];
        System.arraycopy(this.userData_, 0, byArray, 0, this.userData_.length);
        return byArray;
    }

    public String getOwnerProfile() {
        if (this.ownerProfile_ == null) {
            return null;
        }
        return this.ownerProfile_;
    }

    protected void setOwnerProfile(String string) {
        if (string == null) {
            throw new NullPointerException("usr");
        }
        if (string.length() == 0 || string.length() > 10) {
            throw new ExtendedIllegalArgumentException("usr", 1);
        }
        this.ownerProfile_ = string;
    }

    public String getModifiedProfile() {
        if (this.modifyProfile_ == null) {
            return null;
        }
        return this.modifyProfile_;
    }

    protected void setModifiedProfile(String string) {
        if (string == null) {
            throw new NullPointerException("usr");
        }
        if (string.length() == 0 || string.length() > 10) {
            throw new ExtendedIllegalArgumentException("usr", 1);
        }
        this.modifyProfile_ = string;
    }

    private void initializeTransient() {
        this.changes_ = new PropertyChangeSupport(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void setEntryAuthority(int n) {
        if (n != 0 && n != 1) {
            throw new ExtendedIllegalArgumentException("entryAuthority", 2);
        }
        int n2 = this.entryAuthority_;
        this.entryAuthority_ = n;
        this.changes_.firePropertyChange("entryAuthority", new Integer(n2), new Integer(this.entryAuthority_));
    }

    public void setKey(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("key");
        }
        if (byArray.length != 16) {
            throw new ExtendedIllegalArgumentException("key", 1);
        }
        byte[] byArray2 = this.key_;
        this.key_ = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.key_, 0, byArray.length);
        this.changes_.firePropertyChange("key", byArray2, this.key_);
    }

    protected void setEntryStatus(int n) {
        if (n != 0 && n != 1) {
            throw new ExtendedIllegalArgumentException("entryStatus", 4);
        }
        this.entryStatus_ = n;
    }

    public void setTimeToLive(int n) {
        if (n != -1 && n < 60 || n > 31536000) {
            throw new ExtendedIllegalArgumentException("timeToLive", 4);
        }
        int n2 = this.timeToLive_;
        this.timeToLive_ = n;
        this.changes_.firePropertyChange("timeToLive", new Integer(n2), new Integer(this.timeToLive_));
    }

    public void setUpdateOption(int n) {
        if (n != 0 && n != 1) {
            throw new ExtendedIllegalArgumentException("updateOption", 2);
        }
        int n2 = this.entryUpdateOption_;
        this.entryUpdateOption_ = n;
        this.changes_.firePropertyChange("updateOption", new Integer(n2), new Integer(this.entryUpdateOption_));
    }

    public void setUserData(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("userData");
        }
        if (byArray.length < 1 || byArray.length > 61000) {
            throw new ExtendedIllegalArgumentException("userData", 1);
        }
        byte[] byArray2 = this.userData_;
        this.userData_ = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.userData_, 0, byArray.length);
        this.changes_.firePropertyChange("userData", byArray2, this.userData_);
    }
}

