/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSDataStream;
import com.ibm.as400.access.IFSFileDescriptorImpl;
import com.ibm.as400.access.IFSFileDescriptorImplRemote;
import com.ibm.as400.access.IFSFileInputStreamImpl;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.IFSListAttrsRep;
import com.ibm.as400.access.IFSListAttrsReq;
import com.ibm.as400.access.IFSOpenRep;
import com.ibm.as400.access.IFSOpenReq;
import com.ibm.as400.access.IFSReturnCodeRep;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

class IFSFileInputStreamImplRemote
extends InputStream
implements IFSFileInputStreamImpl {
    private IFSFileDescriptorImplRemote fd_;
    private transient ConvTableReader reader_;
    private static final boolean DEBUG = false;

    IFSFileInputStreamImplRemote() {
    }

    public int available() throws IOException {
        return (int)Math.min(this.availableLong(), Integer.MAX_VALUE);
    }

    private long availableLong() throws IOException {
        this.open();
        return this.getFileSize() - this.fd_.getFileOffset();
    }

    public void close() throws IOException {
        this.fd_.close0();
    }

    public void connectAndOpen() throws AS400SecurityException, IOException {
        this.fd_.connect();
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.fd_ != null) {
                this.fd_.finalize0();
            }
        }
        catch (Throwable throwable) {
            Trace.log(2, "Error during finalization.", throwable);
        }
        finally {
            super.finalize();
        }
    }

    private final long getFileSize() throws IOException {
        long l = 0L;
        IFSListAttrsRep iFSListAttrsRep = null;
        IFSListAttrsReq iFSListAttrsReq = new IFSListAttrsReq(this.fd_.getFileHandle());
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.getServer().sendAndReceive(iFSListAttrsReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted.", (Throwable)interruptedException);
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        boolean bl = false;
        do {
            if (iFSListAttrsRep == null && clientAccessDataStream instanceof IFSListAttrsRep) {
                iFSListAttrsRep = (IFSListAttrsRep)clientAccessDataStream;
            } else if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                int n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n != 18) {
                    Trace.log(2, "IFSReturnCodeRep return code ", n);
                    throw new ExtendedIOException(n);
                }
            } else {
                Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
                throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
            }
            bl = ((IFSDataStream)clientAccessDataStream).isEndOfChain();
            if (bl) continue;
            try {
                clientAccessDataStream = (ClientAccessDataStream)this.fd_.getServer().receive(iFSListAttrsReq.getCorrelation());
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                this.fd_.connectionDropped(connectionDroppedException);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted", (Throwable)interruptedException);
                throw new InterruptedIOException(interruptedException.getMessage());
            }
        } while (!bl);
        if (iFSListAttrsRep == null) {
            Trace.log(2, "No reply available.");
            throw new InternalErrorException(6);
        }
        l = iFSListAttrsRep.getSize(this.fd_.serverDatastreamLevel_);
        return l;
    }

    public IFSKey lock(int n) throws IOException {
        this.open();
        try {
            return this.fd_.lock(n);
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new IOException(aS400SecurityException.getMessage());
        }
    }

    public void open() throws IOException {
        if (this.fd_.isOpen_) {
            return;
        }
        if (!this.fd_.isOpenAllowed_) {
            Trace.log(2, "Attempting to re-open a closed stream.");
            throw new ConnectionDroppedException(3);
        }
        String string = this.fd_.getPath();
        if (string.length() == 0) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        try {
            this.fd_.connect();
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, "Access to byte stream server on '" + this.fd_.getSystem().getSystemName() + "' denied.", (Throwable)aS400SecurityException);
            throw new ExtendedIOException(5);
        }
        byte[] byArray = this.fd_.getConverter().stringToByteArray(string);
        IFSOpenReq iFSOpenReq = new IFSOpenReq(byArray, this.fd_.preferredServerCCSID_, this.fd_.preferredServerCCSID_, 1, ~this.fd_.getShareOption(), 0, 8, this.fd_.serverDatastreamLevel_);
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.getServer().sendAndReceive(iFSOpenReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted", (Throwable)interruptedException);
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        if (!(clientAccessDataStream instanceof IFSOpenRep)) {
            if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                int n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n == 2 || n == 3) {
                    Trace.log(2, this.fd_.getPath() + " not found.");
                    throw new FileNotFoundException(this.fd_.getPath());
                }
                if (n == 1) {
                    Trace.log(2, "IFSReturnCodeRep return code ", n);
                    throw new ExtendedIOException(32);
                }
                Trace.log(2, "IFSReturnCodeRep return code ", n);
                throw new ExtendedIOException(n);
            }
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        IFSOpenRep iFSOpenRep = (IFSOpenRep)clientAccessDataStream;
        this.fd_.setOpen(true, iFSOpenRep.getFileHandle());
        this.fd_.setOpenAllowed(false);
    }

    public int read() throws IOException {
        int n;
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray, 0, 1);
        if (n2 == 1) {
            n = byArray[0];
            n &= 0xFF;
        } else {
            n = -1;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.open();
        try {
            return this.fd_.read(byArray, n, n2);
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new IOException(aS400SecurityException.getMessage());
        }
    }

    public String readText(int n) throws IOException {
        String string = "";
        this.open();
        if (this.reader_ == null) {
            this.reader_ = new ConvTableReader((InputStream)this, this.fd_.getCCSID());
        }
        if ((string = this.reader_.read(n)) == null) {
            string = "";
        }
        return string;
    }

    public void setFD(IFSFileDescriptorImpl iFSFileDescriptorImpl) {
        this.fd_ = IFSFileDescriptorImplRemote.castImplToImplRemote(iFSFileDescriptorImpl);
    }

    public long skip(long l) throws IOException {
        long l2;
        this.open();
        long l3 = this.availableLong();
        if (l > l3) {
            this.fd_.incrementFileOffset(l3);
            l2 = l3;
        } else {
            this.fd_.incrementFileOffset(l);
            l2 = l;
        }
        return l2;
    }

    public void unlock(IFSKey iFSKey) throws IOException {
        this.open();
        try {
            this.fd_.unlock(iFSKey);
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new IOException(aS400SecurityException.getMessage());
        }
    }

    static {
        AS400Server.addReplyStream((DataStream)new IFSListAttrsRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSOpenRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSReturnCodeRep(), 0);
    }
}

