/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjAllocTermCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjLivenessTermCCTNode;

public class RuntimeMemoryCCTNode
implements Cloneable,
RuntimeCCTNode {
    protected static final int TYPE_RuntimeMemoryCCTNode = 1;
    protected static final int TYPE_RuntimeObjAllocTermCCTNode = 2;
    protected static final int TYPE_RuntimeObjLivenessTermCCTNode = 3;
    Object children;
    int methodId;

    protected RuntimeMemoryCCTNode() {
    }

    RuntimeMemoryCCTNode(int n) {
        this.methodId = n;
    }

    public int getType() {
        return 1;
    }

    public static RuntimeMemoryCCTNode create(int n) {
        switch (n) {
            case 1: {
                return new RuntimeMemoryCCTNode();
            }
            case 2: {
                return new RuntimeObjAllocTermCCTNode();
            }
            case 3: {
                return new RuntimeObjLivenessTermCCTNode();
            }
        }
        throw new IllegalArgumentException("Illegal type: " + n);
    }

    public RuntimeMemoryCCTNode addNewChild(int n) {
        if (this.children == null) {
            this.children = new RuntimeMemoryCCTNode(n);
            return (RuntimeMemoryCCTNode)this.children;
        }
        RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray = this.addChildEntry();
        RuntimeMemoryCCTNode runtimeMemoryCCTNode = new RuntimeMemoryCCTNode(n);
        runtimeMemoryCCTNodeArray[runtimeMemoryCCTNodeArray.length - 1] = runtimeMemoryCCTNode;
        return runtimeMemoryCCTNode;
    }

    public void attachNodeAsChild(RuntimeMemoryCCTNode runtimeMemoryCCTNode) {
        if (this.children == null) {
            this.children = runtimeMemoryCCTNode;
        } else {
            RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray = this.addChildEntry();
            runtimeMemoryCCTNodeArray[runtimeMemoryCCTNodeArray.length - 1] = runtimeMemoryCCTNode;
        }
    }

    public Object clone() {
        try {
            RuntimeMemoryCCTNode runtimeMemoryCCTNode = (RuntimeMemoryCCTNode)super.clone();
            if (this.children != null) {
                if (this.children instanceof RuntimeMemoryCCTNode) {
                    runtimeMemoryCCTNode.children = ((RuntimeMemoryCCTNode)this.children).clone();
                } else {
                    RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray = (RuntimeMemoryCCTNode[])this.children;
                    runtimeMemoryCCTNode.children = new RuntimeMemoryCCTNode[runtimeMemoryCCTNodeArray.length];
                    for (int i = 0; i < runtimeMemoryCCTNodeArray.length; ++i) {
                        ((RuntimeMemoryCCTNode[])runtimeMemoryCCTNode.children)[i] = (RuntimeMemoryCCTNode)runtimeMemoryCCTNodeArray[i].clone();
                    }
                }
            }
            return runtimeMemoryCCTNode;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clone should never fail");
        }
    }

    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        this.methodId = dataInputStream.readInt();
        int n = dataInputStream.readInt();
        if (n == 0) {
            this.children = null;
        } else if (n == 1) {
            int n2 = dataInputStream.readInt();
            this.children = RuntimeMemoryCCTNode.create(n2);
            ((RuntimeMemoryCCTNode)this.children).readFromStream(dataInputStream);
        } else {
            RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray = new RuntimeMemoryCCTNode[n];
            for (int i = 0; i < n; ++i) {
                int n3 = dataInputStream.readInt();
                runtimeMemoryCCTNodeArray[i] = RuntimeMemoryCCTNode.create(n3);
                runtimeMemoryCCTNodeArray[i].readFromStream(dataInputStream);
            }
            this.children = runtimeMemoryCCTNodeArray;
        }
    }

    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.methodId);
        if (this.children == null) {
            dataOutputStream.writeInt(0);
        } else if (this.children instanceof RuntimeMemoryCCTNode) {
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(((RuntimeMemoryCCTNode)this.children).getType());
            ((RuntimeMemoryCCTNode)this.children).writeToStream(dataOutputStream);
        } else {
            RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray = (RuntimeMemoryCCTNode[])this.children;
            dataOutputStream.writeInt(runtimeMemoryCCTNodeArray.length);
            for (int i = 0; i < runtimeMemoryCCTNodeArray.length; ++i) {
                dataOutputStream.writeInt(runtimeMemoryCCTNodeArray[i].getType());
                runtimeMemoryCCTNodeArray[i].writeToStream(dataOutputStream);
            }
        }
    }

    private RuntimeMemoryCCTNode[] addChildEntry() {
        assert (this.children != null);
        if (this.children instanceof RuntimeMemoryCCTNode) {
            RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray = new RuntimeMemoryCCTNode[2];
            runtimeMemoryCCTNodeArray[0] = (RuntimeMemoryCCTNode)this.children;
            this.children = runtimeMemoryCCTNodeArray;
            return runtimeMemoryCCTNodeArray;
        }
        RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray = (RuntimeMemoryCCTNode[])this.children;
        RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray2 = new RuntimeMemoryCCTNode[runtimeMemoryCCTNodeArray.length + 1];
        System.arraycopy(runtimeMemoryCCTNodeArray, 0, runtimeMemoryCCTNodeArray2, 0, runtimeMemoryCCTNodeArray.length);
        this.children = runtimeMemoryCCTNodeArray2;
        return runtimeMemoryCCTNodeArray2;
    }
}

