/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.tar;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs.provider.tar.TarBuffer;
import org.apache.commons.vfs.provider.tar.TarEntry;

class TarInputStream
extends FilterInputStream {
    private TarBuffer buffer;
    private TarEntry currEntry;
    private boolean debug;
    private int entryOffset;
    private int entrySize;
    private boolean hasHitEOF;
    private byte[] oneBuf;
    private byte[] readBuf;

    TarInputStream(InputStream input) {
        this(input, 10240, 512);
    }

    TarInputStream(InputStream input, int blockSize) {
        this(input, blockSize, 512);
    }

    TarInputStream(InputStream input, int blockSize, int recordSize) {
        super(input);
        this.buffer = new TarBuffer(input, blockSize, recordSize);
        this.oneBuf = new byte[1];
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.buffer.setDebug(debug);
    }

    public TarEntry getNextEntry() throws IOException {
        byte[] headerBuf;
        String message;
        if (this.hasHitEOF) {
            return null;
        }
        if (this.currEntry != null) {
            int numToSkip = this.entrySize - this.entryOffset;
            if (this.debug) {
                message = "TarInputStream: SKIP currENTRY '" + this.currEntry.getName() + "' SZ " + this.entrySize + " OFF " + this.entryOffset + "  skipping " + numToSkip + " bytes";
                this.debug(message);
            }
            if (numToSkip > 0) {
                this.skip(numToSkip);
            }
            this.readBuf = null;
        }
        if ((headerBuf = this.buffer.readRecord()) == null) {
            if (this.debug) {
                this.debug("READ NULL RECORD");
            }
            this.hasHitEOF = true;
        } else if (this.buffer.isEOFRecord(headerBuf)) {
            if (this.debug) {
                this.debug("READ EOF RECORD");
            }
            this.hasHitEOF = true;
        }
        if (this.hasHitEOF) {
            this.currEntry = null;
        } else {
            this.currEntry = new TarEntry(headerBuf);
            if (headerBuf[257] != 117 || headerBuf[258] != 115 || headerBuf[259] != 116 || headerBuf[260] != 97 || headerBuf[261] != 114) {
                // empty if block
            }
            if (this.debug) {
                message = "TarInputStream: SET CURRENTRY '" + this.currEntry.getName() + "' size = " + this.currEntry.getSize();
                this.debug(message);
            }
            this.entryOffset = 0;
            this.entrySize = (int)this.currEntry.getSize();
        }
        if (null != this.currEntry && this.currEntry.isGNULongNameEntry()) {
            StringBuffer longName = new StringBuffer();
            byte[] buffer = new byte[256];
            int length = 0;
            while ((length = this.read(buffer)) >= 0) {
                String str = new String(buffer, 0, length);
                longName.append(str);
            }
            this.getNextEntry();
            if (longName.length() > 0 && longName.charAt(longName.length() - 1) == '\u0000') {
                longName.deleteCharAt(longName.length() - 1);
            }
            this.currEntry.setName(longName.toString());
        }
        return this.currEntry;
    }

    public int getRecordSize() {
        return this.buffer.getRecordSize();
    }

    public int available() throws IOException {
        return this.entrySize - this.entryOffset;
    }

    public void close() throws IOException {
        this.buffer.close();
    }

    public void copyEntryContents(OutputStream output) throws IOException {
        int numRead;
        byte[] buffer = new byte[32768];
        while ((numRead = this.read(buffer, 0, buffer.length)) != -1) {
            output.write(buffer, 0, numRead);
        }
    }

    public void mark(int markLimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int num = this.read(this.oneBuf, 0, 1);
        if (num == -1) {
            return num;
        }
        return this.oneBuf[0];
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int count) throws IOException {
        int position = offset;
        int numToRead = count;
        int totalRead = 0;
        if (this.entryOffset >= this.entrySize) {
            return -1;
        }
        if (numToRead + this.entryOffset > this.entrySize) {
            numToRead = this.entrySize - this.entryOffset;
        }
        if (null != this.readBuf) {
            int size = numToRead > this.readBuf.length ? this.readBuf.length : numToRead;
            System.arraycopy(this.readBuf, 0, buffer, position, size);
            if (size >= this.readBuf.length) {
                this.readBuf = null;
            } else {
                int newLength = this.readBuf.length - size;
                byte[] newBuffer = new byte[newLength];
                System.arraycopy(this.readBuf, size, newBuffer, 0, newLength);
                this.readBuf = newBuffer;
            }
            totalRead += size;
            numToRead -= size;
            position += size;
        }
        while (numToRead > 0) {
            byte[] rec = this.buffer.readRecord();
            if (null == rec) {
                String message = "unexpected EOF with " + numToRead + " bytes unread";
                throw new IOException(message);
            }
            int recordLength = rec.length;
            int size = numToRead;
            if (recordLength > size) {
                System.arraycopy(rec, 0, buffer, position, size);
                this.readBuf = new byte[recordLength - size];
                System.arraycopy(rec, size, this.readBuf, 0, recordLength - size);
            } else {
                size = recordLength;
                System.arraycopy(rec, 0, buffer, position, recordLength);
            }
            totalRead += size;
            numToRead -= size;
            position += size;
        }
        this.entryOffset += totalRead;
        return totalRead;
    }

    public void reset() {
    }

    public void skip(int numToSkip) throws IOException {
        int count;
        int numRead;
        byte[] skipBuf = new byte[8192];
        for (int num = numToSkip; num > 0 && (numRead = this.read(skipBuf, 0, count = num > skipBuf.length ? skipBuf.length : num)) != -1; num -= numRead) {
        }
    }

    protected void debug(String message) {
        if (this.debug) {
            System.err.println(message);
        }
    }
}

