/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.html;

import com.eg.ch.qos.logback.classic.spi.ILoggingEvent;
import com.eg.ch.qos.logback.classic.spi.IThrowableProxy;
import com.eg.ch.qos.logback.classic.spi.StackTraceElementProxy;
import com.eg.ch.qos.logback.core.CoreConstants;
import com.eg.ch.qos.logback.core.helpers.Transform;
import com.eg.ch.qos.logback.core.html.IThrowableRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultThrowableRenderer
implements IThrowableRenderer<ILoggingEvent> {
    static final String TRACE_PREFIX = "<br />&nbsp;&nbsp;&nbsp;&nbsp;";

    @Override
    public void render(StringBuilder sbuf, ILoggingEvent event) {
        IThrowableProxy tp = event.getThrowableProxy();
        sbuf.append("<tr><td class=\"Exception\" colspan=\"6\">");
        while (tp != null) {
            this.render(sbuf, tp);
            tp = tp.getCause();
        }
        sbuf.append("</td></tr>");
    }

    @Override
    void render(StringBuilder sbuf, IThrowableProxy tp) {
        this.printFirstLine(sbuf, tp);
        int commonFrames = tp.getCommonFrames();
        StackTraceElementProxy[] stepArray = tp.getStackTraceElementProxyArray();
        int i = 0;
        while (i < stepArray.length - commonFrames) {
            StackTraceElementProxy step = stepArray[i];
            sbuf.append(TRACE_PREFIX);
            sbuf.append(Transform.escapeTags(step.toString()));
            sbuf.append(CoreConstants.LINE_SEPARATOR);
            ++i;
        }
        if (commonFrames > 0) {
            sbuf.append(TRACE_PREFIX);
            sbuf.append("\t... ").append(commonFrames).append(" common frames omitted").append(CoreConstants.LINE_SEPARATOR);
        }
    }

    public void printFirstLine(StringBuilder sb, IThrowableProxy tp) {
        int commonFrames = tp.getCommonFrames();
        if (commonFrames > 0) {
            sb.append("<br />").append("Caused by: ");
        }
        sb.append(tp.getClassName()).append(": ").append(Transform.escapeTags(tp.getMessage()));
        sb.append(CoreConstants.LINE_SEPARATOR);
    }
}

