/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jradiusclient.jaas;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.sourceforge.jradiusclient.jaas.RadiusCallback;

public class RadiusLoginHandler
implements CallbackHandler {
    public static final String JAAS_MODULE_KEY = "JRadiusClientLoginModule";
    private String name;
    private String password;
    private String clientIP;
    private String hostName;
    private String sharedSecret;
    private int authPort;
    private int acctPort;
    private String callingStationID;
    private int numRetries;
    private int timeout;

    public RadiusLoginHandler(String string, String string2, String string3, String string4, String string5, String string6, int n, int n2, int n3, int n4) {
        if (string == null || string2 == null || string3 == null) {
            throw new IllegalArgumentException("Arguments cannont be null");
        }
        this.name = string;
        this.password = string2;
        this.clientIP = string3;
        this.callingStationID = string4;
        this.hostName = string5;
        this.sharedSecret = string6;
        this.authPort = n;
        this.acctPort = n2;
        this.numRetries = n3;
        this.timeout = n4;
    }

    public void login() throws LoginException {
        LoginContext loginContext = new LoginContext(JAAS_MODULE_KEY, this);
        loginContext.login();
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        int n = 0;
        while (n < callbackArray.length) {
            this.handle(callbackArray[n]);
            ++n;
        }
    }

    protected void handle(Callback callback) throws UnsupportedCallbackException {
        if (callback instanceof NameCallback) {
            ((NameCallback)callback).setName(this.name);
        } else if (callback instanceof PasswordCallback) {
            ((PasswordCallback)callback).setPassword(this.password.toCharArray());
        } else if (callback instanceof TextInputCallback) {
            ((TextInputCallback)callback).setText(this.clientIP);
        } else if (callback instanceof RadiusCallback) {
            RadiusCallback radiusCallback = (RadiusCallback)callback;
            radiusCallback.setHostName(this.hostName);
            radiusCallback.setSharedSecret(this.sharedSecret);
            radiusCallback.setAuthPort(this.authPort);
            radiusCallback.setAcctPort(this.acctPort);
            radiusCallback.setCallingStationID(this.callingStationID);
            radiusCallback.setNumRetries(this.numRetries);
            radiusCallback.setTimeout(this.timeout);
        } else {
            throw new UnsupportedCallbackException(callback);
        }
    }
}

