/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.CharsetEncoder;
import com.tmax.tibero.jdbc.data.charset.MS932TILDECharToByteConverter;
import java.sql.SQLException;

public class MS932TILDEEncoder
implements CharsetEncoder {
    private MS932TILDECharToByteConverter conv = new MS932TILDECharToByteConverter();
    private int maxBytesPerChar = this.conv.getMaxBytesPerChar();

    public int charsToBytes(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        return this.conv.convCharArr(cArray, n, n + n2, byArray, n3, n3 + n4);
    }

    public int charsToFixedBytes(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        return 0;
    }

    public int getEndingBytePos(byte[] byArray, int n) {
        if (this.isEndingByte(byArray, n)) {
            return n;
        }
        return n + 1;
    }

    public int getLeadingBytePos(byte[] byArray, int n) {
        if (this.isLeadingByte(byArray, n)) {
            return n;
        }
        return n - 1;
    }

    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    public boolean isEndingByte(byte[] byArray, int n) {
        if (byArray[n] >= 0) {
            return true;
        }
        return !this.isLeadingByte(byArray, n);
    }

    public boolean isLeadingByte(byte[] byArray, int n) {
        int n2 = n;
        while (!(n2 - 1 < 0 || this.isSingleByte(byArray[n2]) && this.isSingleByte(byArray[n2 - 1]))) {
            --n2;
        }
        while (n2 <= n) {
            if (!this.isSingleByte(byArray[n2])) {
                if (n2 + 1 == n) {
                    return false;
                }
                ++n2;
            } else if (n2 == n) {
                return true;
            }
            ++n2;
        }
        return true;
    }

    private boolean isSingleByte(byte by) {
        if (by < 128) {
            return true;
        }
        return by >= 161 && by < 224;
    }

    public byte[] stringToBytes(String string) throws SQLException {
        byte[] byArray = new byte[string.length() * this.getMaxBytesPerChar()];
        int n = this.conv.convString(string, 0, string.length(), byArray, 0, byArray.length);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public int stringToBytes(byte[] byArray, int n, String string) throws SQLException {
        return this.conv.convString(string, 0, string.length(), byArray, n, byArray.length);
    }
}

