/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.dpl;

import com.tmax.tibero.jdbc.TbDatabaseMetaData;
import com.tmax.tibero.jdbc.TbIntervalDts;
import com.tmax.tibero.jdbc.TbIntervalYtm;
import com.tmax.tibero.jdbc.comm.TbStream;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.ServerInfo;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.data.TbTimestampTZ;
import com.tmax.tibero.jdbc.dpl.TbDirPathMetaData;
import com.tmax.tibero.jdbc.dpl.binder.DPLBinder;
import com.tmax.tibero.jdbc.dpl.binder.StaticDPLBinder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

public class TbDirPathStream {
    public static final int DPL_BIND_STREAM = -1;
    public static final int DPL_LOAD_STREAM_SUCCESS = 0;
    public static final int DPL_LOAD_STREAM_NEED_DATA = 1;
    public static final int DPL_LOAD_STREAM_NO_DATA = 2;
    public static final int DPL_LOAD_STREAM_FAIL = 3;
    public static final int SQL_DPL_DATASAVE_SAVE_ONLY = 0;
    public static final int SQL_DPL_DATASAVE_FINISH = 1;
    public static final int DPL_PARAM_INFO_OFFSET = 24;
    private int returnCode;
    private int rowCnt;
    private int totalRowCnt;
    private TbConnection conn = null;
    private TbDirPathMetaData metaData = null;
    private int bindParamCnt;
    private int[] paramLength = null;
    private TbStreamDataWriter writer = null;
    private int[] paramInt;
    private long[] paramLong;
    private float[] paramFloat;
    private double[] paramDouble;
    private BigDecimal[] paramBigDecimal;
    private String[] paramString;
    private Date[] paramDate;
    private TbDate[] paramTbDate;
    private Time[] paramTime;
    private Timestamp[] paramTimestamp;
    private TbTimestamp[] paramTbTimestamp;
    private TbTimestampTZ[] paramTbTimestampTZ;
    private byte[][] paramBytes;
    private Reader[] paramReader;
    private InputStream[] paramStream;
    private Object[] paramObject;
    private TbIntervalYtm[] paramTbIntervalYtm;
    private TbIntervalDts[] paramTbIntervalDts;
    private DPLBinder[] binder;
    private DPLBinder staticNullDPLBinder = StaticDPLBinder.nullDPLBinder;
    private DPLBinder staticStringDPLBinder = StaticDPLBinder.stringDPLBinder;
    private DPLBinder staticReaderDPLBinder = StaticDPLBinder.readerDPLBinder;
    private DPLBinder staticIntDPLBinder = StaticDPLBinder.intDPLBinder;
    private DPLBinder staticLongDPLBinder = StaticDPLBinder.longDPLBinder;
    private DPLBinder staticFloatDPLBinder = StaticDPLBinder.floatDPLBinder;
    private DPLBinder staticDoubleDPLBinder = StaticDPLBinder.doubleDPLBinder;
    private DPLBinder staticBigDecimalDPLBinder = StaticDPLBinder.bigDecimalDPLBinder;
    private DPLBinder staticDateDPLBinder = StaticDPLBinder.dateDPLBinder;
    private DPLBinder staticTbDateDPLBinder = StaticDPLBinder.tbDateDPLBinder;
    private DPLBinder staticTimeDPLBinder = StaticDPLBinder.timeDPLBinder;
    private DPLBinder staticTimestampDPLBinder = StaticDPLBinder.timestampDPLBinder;
    private DPLBinder staticTbTimestampDPLBinder = StaticDPLBinder.tbTimestampDPLBinder;
    private DPLBinder staticTbTimestampTZDPLBinder = StaticDPLBinder.tbTimestampTZDPLBinder;
    private DPLBinder staticTimestampLTZDPLBinder = StaticDPLBinder.timestampLTZDPLBinder;
    private DPLBinder staticRawDPLBinder = StaticDPLBinder.rawDPLBinder;
    private DPLBinder staticBytesDPLBinder = StaticDPLBinder.bytesDPLBinder;
    private DPLBinder staticRowIdDPLBinder = StaticDPLBinder.rowIdDPLBinder;
    private DPLBinder staticLongStreamDPLBinder = StaticDPLBinder.longStreamDPLBinder;
    private DPLBinder staticStreamDPLBinder = StaticDPLBinder.streamDPLBinder;
    private DPLBinder staticEmptyLOBDPLBinder = StaticDPLBinder.emptyLOBDPLBinder;
    private DPLBinder staticTbIntervalYtmBinder = StaticDPLBinder.tbIntervalYtmDPLBinder;
    private DPLBinder staticTbIntervalDtsBinder = StaticDPLBinder.tbIntervalDtsDPLBinder;

    public TbDirPathStream(TbConnection tbConnection, TbDirPathMetaData tbDirPathMetaData) throws SQLException {
        this.conn = tbConnection;
        this.metaData = tbDirPathMetaData;
        this.bindParamCnt = tbDirPathMetaData.getColumnCnt();
        this.binder = new DPLBinder[this.bindParamCnt];
        TbStream tbStream = this.conn.getTbComm().getTbStream();
        this.writer = tbStream.createDirPathWriter(tbDirPathMetaData.getBufferSize());
        this.writer.clearDPLBuffer();
        this.totalRowCnt = 0;
        this.initReturnInfo();
        if (this.metaData.getParallelFlag() || this.metaData.getPartition() != null && this.metaData.getPartition().length() > 0) {
            ServerInfo serverInfo = tbConnection.getServerInfo();
            if (serverInfo.getProtocolMajorVersion() * 100 + serverInfo.getProtocolMinorVersion() < 205) {
                throw TbError.newSQLException(-90662);
            }
            this.prepareParallel();
        } else {
            this.prepare();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() throws SQLException {
        if (this.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            this.conn.getTbComm().dirPathAbort();
        }
    }

    public void addTotalRowCnt(int n) {
        this.totalRowCnt += n;
    }

    public int getTotalRowCnt() {
        return this.totalRowCnt;
    }

    protected void checkParameterIndex(int n) throws SQLException {
        if (n < 1 || n > this.metaData.getColumnCnt()) {
            throw TbError.newSQLException(-90609);
        }
    }

    public void clearBindData() {
        this.clearArray(this.paramBigDecimal);
        this.clearArray(this.paramString);
        this.clearArray(this.paramDate);
        this.clearArray(this.paramTime);
        this.clearArray(this.paramTimestamp);
        this.clearArray(this.paramTbTimestamp);
        this.clearArray(this.paramTbTimestampTZ);
        this.clearArray((Object[])this.paramBytes);
        this.clearArray(this.paramReader);
        this.clearArray(this.paramStream);
        this.clearArray(this.paramObject);
        this.clearArray(this.binder);
    }

    private void clearArray(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = null;
        }
    }

    public void close() {
        this.reset();
    }

    private void copyStream() throws SQLException {
        try {
            for (int i = 0; i < this.bindParamCnt; ++i) {
                if (this.binder[i] == null) {
                    throw TbError.newSQLException(-90627);
                }
                this.binder[i].bind(this.conn, this, this.writer, i, this.paramLength[i]);
            }
        }
        catch (SQLException sQLException) {
            this.writer.clearDPLBuffer();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataSave(int n) throws SQLException {
        if (this.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            this.conn.getTbComm().dirPathDataSave(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dirPathLoadStream(TbStreamDataWriter tbStreamDataWriter, int n) throws SQLException {
        if (this.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            this.conn.getTbComm().dirPathLoadStream(this, tbStreamDataWriter, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws SQLException {
        if (this.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            this.conn.getTbComm().dirPathFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushRow() throws SQLException {
        if (this.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            this.conn.getTbComm().dirPathFlushRow();
        }
    }

    public int getBindDataSize() {
        return this.writer.getBufferedDataSize();
    }

    public DPLBinder[] getBinder() {
        return this.binder;
    }

    public TbDirPathMetaData getDPLMetaData() {
        return this.metaData;
    }

    public TbStreamDataWriter getDPLStreamDataWriter() {
        return this.writer;
    }

    public BigDecimal getParamBigDecimal(int n) {
        return this.paramBigDecimal[n];
    }

    public byte[] getParamBytes(int n) {
        return this.paramBytes[n];
    }

    public Date getParamDate(int n) {
        return this.paramDate[n];
    }

    public TbDate getParamTbDate(int n) {
        return this.paramTbDate[n];
    }

    public double getParamDouble(int n) {
        return this.paramDouble[n];
    }

    public float getParamFloat(int n) {
        return this.paramFloat[n];
    }

    public int getParamInt(int n) {
        return this.paramInt[n];
    }

    public int getParamLength(int n) {
        return this.paramLength[n];
    }

    public long getParamLong(int n) {
        return this.paramLong[n];
    }

    public Object getParamObject(int n) {
        return this.paramObject[n];
    }

    public Reader getParamReader(int n) {
        return this.paramReader[n];
    }

    public InputStream getParamStream(int n) {
        return this.paramStream[n];
    }

    public String getParamString(int n) {
        return this.paramString[n];
    }

    public Time getParamTime(int n) {
        return this.paramTime[n];
    }

    public Timestamp getParamTimestamp(int n) {
        return this.paramTimestamp[n];
    }

    public TbTimestamp getParamTbTimestamp(int n) {
        return this.paramTbTimestamp[n];
    }

    public TbTimestampTZ getParamTbTimestampTZ(int n) {
        return this.paramTbTimestampTZ[n];
    }

    public TbIntervalYtm getParamTbIntervalYtm(int n) {
        return this.paramTbIntervalYtm[n];
    }

    public TbIntervalDts getParamTbIntervalDts(int n) {
        return this.paramTbIntervalDts[n];
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public int getRowCnt() {
        return this.rowCnt;
    }

    public boolean hasBindData() {
        return this.writer.getBufferedDataSize() > 24;
    }

    private void initReturnInfo() {
        this.returnCode = -1;
        this.rowCnt = 0;
    }

    public int loadStream() throws SQLException {
        this.initReturnInfo();
        this.copyStream();
        this.dirPathLoadStream(this.writer, 0);
        return this.returnCode;
    }

    public int loadStreamBatch(int n) throws SQLException {
        this.initReturnInfo();
        if ((n & 0x100) != 0) {
            this.copyStream();
        }
        if ((n & 0x10) != 0) {
            if (this.writer.getBufferedDataSize() > this.metaData.getBufferSize()) {
                this.dirPathLoadStream(this.writer, 0);
            }
        } else {
            this.dirPathLoadStream(this.writer, 0);
        }
        return this.returnCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws SQLException {
        if (this.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        this.metaData.checkDirPathMetaData();
        this.paramLength = new int[this.bindParamCnt];
        if (this.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            this.conn.getTbComm().dirPathPrepare(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareParallel() throws SQLException {
        if (this.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        this.metaData.checkDirPathMetaData();
        if (this.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        this.paramLength = new int[this.bindParamCnt];
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            this.conn.getTbComm().dirPathPrepareParallel(this);
        }
    }

    private void reset() {
        this.conn = null;
        this.writer = null;
        this.paramLength = null;
        if (this.metaData != null) {
            this.metaData.reset();
            this.metaData = null;
        }
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setBinaryStream(n, inputStream, n2);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.setNull(n);
            return;
        }
        this.checkParameterIndex(n);
        if (this.paramBigDecimal == null) {
            this.paramBigDecimal = new BigDecimal[this.bindParamCnt];
        }
        this.paramLength[n - 1] = 0;
        this.paramBigDecimal[n - 1] = bigDecimal;
        this.binder[n - 1] = this.staticBigDecimalDPLBinder;
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null || n2 <= 0) {
            this.setNull(n);
            return;
        }
        this.checkParameterIndex(n);
        if (this.paramStream == null) {
            this.paramStream = new InputStream[this.bindParamCnt];
        }
        this.paramLength[n - 1] = n2;
        this.paramStream[n - 1] = inputStream;
        this.binder[n - 1] = this.staticStreamDPLBinder;
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkParameterIndex(n);
        if (this.paramString == null) {
            this.paramString = new String[this.bindParamCnt];
        }
        this.paramLength[n - 1] = 20;
        this.paramString[n - 1] = bl ? "1" : "0";
        this.binder[n - 1] = this.staticStringDPLBinder;
    }

    public void setByte(int n, byte by) throws SQLException {
        this.checkParameterIndex(n);
        if (this.paramInt == null) {
            this.paramInt = new int[this.bindParamCnt];
        }
        this.paramLength[n - 1] = 1;
        this.paramInt[n - 1] = by;
        this.binder[n - 1] = this.staticIntDPLBinder;
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.setNull(n);
            return;
        }
        this.checkParameterIndex(n);
        if (this.paramBytes == null) {
            this.paramBytes = new byte[this.bindParamCnt][];
        }
        this.paramLength[n - 1] = byArray.length;
        this.paramBytes[n - 1] = byArray;
        this.binder[n - 1] = this.staticBytesDPLBinder;
    }

    public void setBytes(int n, int n2, byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.setNull(n);
            return;
        }
        this.checkParameterIndex(n);
        if (this.paramBytes == null) {
            this.paramBytes = new byte[this.bindParamCnt][];
        }
        this.paramLength[n - 1] = byArray.length;
        this.paramBytes[n - 1] = byArray;
        this.binder[n - 1] = this.staticRawDPLBinder;
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (reader == null || n2 <= 0) {
            this.setNull(n);
            return;
        }
        this.checkParameterIndex(n);
        if (this.paramReader == null) {
            this.paramReader = new Reader[this.bindParamCnt];
        }
        this.paramLength[n - 1] = n2;
        this.paramReader[n - 1] = reader;
        this.binder[n - 1] = this.staticReaderDPLBinder;
    }

    public void setDate(int n, Date date) throws SQLException {
        if (date == null) {
            this.setNull(n);
            return;
        }
        this.checkParameterIndex(n);
        if (this.paramDate == null) {
            this.paramDate = new Date[this.bindParamCnt];
        }
        this.paramLength[n - 1] = 0;
        this.paramDate[n - 1] = date;
        this.binder[n - 1] = this.staticDateDPLBinder;
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDate(n, date);
    }

    public void setTbDate(int n, TbDate tbDate) throws SQLException {
        if (tbDate == null) {
            this.setNull(n);
            return;
        }
        this.checkParameterIndex(n);
        if (this.paramTbDate == null) {
            this.paramTbDate = new TbDate[this.bindParamCnt];
        }
        this.paramLength[n - 1] = 0;
        this.paramTbDate[n - 1] = tbDate;
        this.binder[n - 1] = this.staticTbDateDPLBinder;
    }

    public void setDouble(int n, double d) throws SQLException {
        this.checkParameterIndex(n);
        if (this.paramDouble == null) {
            this.paramDouble = new double[this.bindParamCnt];
        }
        this.paramLength[n - 1] = 0;
        this.paramDouble[n - 1] = d;
        this.binder[n - 1] = this.staticDoubleDPLBinder;
    }

    public void setEmptyLob(int n) throws SQLException {
        this.checkParameterIndex(n);
        int n2 = this.metaData.getDataType(n);
        if (n2 != 12 && n2 != 13 && n2 != 20) {
            throw TbError.newSQLException(-590703);
        }
        this.paramLength[n - 1] = -1;
        this.binder[n - 1] = this.staticEmptyLOBDPLBinder;
    }

    public void setFloat(int n, float f) throws SQLException {
        this.checkParameterIndex(n);
        if (this.paramFloat == null) {
            this.paramFloat = new float[this.bindParamCnt];
        }
        this.paramLength[n - 1] = 0;
        this.paramFloat[n - 1] = f;
        this.binder[n - 1] = this.staticFloatDPLBinder;
    }

    public void setInt(int n, int n2) throws SQLException {
        this.checkParameterIndex(n);
        if (this.paramInt == null) {
            this.paramInt = new int[this.bindParamCnt];
        }
        this.paramLength[n - 1] = 0;
        this.paramInt[n - 1] = n2;
        this.binder[n - 1] = this.staticIntDPLBinder;
    }

    public void setLong(int n, long l) throws SQLException {
        this.checkParameterIndex(n);
        if (this.paramLong == null) {
            this.paramLong = new long[this.bindParamCnt];
        }
        this.paramLength[n - 1] = 0;
        this.paramLong[n - 1] = l;
        this.binder[n - 1] = this.staticLongDPLBinder;
    }

    public void setLongBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null || n2 <= 0) {
            this.setNull(n);
            return;
        }
        this.checkParameterIndex(n);
        if (this.paramStream == null) {
            this.paramStream = new InputStream[this.bindParamCnt];
        }
        this.paramLength[n - 1] = n2;
        this.paramStream[n - 1] = inputStream;
        String string = this.metaData.getClientCharSet();
        String string2 = ((TbDatabaseMetaData)this.conn.getMetaData()).getServerCharSet();
        this.binder[n - 1] = string == null || string.equals(string2) ? this.staticStreamDPLBinder : this.staticLongStreamDPLBinder;
    }

    public void setNull(int n) throws SQLException {
        this.checkParameterIndex(n);
        this.paramLength[n - 1] = 0;
        this.binder[n - 1] = this.staticNullDPLBinder;
    }

    public void setObject(int n, Object object) throws SQLException {
        this.setObject(n, object, DataType.getSqlType(object), 0);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (object == null) {
            this.setNull(n);
            return;
        }
        switch (n2) {
            case -7: {
                this.setBoolean(n, new Boolean(object.toString()));
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(n, object.toString());
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(n, (byte[])object);
                break;
            }
            case -6: 
            case 5: {
                this.setShort(n, new Short(object.toString()));
                break;
            }
            case 4: {
                this.setInt(n, new Integer(object.toString()));
                break;
            }
            case -5: {
                this.setLong(n, new Long(object.toString()));
                break;
            }
            case 3: {
                this.setBigDecimal(n, new BigDecimal(object.toString()));
                break;
            }
            case 6: {
                this.setFloat(n, new Float(object.toString()).floatValue());
                break;
            }
            case 7: {
                this.setFloat(n, new Float(object.toString()).floatValue());
                break;
            }
            case 8: {
                this.setDouble(n, new Double(object.toString()));
                break;
            }
            case 2: {
                if (object instanceof Short) {
                    this.setShort(n, (Short)object);
                    break;
                }
                if (object instanceof Integer) {
                    this.setInt(n, (Integer)object);
                    break;
                }
                if (object instanceof Long) {
                    this.setLong(n, (Long)object);
                    break;
                }
                if (object instanceof Float) {
                    this.setFloat(n, ((Float)object).floatValue());
                    break;
                }
                if (object instanceof Double) {
                    this.setDouble(n, (Double)object);
                    break;
                }
                if (object instanceof BigDecimal) {
                    this.setBigDecimal(n, (BigDecimal)object);
                    break;
                }
                if (object instanceof Boolean) {
                    this.setBoolean(n, (Boolean)object);
                    break;
                }
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
            case 91: {
                if (object instanceof Date) {
                    this.setDate(n, (Date)object);
                    break;
                }
                if (object instanceof TbDate) {
                    this.setTbDate(n, (TbDate)object);
                    break;
                }
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
            case 92: {
                this.setTime(n, (Time)object);
                break;
            }
            case 93: {
                if (object instanceof Timestamp) {
                    this.setTimestamp(n, (Timestamp)object);
                    break;
                }
                if (object instanceof TbTimestamp) {
                    this.setTbTimestamp(n, (TbTimestamp)object);
                    break;
                }
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
            default: {
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
        }
    }

    public void setReturnCode(int n) {
        this.returnCode = n;
    }

    public void addRowCnt(int n) {
        this.rowCnt += n;
    }

    public void setRowid(int n, String string) throws SQLException {
        if (string == null || string.length() == 0) {
            this.setNull(n);
            return;
        }
        this.checkParameterIndex(n);
        if (this.paramString == null) {
            this.paramString = new String[this.bindParamCnt];
        }
        this.paramLength[n - 1] = string.length();
        this.paramString[n - 1] = string;
        this.binder[n - 1] = this.staticRowIdDPLBinder;
    }

    public void setShort(int n, short s) throws SQLException {
        this.checkParameterIndex(n);
        if (this.paramInt == null) {
            this.paramInt = new int[this.bindParamCnt];
        }
        this.paramLength[n - 1] = 0;
        this.paramInt[n - 1] = s;
        this.binder[n - 1] = this.staticIntDPLBinder;
    }

    public void setString(int n, String string) throws SQLException {
        if (string == null || string.length() == 0) {
            this.setNull(n);
            return;
        }
        this.checkParameterIndex(n);
        if (this.paramString == null) {
            this.paramString = new String[this.bindParamCnt];
        }
        this.paramLength[n - 1] = string.length();
        this.paramString[n - 1] = string;
        this.binder[n - 1] = this.staticStringDPLBinder;
    }

    public void setTime(int n, Time time) throws SQLException {
        if (time == null) {
            this.setNull(n);
            return;
        }
        this.checkParameterIndex(n);
        if (this.paramTime == null) {
            this.paramTime = new Time[this.bindParamCnt];
        }
        this.paramLength[n - 1] = 0;
        this.paramTime[n - 1] = time;
        this.binder[n - 1] = this.staticTimeDPLBinder;
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setTime(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNull(n);
            return;
        }
        this.checkParameterIndex(n);
        if (this.paramTimestamp == null) {
            this.paramTimestamp = new Timestamp[this.bindParamCnt];
        }
        this.paramLength[n - 1] = 0;
        this.paramTimestamp[n - 1] = timestamp;
        this.binder[n - 1] = this.staticTimestampDPLBinder;
    }

    public void setTbTimestamp(int n, TbTimestamp tbTimestamp) throws SQLException {
        if (tbTimestamp == null) {
            this.setNull(n);
            return;
        }
        this.checkParameterIndex(n);
        if (this.paramTbTimestamp == null) {
            this.paramTbTimestamp = new TbTimestamp[this.bindParamCnt];
        }
        this.paramLength[n - 1] = 0;
        this.paramTbTimestamp[n - 1] = tbTimestamp;
        this.binder[n - 1] = this.staticTbTimestampDPLBinder;
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestampTZ(n, timestamp, calendar.getTimeZone());
    }

    public void setTimestampTZ(int n, Timestamp timestamp, TimeZone timeZone) throws SQLException {
        if (timestamp == null) {
            this.setNull(n);
            return;
        }
        this.checkParameterIndex(n);
        if (this.paramTbTimestampTZ == null) {
            this.paramTbTimestampTZ = new TbTimestampTZ[this.bindParamCnt];
        }
        this.paramLength[n - 1] = 0;
        this.paramTbTimestampTZ[n - 1] = new TbTimestampTZ(timestamp, timeZone);
        this.binder[n - 1] = this.staticTbTimestampTZDPLBinder;
    }

    public void setTimestampLTZ(int n, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNull(n);
            return;
        }
        this.checkParameterIndex(n);
        if (this.paramTimestamp == null) {
            this.paramTimestamp = new Timestamp[this.bindParamCnt];
        }
        this.paramLength[n - 1] = 0;
        this.paramTimestamp[n - 1] = timestamp;
        this.binder[n - 1] = this.staticTimestampLTZDPLBinder;
    }

    public void setTbIntervalYtm(int n, TbIntervalYtm tbIntervalYtm) throws SQLException {
        if (tbIntervalYtm == null) {
            this.setNull(n);
            return;
        }
        this.checkParameterIndex(n);
        if (this.paramTbIntervalYtm == null) {
            this.paramTbIntervalYtm = new TbIntervalYtm[this.bindParamCnt];
        }
        this.paramLength[n - 1] = 0;
        this.paramTbIntervalYtm[n - 1] = tbIntervalYtm;
        this.binder[n - 1] = this.staticTbIntervalYtmBinder;
    }

    public void setTbIntervalDts(int n, TbIntervalDts tbIntervalDts) throws SQLException {
        if (tbIntervalDts == null) {
            this.setNull(n);
            return;
        }
        this.checkParameterIndex(n);
        if (this.paramTbIntervalDts == null) {
            this.paramTbIntervalDts = new TbIntervalDts[this.bindParamCnt];
        }
        this.paramLength[n - 1] = 0;
        this.paramTbIntervalDts[n - 1] = tbIntervalDts;
        this.binder[n - 1] = this.staticTbIntervalDtsBinder;
    }
}

