/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import oracle.dms.instrument.EventIntf;
import oracle.dms.instrument.ExecutionContext;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.Tracer;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;
import oracle.dms.util.DMSUtil;

public class Event
extends Sensor
implements EventIntf {
    private int _count = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Event create(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null) {
            throw new InstrumentationException("Event.create(): bad parameters");
        }
        Event event = (Event)Sensor.lookupCache(string);
        if (event != null) {
            return event;
        }
        Noun noun = Sensor.createParent(string);
        String string3 = DMSUtil.getLeafFromPath(string);
        Noun noun2 = noun;
        synchronized (noun2) {
            String string4 = DMSUtil.sanitize(string3, 511, true, true);
            event = (Event)noun.getSensor(string4);
            if (event != null) {
                event.addToCache(string);
                return event;
            }
            return new Event(false, noun, string4, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Event create(Noun noun, String string, String string2) {
        if (noun == null || string2 == null || string == null) {
            throw new InstrumentationException("Event.create(): bad parameters");
        }
        Noun noun2 = noun;
        synchronized (noun2) {
            String string3 = DMSUtil.sanitize(string, 511, true, true);
            Event event = (Event)noun.getSensor(string3);
            if (event != null) {
                return event;
            }
            return new Event(false, noun, string3, string2);
        }
    }

    public Event(Noun noun, String string, String string2) {
        this(true, noun, string, string2);
    }

    private Event(boolean bl, Noun noun, String string, String string2) {
        super(bl, noun, string, string2);
        this._metrics[1] = new Metric(this._name + ".count", this._description, "ops", this, false, 3, 1);
        this.setUpdateTime(0L);
    }

    public static void occurred(String string) {
        ((Event)Sensor.get(string)).occurred();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void occurred() {
        int n;
        Sensor sensor = this;
        synchronized (sensor) {
            n = ++this._count;
        }
        if (this.isTraceable() && (sensor = ExecutionContext.get().getTracer()) != null) {
            ((Tracer)sensor).append(this, 0);
        }
        if (this.isLoggable()) {
            this.logActivation("" + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void occurred(Object[] objectArray) {
        int n;
        Sensor sensor = this;
        synchronized (sensor) {
            n = ++this._count;
        }
        if (this.isTraceable() && (sensor = ExecutionContext.get().getTracer()) != null) {
            ((Tracer)sensor).append(this, 0);
        }
        if (this.isLoggable()) {
            this.logActivation("" + n, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(Metric metric) {
        if (metric == null) {
            metric = this.getMetric(2);
        }
        if (!metric.isAlive()) {
            return new ErrorObject();
        }
        byte by = metric.getIndex();
        if (this._metrics[by] != metric) {
            throw new InstrumentationException("Metric: " + metric + " does not belong to Event " + this);
        }
        Event event = this;
        synchronized (event) {
            if (!this._alive) {
                return new ErrorObject();
            }
            switch (by) {
                case 1: {
                    return new Integer(this._count);
                }
            }
        }
        throw new InstrumentationException("Metric: " + metric + " does not belong to Event " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        long l = System.currentTimeMillis();
        Event event = this;
        synchronized (event) {
            this._count = 0;
            this.setResetTime(l);
        }
    }

    public void deriveMetric(int n) {
    }

    Event getCousin(Noun noun) {
        Event event = null;
        Noun noun2 = this.getParent().getCousin(noun);
        if (noun2 != null) {
            event = Event.create(noun2, this._name, "cousin");
        }
        return event;
    }

    public boolean isInitialized() {
        return this._count > 0;
    }
}

