/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import oracle.dms.instrument.ExecutionContext;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.StateIntf;
import oracle.dms.instrument.Tracer;
import oracle.dms.instrument.state.AnyValue;
import oracle.dms.instrument.state.DoubleValue;
import oracle.dms.instrument.state.IntegerValue;
import oracle.dms.instrument.state.LongValue;
import oracle.dms.instrument.state.ObjectValue;
import oracle.dms.instrument.state.Value;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSUtil;

public class State
extends Sensor
implements StateIntf {
    private int _updateCount;
    private double _min;
    private double _max;
    private Value _value;
    private String _units;
    private static final byte ANY = 0;
    public static final byte DOUBLE = 1;
    public static final byte LONG = 2;
    public static final byte INTEGER = 3;
    public static final byte OBJECT = 5;
    private static final byte _minType = 1;
    private static final byte _maxType = 5;
    private byte _type = 0;
    private boolean _initialized = false;
    private static final String JDBC_STATEMENT = "JDBC_Statement";

    private State(boolean bl, Noun noun, String string, byte by, String string2, String string3) {
        super(bl, noun, string, string3);
        this._units = DMSUtil.sanitize(string2, 99, true, false);
        this._type = by;
        switch (by) {
            case 3: {
                this._value = new IntegerValue();
                break;
            }
            case 2: {
                this._value = new LongValue();
                break;
            }
            case 1: {
                this._value = new DoubleValue();
                break;
            }
            case 5: {
                this._value = new ObjectValue();
                break;
            }
            case 0: {
                this._value = new AnyValue();
                this._type = 0;
            }
        }
        if (this._type != 0) {
            this._metrics[0] = new Metric(this._name + ".value", this._description, this._units, this, false, this._type, 0);
        }
        this.setUpdateTime(0L);
        this.traceAction(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static State makeState(Noun noun, String string, byte by, String string2, String string3) {
        State state = null;
        String string4 = DMSUtil.sanitize(string, 511, true, true);
        if (by < 1 || by > 5) {
            by = 0;
        }
        Noun noun2 = noun;
        synchronized (noun2) {
            state = (State)noun.getSensor(string4);
            if (state == null) {
                state = new State(false, noun, string4, by, string2, string3);
            }
        }
        return state;
    }

    private static State getState(String string, byte by, String string2, String string3) {
        State state = (State)Sensor.lookupCache(string);
        if (state != null) {
            return state;
        }
        Noun noun = Sensor.createParent(string);
        String string4 = DMSUtil.getLeafFromPath(string);
        state = State.makeState(noun, string4, by, string2, string3);
        state.addToCache(string);
        return state;
    }

    public static State create(Noun noun, String string, byte by, String string2, String string3) {
        if (string == null || string.length() == 0 || string3 == null || string2 == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("PARAM_ERROR3", new Object[]{"State.create(NSiSS)", string, string2, string3}));
        }
        if (by < 1 || by > 5) {
            throw new InstrumentationException(DMSNLSupport.getMessage("WRONG_TYPE", null));
        }
        return State.makeState(noun, string, by, string2, string3);
    }

    public static State create(String string, byte by, String string2, String string3) {
        if (string == null || string.length() == 0 || string3 == null || string2 == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("PARAM_ERROR3", new Object[]{"State.create(SiSS)", string, string2, string3}));
        }
        if (by < 1 || by > 5) {
            throw new InstrumentationException(DMSNLSupport.getMessage("WRONG_TYPE", null));
        }
        return State.getState(string, by, string2, string3);
    }

    public static State create(String string, String string2, String string3, int n) {
        if (string == null || string.length() == 0 || string3 == null || string2 == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("PARAM_ERROR", new Object[]{"State.create(SSSi)", string, string2, string3}));
        }
        State state = State.getState(string, (byte)0, string2, string3);
        if (!state.isInitialized()) {
            state.initialize((byte)3, new Integer(n));
        }
        return state;
    }

    public static State create(String string, String string2, String string3, long l) {
        if (string == null || string.length() == 0 || string3 == null || string2 == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("PARAM_ERROR", new Object[]{"State.create(SSSl)", string, string2, string3}));
        }
        State state = State.getState(string, (byte)0, string2, string3);
        if (!state.isInitialized()) {
            state.initialize((byte)2, new Long(l));
        }
        return state;
    }

    public static State create(String string, String string2, String string3, double d) {
        if (string == null || string.length() == 0 || string3 == null || string2 == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("PARAM_ERROR", new Object[]{"State.create(SSSd)", string, string2, string3}));
        }
        State state = State.getState(string, (byte)0, string2, string3);
        if (!state.isInitialized()) {
            state.initialize((byte)1, new Double(d));
        }
        return state;
    }

    public static State create(String string, String string2, String string3, Object object) {
        if (string == null || string.length() == 0 || string3 == null || string2 == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("PARAM_ERROR", new Object[]{"State.create(SSSO)", string, string2, string3}));
        }
        State state = State.getState(string, (byte)0, string2, string3);
        if (!state.isInitialized()) {
            state.initialize((byte)5, object);
        }
        return state;
    }

    public static State create(Noun noun, String string, String string2, String string3, int n) {
        if (noun == null || string == null || string2 == null || string3 == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("PARAM_ERROR5", new Object[]{"State.create(NSSSi)", noun, string, string2, string3}));
        }
        State state = State.makeState(noun, string, (byte)0, string2, string3);
        if (!state.isInitialized()) {
            state.initialize((byte)3, new Integer(n));
        }
        return state;
    }

    public static State create(Noun noun, String string, String string2, String string3, long l) {
        if (noun == null || string == null || string2 == null || string3 == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("PARAM_ERROR5", new Object[]{"State.create(NSSSl)", noun, string, string2, string3}));
        }
        State state = State.makeState(noun, string, (byte)0, string2, string3);
        if (!state.isInitialized()) {
            state.initialize((byte)2, new Long(l));
        }
        return state;
    }

    public static State create(Noun noun, String string, String string2, String string3, double d) {
        if (noun == null || string == null || string2 == null || string3 == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("PARAM_ERROR5", new Object[]{"State.create(NSSSd)", noun, string, string2, string3}));
        }
        State state = State.makeState(noun, string, (byte)0, string2, string3);
        if (!state.isInitialized()) {
            state.initialize((byte)1, new Double(d));
        }
        return state;
    }

    public static State create(Noun noun, String string, String string2, String string3, Object object) {
        if (noun == null || string == null || string2 == null || string3 == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("PARAM_ERROR5", new Object[]{"State.create(NSSSO)", noun, string, string2, string3}));
        }
        State state = State.makeState(noun, string, (byte)0, string2, string3);
        if (!state.isInitialized()) {
            state.initialize((byte)5, object);
        }
        return state;
    }

    public State(Noun noun, String string, String string2, String string3, int n) {
        this(true, noun, string, 0, string2, string3);
        this.initialize((byte)3, new Integer(n));
    }

    public State(Noun noun, String string, String string2, String string3, long l) {
        this(true, noun, string, 0, string2, string3);
        this.initialize((byte)2, new Long(l));
    }

    public State(Noun noun, String string, String string2, String string3, double d) {
        this(true, noun, string, 0, string2, string3);
        this.initialize((byte)1, new Double(d));
    }

    public State(Noun noun, String string, String string2, String string3, Object object) {
        this(true, noun, string, 0, string2, string3);
        this.initialize((byte)5, object);
    }

    private void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.setInitialized(true);
        if (this._metrics[0] != null) {
            return;
        }
        switch (this._type) {
            case 1: 
            case 2: 
            case 3: {
                this._metrics[0] = new Metric(this._name + ".value", this._description, this._units, this, false, this._type, 0);
                break;
            }
            case 5: {
                this._metrics[0] = new Metric(this._name + ".value", this._description, this._units, this, false, 4, 0);
            }
        }
    }

    private void initialize(byte by, Object object) {
        if (this.isInitialized() || this._type != 0) {
            return;
        }
        this.setInitialized(true);
        this.setUpdateTime();
        this._value = new AnyValue();
        switch (by) {
            case 3: {
                this._value.update((Integer)object);
                this._metrics[0] = new Metric(this._name + ".value", this._description, this._units, this, false, 3, 0);
                break;
            }
            case 2: {
                this._value.update((Long)object);
                this._metrics[0] = new Metric(this._name + ".value", this._description, this._units, this, false, 2, 0);
                break;
            }
            case 1: {
                this._value.update((Double)object);
                this._metrics[0] = new Metric(this._name + ".value", this._description, this._units, this, false, 1, 0);
                break;
            }
            default: {
                if (object instanceof String && JDBC_STATEMENT.equals(this.getParent().getType()) && object.equals("null")) {
                    object = "";
                }
                this._value.update(object);
                this._metrics[0] = new Metric(this._name + ".value", this._description, this._units, this, false, 4, 0);
            }
        }
        this.traceAction(8);
    }

    private void traceAction(int n) {
        if (this.isTraceable()) {
            if (!this._initialized && this._type == 0) {
                return;
            }
            Tracer tracer = ExecutionContext.get().getTracer();
            if (tracer != null) {
                Object object;
                String string = null;
                string = this._value != null ? ((object = this._value.getValue()) == null ? "" : object.toString()) : "";
                tracer.append(this, n, string);
            }
        }
    }

    public synchronized void deriveMetric(int n) {
        if (!this.isAlive()) {
            return;
        }
        this._value.deriveMetric(n);
        boolean bl = false;
        if ((n & 2) > 0 && this._metrics[1] == null) {
            this._metrics[1] = new Metric(this._name + ".count", this._description, "ops", this, false, 3, 1);
            bl = true;
        }
        byte by = this._type;
        switch (this._type) {
            case 0: {
                Object object = this._value.getValue();
                if (!(object instanceof Number)) break;
                by = 1;
            }
            case 1: 
            case 2: 
            case 3: {
                if ((n & 8) > 0 && this._metrics[3] == null) {
                    this._metrics[3] = new Metric(this._name + ".maxValue", this._description, this._units, this, false, by, 3);
                    bl = true;
                }
                if ((n & 4) <= 0 || this._metrics[2] != null) break;
                this._metrics[2] = new Metric(this._name + ".minValue", this._description, this._units, this, false, by, 2);
                bl = true;
            }
        }
        if (bl && this.isInitialized()) {
            this.setUpdateTime();
        }
    }

    public static void update(String string, int n) {
        ((State)Sensor.get(string)).update(n);
    }

    public static void update(String string, long l) {
        ((State)Sensor.get(string)).update(l);
    }

    public static void update(String string, double d) {
        ((State)Sensor.get(string)).update(d);
    }

    public static void update(String string, Object object) {
        ((State)Sensor.get(string)).update(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int n) {
        long l = System.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.update(n);
            this.updateAdmin(l);
        }
        if (this.isLoggable()) {
            this.logActivation(n + " " + this._units);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long l) {
        long l2 = System.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.update(l);
            this.updateAdmin(l2);
        }
        if (this.isLoggable()) {
            this.logActivation(l + " " + this._units);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(double d) {
        long l = System.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.update(d);
            this.updateAdmin(l);
        }
        if (this.isLoggable()) {
            this.logActivation(d + " " + this._units);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object object) {
        long l = System.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.update(object);
            this.updateAdmin(l);
        }
        if (this.isLoggable()) {
            this.logActivation(object + " " + this._units);
        }
    }

    private void updateAdmin(long l) {
        if (!this.isInitialized() && this._type != 0) {
            this.initialize();
        }
        this.setUpdateTime(l);
        ++this._updateCount;
        this.traceAction(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(int n) {
        long l = System.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.increment(n);
            this.updateAdmin(l);
        }
        if (this.isLoggable()) {
            this.logActivation(this._value.getValue() + " " + this._units);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(long l) {
        long l2 = System.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.increment(l);
            this.updateAdmin(l2);
        }
        if (this.isLoggable()) {
            this.logActivation(this._value.getValue() + " " + this._units);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(double d) {
        long l = System.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.increment(d);
            this.updateAdmin(l);
        }
        if (this.isLoggable()) {
            this.logActivation(this._value.getValue() + " " + this._units);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(Metric metric) {
        if (metric == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage("DOESNT_BELONG", new Object[]{"State.getValue(Metric)", metric, this}));
        }
        if (!metric.isAlive()) {
            return new ErrorObject();
        }
        byte by = metric.getIndex();
        if (this._metrics[by] != metric) {
            throw new InstrumentationException(DMSNLSupport.getMessage("DOESNT_BELONG", new Object[]{"State.getValue(Metric)", metric, this}));
        }
        State state = this;
        synchronized (state) {
            if (!this.isAlive()) {
                return new ErrorObject();
            }
            switch (by) {
                case 1: {
                    return new Integer(this._updateCount);
                }
                case 2: {
                    return this._value.getMin();
                }
                case 3: {
                    return this._value.getMax();
                }
                case 0: {
                    return this._value.getValue();
                }
            }
        }
        throw new InstrumentationException(DMSNLSupport.getMessage("DOESNT_BELONG", new Object[]{"State.getValue(Metric)", metric, this}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        long l = System.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._updateCount = 0;
            this._value.reset();
            this.setUpdateTime(l);
            this.setResetTime(l);
            this.setInitialized(false);
        }
    }

    State getCousin(Noun noun) {
        State state = null;
        Noun noun2 = this.getParent().getCousin(noun);
        if (noun2 != null) {
            state = State.create(noun2, this._name, this._units, "cousin", this._value);
        }
        return state;
    }

    public void setCopy(boolean bl) {
        this._value.setCopy(bl);
    }

    public byte getValueType() {
        return this._type;
    }

    synchronized void setInitialized(boolean bl) {
        this._initialized = bl;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public String getValueTypeString() {
        switch (this._type) {
            case 1: {
                return new String("State.DOUBLE");
            }
            case 3: {
                return new String("State.INTEGER");
            }
            case 2: {
                return new String("State.LONG");
            }
            case 5: {
                return new String("State.OBJECT");
            }
        }
        return new String("State.ANY");
    }
}

