/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.JTMLog;
import com.eg.jtm.JTMUtils;
import com.eg.jtm.UPDManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class PropsManager {
    public static final String requestIDSep = " @ ";
    public static int Max_Slow_URLs = 10;
    public static int Max_Error_URLs = 10;
    public static double Meth_Exec_CutOff;
    public static String EG_JTM_HOME;
    public static int JTM_Port;
    public static int prev_JTM_Port;
    public static InetAddress DesigAgtInetAddr;
    public static boolean useDesigAgtOnly;
    public static boolean portChanged;
    public static boolean measPeriodChanged;
    public static boolean desigAgtChanged;
    public static boolean isAutoURLPatternDiscovery;
    public static double Slow_URL_Threshold;
    public static long egMeasPeriod;
    public static long RASwitchOverCutoff;
    public static Vector excludeCharsList;
    public static Hashtable patternTbl;
    public static Vector FilteredPatternsList;
    public static final String[] subCompNames;
    public static final String[] propsOrder;
    private static Properties JTMProps;
    public static boolean TalkingToAgent;
    private static boolean JTM_Enabled;
    public static boolean showUrlInStdOut;
    public static boolean isCutOffSql;
    public static boolean jtmDebugEnabled;
    public static int URLLevel;
    public static String urlPatternMode;
    public static int lazyTimeInseconds;
    public static String prevURLPatternMode;
    private static int maxPOJOTraceMethods;
    private static int otherPointcutMethodLimit;
    private static int recursionTraceLimit;
    private static boolean pojoTrack;
    private static long pojoTracePeriod;
    private static long maxTracePeriod;
    private static long maxSQLTraceCount;
    private static int maxExceptionLineCount;
    public static final String MAX_POJO_CALL_TRACE_COUNT = "MAX_POJO_CALL_TRACE_COUNT";
    public static final String MAX_POJO_CALL_TRACE_TIME = "MAX_POJO_CALL_TRACE_TIME";
    public static final String MAX_SQL_QUERY_COUNT = "MAX_SQL_QUERY_COUNT";
    public static String Chars_TO_Exclude;
    private static final String IGNORE_EXCEPTIONS = "IGNORE_EXCEPTIONS";
    private static final String MAX_EXCEPTION_TRACE_LINE_COUNT = "MAX_EXCEPTION_TRACE_LINE_COUNT";
    private static final String MAX_POINTCUT_LIMIT = "MAX_POINTCUT_LIMIT";
    private static final String RECURSION_TRACE_LIMIT = "RECURSION_TRACE_LIMIT";
    private static ArrayList ignoreExceptionList;
    public static File connPropsFile;
    public static File logPropsFile;
    public static File otherPropsFile;
    public static String connPropsFileName;
    public static String logPropsFileName;
    public static String otherPropsFileName;
    private static final Double invalidDouble;
    private static final Long invalidLong;
    private static final Integer invalidInteger;

    static {
        EG_JTM_HOME = "";
        JTM_Port = -1;
        prev_JTM_Port = -1;
        useDesigAgtOnly = false;
        portChanged = false;
        measPeriodChanged = false;
        desigAgtChanged = false;
        isAutoURLPatternDiscovery = true;
        excludeCharsList = new Vector();
        patternTbl = new Hashtable();
        FilteredPatternsList = new Vector();
        subCompNames = new String[]{"ALL_URLS", "SLOW_URLS", "ERROR_URLS", "FILTER", "JSP", "HTTPSERVLET", "GENERICSERVLET", "JDBC", "SQL", "EXCEPTION", "STRUTS", "NATIVE", "RMI", "JAXM", "EMAIL", "EJB", "JNDI", "JXTA", "POJO", "HTTP", "WEBSERVICE"};
        propsOrder = new String[]{"URL_Pattern_Discovery_Mode", "URL_Patterns", "Max_URL_Segments", "Filtered_URL_Patterns", "Slow_URL_Threshold", "Method_Exec_CutOff", "Max_Slow_URLs_Per_Test_Period", "Max_Error_URLs_Per_Test_Period", "egMeasPeriod"};
        TalkingToAgent = true;
        JTM_Enabled = false;
        showUrlInStdOut = false;
        isCutOffSql = true;
        jtmDebugEnabled = false;
        URLLevel = 2;
        urlPatternMode = "Auto";
        lazyTimeInseconds = 180;
        prevURLPatternMode = "Auto";
        maxPOJOTraceMethods = 200;
        otherPointcutMethodLimit = 1000;
        recursionTraceLimit = 1000;
        pojoTrack = false;
        maxTracePeriod = pojoTracePeriod = 10000L;
        maxSQLTraceCount = 3000L;
        maxExceptionLineCount = 10;
        Chars_TO_Exclude = "Chars_TO_Exclude";
        ignoreExceptionList = new ArrayList();
        PropsManager.resetJTMEnabled();
        invalidDouble = new Double(-1.0);
        invalidLong = new Long(-1L);
        invalidInteger = new Integer(-1);
    }

    public static void initProps() {
        JTMProps = new Properties();
        JTMProps.put("Slow_URL_Threshold", "3.0");
        JTMProps.put("egMeasPeriod", "300");
        JTMProps.put("URL_Pattern_Discovery_Mode", "Auto");
        JTMProps.put("URL_Patterns", "None");
        JTMProps.put("Max_URL_Segments", "2");
        JTMProps.put("Filtered_URL_Patterns", "None");
        JTMProps.put("Method_Exec_CutOff", "0.0500");
        JTMProps.put("Max_Slow_URLs_Per_Test_Period", "10");
        JTMProps.put("Max_Error_URLs_Per_Test_Period", "10");
        JTMProps.put(MAX_POJO_CALL_TRACE_COUNT, "200");
        JTMProps.put(MAX_POJO_CALL_TRACE_TIME, "10");
        JTMProps.put(MAX_SQL_QUERY_COUNT, "3000");
        JTMProps.put(Chars_TO_Exclude, "\\");
        JTMProps.put(MAX_EXCEPTION_TRACE_LINE_COUNT, "10");
        JTMProps.put(MAX_POINTCUT_LIMIT, "1000");
        JTMProps.put(RECURSION_TRACE_LIMIT, "1000");
    }

    public static void loadPropsFromFile() {
        try {
            JTMProps.load(new BufferedInputStream(new FileInputStream(otherPropsFileName)));
            JTMLog.logger.info("Using the following parameters from file " + otherPropsFileName);
            JTMLog.logger.info(JTMProps.toString());
        }
        catch (FileNotFoundException fnfe) {
            JTMLog.logger.warn(" JTM props file not found.", fnfe);
        }
        catch (IOException ioe) {
            JTMLog.logger.warn(" IOException while trying to read from JTM props file ", ioe);
        }
    }

    public static void handlePropChangesFromTest(ArrayList CliList) {
        String urlLevel;
        JTMLog.logger.info("Received props from agent: " + CliList);
        String urlPatternMode = (String)CliList.get(0);
        if (PropsManager.isStringPropUpdated(propsOrder[0], urlPatternMode)) {
            UPDManager.setURLPatternDiscoveryMode(urlPatternMode);
        }
        String currPropVal = (String)CliList.get(1);
        if (isAutoURLPatternDiscovery) {
            currPropVal = "None";
        }
        if (PropsManager.isStringPropUpdated(propsOrder[1], PropsManager.cleanupPatternStr(currPropVal, true))) {
            UPDManager.updatePatternData(currPropVal);
        }
        if (currPropVal != null && currPropVal.trim().length() > 0) {
            if (currPropVal.equalsIgnoreCase("none")) {
                UPDManager.setValidPattern(false);
            } else {
                UPDManager.setValidPattern(true);
            }
        }
        if (PropsManager.isIntegerPropUpdated(propsOrder[2], urlLevel = (String)CliList.get(2))) {
            UPDManager.setNoOfURLSegments(urlLevel);
        }
        if (PropsManager.isStringPropUpdated(propsOrder[3], PropsManager.cleanupFilteredPatternStr(currPropVal = (String)CliList.get(3)))) {
            UPDManager.updateFilteredPatternsTbl(currPropVal);
        }
        if (PropsManager.isDoublePropUpdated(propsOrder[4], currPropVal = (String)CliList.get(4))) {
            UPDManager.setSlowURLThreshold(currPropVal);
        }
        if (PropsManager.isDoublePropUpdated(propsOrder[5], currPropVal = (String)CliList.get(5))) {
            UPDManager.setMethExecCutOff(currPropVal);
        }
        if (PropsManager.isIntegerPropUpdated(propsOrder[6], currPropVal = (String)CliList.get(6))) {
            UPDManager.setMaxSlowURLs(currPropVal);
        }
        if (PropsManager.isIntegerPropUpdated(propsOrder[7], currPropVal = (String)CliList.get(7))) {
            UPDManager.setMaxErrorURLs(currPropVal);
        }
        if (PropsManager.isLongPropUpdated(propsOrder[8], currPropVal = (String)CliList.get(8))) {
            UPDManager.setEgMeasPeriod(currPropVal);
        }
        CliList.clear();
    }

    public static void applyJTMProps() {
        UPDManager.setSlowURLThreshold(JTMProps.getProperty("Slow_URL_Threshold"));
        UPDManager.setEgMeasPeriod(JTMProps.getProperty("egMeasPeriod"));
        prevURLPatternMode = JTMProps.getProperty("URL_Pattern_Discovery_Mode");
        UPDManager.setURLPatternDiscoveryMode(prevURLPatternMode);
        if (!isAutoURLPatternDiscovery) {
            UPDManager.updatePatternData(JTMProps.getProperty("URL_Patterns"));
        } else {
            UPDManager.setNoOfURLSegments(JTMProps.getProperty("Max_URL_Segments"));
        }
        UPDManager.setMethExecCutOff(JTMProps.getProperty("Method_Exec_CutOff"));
        UPDManager.updateFilteredPatternsTbl(JTMProps.getProperty("Filtered_URL_Patterns"));
        UPDManager.setMaxSlowURLs(JTMProps.getProperty("Max_Slow_URLs_Per_Test_Period"));
        UPDManager.setMaxErrorURLs(JTMProps.getProperty("Max_Error_URLs_Per_Test_Period"));
        PropsManager.updateOtherJTMProps();
    }

    public static void updateOtherJTMProps() {
        String maxRecursionTracelimit;
        String maxPointcutlimit;
        String[] patterns;
        String sqlTraceCount;
        long currentValue;
        String pojoTraceMaxTime;
        String pojoTraceCount;
        String sqlCutOffString = JTMProps.getProperty("CutOffSQL");
        isCutOffSql = sqlCutOffString == null || sqlCutOffString.length() <= 0 || !sqlCutOffString.equalsIgnoreCase("false");
        String lazyTimePeriod = JTMProps.getProperty("LazyTimePeriod");
        if (lazyTimePeriod != null && lazyTimePeriod.length() > 0) {
            try {
                lazyTimeInseconds = Integer.parseInt(lazyTimePeriod);
            }
            catch (Exception e) {
                lazyTimeInseconds = 180;
            }
        }
        if ((pojoTraceCount = JTMProps.getProperty(MAX_POJO_CALL_TRACE_COUNT)) != null && pojoTraceCount.length() > 0) {
            try {
                int pojoCallCount = Integer.parseInt(pojoTraceCount);
                pojoCallCount = Math.abs(pojoCallCount);
                int currentValue2 = PropsManager.getMaxPOJOTraceMethods();
                if (currentValue2 != pojoCallCount) {
                    PropsManager.setMaxPOJOTraceMethods(pojoCallCount);
                }
            }
            catch (Exception e) {
                PropsManager.setMaxPOJOTraceMethods(maxPOJOTraceMethods);
            }
        }
        if ((pojoTraceMaxTime = JTMProps.getProperty(MAX_POJO_CALL_TRACE_TIME)) != null && pojoTraceMaxTime.length() > 0) {
            try {
                int pojoCallTime = Integer.parseInt(pojoTraceMaxTime);
                pojoCallTime = Math.abs(pojoCallTime);
                long modifiedValue = (long)pojoCallTime * 1000L;
                currentValue = PropsManager.getPOJOTracePeriod();
                if (currentValue != modifiedValue) {
                    PropsManager.setPOJOTracePeriod(pojoCallTime);
                }
            }
            catch (Exception e) {
                PropsManager.setPOJOTracePeriod(10);
            }
        }
        if ((sqlTraceCount = JTMProps.getProperty(MAX_SQL_QUERY_COUNT)) != null && sqlTraceCount.length() > 0) {
            try {
                long sqlCallCount = Long.parseLong(sqlTraceCount);
                sqlCallCount = Math.abs(sqlCallCount);
                currentValue = PropsManager.getMaxSQLTraceCount();
                if (currentValue != sqlCallCount) {
                    PropsManager.setMaxSQLTraceCount(sqlCallCount);
                }
            }
            catch (Exception e) {
                PropsManager.setMaxSQLTraceCount(3000L);
            }
        }
        String charToExclude = JTMProps.getProperty(Chars_TO_Exclude);
        HashSet<String> tempCharExcludeList = new HashSet<String>();
        if (charToExclude != null && charToExclude.length() > 0 && (patterns = charToExclude.split(",")).length != 0) {
            String[] stringArray = patterns;
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                tempCharExcludeList.add(pattern);
                ++n2;
            }
            JTMLog.logger.info("Exclude the URLs that contanis the chars from the list " + tempCharExcludeList);
        }
        excludeCharsList.clear();
        excludeCharsList.addAll(tempCharExcludeList);
        tempCharExcludeList = null;
        String ignoreExceptions = JTMProps.getProperty(IGNORE_EXCEPTIONS);
        if (ignoreExceptions != null && ignoreExceptions.length() > 0) {
            String[] exceptions = ignoreExceptions.split(",");
            ArrayList<String> temporaryIgnoreExceptionList = new ArrayList<String>();
            String[] stringArray = exceptions;
            int n = exceptions.length;
            int n3 = 0;
            while (n3 < n) {
                String exception = stringArray[n3];
                if (!temporaryIgnoreExceptionList.contains(exception.trim())) {
                    temporaryIgnoreExceptionList.add(exception.trim());
                }
                ++n3;
            }
            ignoreExceptionList.clear();
            ignoreExceptionList.addAll(temporaryIgnoreExceptionList);
            temporaryIgnoreExceptionList = null;
        } else {
            ignoreExceptionList.clear();
        }
        String maxExceptionLines = JTMProps.getProperty(MAX_EXCEPTION_TRACE_LINE_COUNT);
        if (maxExceptionLines != null && maxExceptionLines.length() > 0) {
            try {
                int maxStackLineCount = Integer.parseInt(maxExceptionLines);
                int currentValue3 = PropsManager.getMaxExceptionLineCount();
                if (currentValue3 != maxStackLineCount) {
                    if (maxStackLineCount == -1 || maxStackLineCount >= 10) {
                        PropsManager.setMaxExceptionLineCount(maxStackLineCount);
                    } else {
                        PropsManager.setMaxExceptionLineCount(10);
                    }
                }
            }
            catch (Exception e) {
                PropsManager.setMaxExceptionLineCount(10);
                JTMLog.logger.warn("[PropsManager - updateOtherProps ] parsing Exception : " + e);
            }
        }
        if ((maxPointcutlimit = JTMProps.getProperty(MAX_POINTCUT_LIMIT)) != null && maxPointcutlimit.length() > 0) {
            try {
                int maxPCLimit = Integer.parseInt(maxPointcutlimit);
                int currentvalue = PropsManager.getOtherPointcutMethodLimit();
                if (maxPCLimit > 100) {
                    if (currentvalue != maxPCLimit) {
                        PropsManager.setOtherPointcutMethodLimit(maxPCLimit);
                    }
                } else {
                    JTMLog.logger.info("MAX_POINTCUT_LIMIT is too low, setting the current value :" + currentvalue);
                }
            }
            catch (Exception e) {
                PropsManager.setOtherPointcutMethodLimit(1000);
                JTMLog.logger.warn("Invalid  MAX_POINTCUT_LIMIT value : " + maxPointcutlimit + "  " + e);
            }
        }
        if ((maxRecursionTracelimit = JTMProps.getProperty(RECURSION_TRACE_LIMIT)) != null && maxRecursionTracelimit.length() > 0) {
            try {
                int maxPCLimit = Integer.parseInt(maxRecursionTracelimit);
                int currentvalue = PropsManager.getRecursionTraceLimit();
                if (maxPCLimit != currentvalue) {
                    recursionTraceLimit = maxPCLimit;
                }
            }
            catch (Exception e) {
                recursionTraceLimit = 1000;
            }
        }
    }

    public static void setPropFileNames() {
        connPropsFileName = String.valueOf(EG_JTM_HOME) + File.separatorChar + "jtmConn.props";
        connPropsFile = new File(connPropsFileName);
        logPropsFileName = String.valueOf(EG_JTM_HOME) + File.separatorChar + "jtmLogging.props";
        logPropsFile = new File(logPropsFileName);
        otherPropsFileName = String.valueOf(EG_JTM_HOME) + File.separatorChar + "jtmOther.props";
        otherPropsFile = new File(otherPropsFileName);
    }

    public static boolean isPropsFileValid(File propsFile) {
        if (propsFile != null) {
            boolean retBool = propsFile.exists() && propsFile.isFile() && propsFile.length() != 0L;
            return retBool;
        }
        return false;
    }

    private static boolean isStringPropUpdated(String propName, String currValStr) {
        if (currValStr == null) {
            return false;
        }
        if (currValStr.length() != 0) {
            String prevValStr = JTMProps.getProperty(propName);
            if (!currValStr.equals(prevValStr) || !TalkingToAgent) {
                JTMProps.setProperty(propName, currValStr);
                JTMLog.logger.info("Updated param " + propName + " with " + currValStr);
                return true;
            }
            return false;
        }
        JTMLog.logger.warn("Cannot update property " + propName + " with blank value.");
        return false;
    }

    private static boolean isDoublePropUpdated(String propName, String currValStr) {
        if (currValStr == null) {
            return false;
        }
        Double currVal = JTMUtils.String2Double(currValStr);
        String prevValStr = JTMProps.getProperty(propName);
        Double prevVal = JTMUtils.String2Double(prevValStr);
        if (currVal != invalidDouble) {
            if (!currVal.equals(prevVal)) {
                JTMProps.setProperty(propName, currValStr);
                JTMLog.logger.info("Updated prop " + propName + " with " + currValStr);
                return true;
            }
            return false;
        }
        JTMLog.logger.warn("Value from manager for prop " + propName + "(" + currValStr + ") was invalid. Using previous value (" + prevValStr + ")");
        return false;
    }

    private static boolean isLongPropUpdated(String propName, String currValStr) {
        if (currValStr == null) {
            return false;
        }
        String prevValStr = JTMProps.getProperty(propName);
        Long prevVal = JTMUtils.String2Long(prevValStr);
        Long currVal = JTMUtils.String2Long(currValStr);
        if (currVal != invalidLong) {
            if (!currVal.equals(prevVal)) {
                JTMProps.setProperty(propName, currValStr);
                JTMLog.logger.info("Updated prop " + propName + " with " + currValStr);
                return true;
            }
            return false;
        }
        JTMLog.logger.warn("Value from manager for prop " + propName + "(" + currValStr + ") was invalid. Using previous value (" + prevValStr + ")");
        return false;
    }

    private static boolean isIntegerPropUpdated(String propName, String currValStr) {
        if (currValStr == null) {
            return false;
        }
        String prevValStr = JTMProps.getProperty(propName);
        Integer prevVal = JTMUtils.String2Integer(prevValStr);
        Integer currVal = JTMUtils.String2Integer(currValStr);
        if (currVal != invalidInteger) {
            if (!currVal.equals(prevVal)) {
                JTMProps.setProperty(propName, currValStr);
                JTMLog.logger.info("Updated prop " + propName + " with " + currValStr);
                return true;
            }
            return false;
        }
        JTMLog.logger.warn("Value from manager for prop " + propName + "(" + currValStr + ") was invalid. Using previous value (" + prevValStr + ")");
        return false;
    }

    private static String cleanupFilteredPatternStr(String patternsString) {
        if (patternsString == null) {
            return "None";
        }
        if (patternsString.trim().equalsIgnoreCase("None")) {
            return patternsString;
        }
        String[] patterns = patternsString.split(",");
        StringBuffer cleanedPatternsSB = new StringBuffer();
        ArrayList<String> tmpList = new ArrayList<String>();
        int i = 0;
        while (i < patterns.length) {
            String tempPatternString = patterns[i];
            if (tempPatternString != null && tempPatternString.trim().length() > 0 && !tmpList.contains(tempPatternString)) {
                tmpList.add(tempPatternString);
                if (cleanedPatternsSB.length() == 0) {
                    cleanedPatternsSB.append(tempPatternString);
                } else {
                    cleanedPatternsSB.append(",").append(tempPatternString);
                }
            }
            ++i;
        }
        tmpList.clear();
        return cleanedPatternsSB.toString();
    }

    private static String cleanupPatternStr(String patternsString, boolean acceptNone) {
        if (patternsString == null) {
            return null;
        }
        if (acceptNone && patternsString.trim().equalsIgnoreCase("None")) {
            return patternsString;
        }
        String[] patterns = patternsString.split(",");
        StringBuffer cleanedPatternsSB = new StringBuffer();
        if (patterns.length != 0) {
            int i = 0;
            while (i < patterns.length) {
                if (PropsManager.ValidateSyntax(patterns[i])) {
                    if (cleanedPatternsSB.length() == 0) {
                        cleanedPatternsSB.append(patterns[i]);
                    } else {
                        cleanedPatternsSB.append(",").append(patterns[i]);
                    }
                }
                ++i;
            }
        }
        return cleanedPatternsSB.toString();
    }

    private static boolean ValidateSyntax(String patternStr) {
        int delim = 58;
        int idx = patternStr.indexOf(delim);
        if (idx != -1) {
            return patternStr.substring(idx + 1).indexOf(delim) == -1;
        }
        return false;
    }

    public static void setJTMEnabled() {
        System.out.println(new Date() + " *** JTM is ENABLED ***");
        JTM_Enabled = true;
    }

    public static void resetJTMEnabled() {
        System.out.println(new Date() + " *** JTM is DISABLED ***");
        JTM_Enabled = false;
    }

    public static boolean getJTMEnabled() {
        return JTM_Enabled;
    }

    public static int getMaxPOJOTraceMethods() {
        return maxPOJOTraceMethods;
    }

    public static void setMaxPOJOTraceMethods(int traceLines) {
        maxPOJOTraceMethods = traceLines;
        JTMLog.logger.info("Max POJO Trace count is changed to " + PropsManager.getMaxPOJOTraceMethods());
    }

    public static boolean isPojoTrack() {
        return pojoTrack;
    }

    public static void setPojoTrack(boolean flag) {
        pojoTrack = flag;
        if (pojoTrack) {
            JTMLog.logger.info("POJO calls profiling is enabled ");
        } else {
            JTMLog.logger.info("POJO calls profiling is disabled");
        }
    }

    public static void setPOJOTracePeriod(int timeInSec) {
        pojoTracePeriod = (long)timeInSec * 1000L;
        JTMLog.logger.info("Max. POJO call Trace Period is changed to " + PropsManager.getMaxTracePeriod() + "  seconds");
        PropsManager.setMaxTracePeriod();
    }

    public static long getPOJOTracePeriod() {
        return pojoTracePeriod;
    }

    public static void setMaxTracePeriod() {
        maxTracePeriod = PropsManager.getPOJOTracePeriod() + (long)Slow_URL_Threshold * 1000L;
        JTMLog.logger.info("Max.Trace Period is changed to " + PropsManager.getMaxTracePeriod() + "  milliseconds");
    }

    public static long getMaxTracePeriod() {
        return maxTracePeriod;
    }

    public static long getMaxSQLTraceCount() {
        return maxSQLTraceCount;
    }

    public static void setMaxSQLTraceCount(long sqlCount) {
        maxSQLTraceCount = sqlCount;
        JTMLog.logger.info("Max.SQL Trace count is changed to " + PropsManager.getMaxSQLTraceCount());
    }

    public static int getMaxExceptionLineCount() {
        return maxExceptionLineCount;
    }

    private static void setMaxExceptionLineCount(int exceptionLineCount) {
        maxExceptionLineCount = exceptionLineCount;
        JTMLog.logger.info("Max Exception trace Line count is changed to : " + exceptionLineCount);
    }

    public static boolean isExceptionMatchedIgnoreExceptionList(String fullyQualifiedExceptionNames) {
        return ignoreExceptionList.contains(fullyQualifiedExceptionNames);
    }

    public static int getOtherPointcutMethodLimit() {
        return otherPointcutMethodLimit;
    }

    private static void setOtherPointcutMethodLimit(int otherPointcutLimit) {
        otherPointcutMethodLimit = otherPointcutLimit;
        JTMLog.logger.info("Other point-cut limit is changed to : " + otherPointcutMethodLimit);
    }

    public static int getRecursionTraceLimit() {
        return recursionTraceLimit;
    }
}

