/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.JTMLog;
import com.eg.jtm.PropsManager;
import com.eg.jtm.SnapshotTaker;
import com.eg.jtm.UPDManager;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class SnapshotManager {
    static Timer SSTimer;
    static SnapshotTaker ST;
    static int numUnreadSnapshots;
    private static boolean AGENT_REACHABLE;
    private static Date lastContactDateTime;
    private static final int snapshotPeriod = 30000;
    private static boolean initial;
    private static int MAX_UNREAD_LOSTCONN;
    private static int MAX_UNREAD_AGTNA;

    static {
        numUnreadSnapshots = 3;
        AGENT_REACHABLE = false;
        SnapshotManager.resetIsAgentReachable();
        AGENT_REACHABLE = true;
        lastContactDateTime = null;
        initial = false;
        MAX_UNREAD_LOSTCONN = 5;
        MAX_UNREAD_AGTNA = 10;
    }

    public static void incrSnapshotCtr() {
        if (SnapshotManager.isAgentReachable()) {
            if (++numUnreadSnapshots >= MAX_UNREAD_AGTNA) {
                SnapshotManager.resetIsAgentReachable();
                PropsManager.TalkingToAgent = false;
                JTMLog.logger.warn("!!! AGENT NOT REACHABLE. SWITCHING OFF MONITORING !!!");
                UPDManager.clearStoredData();
            } else if (PropsManager.TalkingToAgent && numUnreadSnapshots >= MAX_UNREAD_LOSTCONN) {
                long totalSnapshotTime = numUnreadSnapshots * 30000;
                long maxActiveTime = MAX_UNREAD_AGTNA * 30000;
                long difference = maxActiveTime - totalSnapshotTime;
                JTMLog.logger.warn("*** Looks like the eG agent is running slow & if it continues , after " + difference + " millisecond JTM Monitoring is OFF !!!");
            }
        } else {
            JTMLog.logger.warn("eG Agent is not reachable from " + lastContactDateTime);
        }
    }

    private static void assignValues(long testperiod) {
        if (testperiod >= 30000L) {
            numUnreadSnapshots = (int)(testperiod / 30000L);
            MAX_UNREAD_LOSTCONN = numUnreadSnapshots + 5;
            MAX_UNREAD_AGTNA = numUnreadSnapshots + 10;
        } else {
            numUnreadSnapshots = (int)testperiod;
            MAX_UNREAD_LOSTCONN = numUnreadSnapshots + 2;
            MAX_UNREAD_AGTNA = numUnreadSnapshots + 5;
        }
        if (initial) {
            JTMLog.logger.info(" Since measure period has changed , following shapshot attributes are reassigned!!!");
        } else {
            JTMLog.logger.info("Initialized the following shapshot attributes !!!");
            initial = true;
        }
        JTMLog.logger.info(" numUnreadSnapshots   :" + numUnreadSnapshots);
        JTMLog.logger.info(" MAX_UNREAD_LOSTCONN  :" + MAX_UNREAD_LOSTCONN);
        JTMLog.logger.info(" MAX_UNREAD_AGTNA     :" + MAX_UNREAD_AGTNA);
    }

    public static void resetSnapshotCtr() {
        PropsManager.TalkingToAgent = true;
        numUnreadSnapshots = 0;
        SnapshotManager.setIsAgentReachable();
    }

    public static void scheduleSnapshotTaker() {
        try {
            if (SSTimer != null) {
                SSTimer.cancel();
                SSTimer = null;
            }
            if (ST != null) {
                ST.cancel();
                ST = null;
            }
            SSTimer = new Timer("SnapshotTaker", true);
            ST = new SnapshotTaker();
            SSTimer.schedule((TimerTask)ST, 60000L, 30000L);
            JTMLog.logger.info("Scheduled snapshot timer with a period of 30000 milliseconds.");
            SnapshotManager.assignValues(PropsManager.egMeasPeriod);
        }
        catch (Exception e) {
            JTMLog.logger.error("Exception in scheduleSnapshotTaker", e);
        }
    }

    public static void stopSnapshotTaker() {
        SSTimer.cancel();
        ST.cancel();
        JTMLog.logger.info("Snapshot taker stopped.");
    }

    private static void setIsAgentReachable() {
        JTMLog.logger.info("*** Agent is Reachable ***");
        AGENT_REACHABLE = true;
        lastContactDateTime = null;
    }

    private static void resetIsAgentReachable() {
        JTMLog.logger.info("*** Agent is NOT reachable***");
        AGENT_REACHABLE = false;
        lastContactDateTime = new Date();
    }

    public static boolean isAgentReachable() {
        return AGENT_REACHABLE;
    }
}

