/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.JTMLog;
import com.eg.jtm.JTMServer;
import com.eg.jtm.JTMUtils;
import com.eg.jtm.PropFilesTracker;
import com.eg.jtm.PropsManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class StartServer {
    static boolean started = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void startThread() {
        try {
            if (started) return;
            Class<StartServer> clazz = StartServer.class;
            synchronized (StartServer.class) {
                if (started) return;
                JTMLog.initJTMLogger();
                JTMLog.initJTMDebugLogger();
                PropsManager.resetJTMEnabled();
                if (PropsManager.EG_JTM_HOME == null) {
                    JTMLog.logger.error("JTM_Error: EG_JTM_HOME property was not set!! Aborting JTM startup...");
                    PropsManager.resetJTMEnabled();
                    started = true;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                if (!StartServer.okToStart()) {
                    JTMLog.logger.error("JTM_Error: Aborting JTM Startup");
                    PropsManager.resetJTMEnabled();
                    started = true;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                JTMLog.logger.info("*******************************************************************************************");
                JTMLog.logger.info("************** eG Java Transaction Monitor Begins *************");
                JTMLog.logger.info("*******************************************************************************************");
                JTMLog.logger.info("Working in directory " + PropsManager.EG_JTM_HOME);
                PropsManager.initProps();
                if (PropsManager.isPropsFileValid(PropsManager.otherPropsFile)) {
                    PropsManager.loadPropsFromFile();
                } else {
                    JTMLog.logger.warn("Props file was not valid. Could not load props from file. Using default values instead");
                }
                PropsManager.applyJTMProps();
                PropFilesTracker.scheduleTracking();
                PropsManager.setJTMEnabled();
                JTMServer jtmSrv = new JTMServer();
                jtmSrv.setDaemon(true);
                jtmSrv.setName("JTM_Server");
                jtmSrv.start();
                started = true;
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }
        catch (Exception e) {
            System.out.println("Exception While Starting Thread...");
            e.printStackTrace();
        }
    }

    private static boolean okToStart() {
        File JTM_HOME_DIR_File = new File(PropsManager.EG_JTM_HOME);
        if (!JTM_HOME_DIR_File.isDirectory()) {
            JTMLog.logger.error("JTM_Error: Cannot find EG_JTM_HOME directory : " + PropsManager.EG_JTM_HOME);
            return false;
        }
        PropsManager.setPropFileNames();
        if (!PropsManager.isPropsFileValid(PropsManager.connPropsFile)) {
            JTMLog.logger.error("JTM_Error: Could not find JTM connection properties file in " + PropsManager.EG_JTM_HOME + " or the file is empty.");
            return false;
        }
        Properties connProps = new Properties();
        try {
            connProps.load(new BufferedInputStream(new FileInputStream(PropsManager.connPropsFile)));
        }
        catch (IOException ioe) {
            JTMLog.logger.error("JTM_Error: Exception while getting props from " + PropsManager.connPropsFileName, ioe);
            return false;
        }
        String JTMPortStr = connProps.getProperty("JTM_Port");
        if (JTMPortStr == null) {
            JTMLog.logger.error("JTM_Error: Could not find JTM_Port entry in the connection properties file.");
            return false;
        }
        String portCheckStr = JTMUtils.checkPortAvailability(JTMPortStr);
        if (portCheckStr != null) {
            JTMLog.logger.error("JTM_Error: " + portCheckStr);
            return false;
        }
        System.out.println("OK to start JTM");
        return true;
    }
}

