/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;

public class HTMLNode {
    private HTMLNode parent;
    private String name;
    private AttributeList attr;
    private Vector children;
    private boolean hidden;
    private static String[] defaultStandaloneList = new String[]{"area", "base", "basefont", "bgsound", "br", "col", "dd", "dl", "dt", "font", "frame", "hr", "img", "input", "isindex", "li", "link", "meta", "nextid", "option", "overlay", "p", "param", "tab", "wbr", "!", "!--"};
    private static Vector standaloneList = null;

    public HTMLNode(TagToken tagToken, HTMLNode hTMLNode, Enumeration enumeration) {
        this.parent = hTMLNode;
        this.hidden = false;
        if (tagToken != null) {
            this.name = tagToken.getName();
            this.attr = tagToken.getAttributes();
            this.children = HTMLNode.isStandalone(this.name) ? null : this.parseChildren(enumeration);
        } else {
            this.name = null;
            this.attr = null;
            this.children = this.parseChildren(enumeration);
        }
    }

    public HTMLNode(String string) {
        this.name = string;
        this.parent = null;
        this.attr = new AttributeList();
        this.children = HTMLNode.isStandalone(string) ? null : new Vector();
    }

    public String getName() {
        return this.name;
    }

    public HTMLNode getParent() {
        return this.parent;
    }

    public Enumeration getChildren() {
        if (this.children == null) {
            return null;
        }
        return this.children.elements();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void hide() {
        this.hidden = true;
    }

    public void unhide() {
        this.hidden = false;
    }

    public String getAttribute(String string) {
        if (this.attr == null) {
            return null;
        }
        return this.attr.get(string);
    }

    public Enumeration getAttributes() {
        if (this.attr == null) {
            return null;
        }
        return this.attr.names();
    }

    public String getQuotedAttribute(String string) {
        if (this.attr == null) {
            return null;
        }
        return this.attr.getQuoted(string);
    }

    public String getAttributeToString(String string) {
        if (this.attr == null) {
            return null;
        }
        return this.attr.toString(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.hidden) {
            stringBuffer.append('<');
            stringBuffer.append(this.name);
            if (this.attr != null && this.attr.size() > 0) {
                stringBuffer.append(" " + this.attr);
            }
            stringBuffer.append('>');
        }
        if (HTMLNode.isStandalone(this.name)) {
            return stringBuffer.toString();
        }
        if (this.children != null && this.children.size() > 0) {
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                stringBuffer.append(e.toString());
            }
        }
        if (!this.hidden) {
            stringBuffer.append("</").append(this.name).append(">");
        }
        return stringBuffer.toString();
    }

    public void setParent(HTMLNode hTMLNode) {
        this.parent = hTMLNode;
    }

    public boolean isAttribute(String string) {
        if (this.attr == null) {
            return false;
        }
        return this.attr.exists(string);
    }

    public void addAttribute(String string, String string2) {
        if (this.attr == null) {
            return;
        }
        this.attr.set(string, string2);
    }

    public void addChild(Object object) {
        if (object == null) {
            return;
        }
        if (this.children == null) {
            return;
        }
        if (object instanceof String) {
            this.children.addElement(object);
            return;
        }
        if (object instanceof HTMLNode) {
            this.children.addElement(object);
            ((HTMLNode)object).setParent(this);
            return;
        }
    }

    public void removeChild(HTMLNode hTMLNode) {
        if (hTMLNode == null) {
            return;
        }
        if (this.children == null) {
            return;
        }
        this.children.removeElement(hTMLNode);
    }

    public void addChildBefore(Object object, HTMLNode hTMLNode) {
        if (object == null) {
            return;
        }
        if (this.children == null) {
            return;
        }
        if (hTMLNode == null) {
            this.addChild(object);
            return;
        }
        int n = this.children.size();
        int n2 = this.children.indexOf(hTMLNode);
        if (n2 < 0) {
            n2 = 0;
        }
        if (!(object instanceof String) && !(object instanceof HTMLNode)) {
            return;
        }
        if (n2 == n - 1) {
            this.children.addElement(object);
        } else {
            this.children.insertElementAt(object, n2);
        }
        if (object instanceof HTMLNode) {
            ((HTMLNode)object).setParent(this);
        }
    }

    public void removeAttribute(String string) {
        if (this.attr == null) {
            return;
        }
        this.attr.unset(string);
    }

    public HTMLNode nextSibling() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.nextChild(this);
    }

    public HTMLNode previousSibling() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.previousChild(this);
    }

    public HTMLNode firstChild() {
        if (this.children == null) {
            return null;
        }
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof HTMLNode)) continue;
            return (HTMLNode)e;
        }
        return null;
    }

    public HTMLNode nextChild(HTMLNode hTMLNode) {
        boolean bl = false;
        if (this.children == null) {
            return null;
        }
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (bl) {
                if (!(e instanceof HTMLNode)) continue;
                return (HTMLNode)e;
            }
            if (e != hTMLNode) continue;
            bl = true;
        }
        return null;
    }

    public HTMLNode previousChild(HTMLNode hTMLNode) {
        HTMLNode hTMLNode2 = null;
        boolean bl = true;
        if (this.children == null) {
            return null;
        }
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e == hTMLNode) {
                return hTMLNode2;
            }
            if (!(e instanceof HTMLNode)) continue;
            hTMLNode2 = (HTMLNode)e;
        }
        return null;
    }

    private Vector parseChildren(Enumeration enumeration) {
        Vector<Object> vector = new Vector<Object>();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object e = enumeration.nextElement();
            if (e instanceof TextToken) {
                object = (TextToken)e;
                vector.addElement(((TextToken)object).getText());
                continue;
            }
            if (!(e instanceof TagToken)) continue;
            object = (TagToken)e;
            if (((TagToken)object).isEndTag()) {
                if (this.name == null || !this.name.equals(((TagToken)object).getName())) continue;
                break;
            }
            HTMLNode hTMLNode = new HTMLNode((TagToken)object, this, enumeration);
            vector.addElement(hTMLNode);
        }
        if (vector.size() > 0) {
            return vector;
        }
        return null;
    }

    public static void printDefaultStandaloneList() {
        System.out.println(defaultStandaloneList);
    }

    public static void addStandalone(String string) {
        if (standaloneList == null) {
            return;
        }
        String string2 = string.toLowerCase();
        if (standaloneList.contains(string2)) {
            return;
        }
        standaloneList.addElement(string2);
    }

    public static void removeStandalone(String string) {
        if (standaloneList == null) {
            return;
        }
        String string2 = string.toLowerCase();
        standaloneList.removeElement(string2);
    }

    public static boolean isStandalone(String string) {
        if (standaloneList == null) {
            return true;
        }
        return standaloneList.contains(string);
    }

    private static void setupStandaloneList() {
        standaloneList = new Vector(defaultStandaloneList.length);
        int n = 0;
        while (n < defaultStandaloneList.length) {
            standaloneList.addElement(defaultStandaloneList[n]);
            ++n;
        }
    }

    static {
        HTMLNode.setupStandaloneList();
    }
}

