/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.client.orion;

import com.evermind.client.orion.AdminCommandBase;
import com.evermind.client.orion.AdminCommandException;
import com.evermind.client.orion.AdminCommandUtils;
import com.evermind.server.administration.ApplicationServerAdministrator;
import com.evermind.util.AdminProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeployCommand
extends AdminCommandBase {
    private String _fileName = null;
    private String _appName = null;
    private Map _extraParams = new HashMap();
    private String _clientJarPath = null;

    public DeployCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("deployment subcommand");
            if (command.equals("-file")) {
                this._fileName = this.getNextArgument("deployment -file filename");
                continue;
            }
            if (command.equals("-deploymentName")) {
                this._appName = this.getNextArgument("deployment name");
                continue;
            }
            if (command.equals("-bindWebApp")) {
                this._extraParams.put("bindWebApp", this.getNextArgument("web site name for -bindWebApp"));
                continue;
            }
            if (command.equals("-cluster")) continue;
            if (command.equals("-targetPath")) {
                this._extraParams.put("targetPath", this.getNextArgument("-targetPath argument"));
                continue;
            }
            if (command.equals("-parent")) {
                this._extraParams.put("parent", this.getNextArgument("-parent argument"));
                continue;
            }
            if (command.equals("-deploymentDirectory")) {
                this._extraParams.put("deploymentDirectory", this.getNextArgument("-deploymentDirectory"));
                continue;
            }
            if (command.equals("-autoCreateTables")) {
                this._extraParams.put("autoCreateTables", this.getNextArgument("-autoCreateTables"));
                continue;
            }
            if (command.equals("-iiopClientJar")) {
                this._clientJarPath = this.getNextArgument("-iiopClientJar");
                this._extraParams.put("returnClientJar", "true");
                continue;
            }
            throw new AdminCommandException("Unknown -deploy switch: " + command, 21);
        }
        boolean donotundeploy = AdminProperties.getDoNotUndeployPrevious();
        this._extraParams.put("undeployPrevious", donotundeploy ? "false" : "true");
        this.checkArgIsNull(this._fileName, "-file");
        this.checkArgIsNull(this._appName, "-deploymentName");
    }

    public void execute(ApplicationServerAdministrator admin) throws AdminCommandException {
        File packageFile = new File(this._fileName);
        if (!packageFile.exists()) {
            throw new AdminCommandException("Unable to find archive " + this._fileName, 22);
        }
        if (packageFile.isDirectory()) {
            throw new AdminCommandException(this._fileName + " is a directory, not an archive.", 23);
        }
        Map values = null;
        if (this.getIsLocalHost()) {
            try {
                values = admin.deploy(packageFile.getAbsolutePath(), this._appName, this._extraParams);
            }
            catch (Exception e) {
                throw new AdminCommandException((Throwable)e, "Deploy error: " + e.getMessage());
            }
        }
        Integer id = AdminCommandUtils.uploadFile(admin, packageFile, this._appName + ".ear");
        try {
            values = admin.deploy(id, this._appName, this._extraParams);
        }
        catch (Exception e) {
            throw new AdminCommandException((Throwable)e, "Deploy error: " + e.getMessage());
        }
        System.out.println(values.get("output"));
        if (this._clientJarPath == null) {
            return;
        }
        boolean clientStubsSupported = "true".equals(values.get("<client-stubs-supported>"));
        if (!clientStubsSupported) {
            throw new AdminCommandException("The Server does not support generating client stubs", 25);
        }
        byte[] clientJarBytes = (byte[])values.get("<return-client-jar>");
        if (clientJarBytes == null) {
            throw new AdminCommandException("The Server did not return the iiopClientJar. Please make sure the application deployed contains an EJB jar that requires an associated client jar.", 26);
        }
        try {
            FileOutputStream clientJarOutput = new FileOutputStream(this._clientJarPath);
            clientJarOutput.write(clientJarBytes);
            clientJarOutput.close();
        }
        catch (Exception e) {
            throw new AdminCommandException(e, "Could not make the iiopClientJar" + e.getMessage(), 27);
        }
    }
}

