/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.client.orion;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UploadFileIterator {
    private int _maxBufLen = 1024000;
    private InputStream _iStream;
    private byte[] _buf;
    private int _bufLen;

    public UploadFileIterator(File file) throws IOException {
        this._iStream = new FileInputStream(file);
        long fileLen = file.length();
        int tmplen = (int)fileLen;
        if ((long)tmplen != fileLen) {
            this.init(-1);
        } else {
            this.init((int)fileLen);
        }
    }

    public UploadFileIterator(InputStream iStream) throws IOException {
        this._iStream = iStream;
        this.init(-1);
    }

    public boolean hasMoreBytes() throws IOException {
        return this._iStream != null && this._iStream.available() > 0;
    }

    public byte[] getBytes() throws IOException {
        int bytes = this._iStream.read(this._buf);
        if (bytes < this._bufLen) {
            byte[] newbuf = new byte[bytes];
            for (int i = 0; i < bytes; ++i) {
                newbuf[i] = this._buf[i];
            }
            this._buf = newbuf;
        }
        return this._buf;
    }

    public void setUploadBufLen(int len) {
        if (len > this._maxBufLen) {
            this._bufLen = len;
            this._buf = new byte[this._bufLen];
        }
    }

    private void init(int fileLen) {
        int buflen;
        String bufstr = System.getProperty("upload.buflen");
        if (bufstr != null && (buflen = Integer.parseInt(bufstr)) > this._maxBufLen) {
            this._maxBufLen = buflen;
        }
        this._bufLen = fileLen > 0 && this._maxBufLen > fileLen ? fileLen : this._maxBufLen;
        this._buf = new byte[this._bufLen];
    }
}

