/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.compiler;

import com.evermind.compiler.ClassDescription;
import com.evermind.compiler.CompilationException;
import com.evermind.compiler.JavaCompiler;

public class ExistingClassDescription
extends ClassDescription {
    private Class classObject;

    public ExistingClassDescription(String name) {
        try {
            this.classObject = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class " + name + " not found");
        }
    }

    public ExistingClassDescription(Class classObject, JavaCompiler compiler) throws CompilationException {
        compiler.classDescriptions.add(this);
        if (!classObject.getName().equals("java.lang.Object")) {
            new Exception().printStackTrace();
        }
        System.out.println("ExistingClassDescription(" + classObject.getName() + ")");
        this.compiler = compiler;
        this.classObject = classObject;
        if (classObject.getSuperclass() != null) {
            this.superClassDescription = compiler.findClass(JavaCompiler.emptyVector, classObject.getSuperclass().getName().replace('.', '/'));
        }
        System.out.println("ExistingClassDescription(" + classObject.getName() + ") end");
    }

    public String getName() {
        return this.classObject.getName().replace('.', '/');
    }

    public ClassDescription getSuper() {
        return this.superClassDescription;
    }

    public boolean isInterface() {
        return this.classObject.isInterface();
    }

    public boolean isPrimitive() {
        return this.classObject.isPrimitive();
    }
}

