/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.compiler;

import com.evermind.compiler.Compilable;
import com.evermind.compiler.CompilationException;
import com.evermind.compiler.CompilerFactory;
import com.evermind.compiler.FileLinkedCompilation;
import com.evermind.compiler.LinkedCompiler;
import com.evermind.compiler.SourceObject;
import com.evermind.compiler.SpecialCompilation;
import com.evermind.util.CompilerProperties;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.oc4j.security.OC4JSecurity;

public abstract class FileLinkedCompiler
implements LinkedCompiler {
    protected static String _compiler = CompilerProperties.getBuildCompiler();
    protected static String _compilerDir = CompilerProperties.getBuildCompilerDir();
    protected static String _compilerEncoding = CompilerProperties.getBuildCompilerEncoding();
    protected static String _compilerOptions = CompilerProperties.getBuildCompilerOptions();
    protected OutputStream outputStream = System.out;
    protected byte[] errBuff;
    public static final boolean DELETE_INTERMEDIATE_FILES = !CompilerProperties.getKeepWrapperCode();
    SpecialCompilation callback = null;

    protected void init() {
        if (CompilerFactory.instance().isConfigured()) {
            _compiler = CompilerFactory.instance().getName();
            _compilerDir = CompilerFactory.instance().getDir();
            _compilerEncoding = CompilerFactory.instance().getEncoding();
            _compilerOptions = CompilerFactory.instance().getOptions();
        }
        if (CompilerProperties.getBuildDebug()) {
            this.dump();
        }
    }

    protected void dump() {
        System.out.println("compiler         " + _compiler);
        System.out.println("dir              " + _compilerDir);
        System.out.println("encoding         " + _compilerEncoding);
        System.out.println("options          " + _compilerOptions);
        System.out.println("debug            " + CompilerProperties.getBuildDebug());
    }

    public Collection compile(List sources, Map properties) throws InstantiationException, CompilationException {
        HashMap<String, List> mapSources = new HashMap<String, List>();
        mapSources.put("no_batch_compile", sources);
        return this.compile(mapSources, properties);
    }

    public Collection compile(Map sources, Map properties) throws InstantiationException, CompilationException {
        Collection collection;
        long start_t = System.currentTimeMillis();
        try {
            collection = (Collection)OC4JSecurity.doUnprivileged(new FileLinkedCompilation(this, sources, properties));
            Object var8_6 = null;
        }
        catch (PrivilegedActionException ce) {
            try {
                Exception e = ce.getException();
                if (e instanceof CompilationException) {
                    throw (CompilationException)e;
                }
                if (e instanceof InstantiationException) {
                    throw (InstantiationException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new InternalError("Compilation exception: " + e);
            }
            catch (Throwable throwable) {
                block8: {
                    Object var8_7 = null;
                    long stop_t = System.currentTimeMillis();
                    long elapsed = stop_t - start_t;
                    if (!CompilerProperties.getBuildDebug()) break block8;
                    System.out.println("Compilation elapsed = " + elapsed / 1000L + "s");
                }
                throw throwable;
            }
        }
        long stop_t = System.currentTimeMillis();
        long elapsed = stop_t - start_t;
        if (CompilerProperties.getBuildDebug()) {
            System.out.println("Compilation elapsed = " + elapsed / 1000L + "s");
        }
        return collection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void compile(List sourceFiles, String sourceDirectory, String targetDirectory, Map properties) throws InstantiationException, CompilationException {
        long start_t = System.currentTimeMillis();
        if (CompilerProperties.getBuildDebug()) {
            System.out.println("Start Compilation using " + _compiler);
        }
        try {
            try {
                OC4JSecurity.doUnprivileged(new FileLinkedCompilation(this, sourceFiles, sourceDirectory, targetDirectory, properties));
            }
            catch (PrivilegedActionException ce) {
                Exception e = ce.getException();
                if (e instanceof CompilationException) {
                    throw (CompilationException)e;
                }
                if (e instanceof InstantiationException) {
                    throw (InstantiationException)e;
                }
                if (!(e instanceof RuntimeException)) throw new InternalError("Compilation exception: " + e);
                throw (RuntimeException)e;
            }
            Object var10_6 = null;
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            long stop_t = System.currentTimeMillis();
            long elapsed = stop_t - start_t;
            if (!CompilerProperties.getBuildDebug()) throw throwable;
            System.out.println("Compilation elapsed = " + elapsed / 1000L + "s");
            throw throwable;
        }
        long stop_t = System.currentTimeMillis();
        long elapsed = stop_t - start_t;
        if (!CompilerProperties.getBuildDebug()) return;
        System.out.println("Compilation elapsed = " + elapsed / 1000L + "s");
    }

    public void setCallback(SpecialCompilation callback) {
        this.callback = callback;
    }

    public void setOutputStream(OutputStream out) {
        this.outputStream = out;
    }

    public boolean invokeAnyCallbacks() throws CompilationException {
        if (this.callback == null) {
            return false;
        }
        return this.callback.generateAnySpecialClasses();
    }

    public static String getCompiler() {
        return _compiler;
    }

    public void reset() {
        this.callback = null;
    }

    public void invokeCompiler(Map mapSources, Map properties) throws InstantiationException, CompilationException, IOException {
        String firstFileName = null;
        String classpath = properties.get("classpath") == null ? "" : (String)properties.get("classpath");
        String encoding = (String)properties.get("encoding");
        String sourceDirectory = null;
        String targetDirectory = null;
        String sourceIsClassNameP = (String)properties.get("source.is.class.name");
        boolean sourceIsClassName = true;
        if (sourceIsClassNameP != null && !Boolean.valueOf(sourceIsClassNameP).booleanValue()) {
            sourceIsClassName = false;
        }
        if (encoding == null) {
            encoding = _compilerEncoding;
        }
        Iterator iter = mapSources.keySet().iterator();
        ArrayList tempFullFileNames = new ArrayList();
        String[] compilerArgs = null;
        while (iter.hasNext()) {
            String keyDirectory = (String)iter.next();
            List sources = null;
            if (keyDirectory.equals("no_batch_compile")) {
                sourceDirectory = (String)properties.get("source.directory");
                targetDirectory = (String)properties.get("target.directory");
                sources = (List)mapSources.get("no_batch_compile");
                if (compilerArgs == null) {
                    compilerArgs = this.getCompilerArgs(sourceDirectory, targetDirectory, encoding, classpath);
                }
            } else {
                targetDirectory = sourceDirectory = keyDirectory;
                sources = (List)mapSources.get(sourceDirectory);
                if (compilerArgs == null) {
                    compilerArgs = this.getCompilerArgs(sourceDirectory, null, encoding, classpath);
                }
            }
            String returnedFirstName = this.buildFullPathFileNames(sources, tempFullFileNames, sourceDirectory, sourceIsClassName, compilerArgs == null);
            if (compilerArgs != null) continue;
            firstFileName = returnedFirstName;
        }
        String[] files = new String[tempFullFileNames.size()];
        for (int i = 0; i < tempFullFileNames.size(); ++i) {
            files[i] = (String)tempFullFileNames.get(i);
        }
        String[] args = new String[compilerArgs.length + files.length];
        System.arraycopy(compilerArgs, 0, args, 0, compilerArgs.length);
        System.arraycopy(files, 0, args, compilerArgs.length, files.length);
        this.compile(args, firstFileName);
    }

    private String buildFullPathFileNames(List sources, List fullFileNameSources, String sourceDirectory, boolean sourceIsClassName, boolean isFirstLoop) {
        String firstFileName = null;
        for (int i = 0; i < sources.size(); ++i) {
            if (sourceIsClassName) {
                String className = ((Compilable)sources.get(i)).getName();
                String fileName = className.replace('.', File.separatorChar) + ".java";
                if (isFirstLoop && i == 0) {
                    firstFileName = fileName;
                }
                if (sourceDirectory != null && !sourceDirectory.endsWith("/") && !sourceDirectory.endsWith(File.separator)) {
                    sourceDirectory = sourceDirectory + File.separatorChar;
                }
                if (sourceDirectory != null) {
                    fileName = sourceDirectory + fileName;
                }
                fullFileNameSources.add(fileName);
                continue;
            }
            Object o = sources.get(i);
            fullFileNameSources.add(((SourceObject)o).getName());
        }
        return firstFileName;
    }

    protected abstract void compile(String[] var1, String var2) throws InstantiationException, CompilationException;

    protected abstract String[] getCompilerArgs(String var1, String var2, String var3, String var4);
}

