/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.compiler;

import [Ljava.lang.String;;
import com.evermind.compiler.CompilationException;
import com.evermind.compiler.FileLinkedCompiler;
import com.evermind.util.CompilerProperties;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class Javac
extends FileLinkedCompiler {
    private ClassLoader loader;

    public Javac(ClassLoader loader) {
        this.loader = loader;
    }

    public Collection compile(List sources, Map properties) throws InstantiationException, CompilationException {
        if ((sources = new ArrayList(new HashSet(sources))).isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Class javac = this.getJavacCompiler();
        return super.compile(sources, properties);
    }

    protected String[] getCompilerArgs(String sourceDirectory, String targetDirectory, String encoding, String classpath) {
        int pos = 0;
        int size = 2;
        if (sourceDirectory != null) {
            size += 2;
        }
        if (targetDirectory != null) {
            size += 2;
        }
        if (encoding != null) {
            size += 2;
        }
        String[] compilerArgs = new String[++size];
        compilerArgs[pos++] = "-classpath";
        compilerArgs[pos++] = classpath + File.pathSeparatorChar + '.';
        if (encoding != null) {
            compilerArgs[pos++] = "-encoding";
            compilerArgs[pos++] = encoding;
        }
        if (sourceDirectory != null) {
            compilerArgs[pos++] = "-sourcepath";
            compilerArgs[pos++] = sourceDirectory;
        }
        if (targetDirectory != null) {
            compilerArgs[pos++] = "-d";
            compilerArgs[pos++] = targetDirectory;
        }
        compilerArgs[pos++] = CompilerProperties.getKeepWrapperCode() ? "-g" : "-O";
        return compilerArgs;
    }

    protected void compile(String[] args, String firstFileName) throws InstantiationException, CompilationException {
        try {
            try {
                Class javac = this.getJavacCompiler();
                if (_compiler.equalsIgnoreCase("modern")) {
                    if (CompilerProperties.getBuildDebug()) {
                        System.out.println("Using Modern Compiler...");
                    }
                    if (CompilerProperties.getBuildDebug()) {
                        System.out.println("Args: " + Arrays.asList(args));
                    }
                    Object compiler = javac.newInstance();
                    Method compile = javac.getMethod("compile", new String[0].getClass());
                    int result = (Integer)compile.invoke(compiler, new Object[]{args});
                } else if (_compiler.equalsIgnoreCase("classic")) {
                    if (CompilerProperties.getBuildDebug()) {
                        System.out.println("Using Classic Compiler...");
                    }
                    if (CompilerProperties.getBuildDebug()) {
                        System.out.println("Args: " + Arrays.asList(args));
                    }
                    Constructor constructor = javac.getConstructor(OutputStream.class, String.class);
                    Object javac_inst = constructor.newInstance(this.outputStream, "javac");
                    Method compile = javac.getMethod("compile", String;.class);
                    Boolean result = (Boolean)compile.invoke(javac_inst, new Object[]{args});
                } else if (_compiler.equalsIgnoreCase("ojc")) {
                    if (CompilerProperties.getBuildDebug()) {
                        System.out.println("Using OJC Compiler...");
                    }
                    if (CompilerProperties.getBuildDebug()) {
                        System.out.println("Args: " + Arrays.asList(args));
                    }
                    Object compiler = javac.newInstance();
                    Method compile = javac.getMethod("main", String;.class);
                    compile.invoke(compiler, new Object[]{args});
                }
            }
            catch (IllegalAccessException e) {
                throw new InstantiationException("Error calling javac, access error: " + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                throw new InstantiationException("Error calling javac, main method not found: " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof AccessControlException) {
                    throw new InstantiationException("Error calling javac, tools.jar does not have sufficient security permissions, change your JRE/lib/security/java.policy settings: " + e.getTargetException());
                }
                if (!(e.getTargetException() instanceof SecurityException)) {
                    throw new InstantiationException("Error calling javac, internal error in the compiler: " + e.getTargetException());
                }
            }
        }
        catch (NoClassDefFoundError e) {
            throw new CompilationException("Javac not found (" + e.getMessage() + ")");
        }
    }

    private Class getJavacCompiler() throws InstantiationException {
        Class<?> javac = null;
        if (CompilerProperties.getBuildDebug()) {
            System.out.println("Getting " + _compiler + " ...");
        }
        if (_compiler.equalsIgnoreCase("modern")) {
            try {
                javac = Class.forName("com.sun.tools.javac.Main", true, this.loader);
                _compiler = "modern";
            }
            catch (ClassNotFoundException cnfe) {
                if (CompilerProperties.getBuildDebug()) {
                    System.out.println("Lookup " + _compiler + " com.sun.tools.javac.Main error:" + cnfe);
                }
                javac = null;
            }
        }
        if (_compiler.equalsIgnoreCase("ojc")) {
            try {
                javac = Class.forName("oracle.ojc.frontend.Main", true, this.loader);
                _compiler = "ojc";
            }
            catch (ClassNotFoundException cnfe) {
                if (CompilerProperties.getBuildDebug()) {
                    System.out.println("Lookup " + _compiler + " oracle.ojc.frontend.Main error:" + cnfe);
                }
                javac = null;
            }
        }
        if (_compiler.equalsIgnoreCase("classic") || javac == null) {
            try {
                javac = Class.forName("sun.tools.javac.Main", true, this.loader);
                _compiler = "classic";
            }
            catch (ClassNotFoundException cnfe) {
                if (CompilerProperties.getBuildDebug()) {
                    System.out.println("Lookup " + _compiler + " sun.tools.javac.Main:" + cnfe);
                }
                javac = null;
            }
        }
        if (javac == null) {
            throw new InstantiationException("Javac (classic, modern or ojc compiler) not installed, copy tools.jar or ojc.jar from your sun or oracle JDK dir's lib dir to the oc4j dir or add a <library path=\"the/path/to/<tools|ojc>.jar\" /> and restart");
        }
        if (CompilerProperties.getBuildDebug()) {
            System.out.println("Got " + _compiler + " .");
        }
        return javac;
    }

    public boolean needsSecurityManager() {
        return true;
    }

    public void checkIfValid() throws InstantiationException {
        Class compiler = this.getJavacCompiler();
    }
}

