/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EchoInputStream
extends InputStream {
    private InputStream in;
    private BufferedInputStream bufferedIn;
    private OutputStream out;
    private boolean echo;
    private boolean buffer;
    private boolean isKeyboard;
    private boolean debug;

    public EchoInputStream(InputStream in, OutputStream out) {
        this(in, out, true, false, false, false);
    }

    public EchoInputStream(InputStream in, OutputStream out, boolean echo, boolean buffer, boolean isKeyboard, boolean debug) {
        this.debug = debug;
        this.in = in;
        this.bufferedIn = new BufferedInputStream(in);
        this.out = out;
        this.echo = echo;
        this.isKeyboard = isKeyboard;
    }

    public int read() throws IOException {
        if (this.debug) {
            System.out.println("Single in read");
        }
        int i = this.buffer ? this.bufferedIn.read() : this.in.read();
        if (this.echo && i != -1) {
            this.out.write((byte)i);
        }
        return i;
    }

    public int read(byte[] data, int offset, int length) throws IOException {
        if (this.debug) {
            System.out.println("byte[] in read: " + length);
        }
        if (offset + length > data.length) {
            throw new IllegalArgumentException("Invalid paremeters, " + offset + " + " + length + " is more than " + data.length);
        }
        int i = this.buffer ? this.bufferedIn.read(data, offset, length) : this.in.read(data, offset, length);
        if (this.echo && i > 0) {
            this.out.write(data, offset, i);
        }
        return i;
    }

    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    public int available() throws IOException {
        if (this.debug) {
            System.out.println("in available");
        }
        if (this.buffer) {
            return this.bufferedIn.available();
        }
        return this.in.available();
    }

    public void mark(int i) {
        if (this.buffer) {
            this.bufferedIn.mark(i);
        } else {
            this.in.mark(i);
        }
    }

    public boolean markSupported() {
        if (this.buffer) {
            return this.bufferedIn.markSupported();
        }
        return this.in.markSupported();
    }

    public void reset() throws IOException {
        if (this.debug) {
            System.out.println("in reset()");
        }
        this.in.reset();
        this.bufferedIn.reset();
    }

    public long skip(long l) throws IOException {
        if (this.debug) {
            System.out.println("in skip(" + l + ")");
        }
        if (this.buffer) {
            return this.bufferedIn.skip(l);
        }
        return this.in.skip(l);
    }

    public void setEcho(boolean echo) {
        if (!this.isKeyboard) {
            this.echo = echo;
        }
    }

    public void setBuffer(boolean echo) {
        this.echo = echo;
    }

    public boolean getEcho() {
        return this.echo;
    }

    public boolean getBuffer() {
        return this.buffer;
    }

    public void close() throws IOException {
        if (this.debug) {
            System.out.println("in close()");
        }
        super.close();
    }
}

