/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io;

import com.evermind.io.LightPipedInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LightPipedOutputStream
extends OutputStream {
    public static final int FREED_SPACE_TRESHOLD = 2048;
    private static int currentID = 1;
    byte[] buffer = new byte[4096];
    int startPos;
    int commitedPos;
    int endPos;
    int id = currentID++;
    int queue;
    boolean closed;
    LightPipedInputStream in = new LightPipedInputStream(this);

    public synchronized void write(byte[] data, int offset, int length) throws IOException {
        if (this.closed) {
            throw new IOException("Stream was closed");
        }
        while (this.endPos + length > this.buffer.length) {
            byte[] newBuffer = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        System.arraycopy(data, offset, this.buffer, this.endPos, length);
        this.endPos += length;
    }

    public synchronized void write(int data) throws IOException {
        if (this.closed) {
            throw new IOException("Stream was closed");
        }
        if (this.endPos >= this.buffer.length) {
            byte[] newBuffer = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        this.buffer[this.endPos++] = (byte)data;
    }

    public synchronized void flush() {
        boolean modified = this.commitedPos != this.endPos;
        this.commitedPos = this.endPos;
        if (modified) {
            this.notifyQueue();
        }
    }

    final void notifyQueue() {
        if (this.queue > 0) {
            --this.queue;
            this.notify();
        }
    }

    final void waitForQueue() throws InterruptedException {
        ++this.queue;
        this.wait();
    }

    final void waitForQueue(long timeout) throws InterruptedException {
        ++this.queue;
        this.wait(timeout);
    }

    void freeSpace() {
        System.arraycopy(this.buffer, this.startPos, this.buffer, 0, this.endPos - this.startPos);
        this.endPos -= this.startPos;
        this.commitedPos -= this.startPos;
        this.startPos = 0;
    }

    public LightPipedInputStream getInputStream() {
        return this.in;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.flush();
        this.closed = true;
        this.notifyQueue();
    }

    public String toString() {
        return "Out" + this.id;
    }
}

