/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.messaging;

import java.io.IOException;
import java.io.InputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;

public class BytesMessageInputStream
extends InputStream {
    private BytesMessage message;

    public BytesMessageInputStream(BytesMessage message) {
        this.message = message;
    }

    public int read() throws IOException {
        try {
            return this.message.readByte();
        }
        catch (MessageEOFException e) {
            return -1;
        }
        catch (JMSException e) {
            throw new IOException("JMSException: " + e.getMessage());
        }
    }

    public int read(byte[] data, int offset, int length) throws IOException {
        try {
            if (offset != 0) {
                byte[] temp = new byte[length];
                int read = this.message.readBytes(temp);
                System.arraycopy(temp, 0, data, offset, read);
                return read;
            }
            return this.message.readBytes(data, length);
        }
        catch (MessageEOFException e) {
            return -1;
        }
        catch (JMSException e) {
            throw new IOException("JMSException: " + e.getMessage());
        }
    }
}

