/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.naming.memory;

import com.evermind.naming.CompositeContext;
import com.evermind.naming.CompositeNameParser;
import com.evermind.naming.memory.EntrySetNamingEnumeration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;

public class MapContext
extends CompositeContext {
    protected Map bindings = Collections.synchronizedMap(new HashMap());

    public void load() {
    }

    public void save() {
    }

    public Object lookup(Name name) throws NamingException {
        if (name.size() == 0) {
            return this;
        }
        String shortName = name.get(0);
        Object object = this.bindings.get(shortName);
        if (object == null) {
            throw new NameNotFoundException(name.toString());
        }
        if (name.size() > 1) {
            if (!(object instanceof Context)) {
                throw new NotContextException(shortName);
            }
            return ((Context)object).lookup(name.getSuffix(1));
        }
        return object;
    }

    public void bind(Name name, Object object) throws NamingException {
        if (name.size() == 0) {
            throw new NameAlreadyBoundException(name.toString());
        }
        String shortName = name.get(0);
        Object found = this.bindings.get(shortName);
        if (name.size() > 1) {
            if (!(found instanceof Context)) {
                if (found == null) {
                    throw new NameNotFoundException(name.toString());
                }
                throw new NotContextException(shortName);
            }
            ((Context)found).bind(name.getSuffix(1), object);
        } else if (found != null) {
            throw new NameAlreadyBoundException(name.toString());
        }
        this.bindings.put(shortName, object);
        this.save();
    }

    public void rebind(Name name, Object object) throws NamingException {
        if (name.size() == 0) {
            throw new NameAlreadyBoundException(name.toString());
        }
        if (name.size() <= 1) {
            this.bindings.put(name.get(0), object);
        } else {
            Object found = this.bindings.get(name.get(0));
            if (!(found instanceof Context)) {
                if (found == null) {
                    throw new NameNotFoundException(name.toString());
                }
                throw new NotContextException(name.get(0));
            }
            ((Context)found).rebind(name.getSuffix(1), object);
        }
    }

    public void unbind(Name name) throws NamingException {
        if (name.size() <= 1) {
            if (this.bindings.remove(name.get(0)) == null) {
                throw new NameNotFoundException(name.toString());
            }
        } else {
            Object found = this.bindings.get(name.get(0));
            if (!(found instanceof Context)) {
                if (found == null) {
                    throw new NameNotFoundException(name.toString());
                }
                throw new NotContextException(name.get(0));
            }
            ((Context)found).unbind(name.getSuffix(1));
        }
    }

    public void rename(Name from, Name to) throws NamingException {
        Object object = this.lookup(from);
        this.bind(to, object);
        this.unbind(from);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name.size() == 0) {
            return new EntrySetNamingEnumeration(this.bindings.entrySet(), this, false);
        }
        String shortName = name.get(0);
        Object object = this.bindings.get(shortName);
        if (object == null) {
            throw new NameNotFoundException(name.toString());
        }
        if (!(object instanceof Context)) {
            throw new NotContextException(shortName);
        }
        return ((Context)object).list(name.getSuffix(1));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.size() == 0) {
            return new EntrySetNamingEnumeration(this.bindings.entrySet(), this, true);
        }
        String shortName = name.get(0);
        Object object = this.bindings.get(shortName);
        if (object == null) {
            throw new NameNotFoundException(name.toString());
        }
        if (!(object instanceof Context)) {
            throw new NotContextException(shortName);
        }
        return ((Context)object).listBindings(name.getSuffix(1));
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (name.size() == 0) {
            throw new NamingException("Cannot destroy myself");
        }
        String shortName = name.get(0);
        Object object = this.bindings.get(shortName);
        if (object == null) {
            throw new NameNotFoundException(name.toString());
        }
        if (!(object instanceof Context)) {
            throw new NotContextException(shortName);
        }
        if (name.size() == 1) {
            this.bindings.remove(shortName);
        } else {
            ((Context)object).destroySubcontext(name.getSuffix(1));
        }
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (name.size() == 0) {
            throw new NamingException("Cannot create myself");
        }
        String shortName = name.get(0);
        Object object = this.bindings.get(shortName);
        if (name.size() == 1) {
            if (object != null) {
                throw new NameAlreadyBoundException(name.toString());
            }
            MapContext subContext = new MapContext();
            this.bindings.put(shortName, subContext);
            return subContext;
        }
        if (object == null) {
            throw new NameNotFoundException(shortName);
        }
        if (!(object instanceof Context)) {
            throw new NotContextException(shortName);
        }
        return ((Context)object).createSubcontext(name.getSuffix(1));
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return CompositeNameParser.getInstance();
    }

    public Object addToEnvironment(String name, Object value) {
        return null;
    }

    public Object removeFromEnvironment(String name) {
        return null;
    }

    public Hashtable getEnvironment() {
        return new Hashtable();
    }

    public void close() {
    }

    public String toString() {
        return "[MapContext: " + this.bindings + "]";
    }
}

