/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.net.http;

import com.evermind.net.NetworkConnection;
import com.evermind.net.http.HttpTunnelInputStream;
import com.evermind.util.SecurityProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.SSLSocketFactory;

public class HttpTunnelConnection
implements NetworkConnection {
    private InetAddress address;
    private int port;
    private String path;
    private Socket socket;
    private HttpTunnelInputStream in;
    private OutputStream out;
    private boolean secure;

    public HttpTunnelConnection(InetAddress address, int port, String path, boolean secure) throws IOException {
        this.address = address;
        this.port = port;
        this.path = path;
        this.secure = secure;
        this.connect();
    }

    public void connect() throws IOException {
        this.socket = this.secure ? this.getSecureSocket(this.address, this.port) : new Socket(this.address, this.port);
        this.out = this.socket.getOutputStream();
        this.out.write(("POST " + this.path + " HTTP/1.0\r\n" + "Content-Length: 999999\r\n" + "\r\n").getBytes());
        this.out.flush();
        this.in = new HttpTunnelInputStream(this.socket.getInputStream(), this);
    }

    public Socket getSecureSocket(InetAddress address, int port) throws IOException {
        try {
            String sslProviderName = SecurityProperties.getSSLProvider();
            if (Security.getProvider(sslProviderName) == null) {
                Security.addProvider((Provider)Class.forName(sslProviderName).newInstance());
            }
        }
        catch (Throwable t) {
            throw new IOException("Error adding security provider: " + t);
        }
        return ((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(address.getHostName(), port);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public void setTimeout(int timeout) {
    }

    public String getURL() {
        return "http://" + this.address.getHostName() + ":" + this.port + this.path;
    }

    public String getTypeDescription() {
        return "HTTP tunnel (" + this.getURL() + ")";
    }
}

