/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.parser;

import com.evermind.compiler.CompilationException;
import com.evermind.parser.ConstantNumberExpression;
import com.evermind.parser.Expression;
import com.evermind.parser.ExpressionParser;
import com.evermind.parser.ExpressionType;
import com.evermind.parser.VoidExpression;

public class ConstantNumberExpressionType
implements ExpressionType {
    public boolean implies(String string) {
        try {
            Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public Expression parse(ExpressionParser parser, String token, Expression leftArgs, Expression rightArgs) throws CompilationException {
        if (!(leftArgs instanceof VoidExpression) || !(rightArgs instanceof VoidExpression)) {
            throw new CompilationException("No args should be passed to a constant (" + leftArgs + ", " + rightArgs + ")");
        }
        return new ConstantNumberExpression(Double.parseDouble(token));
    }
}

