/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.naming.DelayedBinding;
import com.evermind.naming.FlatNameParser;
import com.evermind.naming.SubContext;
import com.evermind.naming.memory.FlatMapContext;
import com.evermind.net.AddressContainer;
import com.evermind.security.RoleManager;
import com.evermind.security.User;
import com.evermind.server.Application;
import com.evermind.server.ApplicationContextStub;
import com.evermind.server.ApplicationRoleManager;
import com.evermind.server.ContextContainer;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.TimerServiceProxy;
import com.evermind.server.rmi.RMIServerContext;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.EJBContext;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import oracle.j2ee.jndi.JndiMessages;
import oracle.j2ee.transaction.TransactionSynchronizationRegistry;
import oracle.oc4j.naming.BindingsEnumeration;
import oracle.oc4j.security.OC4JPrivilegedAction;
import oracle.oc4j.security.OC4JSecurity;
import oracle.oc4j.transport.TransportManager;

public class ApplicationContext
implements Context {
    private static ApplicationContext m_exemplar;
    private Map bindings = new HashMap();
    private RMIServerContext rmiContext;
    private ApplicationContextStub m_stub;
    private boolean m_attemptingRelativeLookup = false;
    private static final String READ_ONLY_CONTEXT_ERROR_MSG = "Can't bind to this context.  The environment naming context is immutable";
    private static final boolean SECURITY_ON;

    public ApplicationContext(ApplicationContextStub stub) {
        this.m_stub = stub;
    }

    public static ApplicationContext createApplicationContext(final Application application) {
        ApplicationContextStub stub = new ApplicationContextStub(){
            private RMIServerContext m_rmiContext;

            public String getName() {
                return application.getName();
            }

            public String getParentName() {
                return application.getParent() == null ? null : application.getParent().getName();
            }

            public Application getApplication() {
                return application;
            }

            public RoleManager getRoleManager() {
                return new ApplicationRoleManager(application);
            }

            public boolean hasReadAccess(String path, User user, AddressContainer addressContainer) {
                return application.getNamespaceAccessController().hasReadAccess(path, user, addressContainer);
            }

            public boolean hasWriteAccess(String path, User user, AddressContainer addressContainer) {
                return application.getNamespaceAccessController().hasWriteAccess(path, user, addressContainer);
            }

            public ApplicationContext getParentContext() {
                return application.getParent() == null ? null : application.getParent().getContext();
            }

            public RMIServerContext getRMIContext() {
                if (this.m_rmiContext == null && application.getServer().rmiServer != null) {
                    this.m_rmiContext = application.getServer().rmiServer.getServerContext(this.getDomainName(), true);
                }
                return this.m_rmiContext;
            }

            private String getDomainName() {
                return application == application.getServer().getDefaultApplication() ? null : application.getName();
            }

            public UserTransaction getUserTransaction() {
                return (UserTransaction)application.getServer().getTransactionManager();
            }

            public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
                return application.getServer().getTransactionSynchronizationRegistry();
            }

            public TransactionManager getTransactionManager() {
                return application.getServer().getTransactionManager();
            }

            public Object getResource(String name) throws NamingException {
                try {
                    return application.lookupResource(name);
                }
                catch (InstantiationException e) {
                    throw new NamingException("Unable to find " + name + ": " + e);
                }
            }

            public ClassLoader getBeansClassLoader() {
                if (application == null || !application.isInitialized()) {
                    return null;
                }
                return application.getBeansClassLoader();
            }
        };
        return m_exemplar == null ? new ApplicationContext(stub) : m_exemplar.newApplicationContext(stub);
    }

    protected static void setExemplar(ApplicationContext exemplar) {
        m_exemplar = exemplar;
    }

    protected ApplicationContext newApplicationContext(ApplicationContextStub stub) {
        return new ApplicationContext(stub);
    }

    public void unsetRMIContext() {
        this.rmiContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRMIContext(RMIServerContext context) {
        if (this.rmiContext == context) {
            return;
        }
        this.rmiContext = context;
        this.rmiContext.setApplicationContext(this);
        Map map = this.bindings;
        synchronized (map) {
            Iterator iterator = this.bindings.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!(entry.getValue() instanceof AbstractEJBHome) && !(entry.getValue() instanceof DelayedBinding)) continue;
                try {
                    context.bind((String)entry.getKey(), entry.getValue());
                    iterator.remove();
                }
                catch (NamingException e) {
                    JndiMessages.logException(e);
                }
            }
        }
    }

    public Object lookup(final String name) throws NamingException {
        if (!SECURITY_ON) {
            return this.unprivileged_lookup(name);
        }
        OC4JPrivilegedAction action = new OC4JPrivilegedAction(){

            public Object oc4jRun() throws NamingException {
                return ApplicationContext.this.unprivileged_lookup(name);
            }
        };
        try {
            try {
                return OC4JSecurity.doPrivileged(action);
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        catch (NamingException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object unprivileged_lookup(String name) throws NamingException {
        if (name.equals("")) {
            return new SubContext(this, "");
        }
        Object answer = null;
        if (name.startsWith("java:")) {
            answer = this.lookupInJavaContext(name);
        }
        if (answer == null) {
            Map map = this.bindings;
            synchronized (map) {
                answer = this.bindings.get(name);
                if (answer != null && answer instanceof DelayedBinding) {
                    answer = ((DelayedBinding)answer).getInstance();
                    this.bindings.put(name, answer);
                }
            }
        }
        if (answer == null && this.m_stub.getParentContext() != null) {
            Map parentBindings;
            Map map = parentBindings = this.m_stub.getParentContext().bindings;
            synchronized (map) {
                answer = parentBindings.get(name);
            }
        }
        if (answer == null) {
            try {
                if (this.rmiContext != null) {
                    return this.rmiContext.lookup(name);
                }
                if (this.m_stub.getParentContext() != null) {
                    return this.m_stub.getParentContext().lookup(name);
                }
                throw new NameNotFoundException(name + " not found");
            }
            catch (NamingException e) {
                if (!this.m_attemptingRelativeLookup) {
                    this.m_attemptingRelativeLookup = true;
                    try {
                        answer = this.lookupInJavaContext("java:comp/env/" + name);
                    }
                    catch (NamingException e1) {
                        // empty catch block
                    }
                    this.m_attemptingRelativeLookup = false;
                }
                if (answer != null) {
                    return answer;
                }
                throw e;
            }
        }
        return answer;
    }

    private Object lookupInJavaContext(String name) throws NamingException {
        Object result = null;
        if (name.equals("java:comp/env")) {
            try {
                result = ApplicationContext.getEnvironmentContext(name);
            }
            catch (ClassCastException e) {
                throw new NameNotFoundException(name + " not found");
            }
        } else if (name.startsWith("java:comp/env/")) {
            try {
                Context context = ApplicationContext.getEnvironmentContext(name);
                String relativeName = name.substring("java:comp/env/".length());
                result = context.lookup(relativeName);
            }
            catch (ClassCastException e) {
                throw new NameNotFoundException(name + " not found");
            }
        } else if (name.equals("java:comp/UserTransaction")) {
            EJBUtils.checkCMT();
            result = this.m_stub.getUserTransaction();
        } else if (name.equals("java:comp/TransactionSynchronizationRegistry")) {
            result = this.m_stub.getTransactionSynchronizationRegistry();
        } else if (name.equals("java:comp/pm/TransactionManager")) {
            result = this.m_stub.getTransactionManager();
        } else if (name.equals("java:comp/HandleDelegate")) {
            result = TransportManager.getHandleDelegate();
        } else if (name.equals("java:comp/ORB")) {
            result = TransportManager.getORBInstance();
        } else if (name.equals("java:comp/RoleManager")) {
            result = this.m_stub.getRoleManager();
        } else if (name.equals("java:comp/EJBContext")) {
            result = EJBUtils.getEJBContext();
            if (result == null) {
                throw new NameNotFoundException("Lookup of 'java:comp/EJBContext' within a non-EJB component.");
            }
        } else if (name.equals("java:comp/TimerService")) {
            EJBContext ejbCtx = EJBUtils.getEJBContext();
            if (ejbCtx == null) {
                throw new NameNotFoundException("Lookup of 'java:comp/TimerService' within a non-EJB component.");
            }
            result = new TimerServiceProxy(ejbCtx);
        } else if (name.startsWith("java:comp/ejb/")) {
            result = this.getApplication().getEJBContainer().lookupInEJBModuleContext(name.substring("java:comp/ejb/".length()));
        } else if (name.equals("java:comp")) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("UserTransaction", this.m_stub.getUserTransaction());
            values.put("TransactionSynchronizationRegistry", this.m_stub.getTransactionSynchronizationRegistry());
            values.put("env", new SubContext(this, "java:comp/env"));
            result = new FlatMapContext(values);
        } else if (name.startsWith("java:comp/resource")) {
            result = this.handleResourceLookup(name);
        }
        return result;
    }

    public static Context getEnvironmentContext(String name) throws NamingException {
        ContextContainer container = ThreadState.getCurrentState().getContextContainer();
        if (container == null) {
            throw ApplicationContext.newEnvironmentContextMissingException(name);
        }
        Context context = container.getEnvironmentContext();
        if (context == null) {
            throw ApplicationContext.newEnvironmentContextMissingException(name);
        }
        return context;
    }

    private static NameNotFoundException newEnvironmentContextMissingException(String name) {
        return new NameNotFoundException(name + " not found (not inside a J2EE module, for instance a Web-App, EJB, or Application-Client)");
    }

    public Object lookup(Name name) throws NamingException {
        if (name.size() == 0) {
            return this;
        }
        return this.lookup(name.toString());
    }

    public void bind(String name, Object object) throws NamingException {
        if (this.hasEnvironmentNamingContextPrefix(name)) {
            throw new OperationNotSupportedException(READ_ONLY_CONTEXT_ERROR_MSG);
        }
        this.bind(name, object, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(String name, Object object, int replicate) throws NamingException {
        Map map = this.bindings;
        synchronized (map) {
            if (this.rmiContext != null) {
                this.rmiContext.bind(name, object, replicate);
            } else {
                if (name.equals("")) {
                    throw new InvalidNameException("Cannot bind empty name");
                }
                if (this.bindings.containsKey(name)) {
                    throw new NameAlreadyBoundException("Use rebind to override " + name + " in application " + this.m_stub.getName());
                }
                this.bindings.put(name, object);
            }
        }
    }

    public void bind(Name name, Object object) throws NamingException {
        this.bind(name.toString(), object);
    }

    public void rebind(String name, Object object) throws NamingException {
        if (this.hasEnvironmentNamingContextPrefix(name)) {
            throw new OperationNotSupportedException(READ_ONLY_CONTEXT_ERROR_MSG);
        }
        this.rebind(name, object, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(String name, Object object, int replicate) throws NamingException {
        if (this.rmiContext == null) {
            this.rmiContext = this.m_stub.getRMIContext();
        }
        Map map = this.bindings;
        synchronized (map) {
            if (this.rmiContext != null) {
                this.rmiContext.rebind(name, object, replicate);
            } else {
                if (name == null || name.equals("")) {
                    throw new InvalidNameException("Cannot bind empty name");
                }
                this.bindings.put(name, object);
            }
        }
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.rebind(name.toString(), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String name) throws NamingException {
        Map map = this.bindings;
        synchronized (map) {
            if (name.equals("")) {
                throw new InvalidNameException("Cannot unbind empty name");
            }
            if (this.hasEnvironmentNamingContextPrefix(name)) {
                throw new OperationNotSupportedException(READ_ONLY_CONTEXT_ERROR_MSG);
            }
            if (this.bindings.remove(name) == null && this.rmiContext != null) {
                this.rmiContext.unbindLocalObject(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(String name) throws NamingException {
        Map map = this.bindings;
        synchronized (map) {
            if (name.equals("")) {
                throw new InvalidNameException("Cannot unbind empty name");
            }
            if (this.bindings.remove(name) == null && this.rmiContext != null) {
                this.rmiContext.removeBinding(name);
            }
        }
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String oldname, String newname) throws NamingException {
        if (oldname.equals("") || newname.equals("")) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        if (this.hasEnvironmentNamingContextPrefix(oldname)) {
            throw new OperationNotSupportedException(READ_ONLY_CONTEXT_ERROR_MSG);
        }
        Map map = this.bindings;
        synchronized (map) {
            if (this.bindings.containsKey(newname)) {
                throw new NameAlreadyBoundException(newname + " is already bound");
            }
            Object oldBinding = this.bindings.remove(oldname);
            if (oldBinding == null) {
                if (this.rmiContext != null) {
                    this.rmiContext.rename(oldname, newname);
                    return;
                }
                throw new NameNotFoundException(oldname + " not bound");
            }
            this.bindings.put(newname, oldBinding);
        }
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (!name.startsWith("java:") && this.rmiContext != null) {
            return this.rmiContext.list(name);
        }
        if (name.equals("")) {
            return BindingsEnumeration.list(name, this.bindings);
        }
        Object target = this.lookup(name);
        if (!(target instanceof Context)) {
            throw new NotContextException(name + " is not a context and cannot be listed");
        }
        return ((Context)target).list("");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (!name.startsWith("java:") && this.rmiContext != null) {
            return this.rmiContext.listBindings(name);
        }
        if (name.equals("")) {
            return BindingsEnumeration.listBindings(this, name, this.bindings);
        }
        Object target = this.lookup(name);
        if (!(target instanceof Context)) {
            throw new NotContextException(name + " is not a context and cannot be listed");
        }
        return ((Context)target).listBindings("");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        this.getProxy().destroySubcontext(name);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.getProxy().createSubcontext(name);
    }

    private Context getProxy() {
        return this.rmiContext;
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        return FlatNameParser.getInstance();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Object addToEnvironment(String name, Object value) throws NamingException {
        return this.rmiContext.addToEnvironment(name, value);
    }

    public Object removeFromEnvironment(String name) throws NamingException {
        return this.rmiContext.removeFromEnvironment(name);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.rmiContext.getEnvironment();
    }

    public String getNameInNamespace() throws NamingException {
        if (this.m_stub == null) {
            throw new OperationNotSupportedException();
        }
        return this.m_stub.getName();
    }

    public void close() throws NamingException {
        if (this.rmiContext != null) {
            this.rmiContext.close();
        }
    }

    public String toString() {
        return "application " + this.m_stub.getName() + " context";
    }

    public Application getApplication() {
        return this.m_stub.getApplication();
    }

    public String getApplicationParentName() {
        return this.m_stub.getParentName();
    }

    public RMIServerContext getRMIContext() {
        return this.rmiContext;
    }

    public Object handleResourceLookup(String name) throws NamingException {
        if (!name.equals("java:comp/resource") && name.startsWith("java:comp/resource/")) {
            String resourceName = name.substring("java:comp/resource/".length());
            return this.m_stub.getResource(resourceName);
        }
        return null;
    }

    public boolean hasReadAccess(String name, User user, AddressContainer addressContainer) {
        return this.m_stub.hasReadAccess(name, user, addressContainer);
    }

    public boolean hasWriteAccess(String name, User user, AddressContainer addressContainer) {
        return this.m_stub.hasWriteAccess(name, user, addressContainer);
    }

    public ClassLoader getBeansClassLoader() {
        return this.m_stub.getBeansClassLoader();
    }

    private boolean hasEnvironmentNamingContextPrefix(String name) {
        if (name != null) {
            return name.startsWith("java:comp/env");
        }
        return false;
    }

    static {
        SECURITY_ON = OC4JSecurity.isSecurityOn();
    }
}

