/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.security.Group;
import com.evermind.security.RoleManager;
import com.evermind.security.User;
import com.evermind.security.UserAlreadyExistsException;
import com.evermind.server.Application;
import com.evermind.server.ThreadState;
import com.evermind.server.deployment.EnterpriseArchive;
import com.evermind.server.deployment.SecurityRole;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;

public class ApplicationRoleManager
implements RoleManager {
    private Application application;

    public ApplicationRoleManager(Application application) {
        this.application = application;
    }

    public Principal getPrincipal(String username) {
        return this.application.getUserManager().getUser(username);
    }

    public void addToRole(Principal principal, String roleName) {
        User user = this.getUser(principal);
        SecurityRole role = ((EnterpriseArchive)this.application.getConfig()).getSecurityRole(roleName);
        if (role == null) {
            throw new IllegalArgumentException("No such role: " + roleName);
        }
        List groupNames = role.getGroups();
        boolean wasEmpty = true;
        Iterator iterator = groupNames.iterator();
        while (iterator.hasNext()) {
            wasEmpty = false;
            Group group = this.application.getUserManager().getGroup(iterator.next().toString());
            if (group == null) continue;
            user.addToGroup(group);
        }
        if (wasEmpty) {
            throw new IllegalArgumentException("Role '" + roleName + "' is not mapped to any groups in it's <security-role-mapping>. Check your deployment configuration (orion-* file).");
        }
    }

    public Principal createPrincipal(String username, String password, String role) throws InstantiationException, UserAlreadyExistsException {
        if (username == null) {
            throw new NullPointerException("username was null");
        }
        User user = this.application.getUserManager().createUser(username, password);
        if (role != null) {
            this.addToRole(user, role);
        }
        return user;
    }

    public Principal createPrincipal(String username, String password, X509Certificate certificate) throws InstantiationException, UserAlreadyExistsException {
        if (username == null) {
            throw new NullPointerException("username was null");
        }
        User user = this.application.getUserManager().createUser(username, password);
        user.setCertificate(certificate);
        return user;
    }

    public Principal createPrincipal(String username, String password) throws InstantiationException, UserAlreadyExistsException {
        if (username == null) {
            throw new NullPointerException("username was null");
        }
        return this.application.getUserManager().createUser(username, password);
    }

    public void remove(Principal principal) {
        this.application.getUserManager().remove(this.getUser(principal));
    }

    public void removeFromRole(Principal principal, String roleName) {
        User user = this.getUser(principal);
        SecurityRole role = ((EnterpriseArchive)this.application.getConfig()).getSecurityRole(roleName);
        if (role == null) {
            throw new IllegalArgumentException("No such role: " + roleName);
        }
        List groupNames = role.getGroups();
        Iterator iterator = groupNames.iterator();
        while (iterator.hasNext()) {
            Group group = this.application.getUserManager().getGroup(iterator.next().toString());
            if (group == null) continue;
            user.removeFromGroup(group);
        }
    }

    public void store() throws IOException {
        this.application.getUserManager().store();
    }

    protected User getUser(Principal principal) {
        if (principal instanceof User) {
            return (User)principal;
        }
        User user = this.application.getUserManager().getUser(principal.getName());
        if (user == null) {
            throw new IllegalArgumentException("No such user: " + principal.getName());
        }
        return user;
    }

    public boolean isPrincipalInRole(Principal principal, String roleName) {
        User user = this.getUser(principal);
        SecurityRole role = ((EnterpriseArchive)this.application.getConfig()).getSecurityRole(roleName);
        if (role == null) {
            throw new IllegalArgumentException("No such role: " + roleName);
        }
        Iterator groups = role.getGroups().iterator();
        while (groups.hasNext()) {
            Object groupObject = groups.next();
            Group group = groupObject instanceof Group ? (Group)groups.next() : this.application.getUserManager().getGroup(groupObject.toString());
            if (group == null || !user.isMemberOf(group)) continue;
            return true;
        }
        Iterator users = role.getUsers().iterator();
        while (users.hasNext()) {
            String other = (String)users.next();
            if (!user.getName().equals(other)) continue;
            return true;
        }
        return false;
    }

    public void login(String username, String password) throws SecurityException {
        User user = this.application.getUserManager().getUser(username);
        if (user == null || !user.authenticate(password)) {
            throw new SecurityException("Invalid username/password");
        }
        ThreadState.getCurrentState().setRemoteUser(user, null);
    }
}

