/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import oracle.oc4j.configuration.ConfigException;
import oracle.oc4j.configuration.XMLSerializableBase;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class ApplicationServerThreadPoolConfig
extends XMLSerializableBase {
    public static boolean THREADPOOL_OUTPUT_OLDFORMAT = false;
    public static final String TG_SYS = "SystemThreadGroup";
    public static final String TP_SYS = "system";
    public static final String TG_RMI_REQ = "RMIRequestThreadGroup";
    public static final String TP_RMI_REQ = "rmi request";
    public static final String TG_RMI_CONN = "RMIConnectionThreadGroup";
    public static final String TP_RMI_CONN = "rmi connection";
    public static final String TG_HTTP = "HTTPThreadGroup";
    public static final String TP_HTTP = "http";
    public static final String TP_JCA = "jca";
    public static final int DEFAULT_MIN = 0;
    public static final int DEFAULT_MAX = 1024;
    public static final int DEFAULT_Q_CAPACITY = 0;
    public static final long DEFAULT_KEEPALIVETIME = 600000L;
    public static final long DEFAULT_STACKSIZE = 0L;
    public static final boolean DEFAULT_DEBUG = false;
    private boolean oldFormatOutput = THREADPOOL_OUTPUT_OLDFORMAT;
    private static Hashtable configs = new Hashtable();
    private static Hashtable customConfigs = new Hashtable();

    public static void populateKnownThreadPoolConfigs() {
        ConfigX config = new ConfigX(TP_SYS);
        configs.put(config.getPoolName(), config);
        config = new ConfigX(TP_RMI_REQ);
        configs.put(config.getPoolName(), config);
        config = new ConfigX(TP_RMI_CONN);
        configs.put(config.getPoolName(), config);
        config = new ConfigX(TP_HTTP);
        configs.put(config.getPoolName(), config);
    }

    public static void purgeAllConfigs() {
        configs.clear();
        customConfigs.clear();
    }

    public static ConfigX getConfig(String poolName) {
        ConfigX x = (ConfigX)configs.get(poolName);
        if (x != null) {
            return x;
        }
        throw new IllegalArgumentException("Pool " + poolName + " not recognized");
    }

    public static ConfigX getCustomConfig(String poolName) {
        return (ConfigX)customConfigs.get(poolName);
    }

    public ApplicationServerThreadPoolConfig() {
        ApplicationServerThreadPoolConfig.getConfig(TP_SYS).setASTPC(this);
        ApplicationServerThreadPoolConfig.getConfig(TP_HTTP).setASTPC(this);
        ApplicationServerThreadPoolConfig.getConfig(TP_RMI_REQ).setASTPC(this);
        ApplicationServerThreadPoolConfig.getConfig(TP_RMI_CONN).setASTPC(this);
    }

    public ApplicationServerThreadPoolConfig(Node node) throws ConfigException {
        super(node);
        ApplicationServerThreadPoolConfig.getConfig(TP_SYS).setASTPC(this);
        ApplicationServerThreadPoolConfig.getConfig(TP_HTTP).setASTPC(this);
        ApplicationServerThreadPoolConfig.getConfig(TP_RMI_REQ).setASTPC(this);
        ApplicationServerThreadPoolConfig.getConfig(TP_RMI_CONN).setASTPC(this);
    }

    public void setOldFormatOutput(boolean b) {
        this.oldFormatOutput = b;
    }

    public void read(Node node) throws DOMException {
        ConfigX x = ApplicationServerThreadPoolConfig.getConfig(TP_HTTP);
        x.read(XMLUtils.getNodeAttribute(node, "min"), XMLUtils.getNodeAttribute(node, "max"), XMLUtils.getNodeAttribute(node, "queue"), XMLUtils.getNodeAttribute(node, "keepAlive"), XMLUtils.getNodeAttribute(node, "debug"), XMLUtils.getNodeAttribute(node, "stackSize"));
        x = ApplicationServerThreadPoolConfig.getConfig(TP_RMI_CONN);
        x.read(XMLUtils.getNodeAttribute(node, "cx-min"), XMLUtils.getNodeAttribute(node, "cx-max"), XMLUtils.getNodeAttribute(node, "cx-queue"), XMLUtils.getNodeAttribute(node, "cx-keepAlive"), null, null);
        x = ApplicationServerThreadPoolConfig.getConfig(TP_RMI_REQ);
        x.read(XMLUtils.getNodeAttribute(node, "rmiRequest-min"), XMLUtils.getNodeAttribute(node, "rmiRequest-max"), XMLUtils.getNodeAttribute(node, "rmiRequest-queue"), XMLUtils.getNodeAttribute(node, "rmiRequest-keepAlive"), null, null);
    }

    public void readCustomThreadPool(Node node) throws DOMException {
        ConfigX x = new ConfigX(XMLUtils.getNodeAttribute(node, "name"), "custom-thread-pool");
        x.read(XMLUtils.getNodeAttribute(node, "min"), XMLUtils.getNodeAttribute(node, "max"), XMLUtils.getNodeAttribute(node, "queue"), XMLUtils.getNodeAttribute(node, "keepAlive"), XMLUtils.getNodeAttribute(node, "debug"), XMLUtils.getNodeAttribute(node, "stackSize"));
        customConfigs.put(x.getPoolName(), x);
    }

    public void readNewFormat(Node node) throws DOMException {
        String name = XMLUtils.getNodeAttribute(node, "name");
        ConfigX x = ApplicationServerThreadPoolConfig.getConfig(name);
        x.read(XMLUtils.getNodeAttribute(node, "min"), XMLUtils.getNodeAttribute(node, "max"), XMLUtils.getNodeAttribute(node, "queue"), XMLUtils.getNodeAttribute(node, "keepAlive"), XMLUtils.getNodeAttribute(node, "debug"), XMLUtils.getNodeAttribute(node, "stackSize"));
    }

    public void write(PrintWriter out, String indent) throws IOException {
        if (this.oldFormatOutput) {
            this.old_write(out, indent);
            return;
        }
        ApplicationServerThreadPoolConfig.getConfig(TP_SYS).write(out, indent);
        ApplicationServerThreadPoolConfig.getConfig(TP_RMI_REQ).write(out, indent);
        ApplicationServerThreadPoolConfig.getConfig(TP_RMI_CONN).write(out, indent);
        ApplicationServerThreadPoolConfig.getConfig(TP_HTTP).write(out, indent);
        Iterator it = customConfigs.values().iterator();
        while (it.hasNext()) {
            ConfigX config = (ConfigX)it.next();
            config.write(out, indent);
        }
    }

    public void old_write(PrintWriter out, String indent) throws IOException {
        out.print(indent + "\t<global-thread-pool");
        ConfigX x = ApplicationServerThreadPoolConfig.getConfig(TP_HTTP);
        if (!x.isImplicit()) {
            out.print(" min=\"" + x.getMinPoolSize() + "\"");
            out.print(" max=\"" + x.getMaxPoolSize() + "\"");
            out.print(" queue=\"" + x.getQueueSize() + "\"");
            out.print(" keepAlive=\"" + x.getKeepAliveTime() + "\"");
            out.print(" stackSize=\"" + x.getStackSize() + "\"");
            if (x.isDebug()) {
                out.print(" debug=\"true\"");
            }
        }
        if (!(x = ApplicationServerThreadPoolConfig.getConfig(TP_RMI_CONN)).isImplicit()) {
            out.print(" cx-min=\"" + x.getMinPoolSize() + "\"");
            out.print(" cx-max=\"" + x.getMaxPoolSize() + "\"");
            out.print(" cx-queue=\"" + x.getQueueSize() + "\"");
            out.print(" cx-keepAlive=\"" + x.getKeepAliveTime() + "\"");
        }
        if (!(x = ApplicationServerThreadPoolConfig.getConfig(TP_RMI_REQ)).isImplicit()) {
            out.print(" rmiRequest-min=\"" + x.getMinPoolSize() + "\"");
            out.print(" rmiRequest-max=\"" + x.getMaxPoolSize() + "\"");
            out.print(" rmiRequest-queue=\"" + x.getQueueSize() + "\"");
            out.print(" rmiRequest-keepAlive=\"" + x.getKeepAliveTime() + "\"");
        }
        out.println(" />");
    }

    static {
        ApplicationServerThreadPoolConfig.populateKnownThreadPoolConfigs();
    }

    public static class ConfigX {
        private int minPoolSize;
        private int maxPoolSize;
        private int queueSize;
        private long keepAliveTime;
        private boolean debug;
        private long stackSize;
        private String poolName;
        private boolean implicit;
        private ApplicationServerThreadPoolConfig astpc;
        private String nodeNm;

        public ConfigX(String poolName) {
            this(poolName, "thread-pool");
        }

        public ConfigX(String poolName, String nodeNm) {
            this.assignDefault();
            this.nodeNm = nodeNm;
            this.poolName = poolName;
        }

        public void setASTPC(ApplicationServerThreadPoolConfig astpc) {
            this.astpc = astpc;
        }

        private void assignDefault() {
            this.minPoolSize = 0;
            this.maxPoolSize = 1024;
            this.queueSize = 0;
            this.keepAliveTime = 600000L;
            this.debug = false;
            this.stackSize = 0L;
            this.implicit = true;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
            if (debug) {
                this.implicit = false;
            }
        }

        public long getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public void setKeepAliveTime(long keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
            this.implicit = false;
        }

        public int getMaxPoolSize() {
            return this.maxPoolSize;
        }

        public void setMaxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            this.implicit = false;
        }

        public int getMinPoolSize() {
            return this.minPoolSize;
        }

        public void setMinPoolSize(int minPoolSize) {
            this.minPoolSize = minPoolSize;
            this.implicit = false;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
            this.implicit = false;
        }

        public long getStackSize() {
            return this.stackSize;
        }

        public void setStackSize(long stackSize) {
            this.stackSize = stackSize;
            this.implicit = false;
        }

        public boolean isImplicit() {
            return this.implicit;
        }

        public void setImplicit(boolean b) {
            this.implicit = b;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public void write(PrintWriter out, String indent) throws IOException {
            if (this.isImplicit()) {
                return;
            }
            out.print(indent + "<" + this.nodeNm + " name=\"" + this.getPoolName() + "\" min=\"" + this.getMinPoolSize() + "\" max=\"" + this.getMaxPoolSize() + "\" queue=\"" + this.getQueueSize() + "\" keepAlive=\"" + this.getKeepAliveTime() + "\" stackSize=\"" + this.getStackSize() + "\"");
            if (this.isDebug()) {
                out.println(" debug=\"true\" />");
            } else {
                out.println("/>");
            }
        }

        public void read(String minS, String maxS, String qS, String kaS, String debugS, String sSS) {
            if (minS == null && maxS == null && qS == null && kaS == null && debugS == null && sSS == null) {
                return;
            }
            if (minS != null) {
                this.setMinPoolSize(Integer.parseInt(minS));
            }
            if (maxS != null) {
                this.setMaxPoolSize(Integer.parseInt(maxS));
            }
            if (kaS != null) {
                this.setKeepAliveTime(Long.parseLong(kaS));
            }
            if (qS != null) {
                this.setQueueSize(Integer.parseInt(qS));
            }
            if (sSS != null) {
                this.setStackSize(Long.parseLong(sSS));
            }
            if (debugS != null && debugS.compareToIgnoreCase("true") == 0) {
                this.setDebug(true);
            }
            this.validate();
        }

        private void validate() {
            if (this.maxPoolSize < this.minPoolSize || this.minPoolSize < 0 || this.maxPoolSize < 1) {
                throw new IllegalArgumentException("min cannot be bigger than max");
            }
        }
    }
}

