/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.ApplicationContext;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.ApplicationServerTransactionStats;
import com.evermind.server.DMSEvent;
import com.evermind.server.InvalidConfigurationException;
import com.evermind.server.Oc4jProcessId;
import com.evermind.server.SubordinateTransaction;
import com.evermind.server.ThreadResetHandler;
import com.evermind.server.ThreadState;
import com.evermind.server.TwoPhaseCommitProvider;
import com.evermind.util.ThreadPool;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.CommitCoordinatorFactory;
import oracle.as.j2ee.transaction.CoordinatorCreationException;
import oracle.as.j2ee.transaction.SubordinateTransactionManager;
import oracle.as.j2ee.transaction.TransactionManagerConfiguration;
import oracle.as.j2ee.transaction.TransactionState;
import oracle.as.j2ee.transaction.propagation.ParentReference;
import oracle.as.j2ee.transaction.tpc.Coordinator;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.as.j2ee.transaction.tpc.NormalXid;
import oracle.as.j2ee.transaction.tpc.ProtocolError;
import oracle.as.j2ee.transaction.tpc.RMId;
import oracle.as.j2ee.transaction.tpc.RecoverableSinglePhaseResourceReaperTask;
import oracle.as.j2ee.transaction.tpc.Store;
import oracle.as.j2ee.transaction.tpc.TPCException;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveringTransactionInfo;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveryManager;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveryManagerPresumedAbort;
import oracle.j2ee.transaction.OC4JTransactionManager;
import oracle.j2ee.transaction.OC4JUserTransaction;
import oracle.j2ee.transaction.TransactionMessages;
import oracle.oc4j.admin.management.mbeans.JTAResource;

public class ApplicationServerTransactionManager
implements OC4JTransactionManager,
OC4JUserTransaction,
SubordinateTransactionManager {
    private TransactionManagerConfiguration m_config;
    private CommitCoordinatorFactory m_coordinatorFactory;
    private long m_currentID;
    private RecoveryManager m_recoveryManager;
    private static RecoverableSinglePhaseResourceReaperTask m_recoverableSinglePhaseResourceReaperTask;
    private HashMap m_heuristics = new HashMap();
    static byte[] m_serverIDBytes;
    static byte[] m_clusterIdByteArray;
    private static final long m_initialTMStartupTime;
    byte[] m_initialTMStartupTimeByteArray = new byte[8];
    private HashMap m_transactions = new HashMap(32);
    private ApplicationServerTransactionStats m_stats = new ApplicationServerTransactionStats();
    private JTAResource m_jtaResource;
    private static int m_serialNumberCntr;
    private int m_defaultTimeout;
    private int m_maxConcurrentTransactions = -1;
    static final int SHUTDOWN_IN_PROGRESS = 0;
    private HashSet m_longInDoubtQueue = new HashSet();
    private HashSet m_unrecoverableBranches = new HashSet();
    private static final ThreadLocal m_txThreadLocal;
    private static final ThreadLocal m_txTimeoutThreadLocal;
    public static final int FORMAT_ID = 1330790740;

    protected static synchronized int getSerialNumber() {
        return ++m_serialNumberCntr;
    }

    public ApplicationServerTransactionManager(TransactionManagerConfiguration config, ApplicationContext ctx, long clusterId) throws CoordinatorCreationException, InvalidConfigurationException {
        String uniqueId;
        this.setConfig(config);
        try {
            uniqueId = Oc4jProcessId.currentProcessId().getUniqueId();
        }
        catch (UnknownHostException e) {
            CoordinatorCreationException coordinatorCreationException = new CoordinatorCreationException("Unable to get unique current process id");
            coordinatorCreationException.initCause(e);
            throw coordinatorCreationException;
        }
        int serverID = uniqueId.hashCode();
        m_serverIDBytes = new byte[]{(byte)(serverID >> 24), (byte)(serverID >> 16), (byte)(serverID >> 8), (byte)serverID};
        this.createClusterIdByteArray(clusterId);
        this.createInitialTMStartupTimeByteArray();
        this.setCommitCoordinatorFactory(new CommitCoordinatorFactory(this.getConfig().getCommitCoordinatorConfiguration(), uniqueId, ctx));
        this.setDefaultTransactionTimeout(this.getConfig().getTransactionTimeout());
        this.setMaxConcurrentTransactions(this.getConfig().getMaxConncurrentTransactions());
        this.getStats().addThresholdEventsFromConfig(config);
        this.registerThreadResetHandler();
    }

    private void createClusterIdByteArray(long clusterId) {
        for (int i = 0; i < 8; ++i) {
            ApplicationServerTransactionManager.m_clusterIdByteArray[i] = (byte)(clusterId & 0xFFL);
            clusterId >>= 8;
        }
    }

    private void createInitialTMStartupTimeByteArray() {
        long serverStartupTime = m_initialTMStartupTime;
        for (int i = 0; i < 8; ++i) {
            this.m_initialTMStartupTimeByteArray[i] = (byte)(serverStartupTime & 0xFFL);
            serverStartupTime >>= 8;
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        this.begin(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void begin(String type) throws NotSupportedException, SystemException {
        block4: {
            try {
                int txnStatus;
                if (this.getTransaction() != null && (txnStatus = this.getTransaction().getStatus()) != 3 && txnStatus != 4) {
                    throw new NotSupportedException("OC4J does NOT support nested transactions");
                }
                ApplicationServerTransaction transaction = this.createTransaction();
                transaction.setType(type);
                this.associateTransactionWithThread(transaction);
                Object var4_4 = null;
                if (this.getTransaction() == null) break block4;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (this.getTransaction() != null) {
                    TransactionMessages.fineExitingBeginMethodWithTx(this.getApplicationServerTransaction());
                    throw throwable;
                }
                TransactionMessages.warningBeginCouldNotStartTx();
                throw throwable;
            }
            TransactionMessages.fineExitingBeginMethodWithTx(this.getApplicationServerTransaction());
            return;
        }
        TransactionMessages.warningBeginCouldNotStartTx();
    }

    private ApplicationServerTransaction createTransaction() throws SystemException {
        return this.createTransactionWithMaxConcurrentTxCheck(this.getXid(), null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Xid getXid() {
        long currentId;
        ApplicationServerTransactionManager applicationServerTransactionManager = this;
        synchronized (applicationServerTransactionManager) {
            currentId = this.m_currentID++;
        }
        byte[] id = new byte[24];
        System.arraycopy(m_clusterIdByteArray, 0, id, 0, 8);
        System.arraycopy(this.m_initialTMStartupTimeByteArray, 0, id, 8, 8);
        for (int i = 16; i < 24; ++i) {
            id[i] = (byte)(currentId & 0xFFL);
            currentId >>= 8;
        }
        return new NormalXid(id, 1330790740);
    }

    ApplicationServerTransaction createTransactionWithMaxConcurrentTxCheck(Xid xid, ParentReference pr, boolean isSubordinate) throws SystemException {
        if (this.getMaxConcurrentTransactions() == -1 || this.getTransactionCount() < this.getMaxConcurrentTransactions()) {
            return this.createTransaction(xid, pr, isSubordinate);
        }
        if (this.getMaxConcurrentTransactions() == 0) {
            throw new SystemException("Server is currently shutting down, no further transactions may be started");
        }
        throw new SystemException("Can not begin transaction as max-concurrent-transactions limit of " + this.getMaxConcurrentTransactions() + " set in transaction-manager.xml has been exceeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationServerTransaction createTransaction(Xid xid, ParentReference pr, boolean isSubordinate) {
        if (this.getTransactionTimeout() == 0) {
            this.setThreadTransactionTimeout(this.getDefaultTransactionTimeout());
        }
        ApplicationServerTransaction transaction = null;
        transaction = isSubordinate ? new SubordinateTransaction(xid, this.getTransactionTimeout(), this, pr) : this.getNewTransaction(xid, pr);
        HashMap hashMap = this.m_transactions;
        synchronized (hashMap) {
            this.m_transactions.put(transaction.getXid(), transaction);
        }
        this.getStats().updateActive(this.getTransactionCount());
        return transaction;
    }

    ApplicationServerTransaction getNewTransaction(Xid xid, ParentReference pr) {
        return new ApplicationServerTransaction(xid, this.getTransactionTimeout(), this, pr);
    }

    private ApplicationServerTransaction createSubordinateTransaction(Xid xid, ParentReference pr, int timeout, Synchronization sync) throws SystemException, RollbackException {
        ApplicationServerTransaction tx = this.createTransactionWithMaxConcurrentTxCheck(xid, pr, true);
        if (timeout != 0) {
            tx.setTransactionTimeout(timeout);
        }
        if (sync != null) {
            tx.registerSynchronization(sync);
        }
        TransactionMessages.finest(TransactionMessages.getTraceMsgCreateSubTransaction(tx, timeout, sync, pr));
        return tx;
    }

    public int getTransactionTimeout() {
        Object object = m_txTimeoutThreadLocal.get();
        return object == null ? 0 : (Integer)object;
    }

    private void setThreadTransactionTimeout(int txTimeout) {
        TransactionMessages.fineSetTimeout(txTimeout);
        m_txTimeoutThreadLocal.set(new Integer(txTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ApplicationServerTransaction[] getCopyOfTransactions() {
        HashMap hashMap = this.m_transactions;
        synchronized (hashMap) {
            Object[] txs = this.m_transactions.values().toArray();
            ApplicationServerTransaction[] txCopy = new ApplicationServerTransaction[txs.length];
            System.arraycopy(txs, 0, txCopy, 0, txs.length);
            return txCopy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ApplicationServerTransaction getTransaction(Xid xid) {
        ApplicationServerTransaction tx = null;
        HashMap hashMap = this.m_transactions;
        synchronized (hashMap) {
            tx = (ApplicationServerTransaction)this.m_transactions.get(new NormalXid(xid));
        }
        TransactionMessages.finest(TransactionMessages.getTraceMsgGetTransaction(xid, tx));
        return tx;
    }

    void manageExpirations(boolean timeoutCheck, boolean recoverBottomUp) {
        ApplicationServerTransaction[] txListCopy = this.getCopyOfTransactions();
        ApplicationServerTransaction tx = null;
        for (int i = 0; i < txListCopy.length; ++i) {
            tx = txListCopy[i];
            if (tx.getTransactionState() == 0) {
                this.manageTimeouts(tx, timeoutCheck);
            }
            if (tx.getTransactionState() != 9 || !timeoutCheck || !recoverBottomUp) continue;
            this.manageExtendedIndoubt(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageExtendedIndoubt(ApplicationServerTransaction tx) {
        ApplicationServerTransaction applicationServerTransaction = tx;
        synchronized (applicationServerTransaction) {
            if (tx.getTransactionState() == 9 && (long)(this.getDefaultTransactionTimeout() * 1000 * 4) < tx.getTimePrepared() && !this.m_longInDoubtQueue.contains(tx)) {
                this.m_longInDoubtQueue.add(tx);
            }
        }
    }

    private void manageTimeouts(ApplicationServerTransaction tx, boolean timeoutCheck) {
        if (tx.getStatus() == 4) {
            return;
        }
        if (timeoutCheck && !tx.isTimedOut()) {
            return;
        }
        tx.forceRollback(timeoutCheck ? 201 : 205, false);
    }

    void adminSetRollbackOnly(Xid xid) throws IllegalStateException {
        this.adminAbort(xid, false);
    }

    void adminRollbackTransaction(Xid xid) throws IllegalStateException {
        this.adminAbort(xid, true);
    }

    private void adminAbort(Xid xid, boolean alwaysRollback) {
        ApplicationServerTransaction[] transactions = this.getCopyOfTransactions();
        ApplicationServerTransaction transaction = null;
        for (int i = 0; i < transactions.length; ++i) {
            if (!Arrays.equals(transactions[i].getGlobalID(), xid.getGlobalTransactionId())) continue;
            transaction = transactions[i];
        }
        if (transaction == null) {
            throw new IllegalStateException("Unable to perform administrative rollback: No such transaction or transaction in inproper state on thread: " + Thread.currentThread());
        }
        if (transaction.getStatus() != 4) {
            TransactionMessages.infoAdminRollback(transaction);
            transaction.forceRollback(204, alwaysRollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTransaction(Xid xid) {
        this.removeThreadAssociation();
        HashMap hashMap = this.m_transactions;
        synchronized (hashMap) {
            this.m_transactions.remove(xid);
        }
        this.getStats().updateActive(this.getTransactionCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeResources(ApplicationServerTransaction tx) {
        TransactionMessages.finest(TransactionMessages.getTraceMsgFreeResources(tx));
        DMSEvent freeResourcesEvent = DMSEvent.create(8);
        freeResourcesEvent.start();
        try {
            this.removeTransaction(tx.getXid());
            tx.callSynchronizationAfterCompletion();
        }
        finally {
            freeResourcesEvent.stop();
        }
    }

    private void removeThreadAssociation() {
        m_txThreadLocal.set(null);
    }

    public final Transaction getTransaction() {
        return (Transaction)m_txThreadLocal.get();
    }

    private ApplicationServerTransaction getApplicationServerTransaction() {
        return (ApplicationServerTransaction)m_txThreadLocal.get();
    }

    void setTransaction(Transaction tx) {
        m_txThreadLocal.set(tx);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        ApplicationServerTransaction tx = this.getApplicationServerTransaction();
        if (tx == null) {
            if (ApplicationServer.DMS_GATE) {
                this.getStats().incrementStat("IllegalStateExceptionCount");
            }
            throw new IllegalStateException("Rollback called with no active transaction on thread: " + Thread.currentThread());
        }
        TransactionMessages.fineRollbackCalled(tx);
        try {
            tx.setTxRollbackCause(202);
            tx.rollback();
        }
        catch (IllegalStateException ise) {
            if (ApplicationServer.DMS_GATE) {
                this.getStats().incrementStat("IllegalStateExceptionCount");
            }
            throw ise;
        }
        catch (SystemException syse) {
            if (ApplicationServer.DMS_GATE) {
                this.getStats().incrementStat("SystemExceptionCount");
            }
            throw syse;
        }
        catch (SecurityException sece) {
            if (ApplicationServer.DMS_GATE) {
                this.getStats().incrementStat("SecurityExceptionCount");
            }
            throw sece;
        }
        finally {
            this.removeThreadAssociation();
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        ApplicationServerTransaction tx = this.getApplicationServerTransaction();
        if (tx == null) {
            this.getStats().incrementStat("IllegalStateExceptionCount");
            throw new IllegalStateException("Commit called with no active transaction on thread: " + Thread.currentThread());
        }
        TransactionMessages.fineCommitCalled(tx);
        try {
            tx.commit();
        }
        catch (RollbackException rbe) {
            this.getStats().incrementStat("RollbackExceptionCount");
            tx.updateCompletionStatistics();
            throw rbe;
        }
        catch (HeuristicMixedException hme) {
            this.getStats().incrementStat("HeuristicMixedExceptionCount");
            throw hme;
        }
        catch (SystemException syse) {
            this.getStats().incrementStat("SystemExceptionCount");
            throw syse;
        }
        catch (IllegalStateException syse) {
            this.getStats().incrementStat("IllegalStateExceptionCount");
            throw syse;
        }
        catch (SecurityException sece) {
            this.getStats().incrementStat("SecurityExceptionCount");
            throw sece;
        }
    }

    public void setTransactionTimeout(int timeout) {
        this.setThreadTransactionTimeout(timeout <= 0 ? this.getDefaultTransactionTimeout() : timeout);
    }

    public void setRollbackOnly() throws SystemException {
        ApplicationServerTransaction tx = this.getApplicationServerTransaction();
        if (tx == null) {
            throw new IllegalStateException("setRollbackOnly called with no active transaction on thread: " + Thread.currentThread());
        }
        TransactionMessages.fineSetRollbackOnly(tx);
        tx.setTxRollbackCause(202);
        tx.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        Transaction transaction = this.getTransaction();
        if (transaction == null) {
            return 6;
        }
        return transaction.getStatus();
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, SystemException {
        if (transaction == null) {
            throw new InvalidTransactionException("Transaction to resume is null on thread: " + Thread.currentThread());
        }
        if (!(transaction instanceof ApplicationServerTransaction)) {
            throw new InvalidTransactionException("Transaction is not an instance of OC4J transaction type");
        }
        ApplicationServerTransaction tx = this.getApplicationServerTransaction();
        if (tx != null && tx.getTransactionState() == 0) {
            throw new IllegalStateException("Can't resume transaction, a transaction is already active");
        }
        TransactionMessages.fineResume((ApplicationServerTransaction)transaction);
        ((ApplicationServerTransaction)transaction).resume();
        this.setTransaction(transaction);
    }

    public Transaction suspend() throws SystemException {
        ApplicationServerTransaction transaction = this.getApplicationServerTransaction();
        if (transaction == null) {
            return null;
        }
        TransactionMessages.fineSuspend(transaction);
        transaction.suspend();
        this.removeThreadAssociation();
        return transaction;
    }

    void setConfig(TransactionManagerConfiguration config) {
        this.m_config = config;
    }

    TransactionManagerConfiguration getConfig() {
        return this.m_config;
    }

    private void checkThreadForTransaction() throws NotSupportedException {
        if (m_txThreadLocal.get() != null) {
            throw new NotSupportedException("Nested Transactions are not allowed. Thread already associated with transaction: " + this.getTransaction());
        }
    }

    private void associateTransactionWithThread(ApplicationServerTransaction tx) throws NotSupportedException {
        this.checkThreadForTransaction();
        this.setTransaction(tx);
    }

    void cleanupForProtocolError(ApplicationServerTransaction tx) {
        TransactionMessages.finest(TransactionMessages.getTraceMsgCleanupForProtocolError(tx));
        tx.setTransactionState(16);
        this.removeTransaction(tx.getXid());
        Store store = this.m_coordinatorFactory.getStore();
        GlobalTransaction gtx = null;
        try {
            gtx = store.recover(tx.getXid());
            this.addRecoveredTransaction(gtx);
        }
        catch (Store.StoreException e) {
            Xid xid = tx.getXid();
            this.addUnrecoverableXid(xid);
            TransactionMessages.warningCouldNotReconstructTxFromStoreOnProto(e.toString(), xid);
        }
    }

    RecoveringTransactionInfo getRecoveringTransactionInfo() throws Store.StoreException {
        return this.m_coordinatorFactory.getStore().getRecoveringTransactionInfo();
    }

    TwoPhaseCommitProvider createCoordinator(ApplicationServerTransaction tx) throws RollbackException {
        TransactionMessages.finest(TransactionMessages.getTraceMsgCreateCoordinator(tx));
        try {
            return this.m_coordinatorFactory.createInstance(tx);
        }
        catch (CoordinatorCreationException e) {
            tx.setRollbackMessage("Unable to create coordinator : " + e);
            tx.rollbackResources();
            RollbackException re = new RollbackException("Unable to create coordinator, transaction rolled back");
            re.initCause((Throwable)e);
            throw re;
        }
    }

    boolean isUsingMidTierCoordinator() {
        return !this.m_coordinatorFactory.coordinatorDelegatesToDatabase();
    }

    boolean isLastResourceCommitSupported() {
        return this.m_coordinatorFactory.coordinatorSupportsLastResourceCommit();
    }

    void setCommitCoordinatorFactory(CommitCoordinatorFactory factory) {
        this.m_coordinatorFactory = factory;
    }

    CommitCoordinatorFactory getCommitCoordinatorFactory() {
        return this.m_coordinatorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean infectThread(Xid xid, int txTimeout, Synchronization sync, boolean allowNewBranch) throws NotSupportedException, SystemException, RollbackException, InvalidTransactionException {
        TransactionMessages.finest(TransactionMessages.getTraceMsgInfectThread(xid, txTimeout, sync));
        if (!this.isUsingMidTierCoordinator()) {
            throw new NotSupportedException("Propagation not supported when using the in-database coordinator");
        }
        this.validateInflowedXid(xid);
        this.checkThreadForTransaction();
        boolean existingBranch = false;
        ApplicationServerTransaction tx = null;
        HashMap hashMap = this.m_transactions;
        synchronized (hashMap) {
            tx = this.matchPropagatedTransaction(xid);
        }
        if (tx != null) {
            existingBranch = true;
            this.resumeImportedBranchTransaction(tx);
        } else {
            if (!allowNewBranch) {
                return false;
            }
            tx = this.createSubordinateTransaction(xid, null, txTimeout, sync);
            tx.markInfectingBegin();
            this.associateTransactionWithThread(tx);
        }
        return existingBranch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importTransaction(Xid xid, int txTimeout, Synchronization sync, ParentReference pr) throws NotSupportedException, SystemException, RollbackException, InvalidTransactionException {
        TransactionMessages.finest(TransactionMessages.getTraceMsgImportTransaction(xid, txTimeout, sync, pr));
        this.validateInflowedXid(xid);
        this.checkThreadForTransaction();
        HashMap hashMap = this.m_transactions;
        synchronized (hashMap) {
            ApplicationServerTransaction tx;
            ApplicationServerTransaction createdTx = null;
            if (this.getTransaction(xid) == null) {
                createdTx = this.createSubordinateTransaction(xid, pr, txTimeout, sync);
            }
            if (createdTx != null) {
                createdTx.m_isRootOfImportedTx = true;
            }
            if ((tx = this.matchPropagatedTransaction(xid)) != createdTx) {
                if (createdTx != null) {
                    createdTx.suspend();
                }
                this.resumeImportedBranchTransaction(tx);
            } else {
                createdTx.markInfectingBegin();
                this.associateTransactionWithThread(createdTx);
            }
        }
    }

    ApplicationServerTransaction matchPropagatedTransaction(Xid xid) {
        ApplicationServerTransaction matchedTx = null;
        Object[] txs = this.m_transactions.values().toArray();
        for (int i = 0; i < txs.length; ++i) {
            ApplicationServerTransaction tx = (ApplicationServerTransaction)txs[i];
            if (tx.getXid().getFormatId() != xid.getFormatId() || !Arrays.equals(tx.getXid().getGlobalTransactionId(), xid.getGlobalTransactionId())) continue;
            TransactionMessages.finest(TransactionMessages.getTraceMsgMatchedInflowedTransaction(xid, tx));
            if (tx.getResourceCount() > 0) {
                matchedTx = tx;
                break;
            }
            if (matchedTx != null) continue;
            matchedTx = tx;
        }
        TransactionMessages.finest(TransactionMessages.getTraceMsgReturningMatchedTransaction(matchedTx));
        return matchedTx;
    }

    private void resumeImportedBranchTransaction(ApplicationServerTransaction tx) throws InvalidTransactionException, SystemException {
        tx.blockIfConcurrentRequest();
        this.resume(tx);
    }

    public void endInfection() throws SystemException {
        ApplicationServerTransaction tx = (ApplicationServerTransaction)this.getTransaction();
        if (tx == null) {
            return;
        }
        TransactionMessages.finest(TransactionMessages.getTraceMsgEndInfection(tx));
        this.suspend();
        tx.markInfectingEnded();
    }

    private void addRecoveredInDoubtTransaction(TwoPhaseCommitProvider branch) {
        ApplicationServerTransaction tx = this.createTransaction(branch.getGlobalTransaction().getXid(), branch.getGlobalTransaction().getParentReference(), true);
        TransactionMessages.finest(TransactionMessages.getTraceMsgAddInDoubt(tx));
        tx.setCoordinator(branch);
        tx.setTransactionState(9);
    }

    void forget(GlobalTransaction tx) throws XAException {
        TransactionMessages.finest(TransactionMessages.getTraceMsgForget(tx));
        Coordinator coord = new Coordinator(tx, this.m_recoveryManager);
        try {
            coord.forget();
            this.m_heuristics.remove(tx.getXid());
        }
        catch (SystemException e) {
            XAException xe = new XAException(-3);
            xe.initCause(e);
            throw xe;
        }
        catch (IllegalStateException e) {
            XAException xe = new XAException(-6);
            xe.initCause(e);
            throw xe;
        }
    }

    public void forget(Xid xid) throws XAException {
        TransactionMessages.fineInflowForget(xid);
        GlobalTransaction tx = (GlobalTransaction)this.m_heuristics.get(xid);
        if (tx == null) {
            throw new XAException(-4);
        }
        if (!tx.isHeuristicCompleted()) {
            throw new XAException(-3);
        }
        this.forget(tx);
    }

    public void end(Xid xid, int flag) throws XAException {
        ApplicationServerTransaction tx = this.getTransaction(xid);
        if (tx == null) {
            throw new XAException(-4);
        }
        TransactionMessages.fineEnd(tx, flag);
        tx.endResources(flag == 0x4000000);
    }

    public int prepare(Xid xid) throws XAException {
        ApplicationServerTransaction tx = this.getTransaction(xid);
        if (tx == null) {
            throw new XAException(-4);
        }
        TransactionMessages.finePrepare(tx);
        try {
            return tx.prepare();
        }
        catch (ProtocolError pe) {
            this.cleanupForProtocolError(tx);
            XAException xae = new XAException("prepare() resulted in a protocol error: " + pe);
            xae.errorCode = -6;
            xae.initCause(pe);
            throw xae;
        }
    }

    public void beforeCompletion() {
        ApplicationServerTransaction tx = (ApplicationServerTransaction)this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("beforeCompletion called outside of transaction scope on thread: " + Thread.currentThread());
        }
        TransactionMessages.fineBeforeCompletion(tx);
        tx.callBeforeCompletion();
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        ApplicationServerTransaction tx = this.getTransaction(xid);
        if (tx == null) {
            this.checkForHeuristicFinish(xid);
            if (this.isXidUnrecoverable(xid)) {
                throw new XAException(-7);
            }
            throw new XAException(-4);
        }
        TransactionMessages.fineInflowCommit(tx, onePhase);
        try {
            tx.commit(false, onePhase);
        }
        catch (XAException xae) {
            this.rememberHeuristicBranch(xae, tx);
        }
        catch (ProtocolError err) {
            this.cleanupForProtocolError(tx);
            XAException xae = new XAException("commit() resulted in a protocol error: " + err);
            xae.errorCode = -6;
            throw xae;
        }
    }

    public void rollback(Xid xid) throws XAException {
        ApplicationServerTransaction tx = this.getTransaction(xid);
        if (tx == null) {
            this.checkForHeuristicFinish(xid);
            if (this.isXidUnrecoverable(xid)) {
                throw new XAException(-7);
            }
            throw new XAException(-4);
        }
        TransactionMessages.fineInflowRollback(tx);
        try {
            tx.rollback(false);
        }
        catch (XAException xae) {
            this.rememberHeuristicBranch(xae, tx);
        }
        catch (ProtocolError err) {
            this.cleanupForProtocolError(tx);
            XAException xae = new XAException("rollback() resulted in a protocol error: " + err);
            xae.errorCode = -6;
            throw xae;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid[] recover(int flag) throws XAException {
        ArrayList recoveredXids = new ArrayList();
        ApplicationServerTransactionManager applicationServerTransactionManager = this;
        synchronized (applicationServerTransactionManager) {
            this.collectInDoubtXids(recoveredXids);
            this.collectHeuristicXids(recoveredXids);
            this.collectUnrecoverableXids(recoveredXids);
        }
        TransactionMessages.finest(TransactionMessages.getTraceMsgRecover(flag, recoveredXids));
        return recoveredXids.toArray(new Xid[0]);
    }

    private void checkForHeuristicFinish(Xid xid) throws XAException {
        GlobalTransaction tx = (GlobalTransaction)this.m_heuristics.get(xid);
        if (tx == null) {
            return;
        }
        if (tx.getTransactionState() == 10) {
            XAException xae = new XAException("The transaction branch has been heuristically committed");
            xae.errorCode = 7;
            throw xae;
        }
        if (tx.getTransactionState() == 11) {
            XAException xae = new XAException("The transaction branch has been heuristically rolled back");
            xae.errorCode = 6;
            throw xae;
        }
        if (tx.getTransactionState() == 15) {
            XAException xae = new XAException("The transaction branch is heuristic mixed");
            xae.errorCode = 5;
            throw xae;
        }
        XAException xae = new XAException("The branch has been heuristically completed but state is unknown");
        xae.errorCode = 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUnrecoverableXid(Xid xid) {
        TransactionMessages.finest(TransactionMessages.getTraceMsgAddUnrecoverableXid(xid));
        HashSet hashSet = this.m_unrecoverableBranches;
        synchronized (hashSet) {
            this.m_unrecoverableBranches.add(xid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isXidUnrecoverable(Xid xid) {
        HashSet hashSet = this.m_unrecoverableBranches;
        synchronized (hashSet) {
            return this.m_unrecoverableBranches.contains(xid);
        }
    }

    private void collectHeuristicXids(ArrayList list) {
        Iterator iter = this.m_heuristics.keySet().iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
    }

    Xid[] getInDoubtXids() {
        ArrayList l = new ArrayList();
        this.collectInDoubtXids(l);
        return l.toArray(new Xid[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectInDoubtXids(ArrayList list) {
        HashMap hashMap = this.m_transactions;
        synchronized (hashMap) {
            Object[] txs = this.m_transactions.values().toArray();
            for (int i = 0; i < txs.length; ++i) {
                ApplicationServerTransaction tx = (ApplicationServerTransaction)txs[i];
                if (tx.getTransactionState() != 9) continue;
                list.add(tx.getXid());
            }
        }
    }

    Xid[] getActiveXids() {
        ArrayList l = new ArrayList();
        this.collectActiveXids(l);
        return l.toArray(new Xid[0]);
    }

    private void collectUnrecoverableXids(ArrayList list) {
        Iterator iter = this.m_unrecoverableBranches.iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectActiveXids(ArrayList list) {
        HashMap hashMap = this.m_transactions;
        synchronized (hashMap) {
            Object[] txs = this.m_transactions.values().toArray();
            for (int i = 0; i < txs.length; ++i) {
                ApplicationServerTransaction tx = (ApplicationServerTransaction)txs[i];
                if (tx.getTransactionState() != 0) continue;
                list.add(tx.getXid());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void heuristicRollback(Xid xid) throws SystemException, IllegalStateException {
        ApplicationServerTransaction tx = this.getTransaction(xid);
        if (tx == null) {
            throw new IllegalStateException("No transaction exists for Xid: " + xid + " on thread: " + Thread.currentThread());
        }
        if (tx.getTransactionState() != 9) {
            throw new IllegalStateException("Transaction: " + tx + " not in-doubt; status " + TransactionState.toString(tx.getTransactionState()));
        }
        TransactionMessages.fineHeuristicRollback(tx);
        try {
            tx.rollback(true);
        }
        catch (XAException e) {
            if (e.errorCode != 6) {
                SystemException se = new SystemException();
                se.initCause((Throwable)e);
                throw se;
            }
        }
        finally {
            this.m_heuristics.put(xid, tx.getGlobalTransaction());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void heuristicCommit(Xid xid) throws SystemException, IllegalStateException {
        ApplicationServerTransaction tx = this.getTransaction(xid);
        if (tx == null) {
            throw new IllegalStateException("No transaction exists for Xid: " + xid + " on thread: " + Thread.currentThread());
        }
        if (tx.getTransactionState() != 9) {
            throw new IllegalStateException("Transaction: " + tx + " not in-doubt; status " + TransactionState.toString(tx.getTransactionState()));
        }
        TransactionMessages.fineHeuristicCommit(tx);
        try {
            tx.commit(true, false);
        }
        catch (XAException e) {
            if (e.errorCode != 7) {
                SystemException se = new SystemException();
                se.initCause((Throwable)e);
                throw se;
            }
        }
        finally {
            this.m_heuristics.put(xid, tx.getGlobalTransaction());
        }
    }

    Xid[] getHeurCompletedTxsForState(int state) {
        Iterator iter = this.m_heuristics.values().iterator();
        ArrayList<Xid> matches = new ArrayList<Xid>();
        while (iter.hasNext()) {
            GlobalTransaction tx = (GlobalTransaction)iter.next();
            if (!tx.is(state)) continue;
            matches.add(tx.getXid());
        }
        return matches.toArray(new Xid[0]);
    }

    void createRecoveryManager(RecoveringTransactionInfo recoveringTransactionInfo) {
        if (!this.isUsingMidTierCoordinator()) {
            return;
        }
        List recoveredTransactions = recoveringTransactionInfo.getRecoveringTxs();
        this.m_recoveryManager = new RecoveryManagerPresumedAbort(this.getConfig().getRecoveryRetryInterval(), this.getConfig().getRecoveryAbandonmentDetails());
        Iterator i = recoveredTransactions.iterator();
        while (i.hasNext()) {
            this.addRecoveredTransaction((GlobalTransaction)i.next());
        }
        Iterator iterator = recoveringTransactionInfo.getRecoveringRMIds().iterator();
        RMId rmid = null;
        while (iterator.hasNext()) {
            try {
                rmid = (RMId)iterator.next();
                this.m_recoveryManager.acquireXAResource(rmid);
            }
            catch (TPCException e) {
                this.m_recoveryManager.addUnacquiredResource(rmid);
                TransactionMessages.finer("Unable to acquire xids for " + rmid + " (this may be expected during startup particularly for resources not bound to the default " + "application) : " + e);
            }
        }
        this.m_coordinatorFactory.setRecoveryManager(this.m_recoveryManager);
        if (this.m_coordinatorFactory.coordinatorSupportsLastResourceCommit()) {
            m_recoverableSinglePhaseResourceReaperTask = new RecoverableSinglePhaseResourceReaperTask(this.m_recoveryManager, this.getConfig().getRLRCPurgeInterval(), this.getConfig().getRLRCMinPurgeSize());
            Thread recoverableSinglePhaseResourceReaperTaskThread = new Thread((Runnable)m_recoverableSinglePhaseResourceReaperTask, "RecoverableSinglePhaseResourceReaperTaskThread");
            recoverableSinglePhaseResourceReaperTaskThread.setDaemon(true);
            recoverableSinglePhaseResourceReaperTaskThread.start();
        }
    }

    void setRecoveryManager(RecoveryManager recoveryManager) {
        this.m_recoveryManager = recoveryManager;
    }

    void addRecoveredTransaction(GlobalTransaction tx) {
        TransactionMessages.finest(TransactionMessages.getTraceMsgAddRecoveredTransaction(tx));
        if (tx.is(9)) {
            this.addRecoveredInDoubtTransaction(this.m_recoveryManager.restoreInDoubtBranches(tx));
        } else {
            if (tx.isHeuristic()) {
                this.m_heuristics.put(tx.getXid(), tx);
                if (tx.isHeuristicCompleted()) {
                    return;
                }
            }
            this.m_recoveryManager.add(tx);
        }
    }

    void launchRecoveryThread(ThreadPool pool) {
        if (!this.isUsingMidTierCoordinator()) {
            return;
        }
        TransactionMessages.finer("Launching recovery manager");
        pool.launch(this.m_recoveryManager);
    }

    RecoveryManager getRecoveryManager() {
        return this.m_recoveryManager;
    }

    Set getLongDurationInDoubt() {
        return this.m_longInDoubtQueue;
    }

    private void rememberHeuristicBranch(XAException xae, ApplicationServerTransaction tx) throws XAException {
        if (xae.errorCode == 7) {
            tx.setTransactionState(10);
            this.m_heuristics.put(tx.getXid(), tx.getGlobalTransaction());
        } else if (xae.errorCode == 5) {
            tx.setTransactionState(15);
            this.m_heuristics.put(tx.getXid(), tx.getGlobalTransaction());
        } else if (xae.errorCode == 6) {
            tx.setTransactionState(11);
            this.m_heuristics.put(tx.getXid(), tx.getGlobalTransaction());
        } else if (xae.errorCode == 8) {
            tx.setTransactionState(17);
            this.m_heuristics.put(tx.getXid(), tx.getGlobalTransaction());
        }
        throw xae;
    }

    void shutdownRecoverableSinglePhaseResourceReaper() {
        if (m_recoverableSinglePhaseResourceReaperTask != null) {
            m_recoverableSinglePhaseResourceReaperTask.shutdown();
        }
    }

    void shutdown() {
        TransactionMessages.finer("Shutting down TransactionManager...");
        this.setMaxConcurrentTransactions(0);
        this.manageExpirations(false, false);
        if (this.getConfig().isCoordConfigChanged()) {
            try {
                this.getConfig().setTMShuttingDown(true);
                this.waitForAnyIndoubtsToComplete();
            }
            catch (IOException ioe) {
                TransactionMessages.severeUnableToStoreConfigChanges(ioe.getMessage());
            }
        }
        if (this.m_recoveryManager != null) {
            this.m_recoveryManager.cancel();
        }
        this.getCommitCoordinatorFactory().getStore().shutdown(this.isNoPotentialForIncompleteTransactions());
    }

    private boolean isNoPotentialForIncompleteTransactions() {
        TransactionMessages.finer("TransactionManager shutdown: " + this.m_transactions.size() + " active and indoubt transaction(s) remain(s)");
        TransactionMessages.finer(">>>>>>>>>>>>>>>>>>>>>>>");
        TransactionMessages.finer("" + this.m_transactions);
        TransactionMessages.finer(">>>>>>>>>>>>>>>>>>>>>>>");
        TransactionMessages.finer("TransactionManager shutdown: " + this.m_heuristics.size() + " heuristically complete transaction(s) remain(s)");
        TransactionMessages.finer(">>>>>>>>>>>>>>>>>>>>>>>");
        TransactionMessages.finer("" + this.m_heuristics);
        TransactionMessages.finer(">>>>>>>>>>>>>>>>>>>>>>>");
        TransactionMessages.finer("TransactionManager shutdown: " + this.m_unrecoverableBranches.size() + " unrecoverable transaction branch(es) remain(s)");
        TransactionMessages.finer(">>>>>>>>>>>>>>>>>>>>>>>");
        TransactionMessages.finer("" + this.m_unrecoverableBranches);
        TransactionMessages.finer(">>>>>>>>>>>>>>>>>>>>>>>");
        return this.m_transactions.size() == 0 && this.m_heuristics.size() == 0 && this.m_unrecoverableBranches.size() == 0 && this.m_recoveryManager != null && this.m_recoveryManager.isNoPotentialForUnrecoveredTransactions();
    }

    private void waitForAnyIndoubtsToComplete() throws IOException {
        int oldLength = 0;
        int length = 0;
        while (this.getInDoubtXids().length > 0) {
            length = this.getInDoubtXids().length;
            try {
                if (oldLength != length) {
                    oldLength = length;
                    String listOfIndoubtXids = "";
                    for (int i = 0; i < length; ++i) {
                        listOfIndoubtXids = listOfIndoubtXids + "\n" + this.getInDoubtXids()[i];
                    }
                    TransactionMessages.infoWaitingForIndoubtToComplete(length, length == 1 ? "" : "s", listOfIndoubtXids);
                }
                Thread.sleep(4000L);
            }
            catch (InterruptedException ioe) {
                IOException ice = new IOException("Interrupted while waiting for in-doubt transactions to complete");
                ice.initCause(ioe);
                throw ice;
            }
        }
    }

    public static byte[] getServerIDBytes() {
        return m_serverIDBytes;
    }

    public static byte[] getClusterIDBytes() {
        return m_clusterIdByteArray;
    }

    ApplicationServerTransactionStats getStats() {
        return this.m_stats;
    }

    void setJTAResource(JTAResource jtaResource) {
        this.m_jtaResource = jtaResource;
    }

    public boolean isAdminAvailable() {
        return this.m_jtaResource != null;
    }

    void fireEvent(String type, long sequenceNumber, String message) throws MalformedObjectNameException {
        this.m_jtaResource.fireEvent(new Notification(type, (Object)this.m_jtaResource.getObjectName(), sequenceNumber, message));
    }

    void setDefaultTransactionTimeout(int timeout) {
        this.m_defaultTimeout = timeout;
    }

    private int getDefaultTransactionTimeout() {
        return this.m_defaultTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addThresholdEvent(String thresholdStatisticName, int threshold, int repeatNotificationInterval, NotificationBroadcaster notificationBroadcaster) throws InvalidConfigurationException {
        TransactionManagerConfiguration transactionManagerConfiguration = this.getConfig();
        synchronized (transactionManagerConfiguration) {
            boolean thresholdEventForThisStatExists = this.getStats().addThresholdEvent(thresholdStatisticName, threshold, repeatNotificationInterval);
            this.getConfig().addOrUpdateThresholdEventToConfigXML(thresholdEventForThisStatExists, thresholdStatisticName, threshold, repeatNotificationInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeThresholdEvent(String thresholdStatisticName) throws InvalidConfigurationException {
        TransactionManagerConfiguration transactionManagerConfiguration = this.getConfig();
        synchronized (transactionManagerConfiguration) {
            this.getStats().removeThresholdEvent(thresholdStatisticName);
            this.getConfig().addOrUpdateThresholdEventToConfigXML(true, thresholdStatisticName, 0, 0);
        }
    }

    void setMaxConcurrentTransactions(int maxConcurrentTransactions) {
        this.m_maxConcurrentTransactions = maxConcurrentTransactions;
    }

    int getMaxConcurrentTransactions() {
        return this.m_maxConcurrentTransactions;
    }

    int getTransactionCount() {
        return this.m_transactions.size();
    }

    private void registerThreadResetHandler() {
        ThreadResetHandler handler = new ThreadResetHandler(){

            public void cleanup(Thread thread) {
                m_txTimeoutThreadLocal.set(null);
            }
        };
        ThreadState.registerResetHandler(handler);
    }

    private void validateInflowedXid(Xid xid) throws InvalidTransactionException {
        if (xid == null) {
            throw new InvalidTransactionException(TransactionMessages.warningInvalidInflowedXid("Inflowed Xid can't be null."));
        }
        if (xid.getGlobalTransactionId() == null || xid.getGlobalTransactionId().length == 0) {
            throw new InvalidTransactionException(TransactionMessages.warningInvalidInflowedXid("Inflowed Xid can't have null transaction identifier"));
        }
        if (xid.getBranchQualifier() == null || xid.getBranchQualifier().length == 0) {
            throw new InvalidTransactionException(TransactionMessages.warningInvalidInflowedXid("Inflowed Xid can't have null branch qualifier"));
        }
    }

    public static RecoverableSinglePhaseResourceReaperTask getRecoverableSinglePhaseResourceReaperTask() {
        return m_recoverableSinglePhaseResourceReaperTask;
    }

    public void setType(String type) {
        ApplicationServerTransaction tx = this.getApplicationServerTransaction();
        if (tx != null) {
            tx.setType(type);
        }
    }

    public String getType() {
        ApplicationServerTransaction tx = this.getApplicationServerTransaction();
        return tx == null ? null : tx.getType();
    }

    public void setTransactionIsolation(int isolationLevel) {
        ApplicationServerTransaction tx = this.getApplicationServerTransaction();
        if (tx != null) {
            tx.setTransactionIsolation(isolationLevel);
        }
    }

    public int getTransactionIsolation() {
        ApplicationServerTransaction tx = this.getApplicationServerTransaction();
        return tx == null ? -1 : tx.getTransactionIsolation();
    }

    static {
        m_serverIDBytes = new byte[8];
        m_clusterIdByteArray = new byte[8];
        m_initialTMStartupTime = System.currentTimeMillis();
        m_serialNumberCntr = 0;
        m_txThreadLocal = new ThreadLocal();
        m_txTimeoutThreadLocal = new ThreadLocal();
    }
}

