/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import oracle.dms.console.NounFactoryIntf;
import oracle.dms.console.PhaseEventFactoryIntf;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.PhaseEventIntf;

public class DMSEvent {
    static final int PERFORMTX = 0;
    static final int SINGLE_PHASE = 1;
    static final int TWO_PHASE = 2;
    static final int SUSPEND = 3;
    static final int ROLLBACK = 4;
    static final int PREPARE = 5;
    static final int BEFORE_COMPLETION = 6;
    static final int RESUME_RESOURCES = 7;
    static final int FREE_RESOURCES = 8;
    static final int PERFORMCCOMMITTX = 9;
    static final int NO_OP = 10;
    private static NounFactoryIntf m_nounFactory = null;
    private static PhaseEventFactoryIntf m_phaseFactory = null;
    private static NounIntf m_txnNoun = null;
    private static PhaseEventIntf m_performTxPhase = null;
    private static PhaseEventIntf m_performCommitTxPhase = null;
    private static PhaseEventIntf m_singlePhaseCommitPhase = null;
    private static PhaseEventIntf m_twoPhaseCommitPhase = null;
    private static PhaseEventIntf m_suspendPhase = null;
    private static PhaseEventIntf m_rollBackPhase = null;
    private static PhaseEventIntf m_doPreparePhase = null;
    private static PhaseEventIntf m_callBeforeCompletionPhase = null;
    private static PhaseEventIntf m_resumeResourcesPhase = null;
    private static PhaseEventIntf m_freeResourcesPhase = null;
    private static boolean m_heavySensors = false;
    private static DMSEvent m_inactiveDMSEvent = new DMSEvent(false);
    private PhaseEventIntf m_pe = null;
    private long m_token = 0L;
    private boolean m_enabled = true;
    public static final String PERFORMTRANSACTION = "PerformTransaction";
    public static final String AVERAGECOMMITTIME = "AverageCommitTime";
    public static final String SINGLEPHASECOMMIT_COMPLETION = "SinglePhaseCommitCompletion";
    public static final String TWOPHASECOMMIT_COMPLETION = "TwoPhaseCommitCompletion";
    public static final String TRANSACTIONSUSPENDED = "TransactionSuspended";
    public static final String ROLLBACK_COMPLETION = "RollbackCompletion";
    public static final String[] JTA_STAT_NAMES = new String[]{"PerformTransaction", "AverageCommitTime", "SinglePhaseCommitCompletion", "TwoPhaseCommitCompletion", "TransactionSuspended", "RollbackCompletion"};

    static DMSEvent create(int eventType) {
        if (!ApplicationServer.DMS_GATE) {
            return m_inactiveDMSEvent;
        }
        switch (eventType) {
            case 0: {
                return DMSEvent.constructEvent(true, m_performTxPhase);
            }
            case 9: {
                return DMSEvent.constructEvent(true, m_performCommitTxPhase);
            }
            case 1: {
                return DMSEvent.constructEvent(true, m_singlePhaseCommitPhase);
            }
            case 2: {
                return DMSEvent.constructEvent(true, m_twoPhaseCommitPhase);
            }
            case 3: {
                return DMSEvent.constructEvent(true, m_suspendPhase);
            }
            case 4: {
                return DMSEvent.constructEvent(true, m_rollBackPhase);
            }
            case 5: {
                return DMSEvent.constructEvent(m_heavySensors, m_doPreparePhase);
            }
            case 6: {
                return DMSEvent.constructEvent(m_heavySensors, m_callBeforeCompletionPhase);
            }
            case 7: {
                return DMSEvent.constructEvent(m_heavySensors, m_resumeResourcesPhase);
            }
            case 8: {
                return DMSEvent.constructEvent(m_heavySensors, m_freeResourcesPhase);
            }
            case 10: {
                return DMSEvent.constructEvent(false, null);
            }
        }
        System.out.println("WARNING: Invalid event type passed into DMSEvent.create: " + eventType);
        return DMSEvent.constructEvent(false, null);
    }

    private static DMSEvent constructEvent(boolean enable, PhaseEventIntf event) {
        DMSEvent newEvent = new DMSEvent(enable);
        newEvent.setPhaseEvent(event);
        return newEvent;
    }

    private DMSEvent(boolean enable) {
        this.m_enabled = enable;
    }

    void start() {
        if (this.m_pe != null) {
            this.m_token = this.m_pe.start();
        }
    }

    void stop() {
        if (this.m_pe != null) {
            this.m_pe.stop(this.m_token);
            this.m_pe = null;
        }
    }

    void abort() {
        if (this.m_pe != null) {
            this.m_pe.abort(this.m_token);
            this.m_pe = null;
        }
    }

    private void setPhaseEvent(PhaseEventIntf phaseEvent) {
        if (ApplicationServer.DMS_GATE && this.m_enabled) {
            this.m_pe = phaseEvent;
        }
    }

    static {
        if (ApplicationServer.DMS_GATE) {
            m_nounFactory = ApplicationServer.nounFactory();
            m_phaseFactory = ApplicationServer.phaseEventFactory();
            m_txnNoun = m_nounFactory.create(Application.getJ2eeNoun(), "JTAResource", "JTAResource");
            m_performTxPhase = m_phaseFactory.create(m_txnNoun, PERFORMTRANSACTION, "Time from start to end of transaction");
            m_performTxPhase.deriveMetric(511);
            m_performCommitTxPhase = m_phaseFactory.create(m_txnNoun, AVERAGECOMMITTIME, "Time from start to end of committed transaction");
            m_performCommitTxPhase.deriveMetric(511);
            m_singlePhaseCommitPhase = m_phaseFactory.create(m_txnNoun, SINGLEPHASECOMMIT_COMPLETION, "Time required for a single-phase commit");
            m_singlePhaseCommitPhase.deriveMetric(511);
            m_twoPhaseCommitPhase = m_phaseFactory.create(m_txnNoun, TWOPHASECOMMIT_COMPLETION, "Time required for a two-phase commit");
            m_twoPhaseCommitPhase.deriveMetric(511);
            m_suspendPhase = m_phaseFactory.create(m_txnNoun, TRANSACTIONSUSPENDED, "Time transaction is suspended");
            m_suspendPhase.deriveMetric(511);
            m_rollBackPhase = m_phaseFactory.create(m_txnNoun, ROLLBACK_COMPLETION, "Time required to rollback transaction");
            m_rollBackPhase.deriveMetric(511);
            if (DMSConsole.getSensorWeight() > 5) {
                m_heavySensors = true;
            }
            if (m_heavySensors) {
                m_doPreparePhase = m_phaseFactory.create(m_txnNoun, "doPrepare", "Time required for a prepare call on this subordinate node (issued by it's coordinator)");
                m_doPreparePhase.deriveMetric(511);
                m_callBeforeCompletionPhase = m_phaseFactory.create(m_txnNoun, "callBeforeCompletion", "Time required for beforeCompletion calls on Synchronizations");
                m_callBeforeCompletionPhase.deriveMetric(511);
                m_resumeResourcesPhase = m_phaseFactory.create(m_txnNoun, "resumeResources", "Time required for resources of this transaction to be resumed");
                m_resumeResourcesPhase.deriveMetric(511);
                m_freeResourcesPhase = m_phaseFactory.create(m_txnNoun, "freeResources", "Time required to freeResources of this transaction");
                m_freeResourcesPhase.deriveMetric(511);
            }
        }
    }
}

