/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerThread;
import com.evermind.util.ServerProperties;
import com.evermind.util.Task;
import com.evermind.util.TaskManager;
import javax.naming.NamingException;

public class EventThreadChecker
implements Runnable {
    private ApplicationServer server;
    private TaskManager taskManager;
    private long timeout = 120000L;

    public EventThreadChecker(ApplicationServer server, TaskManager taskManager) {
        this.server = server;
        this.taskManager = taskManager;
    }

    public void run() {
        if (ServerProperties.getThreadMonitorDebug()) {
            System.out.println("Resource thread monitor launched...");
        }
        ApplicationServerThread ethread = (ApplicationServerThread)Thread.currentThread();
        ethread.setName("Resource Thread Checker");
        ethread.setDaemon(true);
        while (this.server.isAlive()) {
            Task currentlyRunning = this.taskManager.getCurrentlyRunningTask();
            System.out.println("Checking up on event thread: " + (currentlyRunning == null ? "<none>" : String.valueOf(currentlyRunning.runnable)));
            long lastReturned = this.taskManager.getLastKnownNotHavingReturned();
            if (ServerProperties.getThreadMonitorDebug() && lastReturned != 0L) {
                System.out.println("Resource thread has been operating in " + (System.currentTimeMillis() - lastReturned) + " milli seconds");
            }
            if (lastReturned != 0L && lastReturned + this.timeout < System.currentTimeMillis()) {
                String message = "WARNING: A critical thread seems to be stuck. This happens if user code hogs an important resource and then goes into an infinite loop or similar.\n";
                Task task = this.taskManager.getCurrentlyRunningTask();
                if (task != null) {
                    message = message + "The task that is stuck is: " + (task.runnable == null ? "<unknown>" : task.runnable.toString());
                }
                ApplicationServerThread thread = (ApplicationServerThread)this.taskManager.getThread();
                if (thread.state.waitingForResource != null || thread.state.waitingForState != null) {
                    message = message + thread.state.getChainMessage() + "\n";
                }
                try {
                    if (thread.state.contextContainer != null) {
                        message = message + "The context of the action is '" + thread.state.contextContainer + "' in application '" + thread.state.contextContainer.getApplication().getName() + "'";
                    }
                }
                catch (NamingException e) {
                    // empty catch block
                }
                message = message + "Attempting to interrupt thread\n";
                message = message + "Advice: If a debug environment is accessible (JDB or an IDE debugger or similar) then it is often useful to reproduce the problem inside that environment. The name of the thread to look for is: '" + thread.getName() + "'\n";
                thread.interrupt();
                System.err.println(message);
                this.server.log(message);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }
}

