/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.naming.ContextUtils;
import com.evermind.security.User;
import com.evermind.server.Application;
import com.evermind.server.ApplicationClientContext;
import com.evermind.server.ApplicationClientThreadGroup;
import com.evermind.server.ApplicationContextClassLoader;
import com.evermind.server.ApplicationServerThread;
import com.evermind.server.ContextContainer;
import com.evermind.server.administration.ApplicationResourceFinder;
import com.evermind.server.deployment.ApplicationClientArchive;
import com.evermind.server.deployment.ClientModule;
import com.oracle.naming.J2EEContext;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.jar.Manifest;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;
import oracle.j2ee.naming.ApplicationClientInitialContextFactory;
import oracle.j2ee.util.SetContextClassLoaderAction;
import oracle.oc4j.appclient.ApplicationClientLauncherImpl;
import oracle.oc4j.loader.OC4JProtectionPolicy;
import oracle.oc4j.loader.config.OC4JConfigurationPolicy;
import oracle.oc4j.loader.config.OC4JConfigurationType;

public class ServerApplicationClientLauncherImpl
extends ApplicationClientLauncherImpl
implements Runnable,
ContextContainer {
    private ApplicationClientThreadGroup group;
    private ClientModule module;
    private Application application;
    private PolicyClassLoader classLoader;
    private User user;
    private ApplicationClientArchive m_clientArchive;

    public ServerApplicationClientLauncherImpl(ClientModule module, Application application, ApplicationClientArchive archive, User user, ClassLoader parent) throws InstantiationException {
        this.module = module;
        this.application = application;
        this.user = user;
        this.m_clientArchive = archive;
        this.init(this.m_clientArchive, parent);
    }

    public static ServerApplicationClientLauncherImpl getCurrentClient() {
        for (ThreadGroup group = Thread.currentThread().getThreadGroup(); group != null; group = group.getParent()) {
            if (!(group instanceof ApplicationClientThreadGroup)) continue;
            return ((ApplicationClientThreadGroup)group).getApplicationClient();
        }
        return null;
    }

    public void run() {
        this.launch(this.module.getArguments());
    }

    public void launch(String[] parameters) {
        if (this.m_mainMethod != null) {
            while (this.isAppClientNotRunnable()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {}
            }
            if (this.application.isDestroyed()) {
                return;
            }
            try {
                this.m_mainMethod.invoke(null, new Object[]{parameters});
            }
            catch (IllegalAccessException e) {
                this.application.log(this.module.getPath() + ": Could not access main method");
            }
            catch (InvocationTargetException e) {
                this.application.log(this.module.getPath() + ": Application error", e.getTargetException());
            }
        }
    }

    protected boolean isAppClientNotRunnable() {
        return !this.application.isInitialized() && !this.application.isDestroyed();
    }

    public Application getApplication() {
        return this.application;
    }

    public Context getEnvironmentContext() {
        return this.m_environmentContext;
    }

    public void start() throws InstantiationException {
        this.group = new ApplicationClientThreadGroup(Thread.currentThread().getThreadGroup(), this.m_clientArchive.getDisplayName(), this);
        String displayName = this.m_clientArchive.getDisplayName() == null ? this.module.getPath() : this.m_clientArchive.getDisplayName();
        ApplicationServerThread thread = new ApplicationServerThread(null, (Runnable)this, displayName, this.group);
        ApplicationContextClassLoader loader = new ApplicationContextClassLoader();
        AccessController.doPrivileged(new SetContextClassLoaderAction(thread, loader));
        thread.state.contextContainer = this;
        try {
            ApplicationClientInitialContextFactory.setContext(this.group, new ApplicationClientContext(this.application.getContext(), this.getEnvironmentContext(), this.m_clientArchive));
        }
        catch (InvalidNameException e) {
            throw new InstantiationException("Naming Error: " + e.getMessage());
        }
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.group == null) {
            return;
        }
        try {
            Thread[] threads = new Thread[this.group.activeCount()];
            this.group.enumerate(threads);
            for (int i = 0; i < threads.length; ++i) {
                if (threads[i] == null) continue;
                threads[i].interrupt();
            }
        }
        finally {
            this.group = null;
            this.classLoader.close();
        }
    }

    public User getUser() {
        return this.user;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void stop() {
        if (this.group == null) {
            return;
        }
        Thread[] threads = new Thread[this.group.activeCount()];
        this.group.enumerate(threads);
        for (int i = 0; i < threads.length; ++i) {
            if (threads[i] == null) continue;
            threads[i].interrupt();
        }
    }

    public Context getAssemblyContext() {
        return this.m_clientArchive.getContext();
    }

    protected String getAppConfigPath(Application application) {
        return application.getConfig().getURL().getPath();
    }

    private void init(ApplicationClientArchive m_clientArchive, ClassLoader parent) throws InstantiationException {
        String mainClassName = "unknown";
        try {
            this.classLoader = this.createPolicyClassLoader(parent, this.application.getName(), m_clientArchive.getDisplayName());
            String appConfigPath = this.getAppConfigPath(this.application);
            SharedCodeSource cs = ServerApplicationClientLauncherImpl.createSharedCodeSource(m_clientArchive.getContext(), appConfigPath, this.classLoader);
            mainClassName = ServerApplicationClientLauncherImpl.getMainClassFromSharedCodeSource(cs);
            if (mainClassName == null) {
                this.classLoader.close();
                throw new InstantiationException("Main-Class attribute not found.");
            }
            this.m_mainClass = this.getMainClass(mainClassName, (ClassLoader)this.classLoader);
        }
        catch (IOException e) {
            InstantiationException ex = new InstantiationException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (ClassNotFoundException e) {
            InstantiationException ex = new InstantiationException("main-class '" + mainClassName + "' not found");
            ex.initCause(e);
            throw ex;
        }
        try {
            this.m_mainMethod = this.getMainMethod(this.m_mainClass);
        }
        catch (NoSuchMethodException e) {
            throw new InstantiationException("main-class '" + this.m_mainClass + "' does not have a public static void main(String[] args) method");
        }
        this.m_environmentContext = J2EEContext.create(m_clientArchive, new ApplicationResourceFinder(this.application), this.application.getContext(), null);
    }

    private static String getMainClassFromSharedCodeSource(SharedCodeSource cs) throws IOException, InstantiationException {
        String mainClassName = null;
        Manifest manifest = cs.getManifest();
        mainClassName = ServerApplicationClientLauncherImpl.getMainClassName(manifest);
        return mainClassName;
    }

    private static SharedCodeSource createSharedCodeSource(Context clientArchiveContext, String appClientXmlPath, PolicyClassLoader pcl) throws IOException {
        ConfigurationOrigin origin = new ConfigurationOrigin(OC4JConfigurationType.APPLICATION_CLIENT_MODULE, appClientXmlPath);
        File appClientJar = ContextUtils.getFile(clientArchiveContext, false);
        SharedCodeSource cs = pcl.addCodeSource(appClientJar, origin);
        if (cs == null) {
            throw new IOException("ShareCodeSource is unexpectedly null!");
        }
        return cs;
    }

    private PolicyClassLoader createPolicyClassLoader(ClassLoader parent, String applicationName, String clientArchiveDisplayName) {
        int slash;
        if (applicationName.startsWith("application ")) {
            applicationName = applicationName.substring("application ".length());
        }
        if ((slash = clientArchiveDisplayName.lastIndexOf(47)) < 0) {
            slash = clientArchiveDisplayName.lastIndexOf(92);
        }
        if (slash >= 0) {
            clientArchiveDisplayName = clientArchiveDisplayName.substring(slash + 1);
        }
        String loaderName = applicationName + ".client." + clientArchiveDisplayName;
        String source = "unknown";
        ConfigurationOrigin loaderOrigin = new ConfigurationOrigin(OC4JConfigurationType.CLIENT_MODULE_ELEMENT, source);
        return new PolicyClassLoader(loaderName, parent, loaderOrigin, OC4JConfigurationPolicy.APPLICATION_CLIENT, OC4JProtectionPolicy.applicationPolicy(applicationName));
    }
}

