/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.SubjectPropagationHandler;
import com.evermind.server.rmi.InterceptorNotificationException;
import com.evermind.server.rmi.RMIConnection;
import com.evermind.server.rmi.RMIInterceptor;
import com.evermind.server.rmi.RMIInterceptorContext;
import com.evermind.util.OrderedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import oracle.j2ee.util.TraceLogger;

public class SubjectPropagationInterceptor
implements RMIInterceptor {
    private static int s_identifier = SubjectPropagationInterceptor.class.getName().hashCode();
    static Logger s_logger = TraceLogger.getLogger(SubjectPropagationInterceptor.class);

    private SubjectPropagationHandler getHandler() {
        return SubjectPropagationHandler.getInstance();
    }

    public boolean isInterested(int command) {
        return RMIConnection.isMethodInvocationCommand(command);
    }

    public Object processSendRequest() throws IOException {
        if (!this.getHandler().getConfiguration().isSubjectPropagationEnabled()) {
            return null;
        }
        Subject subject = this.getHandler().getCurrentSubject();
        return subject == null ? null : new RequestContext(subject);
    }

    public void processReceiveRequest(Object context, RMIInterceptorContext metaContext) throws IOException {
        RequestContext requestContext = (RequestContext)context;
        if (this.allowProcessReceiveRequest(requestContext, metaContext)) {
            this.getHandler().setCurrentSubject(requestContext.getSubject(metaContext));
        } else {
            this.getHandler().setCurrentSubject(null);
        }
    }

    public Object processSendReply() throws IOException {
        return null;
    }

    public void processReceiveReply(Object context) throws IOException {
    }

    public void receiveException(Throwable e) throws InterceptorNotificationException {
    }

    public void sendException(Throwable e) throws InterceptorNotificationException {
    }

    private boolean allowProcessReceiveRequest(RequestContext requestContext, RMIInterceptorContext metaContext) throws IOException {
        return this.getHandler().getConfiguration().isSubjectPropagationEnabled() && requestContext != null && requestContext.getSubject() != null && !requestContext.getSubject().getPrincipals().isEmpty() && metaContext.isTrustedSender("subject.propagation");
    }

    public int getIdentifier() {
        return s_identifier;
    }

    public static class RequestContext
    implements Serializable {
        public static final long serialVersionUID = -7935791868572375478L;
        private Subject m_subject;

        public RequestContext() {
        }

        public RequestContext(Subject subject) {
            this.m_subject = subject;
        }

        public Subject getSubject() {
            return this.m_subject;
        }

        public Subject getSubject(RMIInterceptorContext metaContext) {
            Subject subject = this.getSubject();
            if (null == subject) {
                return null;
            }
            if (this.isTrustedSender(metaContext, "*")) {
                return subject;
            }
            OrderedSet filteredPrincipals = new OrderedSet();
            Iterator<Principal> iter = subject.getPrincipals().iterator();
            while (iter.hasNext()) {
                Principal p = iter.next();
                if (!this.isTrustedSender(metaContext, p.getName())) continue;
                filteredPrincipals.add(p);
            }
            if (filteredPrincipals.size() < subject.getPrincipals().size()) {
                subject = new Subject(subject.isReadOnly(), filteredPrincipals, subject.getPublicCredentials(), subject.getPrivateCredentials());
            }
            return subject;
        }

        private boolean isTrustedSender(RMIInterceptorContext metaContext, String principals) {
            try {
                return metaContext.isTrustedSender("subject.propagation", principals);
            }
            catch (IOException e) {
                s_logger.throwing(this.getClass().getName(), "isTrustedSender", e);
                return false;
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            if (this.m_subject != null) {
                OrderedSet principals = new OrderedSet(this.m_subject.getPrincipals());
                Iterator iterator = principals.iterator();
                while (iterator.hasNext()) {
                    Object principal = iterator.next();
                    if (!(principal instanceof Serializable)) continue;
                    out.writeObject(principal);
                }
            }
            out.writeObject(null);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            boolean tryAnother;
            this.m_subject = new Subject();
            Object principal = null;
            do {
                try {
                    tryAnother = false;
                    principal = in.readObject();
                    if (!(principal instanceof Principal)) continue;
                    this.m_subject.getPrincipals().add((Principal)principal);
                }
                catch (Exception e) {
                    s_logger.log(Level.SEVERE, "unable to deserialize principal from peer");
                    tryAnother = true;
                }
            } while (null != principal || tryAnother);
        }
    }
}

