/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.deployment.ConnectorModule;
import com.evermind.xml.XMLConfig;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLConnectorsConfig
extends XMLConfig {
    protected Collection connectors;

    public XMLConnectorsConfig(Collection connectors) {
        this.connectors = connectors;
    }

    public XMLConnectorsConfig(URL url) throws IOException, SAXException, InstantiationException {
        super(url);
    }

    public void parseDeploymentMainNode(Node node) throws InstantiationException {
        if (node.getNodeName().equals("connector")) {
            ConnectorModule module = new ConnectorModule(node);
            if (this.connectors == null) {
                this.connectors = new TreeSet();
            }
            if (this.connectors.contains(module)) {
                this.connectors.remove(module);
            }
            this.connectors.add(module);
        } else {
            super.parseDeploymentMainNode(node);
        }
    }

    public Collection getConnectors() {
        if (this.connectors == null) {
            return Collections.EMPTY_SET;
        }
        return this.connectors;
    }

    protected void verifyDocumentType(String name) throws InstantiationException {
        if (!name.equals("oc4j-connectors")) {
            throw new InstantiationException(this.getName() + " contained a " + name + " file, not a connectors file as expected");
        }
    }

    protected void writeConfig(PrintWriter out) throws IOException {
        out.println("<?xml version=\"1.0\" standalone='yes'?>");
        out.println();
        this.writeXML(out, "");
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println("<oc4j-connectors xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://xmlns.oracle.com/oracleas/schema/oc4j-connectors-10_0.xsd\"  schema-major-version=\"10\" schema-minor-version=\"0\"  >");
        if (this.connectors != null) {
            Iterator iterator = this.connectors.iterator();
            while (iterator.hasNext()) {
                ConnectorModule config = (ConnectorModule)iterator.next();
                config.writeOrionXML(out, indention + "\t");
            }
        }
        out.println("</oc4j-connectors>");
    }
}

