/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector.deployment;

import com.evermind.server.connector.deployment.ConfigurationProperty;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.oc4j.admin.management.callbackinterfaces.JCAConnectionDefinitionCallBackIf;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConnectionDefinition
implements XMLizable,
JCAConnectionDefinitionCallBackIf {
    private String m_managedConnectionFactoryClass;
    private String m_connectionFactoryInterface;
    private String m_connectionFactoryImplementationClass;
    private String m_connectionInterface;
    private String m_connectionImplementationClass;
    private List m_configurationProperties;

    public ConnectionDefinition(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.startsWith("#")) continue;
                String value = XMLUtils.getStringValue(node);
                if (nodeName.equals("managedconnectionfactory-class")) {
                    this.m_managedConnectionFactoryClass = value;
                    continue;
                }
                if (nodeName.equals("connectionfactory-interface")) {
                    this.m_connectionFactoryInterface = value;
                    continue;
                }
                if (nodeName.equals("connectionfactory-impl-class")) {
                    this.m_connectionFactoryImplementationClass = value;
                    continue;
                }
                if (nodeName.equals("connection-interface")) {
                    this.m_connectionInterface = value;
                    continue;
                }
                if (nodeName.equals("connection-impl-class")) {
                    this.m_connectionImplementationClass = value;
                    continue;
                }
                if (nodeName.equals("config-property")) {
                    this.addConfigurationProperty(new ConfigurationProperty(node));
                    continue;
                }
                throw new InstantiationException("Unknown connection-definition subtag: " + nodeName);
            }
        }
        if (this.m_managedConnectionFactoryClass == null) {
            throw new InstantiationException("Missing 'managedconnectionfactory-class' subtag in connection-definition tag");
        }
        if (this.m_connectionFactoryInterface == null) {
            throw new InstantiationException("Missing 'connectionfactory-interface' subtag in connection-definition tag");
        }
        if (this.m_connectionFactoryImplementationClass == null) {
            throw new InstantiationException("Missing 'connectionfactory-impl-class' subtag in connection-definition tag");
        }
        if (this.m_connectionInterface == null) {
            throw new InstantiationException("Missing 'connection-interface' subtag in connection-definition tag");
        }
        if (this.m_connectionImplementationClass == null) {
            throw new InstantiationException("Missing 'connection-impl-class' subtag in connection-definition tag");
        }
    }

    public ConnectionDefinition() {
    }

    public void addConfigurationProperty(ConfigurationProperty property) {
        if (this.m_configurationProperties == null) {
            this.m_configurationProperties = new ArrayList();
        }
        this.m_configurationProperties.add(property);
    }

    public String getManagedConnectionFactoryClass() {
        return this.m_managedConnectionFactoryClass;
    }

    public void setManagedConnectionFactoryClass(String type) {
        this.m_managedConnectionFactoryClass = type;
    }

    public String getConnectionFactoryImplementationClass() {
        return this.m_connectionFactoryImplementationClass;
    }

    public void setConnectionFactoryImplementationClass(String type) {
        this.m_connectionFactoryImplementationClass = type;
    }

    public String getConnectionFactoryInterface() {
        return this.m_connectionFactoryInterface;
    }

    public void setConnectionFactoryInterface(String type) {
        this.m_connectionFactoryInterface = type;
    }

    public String getConnectionInterface() {
        return this.m_connectionInterface;
    }

    public void setConnectionInterface(String type) {
        this.m_connectionInterface = type;
    }

    public String getConnectionImplementationClass() {
        return this.m_connectionImplementationClass;
    }

    public void setConnectionImplementationClass(String type) {
        this.m_connectionImplementationClass = type;
    }

    public List getConfigurationProperties() {
        if (this.m_configurationProperties == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_configurationProperties;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<connection-definition>");
        out.println(indention + "\t<managedconnectionfactory-class>" + XMLUtils.encode(this.m_managedConnectionFactoryClass) + "</managedconnectionfactory-class>");
        out.println(indention + "\t<connectionfactory-interface>" + XMLUtils.encode(this.m_connectionFactoryInterface) + "</connectionfactory-interface>");
        out.println(indention + "\t<connectionfactory-impl-class>" + XMLUtils.encode(this.m_connectionFactoryImplementationClass) + "</connectionfactory-impl-class>");
        out.println(indention + "\t<connection-interface>" + XMLUtils.encode(this.m_connectionInterface) + "</connection-interface>");
        out.println(indention + "\t<connection-impl-class>" + XMLUtils.encode(this.m_connectionImplementationClass) + "</connection-impl-class>");
        if (this.m_configurationProperties != null) {
            XMLUtils.writeAll(this.m_configurationProperties, out, indention + "\t");
        }
        out.println(indention + "</connection-definition>");
    }

    public void writeOrionXML(PrintWriter out, String indention) {
    }
}

