/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector.deployment;

import com.evermind.naming.ContextUtils;
import com.evermind.server.connector.deployment.ConfigurationProperty;
import com.evermind.server.connector.deployment.ConnectionDefinition;
import com.evermind.server.connector.deployment.ConnectorArchive;
import com.evermind.server.connector.deployment.OutboundResourceAdapter;
import com.evermind.server.connector.deployment.PrincipalHolder;
import com.evermind.server.connector.deployment.PrincipalMappingEntries;
import com.evermind.server.connector.deployment.ResourceAdapterDescriptor;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConnectorPropertySet
extends AbstractDescribable
implements XMLizable {
    private String location;
    private List configurationProperties;
    private List configPropertyNodes;
    private ConnectorArchive archive;
    private String logPath;
    private PrintWriter logWriter;
    private String connectionFactoryInterface;
    private int transactionSupport = 0;
    private int useWhichConnectionPool;
    private String sharedConnectionPoolName;
    private String connectionPoolImplementationClass;
    private Properties connectionPoolProperties;
    protected static final String DEFAULT_CONNECTION_POOL_IMPL_CLASS = "oracle.j2ee.connector.ConnectionPoolImpl";
    public static final int USE_POOL_NONE = 0;
    public static final int USE_POOL_PRIVATE = 1;
    public static final int USE_POOL_SHARED = 2;
    private String principalMappingImplementationClass;
    private Properties principalMappingProperties;
    private PrincipalMappingEntries principalMappingEntries;
    private String jaasApplicationName;
    private int principalMappingMechanism;
    public static final String PRINCIPAL_MAPPING_ENTRIES_IMPL_CLASS = "oracle.j2ee.connector.PrincipalMappingImpl";
    public static final int PRINCIPAL_MAPPING_UNDEFINED = -1;
    public static final int PRINCIPAL_MAPPING_NONE = 0;
    public static final int PRINCIPAL_MAPPING_INTERFACE = 1;
    public static final int PRINCIPAL_MAPPING_ENTRIES = 2;
    public static final int PRINCIPAL_MAPPING_JAAS = 3;
    private List xaRecoveryConfigCredentials;
    public static final String PRINCIPAL_MAPPING_NONE_STRING = "none";
    public static final String PRINCIPAL_MAPPING_ENTRIES_STRING = "principal-mapping-entries";
    public static final String PRINCIPAL_MAPPING_INTERFACE_STRING = "principal-mapping-interface";
    public static final String PRINCIPAL_MAPPING_JAAS_STRING = "jaas-module";
    private static final String CONNECTION_DEFINITION_KEY_ELEMENT = "connectionfactory-interface";

    public ConnectorPropertySet(ConnectorArchive archive, String connectionFactoryInterface, Map configProperties) throws InstantiationException {
        this.archive = archive;
        this.connectionFactoryInterface = connectionFactoryInterface;
        this.createConfigProperties(configProperties);
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void addConfigProperty(String name, String value) throws InstantiationException {
        if (name == null) {
            throw new InstantiationException("The name cannot be null.");
        }
        if (value == null) {
            value = "";
        }
        this.setConfigProperty(name, value);
    }

    private void createConfigProperties(Map configProperties) throws InstantiationException {
        ResourceAdapterDescriptor resourceAdapter = this.archive.getResourceAdapterDescriptor();
        OutboundResourceAdapter outboundRA = null;
        if (resourceAdapter != null) {
            outboundRA = resourceAdapter.getOutboundResourceAdapter();
        }
        if (outboundRA != null) {
            ConnectionDefinition connDef = null;
            connDef = outboundRA.getConnectionDefinition(this.connectionFactoryInterface);
            if (connDef == null) {
                if (this.connectionFactoryInterface == null) {
                    throw new InstantiationException("For resource adapters that are compliant with Connector Architecture 1.5 specifications and contain more than one <connection-definition> element, there must be a connectionfactory-interface element specified under each connector-factory element defined in oc4j-ra.xml");
                }
                throw new InstantiationException("Unable to find connection definition in ra.xml for connectionfactory interface specified in connection-factory element: " + this.connectionFactoryInterface + ".");
            }
            List configList = connDef.getConfigurationProperties();
            if (configList != null) {
                this.configurationProperties = new ArrayList();
                Iterator iter = configList.iterator();
                while (iter.hasNext()) {
                    ConfigurationProperty config = (ConfigurationProperty)iter.next();
                    if (config != null) {
                        this.configurationProperties.add(config.clone());
                    }
                    if (configProperties == null) continue;
                    Iterator it = configProperties.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry t = it.next();
                        String name = t.getKey().toString();
                        if (!name.equalsIgnoreCase(config.getName())) continue;
                        String value = t.getValue().toString();
                        this.setConfigProperty(name, value);
                    }
                }
            }
        }
    }

    public void setTransactionSupport(int value) throws InstantiationException {
        if (value != 1 && value != 2 && value != 3) {
            throw new InstantiationException("Invalid transaction support level value: " + value + ".");
        }
        ResourceAdapterDescriptor resourceAdapter = this.archive.getResourceAdapterDescriptor();
        OutboundResourceAdapter outboundRA = null;
        if (resourceAdapter != null) {
            outboundRA = resourceAdapter.getOutboundResourceAdapter();
        }
        if (outboundRA != null && outboundRA.getTransactionSupport() < value) {
            throw new InstantiationException("Transaction support level is not supported by resource adapter.");
        }
        this.transactionSupport = value;
    }

    public int getTransactionSupport() {
        return this.transactionSupport;
    }

    public ConnectorPropertySet(ConnectorArchive archive, Node parent) throws InstantiationException {
        this.archive = archive;
        this.setName(XMLUtils.getNodeAttribute(parent, "connector-name"));
        if (this.getName() == null) {
            throw new InstantiationException("Missing 'connector-name' attribute in <connector-factory> tag");
        }
        this.location = XMLUtils.getNodeAttribute(parent, "location");
        if (this.location == null) {
            throw new InstantiationException("Missing 'location' attribute in <connector-factory> tag");
        }
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.startsWith("#")) continue;
                if (nodeName.equals("description")) {
                    this.setDescription(XMLUtils.getStringValue(node));
                    continue;
                }
                if (nodeName.equals("managedconnectionfactory-class")) {
                    throw new InstantiationException("managedconnectionfactory-class element has been replaced by connectionfactory-interface which should contain the name of the connection factory interface");
                }
                if (nodeName.equals(CONNECTION_DEFINITION_KEY_ELEMENT)) {
                    this.connectionFactoryInterface = XMLUtils.getStringValue(node);
                    continue;
                }
                if (nodeName.equals("log")) {
                    this.parseLoggingNode(node);
                    continue;
                }
                if (nodeName.equals("connection-pooling")) {
                    this.parsePoolingConfig(node);
                    continue;
                }
                if (nodeName.equals("config-property")) {
                    this.addConfigPropertyNode(node);
                    continue;
                }
                if (nodeName.equals("security-config")) {
                    this.parseSecurityConfig(node);
                    continue;
                }
                if (nodeName.equals("xa-recovery-config")) {
                    this.parseXAReoveryConfig(node);
                    continue;
                }
                throw new InstantiationException("Unknown connector-factory subtag: " + nodeName);
            }
        }
        try {
            this.createConfigProperties(null);
        }
        catch (InstantiationException e) {
            System.err.println(e.getMessage());
        }
        if (this.configPropertyNodes != null) {
            Iterator iter = this.configPropertyNodes.iterator();
            while (iter.hasNext()) {
                Node configPropertyNode = (Node)iter.next();
                this.parseConfigurationProperty(configPropertyNode);
            }
            this.configPropertyNodes = null;
        }
    }

    private void printConfigProperties() {
        if (this.configurationProperties != null) {
            Iterator iter = this.configurationProperties.iterator();
            while (iter.hasNext()) {
                ConfigurationProperty config = (ConfigurationProperty)iter.next();
                System.out.println(config);
            }
        }
    }

    private void addConfigPropertyNode(Node node) {
        if (this.configPropertyNodes == null) {
            this.configPropertyNodes = new ArrayList();
        }
        this.configPropertyNodes.add(node);
    }

    public ConnectorPropertySet(String name) {
        this.setName(name);
    }

    public ConnectorPropertySet(String name, String _connectionFactoryInterface) {
        this(name);
        this.connectionFactoryInterface = _connectionFactoryInterface;
    }

    private void parseXAReoveryConfig(Node parent) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Node childnode = list.item(i);
            String childname = childnode.getNodeName();
            if (childname.startsWith("#")) continue;
            if (childname.equals("password-credential")) {
                this.parseXARecoveryPasswordCredential(childnode);
                continue;
            }
            throw new InstantiationException("Unknown xa-recovery-config subtag: " + childname);
        }
    }

    private void parseXARecoveryPasswordCredential(Node parent) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        if (list == null) {
            return;
        }
        String username = null;
        String password = null;
        for (int i = 0; i < list.getLength(); ++i) {
            Node childnode = list.item(i);
            String childname = childnode.getNodeName();
            if (childname.startsWith("#")) continue;
            if (childname.equals("username")) {
                username = XMLUtils.getStringValue(childnode);
                continue;
            }
            if (childname.equals("password")) {
                password = XMLUtils.getStringValue(childnode);
                continue;
            }
            throw new InstantiationException("Unknown xa-recovery-config subtag: " + childname);
        }
        this.addXaRecoveryConfigCredentials(new PrincipalHolder(username, password));
    }

    public void addXaRecoveryConfigCredentials(PrincipalHolder principalHolder) {
        if (this.xaRecoveryConfigCredentials == null) {
            this.xaRecoveryConfigCredentials = new ArrayList();
        }
        this.xaRecoveryConfigCredentials.add(principalHolder);
    }

    public List getXARecoveryConfigCredentials() {
        if (this.xaRecoveryConfigCredentials == null) {
            return Collections.EMPTY_LIST;
        }
        return this.xaRecoveryConfigCredentials;
    }

    public void clearXARecoveryConfigCredentials() {
        this.xaRecoveryConfigCredentials = null;
    }

    protected void parseLoggingNode(Node parent) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (!name.equals("file")) continue;
                this.logPath = XMLUtils.getNodeAttribute(node, "path");
                if (this.logPath == null) {
                    throw new InstantiationException("<log> tag with <file> subtag with missing path attribute in " + this.archive.getDeploymentDescriptorPath());
                }
                this.setLogWriter(this.logPath);
            }
        }
    }

    protected void parsePoolingConfig(Node parent) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        if (list == null) {
            return;
        }
        this.useWhichConnectionPool = this.encodeUseWhichConnectionPool(XMLUtils.getNodeAttribute(parent, "use"));
        for (int i = 0; i < list.getLength(); ++i) {
            Node childnode = list.item(i);
            String childname = childnode.getNodeName();
            if (childname.equals("use-connection-pool")) {
                this.sharedConnectionPoolName = XMLUtils.getStringValue(childnode);
                continue;
            }
            if (childname.equals("connectionpool-impl-class")) {
                this.connectionPoolImplementationClass = XMLUtils.getStringValue(childnode);
                continue;
            }
            if (!childname.equals("property")) continue;
            String propertyName = XMLUtils.getNodeAttribute(childnode, "name");
            String propertyValue = XMLUtils.getNodeAttribute(childnode, "value");
            if (propertyName == null) {
                throw new InstantiationException("connection-pooling property tag in " + this.archive.getDeploymentDescriptorPath() + " with missing name attribute");
            }
            if (propertyValue == null) {
                throw new InstantiationException("connection-pooling property tag in " + this.archive.getDeploymentDescriptorPath() + " with missing value attribute");
            }
            this.setConnectionPoolProperty(propertyName, propertyValue);
        }
        if (this.useWhichConnectionPool == 2 && this.sharedConnectionPoolName == null) {
            throw new InstantiationException("use-connection-pool must be specified when use=\"shared\".");
        }
    }

    protected void parseSecurityConfig(Node parent) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        if (list == null) {
            return;
        }
        this.principalMappingMechanism = this.encodeUseWhichMappingMechanism(XMLUtils.getNodeAttribute(parent, "use"));
        for (int i = 0; i < list.getLength(); ++i) {
            Node childnode = list.item(i);
            String childname = childnode.getNodeName();
            if (childname.startsWith("#")) continue;
            if (childname.equals(PRINCIPAL_MAPPING_INTERFACE_STRING)) {
                if (this.principalMappingMechanism == -1) {
                    this.principalMappingMechanism = 1;
                }
                this.principalMappingProperties = new Properties();
                this.parsePrincipalMappingInterface(childnode);
                continue;
            }
            if (childname.equals(PRINCIPAL_MAPPING_ENTRIES_STRING)) {
                if (this.principalMappingMechanism == -1) {
                    this.principalMappingMechanism = 2;
                }
                this.principalMappingEntries = new PrincipalMappingEntries(childnode);
                continue;
            }
            if (childname.equals(PRINCIPAL_MAPPING_JAAS_STRING)) {
                if (this.principalMappingMechanism == -1) {
                    this.principalMappingMechanism = 3;
                }
                this.parseJaasModule(childnode);
                continue;
            }
            throw new InstantiationException("Unknown security-config subtag: " + childname);
        }
        if (this.principalMappingMechanism == -1) {
            this.principalMappingMechanism = 0;
        }
    }

    protected void parseJaasModule(Node parent) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Node childnode = list.item(i);
            String childname = childnode.getNodeName();
            if (childname.startsWith("#")) continue;
            if (childname.equals("jaas-application-name")) {
                this.jaasApplicationName = XMLUtils.getStringValue(childnode);
                continue;
            }
            throw new InstantiationException("Unknown principal-mapping-interface subtag: " + childname);
        }
        if (this.jaasApplicationName == null) {
            throw new InstantiationException("Missing 'jaas-application-name' attribute in <jaas-module> tag");
        }
    }

    protected void parsePrincipalMappingInterface(Node parent) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Node childnode = list.item(i);
            String childname = childnode.getNodeName();
            if (childname.startsWith("#")) continue;
            if (childname.equals("impl-class")) {
                this.principalMappingImplementationClass = XMLUtils.getStringValue(childnode);
                continue;
            }
            if (childname.equals("property")) {
                String propertyName = XMLUtils.getNodeAttribute(childnode, "name");
                String propertyValue = XMLUtils.getNodeAttribute(childnode, "value");
                if (propertyName == null) {
                    throw new InstantiationException("Missing 'name' attribute in the property tag in <principal-mapping-interface> in file " + this.archive.getDeploymentDescriptorPath());
                }
                if (propertyValue == null) {
                    throw new InstantiationException("Missing 'value' attribute in the property tag in <principal-mapping-interface> in file " + this.archive.getDeploymentDescriptorPath());
                }
                this.principalMappingProperties.setProperty(propertyName, propertyValue);
                continue;
            }
            throw new InstantiationException("Unknown principal-mapping-interface subtag: " + childname);
        }
        if (this.principalMappingImplementationClass == null) {
            throw new InstantiationException("Missing 'principalmapping-impl-class' attribute in <security-config> tag");
        }
    }

    protected void parseConfigurationProperty(Node parent) throws InstantiationException {
        String name = XMLUtils.getNodeAttribute(parent, "name");
        if (name == null) {
            throw new InstantiationException("Missing 'name' attribute in <config-property> tag");
        }
        String value = XMLUtils.getNodeAttribute(parent, "value");
        if (value == null) {
            throw new InstantiationException("Missing 'value' attribute in <config-property> tag");
        }
        try {
            this.setConfigProperty(name, value);
        }
        catch (InstantiationException e) {
            System.err.println("Warning: " + e.getMessage());
            if (this.configurationProperties == null) {
                this.configurationProperties = new ArrayList();
            }
            this.configurationProperties.add(new ConfigurationProperty(name, "", "", value));
        }
    }

    public void setConfigProperty(String name, String value) throws InstantiationException {
        boolean found = false;
        if (this.configurationProperties != null) {
            Iterator iter = this.configurationProperties.iterator();
            while (iter.hasNext() && !found) {
                ConfigurationProperty config = (ConfigurationProperty)iter.next();
                if (!name.equals(config.getName())) continue;
                found = true;
                config.setRuntimeValue(value);
            }
        }
        if (!found) {
            throw new InstantiationException("config-property named " + name + " specified in " + this.archive.getDeploymentDescriptorPath() + " does not exist in ra.xml");
        }
    }

    private int encodeUseWhichMappingMechanism(String mappingMechanismString) throws InstantiationException {
        int code = -1;
        if (mappingMechanismString != null) {
            if (mappingMechanismString.equalsIgnoreCase(PRINCIPAL_MAPPING_ENTRIES_STRING)) {
                code = 2;
            } else if (mappingMechanismString.equalsIgnoreCase(PRINCIPAL_MAPPING_INTERFACE_STRING)) {
                code = 1;
            } else if (mappingMechanismString.equalsIgnoreCase(PRINCIPAL_MAPPING_JAAS_STRING)) {
                code = 3;
            } else if (mappingMechanismString.equalsIgnoreCase(PRINCIPAL_MAPPING_NONE_STRING)) {
                code = 0;
            } else {
                throw new InstantiationException("Invalid use attribute value '" + mappingMechanismString + "' in security-config element.");
            }
        }
        return code;
    }

    private String decodeUseWhichMappingMechanism(int mappingMechanism) {
        String result;
        switch (mappingMechanism) {
            case 0: {
                result = PRINCIPAL_MAPPING_NONE_STRING;
                break;
            }
            case 2: {
                result = PRINCIPAL_MAPPING_ENTRIES_STRING;
                break;
            }
            case 1: {
                result = PRINCIPAL_MAPPING_INTERFACE_STRING;
                break;
            }
            case 3: {
                result = PRINCIPAL_MAPPING_JAAS_STRING;
                break;
            }
            default: {
                result = PRINCIPAL_MAPPING_NONE_STRING;
            }
        }
        return result;
    }

    private int encodeUseWhichConnectionPool(String poolToUseString) throws InstantiationException {
        int poolCode = 1;
        if (poolToUseString != null) {
            if (poolToUseString.equalsIgnoreCase("shared")) {
                poolCode = 2;
            } else if (poolToUseString.equalsIgnoreCase("private")) {
                poolCode = 1;
            } else if (poolToUseString.equalsIgnoreCase(PRINCIPAL_MAPPING_NONE_STRING)) {
                poolCode = 0;
            } else {
                throw new InstantiationException("Invalid use attribute value '" + poolToUseString + "' in connection-pooling element.");
            }
        }
        return poolCode;
    }

    private String decodeUseWhichConnectionPool(int poolToUseInt) {
        String result;
        switch (poolToUseInt) {
            case 0: {
                result = PRINCIPAL_MAPPING_NONE_STRING;
                break;
            }
            case 1: {
                result = "private";
                break;
            }
            case 2: {
                result = "shared";
                break;
            }
            default: {
                result = PRINCIPAL_MAPPING_NONE_STRING;
            }
        }
        return result;
    }

    public String getSharedConnectionPoolName() {
        if (this.useWhichConnectionPool == 2) {
            return this.sharedConnectionPoolName;
        }
        return null;
    }

    public String getConnectionPoolImplementationClass() {
        if (this.connectionPoolImplementationClass == null) {
            return DEFAULT_CONNECTION_POOL_IMPL_CLASS;
        }
        return this.connectionPoolImplementationClass;
    }

    public void setConnectionPoolImplementationClass(String connectionPoolImplementationClass) {
        this.connectionPoolImplementationClass = connectionPoolImplementationClass;
    }

    public boolean isConnectionPoolDisabled() {
        return this.useWhichConnectionPool == 0;
    }

    public int getUseWhichConnectionPool() {
        return this.useWhichConnectionPool;
    }

    public void setUseWhichConnectionPool(int useWhichConnectionPool) {
        if (useWhichConnectionPool != 1 && useWhichConnectionPool != 2 && useWhichConnectionPool != 0) {
            if (this.logWriter != null) {
                this.logWriter.println("Invalid value passed to setUseWhichConnectionPool. Value of USE_POOL_PRIVATE is assumed.");
            }
            useWhichConnectionPool = 1;
        }
        this.useWhichConnectionPool = useWhichConnectionPool;
    }

    public void setSharedConnectionPoolName(String connectionPoolName) {
        this.sharedConnectionPoolName = connectionPoolName;
    }

    public int getPrincipalMappingMechanism() {
        return this.principalMappingMechanism;
    }

    public void setPrincipalMappingMechanism(int newMechanism) {
        this.principalMappingMechanism = newMechanism;
    }

    public String getJaasApplicationName() {
        return this.jaasApplicationName;
    }

    public void setJaasApplicationName(String name) {
        this.jaasApplicationName = name;
    }

    public PrincipalMappingEntries getPrincipalMappingEntries() {
        return this.principalMappingEntries;
    }

    public String getPrincipalMappingImplementationClass() {
        if (this.principalMappingMechanism == 2 || this.principalMappingMechanism == 0) {
            return PRINCIPAL_MAPPING_ENTRIES_IMPL_CLASS;
        }
        return this.principalMappingImplementationClass;
    }

    public void setPrincipalMappingImplementationClass(String clazz) {
        this.principalMappingImplementationClass = clazz;
    }

    public Properties getConnectionPoolProperties() {
        return this.connectionPoolProperties;
    }

    public void setConnectionPoolProperty(String name, String value) {
        if (this.connectionPoolProperties == null) {
            this.connectionPoolProperties = new Properties();
        }
        this.connectionPoolProperties.setProperty(name, value);
    }

    public Properties getPrincipalMappingProperties() {
        if (this.principalMappingMechanism == 2) {
            Properties prop = new Properties();
            prop.setProperty("xmlconfig", this.principalMappingEntries.toString());
            return prop;
        }
        if (this.principalMappingMechanism == 1) {
            return this.principalMappingProperties;
        }
        return null;
    }

    public List getConfigurationProperties() {
        if (this.configurationProperties == null) {
            return Collections.EMPTY_LIST;
        }
        return this.configurationProperties;
    }

    public void setConfigurationProperties(List _configurationProperties) {
        this.configurationProperties = _configurationProperties;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(String log) throws InstantiationException {
        if (log == null) {
            this.logWriter = null;
            return;
        }
        try {
            if (new File(log).isAbsolute()) {
                this.logWriter = new PrintWriter((Writer)new FileWriter(this.logPath), true);
            } else {
                Context logPathContext = ContextUtils.getContext(this.archive.getDeploymentContext(), this.logPath, false);
                if (logPathContext != null) {
                    this.logWriter = new PrintWriter((Writer)new FileWriter(logPathContext.getNameInNamespace(), true), true);
                }
            }
        }
        catch (Exception e) {
            throw new InstantiationException("Error occurs while creating a log file \"" + log + "\" for a <connector-property>. Exception is: " + e);
        }
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String newPath) {
        this.logPath = newPath;
    }

    public String getConnectionFactoryInterface() {
        return this.connectionFactoryInterface;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
    }

    public void writeOrionXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<connector-factory location=\"" + XMLUtils.encode(this.location) + "\" connector-name=\"" + XMLUtils.encode(this.getName()) + "\">");
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.configurationProperties != null) {
            Iterator iterator = this.configurationProperties.iterator();
            while (iterator.hasNext()) {
                ((ConfigurationProperty)iterator.next()).writeOrionXML(out, indention + "\t");
            }
        }
        out.println(indention + "\t<connection-pooling use=\"" + this.decodeUseWhichConnectionPool(this.useWhichConnectionPool) + "\">");
        if (this.sharedConnectionPoolName != null) {
            out.println(indention + "\t\t<use-connection-pool>" + XMLUtils.encode(this.sharedConnectionPoolName) + "</use-connection-pool>");
        }
        if (this.connectionPoolImplementationClass != null) {
            out.println(indention + "\t\t<connectionpool-impl-class>" + XMLUtils.encode(this.connectionPoolImplementationClass) + "</connectionpool-impl-class>");
        }
        if (this.connectionPoolProperties != null) {
            XMLUtils.writeCompressedMap(this.connectionPoolProperties, "property", out, "name", "value", indention + "\t\t");
        }
        out.println(indention + "\t</connection-pooling>");
        if (this.principalMappingMechanism != -1) {
            out.println(indention + "\t<security-config use=\"" + XMLUtils.encode(this.decodeUseWhichMappingMechanism(this.principalMappingMechanism)) + "\">");
            if (this.principalMappingEntries != null) {
                this.principalMappingEntries.writeXML(out, indention + "\t\t");
            }
            if (this.principalMappingImplementationClass != null) {
                out.println(indention + "\t\t<principal-mapping-interface>");
                out.println(indention + "\t\t\t<impl-class>" + XMLUtils.encode(this.principalMappingImplementationClass) + "</impl-class>");
                if (this.principalMappingProperties != null) {
                    XMLUtils.writeCompressedMap(this.principalMappingProperties, "property", out, "name", "value", indention + "\t\t\t");
                }
                out.println(indention + "\t\t</principal-mapping-interface>");
            }
            if (this.jaasApplicationName != null) {
                out.println(indention + "\t\t<jaas-module>");
                out.println(indention + "\t\t\t<jaas-application-name>" + XMLUtils.encode(this.jaasApplicationName) + "</jaas-application-name>");
                out.println(indention + "\t\t</jaas-module>");
            }
            out.println(indention + "\t</security-config>");
        }
        if (this.logPath != null) {
            out.println(indention + "\t<log>");
            out.println(indention + "\t\t<file path=\"" + XMLUtils.encode(this.logPath) + "\"/>");
            out.println(indention + "\t</log>");
        }
        if (this.connectionFactoryInterface != null) {
            out.println(indention + "\t<" + CONNECTION_DEFINITION_KEY_ELEMENT + ">" + XMLUtils.encode(this.connectionFactoryInterface) + "</" + CONNECTION_DEFINITION_KEY_ELEMENT + ">");
        }
        if (this.xaRecoveryConfigCredentials != null) {
            out.println(indention + "\t<xa-recovery-config>");
            Iterator iter = this.xaRecoveryConfigCredentials.iterator();
            while (iter.hasNext()) {
                PrincipalHolder xaUser = (PrincipalHolder)iter.next();
                out.println(indention + "\t\t<password-credential>");
                String username = null;
                String password = null;
                if (xaUser != null) {
                    username = xaUser.getUser();
                    password = xaUser.getObfuscatedPassword();
                }
                out.println(indention);
                out.println("\t\t\t<username>" + XMLUtils.encode(username) + "</username>\n");
                out.println(indention);
                out.println("\t\t\t<password>" + XMLUtils.encode(password) + "</password>\n");
                out.println(indention + "\t\t</password-credential>");
            }
            out.println(indention + "\t</xa-recovery-config>");
        }
        out.println(indention + "</connector-factory>");
    }

    public boolean equals(Object other) {
        if (other instanceof ConnectorPropertySet) {
            return ((ConnectorPropertySet)other).getName().equals(this.getName());
        }
        return false;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isPrivatePoolDefined() {
        return this.connectionPoolProperties != null;
    }

    public void persistConfigChange() {
        this.archive.persistConfigChange();
    }

    public void createPrincipalMappings() {
        try {
            this.principalMappingEntries = new PrincipalMappingEntries((Node)null);
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }
}

