/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector.deployment;

import com.evermind.server.connector.deployment.AuthenticationMechanism;
import com.evermind.server.connector.deployment.ConfigurationProperty;
import com.evermind.server.connector.deployment.ConnectionDefinition;
import com.evermind.server.connector.deployment.InboundResourceAdapter;
import com.evermind.server.connector.deployment.OutboundResourceAdapter;
import com.evermind.server.connector.deployment.ResourceAdapterDescriptor;
import com.evermind.server.connector.deployment.SecurityPermission;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceAdapter
extends AbstractDescribable
implements XMLizable,
ResourceAdapterDescriptor,
OutboundResourceAdapter {
    protected int transactionSupport = 0;
    protected boolean reauthenticationSupport;
    protected List securityPermissions;
    protected List authenticationMechanisms;
    private ConnectionDefinition connectionDefinition = new ConnectionDefinition();

    public ResourceAdapter() {
    }

    public ResourceAdapter(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.startsWith("#")) continue;
                String value = XMLUtils.getStringValue(node);
                if (nodeName.equals("managedconnectionfactory-class")) {
                    this.setManagedConnectionFactoryClass(value);
                    continue;
                }
                if (nodeName.equals("connectionfactory-interface")) {
                    this.setConnectionFactoryInterface(value);
                    continue;
                }
                if (nodeName.equals("connectionfactory-impl-class")) {
                    this.setConnectionFactoryImplementationClass(value);
                    continue;
                }
                if (nodeName.equals("connection-interface")) {
                    this.setConnectionInterface(value);
                    continue;
                }
                if (nodeName.equals("connection-impl-class")) {
                    this.setConnectionImplementationClass(value);
                    continue;
                }
                if (nodeName.equals("transaction-support")) {
                    this.setTransactionSupport(value);
                    continue;
                }
                if (nodeName.equals("config-property")) {
                    this.addConfigurationProperty(new ConfigurationProperty(node));
                    continue;
                }
                if (nodeName.equals("reauthentication-support")) {
                    this.setReauthenticationSupported("true".equals(value));
                    continue;
                }
                if (nodeName.equals("security-permission")) {
                    this.addSecurityPermission(new SecurityPermission(node));
                    continue;
                }
                if (nodeName.equals("authentication-mechanism")) {
                    this.addAuthenticationMechanism(new AuthenticationMechanism(node));
                    continue;
                }
                throw new InstantiationException("Unknown resourceadapter subtag: " + nodeName);
            }
        }
        if (this.transactionSupport == 0) {
            throw new InstantiationException("Missing 'transaction-support' subtag in resourceadapter tag");
        }
        if (this.getManagedConnectionFactoryClass() == null) {
            throw new InstantiationException("Missing 'managedconnectionfactory-class' subtag in resourceadapter tag");
        }
        if (this.getConnectionFactoryInterface() == null) {
            throw new InstantiationException("Missing 'connectionfactory-interface' subtag in resourceadapter tag");
        }
        if (this.getConnectionFactoryImplementationClass() == null) {
            throw new InstantiationException("Missing 'connectionfactory-impl-class' subtag in resourceadapter tag");
        }
        if (this.getConnectionInterface() == null) {
            throw new InstantiationException("Missing 'connection-interface' subtag in resourceadapter tag");
        }
        if (this.getConnectionImplementationClass() == null) {
            throw new InstantiationException("Missing 'connection-impl-class' subtag in resourceadapter tag");
        }
    }

    public ResourceAdapter(String name) {
        this.setName(name);
    }

    public void addConfigurationProperty(ConfigurationProperty property) {
        this.connectionDefinition.addConfigurationProperty(property);
        this.firePropertyChangeEvent("configurationProperties", null, property);
    }

    public void setTransactionSupport(String value) {
        if (value.equalsIgnoreCase("NoTransaction")) {
            this.transactionSupport = 1;
        } else if (value.equalsIgnoreCase("LocalTransaction")) {
            this.transactionSupport = 2;
        } else if (value.equalsIgnoreCase("XATransaction")) {
            this.transactionSupport = 3;
        }
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<resourceadapter>");
        out.println(indention + "\t<managedconnectionfactory-class>" + XMLUtils.encode(this.getManagedConnectionFactoryClass()) + "</managedconnectionfactory-class>");
        out.println(indention + "\t<connectionfactory-interface>" + XMLUtils.encode(this.getConnectionFactoryInterface()) + "</connectionfactory-interface>");
        out.println(indention + "\t<connectionfactory-impl-class>" + XMLUtils.encode(this.getConnectionFactoryImplementationClass()) + "</connectionfactory-impl-class>");
        out.println(indention + "\t<connection-interface>" + XMLUtils.encode(this.getConnectionInterface()) + "</connection-interface>");
        out.println(indention + "\t<connection-impl-class>" + XMLUtils.encode(this.getConnectionImplementationClass()) + "</connection-impl-class>");
        out.println(indention + "\t<transaction-support>" + ResourceAdapter.getTransactionSupportName(this.transactionSupport) + "</transaction-support>");
        out.println(indention + "<reauthentication-support>" + this.reauthenticationSupport + "</reauthentication-support>");
        if (this.securityPermissions != null) {
            XMLUtils.writeAll(this.securityPermissions, out, indention + "\t");
        }
        if (this.authenticationMechanisms != null) {
            XMLUtils.writeAll(this.authenticationMechanisms, out, indention + "\t");
        }
        if (this.getConfigurationProperties() != Collections.EMPTY_LIST) {
            XMLUtils.writeAll(this.getConfigurationProperties(), out, indention + "\t");
        }
        out.println(indention + "</resourceadapter>");
    }

    public void writeOrionXML(PrintWriter out, String indention) throws IOException {
    }

    public static String getTransactionSupportName(int type) {
        if (type == 2) {
            return "local_transaction";
        }
        if (type == 3) {
            return "xa_transaction";
        }
        return "no_transaction";
    }

    public String getManagedConnectionFactoryClass() {
        return this.connectionDefinition.getManagedConnectionFactoryClass();
    }

    public String getConnectionFactoryImplementationClass() {
        return this.connectionDefinition.getConnectionFactoryImplementationClass();
    }

    public String getConnectionFactoryInterface() {
        return this.connectionDefinition.getConnectionFactoryInterface();
    }

    public String getConnectionInterface() {
        return this.connectionDefinition.getConnectionInterface();
    }

    public String getConnectionImplementationClass() {
        return this.connectionDefinition.getConnectionImplementationClass();
    }

    public boolean equals(Object other) {
        if (other instanceof ResourceAdapter) {
            return ((ResourceAdapter)other).getName().equals(this.getName());
        }
        return false;
    }

    public void setManagedConnectionFactoryClass(String type) {
        this.connectionDefinition.setManagedConnectionFactoryClass(type);
    }

    public void setConnectionFactoryClass(String type) {
        this.setConnectionFactoryImplementationClass(type);
    }

    public void setConnectionFactoryImplementationClass(String type) {
        this.connectionDefinition.setConnectionFactoryImplementationClass(type);
    }

    public void setConnectionFactoryInterface(String type) {
        this.connectionDefinition.setConnectionFactoryInterface(type);
    }

    public void setConnectionInterface(String type) {
        this.connectionDefinition.setConnectionInterface(type);
    }

    public void setConnectionImplementationClass(String type) {
        this.connectionDefinition.setConnectionImplementationClass(type);
    }

    public void setConnectionClass(String type) {
        this.setConnectionImplementationClass(type);
    }

    public ConnectionDefinition getConnectionDefinition(String connectionFactoryInterface) {
        if (connectionFactoryInterface != null && !connectionFactoryInterface.equals(this.connectionDefinition.getConnectionFactoryInterface())) {
            return null;
        }
        return this.connectionDefinition;
    }

    public Iterator getConnectionDefinitions() {
        ArrayList<ConnectionDefinition> aList = new ArrayList<ConnectionDefinition>(1);
        if (this.connectionDefinition != null) {
            aList.add(this.connectionDefinition);
        }
        return aList.iterator();
    }

    public int getTransactionSupport() {
        return this.transactionSupport;
    }

    public List getConfigurationProperties() {
        return this.connectionDefinition.getConfigurationProperties();
    }

    public void removeConfigurationProperty(int pos) {
        this.connectionDefinition.getConfigurationProperties().remove(pos);
    }

    public boolean isReauthenticationSupported() {
        return this.reauthenticationSupport;
    }

    public void setReauthenticationSupported(boolean support) {
        this.reauthenticationSupport = support;
    }

    public void addSecurityPermission(SecurityPermission permission) {
        if (this.securityPermissions == null) {
            this.securityPermissions = new ArrayList();
        }
        this.securityPermissions.add(permission);
        this.firePropertyChangeEvent("securityPermissions", null, permission);
    }

    public void removeSecurityPermission(int pos) {
        Object permission = this.securityPermissions.remove(pos);
        this.firePropertyChangeEvent("securityPermissions", permission, null);
    }

    public List getSecurityPermissions() {
        if (this.securityPermissions == null) {
            return Collections.EMPTY_LIST;
        }
        return this.securityPermissions;
    }

    public void addAuthenticationMechanism(AuthenticationMechanism auth) {
        if (this.authenticationMechanisms == null) {
            this.authenticationMechanisms = new ArrayList();
        }
        this.authenticationMechanisms.add(auth);
        this.firePropertyChangeEvent("authenticationMechanisms", null, auth);
    }

    public void removeAuthenticationMechanism(int pos) {
        Object auth = this.authenticationMechanisms.remove(pos);
        this.firePropertyChangeEvent("authenticationMechanisms", auth, null);
    }

    public List getAuthenticationMechanisms() {
        if (this.authenticationMechanisms == null) {
            return Collections.EMPTY_LIST;
        }
        return this.authenticationMechanisms;
    }

    public OutboundResourceAdapter getOutboundResourceAdapter() {
        return this;
    }

    public String getResourceAdapterClass() {
        return null;
    }

    public InboundResourceAdapter getInboundResourceAdapter() {
        return null;
    }

    public List getAdminObjects() {
        return Collections.EMPTY_LIST;
    }

    public List getResourceAdapterConfigurationProperties() {
        return Collections.EMPTY_LIST;
    }
}

