/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.connector.deployment.AdminObject;
import com.evermind.server.connector.deployment.AdminObjectInstance;
import com.evermind.server.connector.deployment.ConfigurationProperty;
import com.evermind.server.connector.deployment.ConnectorArchive;
import com.evermind.server.connector.deployment.ResourceAdapterDescriptor;
import com.evermind.server.connector.deployment.SecurityPermission;
import com.evermind.server.deployment.Module;
import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import oracle.oc4j.admin.management.callbackinterfaces.ResourceAdapterModuleCallBackIf;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConnectorModule
extends Module
implements Comparable,
ResourceAdapterModuleCallBackIf {
    static final int UNDEFINED_STARTORDER = Integer.MAX_VALUE;
    public static final String DATASOURCE_CONNECTOR_MODULE_NAME = "datasources";
    public static final String GENERIC_JMS_CONNECTOR_MODULE_NAME = "OracleASjms";
    protected String unpackedPath;
    protected String nativeLibraryPath;
    protected List securityPermissions;
    protected boolean grantAllPermissions;
    protected ResourceAdapterDescriptor resourceAdapterDescriptor;
    protected int startOrder = Integer.MAX_VALUE;
    protected List configurationProperties = new ArrayList();
    protected List adminObjectInstances;
    private Application m_application;
    private ConnectorArchive archive;
    static final boolean DEBUG_PERSISTENCE = false;
    private static final String RESOURCE_PROVIDER_PROP_NAME = "lookupMethod";
    private static final String RESOURCE_PROVIDER_PROP_VALUE = "resourceProvider";

    public ConnectorModule(String path, String name, boolean grantAllPermissions) {
        super(path, name);
        this.grantAllPermissions = grantAllPermissions;
    }

    public ConnectorModule(Node parent) throws InstantiationException {
        super(parent);
        this.init(parent);
    }

    private void init(Node parent) throws InstantiationException {
        if (parent.getNodeName().equals("module")) {
            this.path = XMLUtils.getSubnodeValue(parent, "connector");
        } else {
            String _path = XMLUtils.getNodeAttribute(parent, "path");
            if (_path == null) {
                throw new InstantiationException("Missing 'path' attribute in <connector> tag");
            }
            if (this.path != null && !this.path.equals(_path)) {
                throw new InstantiationException("different descriptor is provided. path:" + _path);
            }
            this.path = _path;
            String _name = XMLUtils.getNodeAttribute(parent, "name");
            if (_name == null) {
                throw new InstantiationException("Missing 'name' attribute in <connector> tag");
            }
            if (this.name != null && !this.name.equals(_name)) {
                throw new InstantiationException("different descriptor is provided. name:" + _name);
            }
            this.name = _name;
            NodeList nodes = parent.getChildNodes();
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    String nodeName = node.getNodeName();
                    if (nodeName.equals("native-library")) {
                        this.nativeLibraryPath = XMLUtils.getStringValue(node);
                        if (this.nativeLibraryPath != null && !this.nativeLibraryPath.equals("")) continue;
                        this.nativeLibraryPath = XMLUtils.getNodeAttribute(node, "path");
                        continue;
                    }
                    if (nodeName.equals("security-permission")) {
                        this.addSecurityPermission(new SecurityPermission(node, true));
                        continue;
                    }
                    if (nodeName.equals("config-property")) {
                        this.addConfigurationProperty(new ConfigurationProperty(node, 2));
                        continue;
                    }
                    if (nodeName.equals("adminobject-config")) {
                        this.addAdminObjectInstance(new AdminObjectInstance(node));
                        continue;
                    }
                    if (!nodeName.equals("start-order")) continue;
                    this.startOrder = XMLUtils.parseInt("start-order", XMLUtils.getStringValue(node));
                }
            }
        }
    }

    public void setDeploymentDescriptor(String dd) throws IllegalArgumentException {
        byte[] m_deplData;
        try {
            m_deplData = dd.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsEx) {
            m_deplData = dd.getBytes();
        }
        try {
            Node node = XMLUtils.getRootNode(m_deplData, null, "connector");
            this.init(node);
        }
        catch (InstantiationException e) {
            IllegalArgumentException ex = new IllegalArgumentException("A different desscriptor is provided.");
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            IllegalArgumentException ex = new IllegalArgumentException("A wrong desscriptor is provided.");
            ex.initCause(e);
            throw ex;
        }
    }

    protected void addConfigurationProperty(ConfigurationProperty property) {
        this.configurationProperties.add(property);
    }

    public void addAdminObjectInstance(AdminObjectInstance adm) {
        if (this.adminObjectInstances == null) {
            this.adminObjectInstances = new ArrayList();
        }
        this.adminObjectInstances.add(adm);
    }

    public void removeAdminObjectInstance(AdminObjectInstance adm) {
        if (this.adminObjectInstances != null) {
            this.adminObjectInstances.remove(adm);
        }
    }

    public void grantAllPermissions() {
        this.grantAllPermissions = true;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setApplication(Application app) {
        this.m_application = app;
    }

    public boolean isStandalone() {
        if (this.isAppNullOrNotDefault()) {
            return false;
        }
        return !this.isDeployedAsResourceProvider();
    }

    public boolean isAppNullOrNotDefault() {
        return this.m_application == null || !this.m_application.isDefaultApplication();
    }

    public boolean isDeployedAsResourceProvider() {
        return RESOURCE_PROVIDER_PROP_VALUE.equals(this.getConfigurationProperty(RESOURCE_PROVIDER_PROP_NAME));
    }

    public void addSecurityPermission(SecurityPermission permission) {
        if (this.securityPermissions == null) {
            this.securityPermissions = new ArrayList();
        }
        this.securityPermissions.add(permission);
    }

    public void setNativeLibraryPath(String _nativeLibraryPath) {
        this.nativeLibraryPath = _nativeLibraryPath;
    }

    public PermissionCollection getPermissions() throws InstantiationException {
        Permissions ps = new Permissions();
        if (this.securityPermissions != null) {
            Iterator iter = this.securityPermissions.iterator();
            while (iter.hasNext()) {
                SecurityPermission sp = (SecurityPermission)iter.next();
                PermissionCollection permissions = sp.getPermissions();
                if (permissions == null) continue;
                Enumeration<Permission> e = permissions.elements();
                while (e.hasMoreElements()) {
                    ps.add(e.nextElement());
                }
            }
        }
        return ps;
    }

    public void setResourceAdapterDescriptor(ResourceAdapterDescriptor _resourceAdapterDescriptor) throws InstantiationException {
        this.resourceAdapterDescriptor = _resourceAdapterDescriptor;
        if (_resourceAdapterDescriptor != null) {
            this.setSecurityPermissions(_resourceAdapterDescriptor.getSecurityPermissions());
            this.loadConfigProperties(_resourceAdapterDescriptor.getResourceAdapterConfigurationProperties());
            this.loadAdminObjects(_resourceAdapterDescriptor.getAdminObjects());
        }
    }

    protected void setSecurityPermissions(List sp) {
        if (this.securityPermissions == null) {
            this.securityPermissions = sp;
        }
    }

    protected void loadConfigProperties(List _configProperties) throws InstantiationException {
        if (this.configurationProperties.size() > 0) {
            Iterator oc4jIter = this.configurationProperties.iterator();
            while (oc4jIter.hasNext()) {
                ConfigurationProperty oc4jProperty = (ConfigurationProperty)oc4jIter.next();
                if (this.containsConfigurationProperty(_configProperties, oc4jProperty.getName())) continue;
                throw new InstantiationException("resource adapter config-property named " + oc4jProperty.getName() + " specified in " + this.path + " does not exist in ra.xml");
            }
        }
        Iterator iter = _configProperties.iterator();
        while (iter.hasNext()) {
            ConfigurationProperty config = (ConfigurationProperty)iter.next();
            if (config == null || this.containsConfigurationProperty(this.configurationProperties, config.getName())) continue;
            this.addConfigurationProperty((ConfigurationProperty)config.clone());
        }
    }

    protected void loadAdminObjects(List _adminObjects) throws InstantiationException {
        if (this.adminObjectInstances != null) {
            Iterator oc4jIter = this.adminObjectInstances.iterator();
            while (oc4jIter.hasNext()) {
                AdminObject oc4jAdminObj = (AdminObject)oc4jIter.next();
                if (this.containsAdminObjectClass(_adminObjects, oc4jAdminObj.getAdminObjectClass())) continue;
                System.err.println("Warning: adminobject with adminobject-class named " + oc4jAdminObj.getAdminObjectClass() + " specified in " + this.getPath() + " does not exist in ra.xml");
            }
        }
        Iterator iter = _adminObjects.iterator();
        while (iter.hasNext()) {
            AdminObject adminObj = (AdminObject)iter.next();
            if (adminObj == null || this.containsAdminObjectClass(this.adminObjectInstances, adminObj.getAdminObjectClass())) continue;
            AdminObjectInstance aObj = adminObj.createInstance(null);
            aObj.setIsExampleOnly(true);
            this.addAdminObjectInstance(aObj);
        }
    }

    public List getAdminObjectInstances() {
        if (this.adminObjectInstances == null) {
            return Collections.EMPTY_LIST;
        }
        return this.adminObjectInstances;
    }

    public List getConfigurationProperties() {
        return this.configurationProperties;
    }

    public String getConfigurationProperty(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        List l = this.getConfigurationProperties();
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            ConfigurationProperty property = (ConfigurationProperty)iter.next();
            if (!property.getName().equals(name)) continue;
            return property.getStringValue();
        }
        return null;
    }

    public void setUnpackedPath(String path) {
        this.unpackedPath = path;
    }

    private boolean containsConfigurationProperty(List propertyList, String propertyName) {
        if (propertyList == null || propertyName == null) {
            return false;
        }
        Iterator iter = propertyList.iterator();
        boolean found = false;
        while (iter.hasNext() && !found) {
            ConfigurationProperty configProperty = (ConfigurationProperty)iter.next();
            if (!propertyName.equals(configProperty.getName())) continue;
            found = true;
        }
        return found;
    }

    private boolean containsAdminObjectClass(List adminObjectList, String className) {
        if (adminObjectList == null || className == null) {
            return false;
        }
        Iterator iter = adminObjectList.iterator();
        boolean found = false;
        while (iter.hasNext() && !found) {
            AdminObject adminObj = (AdminObject)iter.next();
            if (!className.equals(adminObj.getAdminObjectClass())) continue;
            found = true;
        }
        return found;
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<module>");
        out.println(indention + "\t<connector>" + XMLUtils.encode(this.path) + "</connector>");
        out.println(indention + "</module>");
    }

    public void writeOrionXML(PrintWriter out, String indention) {
        Iterator iter;
        out.println(indention + "<connector name=\"" + XMLUtils.encode(this.name) + "\" path=\"" + XMLUtils.encode(this.path) + "\">");
        if (this.startOrder != Integer.MAX_VALUE) {
            out.println(indention + "\t<start-order>" + this.startOrder + "</start-order>");
        }
        if (this.nativeLibraryPath != null) {
            out.println(indention + "\t<native-library>" + XMLUtils.encode(this.nativeLibraryPath) + "</native-library>");
        }
        if (this.securityPermissions != null) {
            iter = this.securityPermissions.iterator();
            while (iter.hasNext()) {
                SecurityPermission permission = (SecurityPermission)iter.next();
                if (this.grantAllPermissions) {
                    permission.enable();
                }
                permission.writeOrionXML(out, indention + "\t");
            }
        }
        iter = this.configurationProperties.iterator();
        while (iter.hasNext()) {
            ConfigurationProperty config = (ConfigurationProperty)iter.next();
            config.writeOrionXML(out, indention + "\t");
        }
        if (this.adminObjectInstances != null) {
            iter = this.adminObjectInstances.iterator();
            while (iter.hasNext()) {
                AdminObject adm = (AdminObject)iter.next();
                adm.writeOrionXML(out, indention + "\t");
            }
        }
        out.println(indention + "</connector>");
    }

    public String toString() {
        return "<connector name=\"" + XMLUtils.encode(this.name) + "\" path=\"" + XMLUtils.encode(this.path) + "\" />";
    }

    public int compareTo(Object o) throws ClassCastException {
        ConnectorModule other = (ConnectorModule)o;
        if (this.startOrder == Integer.MAX_VALUE) {
            if (other.getStartOrder() == Integer.MAX_VALUE) {
                return this.hashCode() - other.hashCode();
            }
            return 1;
        }
        if (other.getStartOrder() == Integer.MAX_VALUE) {
            return -1;
        }
        if (this.startOrder == other.getStartOrder()) {
            return this.hashCode() - other.hashCode();
        }
        return this.startOrder - other.getStartOrder();
    }

    public void setConnectorArchive(ConnectorArchive _connectorArchive) {
        this.archive = _connectorArchive;
    }

    public ConnectorArchive getConnectorArchive() {
        return this.archive;
    }

    public String getNativeLibraryPath() {
        return this.nativeLibraryPath;
    }

    public int getStartOrder() {
        return this.startOrder;
    }

    public void setStartOrder(int startOrder) {
    }

    public String getdeploymentDescriptor() {
        try {
            StringWriter buffer = new StringWriter();
            PrintWriter writer = new PrintWriter(buffer);
            this.archive.writeXML(writer, "");
            return buffer.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getproprietaryDeploymentDescriptor() {
        try {
            StringWriter buffer = new StringWriter();
            PrintWriter writer = new PrintWriter(buffer);
            writer.println("<?xml version=\"1.0\"?>");
            writer.println();
            writer.println("<connector-descriptors>");
            this.writeOrionXML(writer, "");
            writer.println();
            this.archive.writeOrionXML(writer, "");
            writer.println();
            writer.println("</connector-descriptors>");
            return buffer.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getPath() {
        if (this.unpackedPath != null) {
            return this.unpackedPath;
        }
        return super.getPath();
    }

    public void persistConfigChange() {
        ApplicationServer appserver;
        if (this.m_application != null && (appserver = this.m_application.getServer()) != null) {
            try {
                this.m_application.getConfig().storeConnectors();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isDataSourceModule() {
        return this.getName().equals(DATASOURCE_CONNECTOR_MODULE_NAME);
    }

    public boolean isJMSRAModule() {
        return this.getName().equals(GENERIC_JMS_CONNECTOR_MODULE_NAME);
    }
}

