/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IconDescriptor
extends AbstractDescribable
implements XMLizable {
    protected String smallIconName;
    protected String largeIconName;

    public IconDescriptor(Node node) {
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String name = nodes.item(i).getNodeName();
            if (name.equals("small-icon")) {
                this.smallIconName = XMLUtils.getStringValue(nodes.item(i));
                continue;
            }
            if (!name.equals("large-icon")) continue;
            this.largeIconName = XMLUtils.getStringValue(nodes.item(i));
        }
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<icon>");
        if (this.smallIconName != null) {
            out.println(indention + "\t<small-icon>" + XMLUtils.encode(this.smallIconName) + "</small-icon>");
        }
        if (this.largeIconName != null) {
            out.println(indention + "\t<large-icon>" + XMLUtils.encode(this.largeIconName) + "</large-icon>");
        }
        out.println(indention + "</icon>");
    }

    public String toString() {
        String iconStr = "";
        if (this.smallIconName != null) {
            iconStr = "smallIcon: " + this.smallIconName + " ";
        }
        if (this.largeIconName != null) {
            iconStr = "largeIcon: " + this.largeIconName;
        }
        return iconStr;
    }
}

