/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.server.deployment.ClassUtils;
import com.evermind.server.deployment.InjectionField;
import com.evermind.server.deployment.InjectionMethod;
import com.evermind.server.deployment.InjectionTarget;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;

public class InjectableReference
extends AbstractDescribable {
    private static final long serialVersionUID = 8872137436895388044L;
    public static final String INJECTION_TARGET_TAG = "injection-target";
    public static final String INJECTION_TARGET_NAME_TAG = "injection-target-name";
    public static final String INJECTION_TARGET_CLASS_TAG = "injection-target-class";
    private transient List injectionTargets = new ArrayList();
    private String targetClass;

    public InjectableReference() {
    }

    public InjectableReference(String name) {
        super(name);
    }

    public InjectableReference(String name, String type) {
        super(name);
        this.targetClass = type;
    }

    public InjectableReference(String name, String displayName, String description) {
        super(name, displayName, description);
    }

    protected boolean parseInjectionTarget(Node node) throws InstantiationException {
        String name = node.getNodeName();
        if (name.equals(INJECTION_TARGET_TAG)) {
            String targetName = XMLUtils.getSubnodeValue(node, INJECTION_TARGET_NAME_TAG);
            if (targetName == null) {
                throw new InstantiationException("Missing <injection-target-name> element from <injection-target>");
            }
            String targetCls = XMLUtils.getSubnodeValue(node, INJECTION_TARGET_CLASS_TAG);
            this.addInjectionTarget(new InjectionXML(targetCls, targetName, this.getReferenceClass()));
            return true;
        }
        return false;
    }

    public String getReferenceClass() {
        return this.targetClass;
    }

    public void setReferenceClass(String type) {
        this.targetClass = type;
    }

    public void writeInjectableXML(PrintWriter out, String indention) {
        Iterator iter = this.injectionTargets.iterator();
        while (iter.hasNext()) {
            InjectionTarget target = (InjectionTarget)iter.next();
            out.println(indention + "<" + INJECTION_TARGET_TAG + ">");
            InjectableReference.writeAroundTag(out, indention + "\t", INJECTION_TARGET_NAME_TAG, target.getTargetName());
            InjectableReference.writeAroundTag(out, indention + "\t", INJECTION_TARGET_CLASS_TAG, target.getTargetClass());
            out.println(indention + "</" + INJECTION_TARGET_TAG + ">");
        }
    }

    protected static void writeAroundTag(PrintWriter out, String indentation, String tagName, String value) {
        out.println(indentation + "<" + tagName + ">" + value + "</" + tagName + ">");
    }

    public void addInjectionTarget(InjectionTarget target) {
        this.injectionTargets.add(target);
    }

    public void inject(Object target, Object value) throws Exception {
        Iterator iter = this.injectionTargets.iterator();
        while (iter.hasNext()) {
            ((InjectionTarget)iter.next()).inject(target, value);
        }
    }

    public void initializeInjection(Class componentClass) throws InstantiationException {
        Iterator iter = this.injectionTargets.iterator();
        while (iter.hasNext()) {
            InjectionTarget target = (InjectionTarget)iter.next();
            if (target.getResourceType() == null) {
                target.setResourceType(this.getReferenceClass());
            }
            target.initialize(componentClass);
        }
    }

    public boolean hasInjectionTarget() {
        return !this.injectionTargets.isEmpty();
    }

    public List getInjectionTargets() {
        return this.injectionTargets;
    }

    protected void writeMappedName(PrintWriter out, String indention, String mappedName) {
        if (mappedName != null && mappedName.length() > 0) {
            InjectableReference.writeAroundTag(out, indention + "\t", "mapped-name", mappedName);
        }
    }

    public class InjectionXML
    extends InjectionTarget {
        private InjectionTarget injectTarget;

        private InjectionXML(String targetClass, String targetName, String resourceType) {
            super(targetClass, targetName, resourceType);
        }

        /*
         * WARNING - void declaration
         */
        public void initialize(Class componentClass) throws InstantiationException {
            Class<?> resourceClass;
            void var2_2;
            Class<?> theClass;
            if (this.getTargetClass() == null) {
                theClass = componentClass;
                this.setTargetClass(componentClass.getName());
            } else {
                try {
                    theClass = componentClass.getClassLoader().loadClass(this.getTargetClass());
                }
                catch (ClassNotFoundException e) {
                    throw new InstantiationException("Error loading class '" + this.getTargetClass() + "' due to ClassNotFoundException");
                }
            }
            String setterMethod = "set" + String.valueOf(this.getTargetName().charAt(0)).toUpperCase() + this.getTargetName().substring(1);
            try {
                resourceClass = var2_2.getClassLoader().loadClass(this.getResourceType());
            }
            catch (ClassNotFoundException e) {
                throw new InstantiationException("Error loading method parameter '" + this.getResourceType() + "' due to ClassNotFoundException");
            }
            Method method = ClassUtils.getInjectableMethod((Class)var2_2, setterMethod, resourceClass);
            if (method != null) {
                this.injectTarget = new InjectionMethod(method);
            } else {
                try {
                    Field field = ClassUtils.getField((Class)var2_2, this.getTargetName(), this.getResourceType());
                    if (field != null) {
                        this.injectTarget = new InjectionField(field);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw (InstantiationException)new InstantiationException("Error loading java.lang.reflect.Field[name=" + this.getTargetName() + ", type=" + this.getResourceType() + " from " + var2_2.getName()).initCause(e);
                }
            }
            if (this.injectTarget == null) {
                throw new InstantiationException("Injection target error: setter method '" + setterMethod + "' or field '" + this.getTargetName() + "' of type '" + this.getResourceType() + "' is not found from class '" + var2_2.getName() + "'");
            }
        }

        public void inject(Object target, Object value) throws Exception {
            this.injectTarget.inject(target, value);
        }
    }
}

