/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.File;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public abstract class Module
implements XMLizable {
    protected String path = null;
    protected String alternativeDescriptor = null;
    protected String name = null;

    protected Module(String path) {
        this.path = path;
    }

    protected Module(String path, String name) {
        this.path = path;
        this.name = name;
    }

    protected Module(Node parent) {
        this.alternativeDescriptor = XMLUtils.getSubnodeValue(parent, "alt-dd");
    }

    public String getAltDD() {
        return this.alternativeDescriptor;
    }

    public void setAltDD(String path) {
        this.alternativeDescriptor = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getPath();
            if (this.name.endsWith(".war") || this.name.endsWith(".jar") || this.name.endsWith(".rar")) {
                this.name = this.name.substring(0, this.name.lastIndexOf("."));
            }
        }
        return this.name;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Module)) {
            return false;
        }
        return this.path.equals(((Module)other).path);
    }

    public int hashCode() {
        if (this.path == null) {
            return -1;
        }
        return this.path.hashCode();
    }

    public abstract void writeOrionXML(PrintWriter var1, String var2);

    protected String checkPath(String givenPath) {
        if (givenPath == null) {
            return givenPath;
        }
        String returnedPath = givenPath;
        return returnedPath.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }
}

