/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.net.AccessRegionSet;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityRole
extends AbstractDescribable
implements XMLizable,
Serializable {
    protected List users;
    protected List groups;
    protected boolean impliesAll;
    protected AccessRegionSet accessRegion;

    public SecurityRole(String name) {
        if (name == null) {
            throw new InternalError("name was null");
        }
        this.setName(name);
    }

    public SecurityRole(String name, boolean impliesAll) {
        this.setName(name);
        this.setImpliesAll(impliesAll);
    }

    public SecurityRole(Node parent) throws InstantiationException {
        this.readNode(parent);
    }

    public void readNode(Node parent) throws InstantiationException {
        if (parent.getNodeName().equals("security-role-mapping")) {
            this.parseOrionXML(parent);
        } else {
            NodeList nodes = parent.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                if (name.startsWith("#")) continue;
                String value = XMLUtils.getStringValue(node);
                if (name.equals("description")) {
                    this.setDescription(value);
                    continue;
                }
                if (name.equals("role-name")) {
                    this.setName(value);
                    continue;
                }
                throw new InstantiationException("Unknown " + parent.getNodeName() + " subtag: " + name);
            }
        }
        if (this.getName() == null) {
            throw new InstantiationException("No role-name specified in security-role tag");
        }
    }

    public void parseOrionXML(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        this.impliesAll = "true".equalsIgnoreCase(XMLUtils.getNodeAttribute(parent, "impliesAll"));
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.startsWith("#")) continue;
            if (name.equals("group")) {
                String groupName = XMLUtils.getNodeAttribute(node, "name");
                if (groupName == null) continue;
                this.addGroup(groupName);
                continue;
            }
            if (name.equals("user")) {
                String userName = XMLUtils.getNodeAttribute(node, "name");
                if (name == null) continue;
                this.addUser(userName);
                continue;
            }
            if (name.equals("access-mask")) {
                this.accessRegion = AccessRegionSet.getSet(node);
                continue;
            }
            throw new InstantiationException("Unknown security-role-mapping tag: " + name);
        }
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<security-role>");
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.getName() != null) {
            out.println(indention + "\t<role-name>" + XMLUtils.encode(this.getName()) + "</role-name>");
        }
        out.println(indention + "</security-role>");
    }

    protected void writeRoles(PrintWriter out, String indention) {
        List groups = this.getGroups();
        for (int i = 0; i < groups.size(); ++i) {
            out.println(indention + "<group name=\"" + XMLUtils.encode((String)groups.get(i)) + "\" />");
        }
        List users = this.getUsers();
        for (int i = 0; i < users.size(); ++i) {
            out.println(indention + "<user name=\"" + XMLUtils.encode((String)users.get(i)) + "\" />");
        }
    }

    public void writeOrionXML(PrintWriter out, String indention) throws IOException {
        out.print(indention + "<security-role-mapping");
        if (this.getName() != null) {
            out.print(" name=\"" + XMLUtils.encode(this.getName()) + "\"");
        }
        if (this.impliesAll) {
            out.println(" impliesAll=\"true\" />");
        } else {
            out.println(">");
            this.writeRoles(out, indention + "\t");
            if (this.accessRegion != null) {
                this.accessRegion.writeXML(out, indention + "\t");
            }
            out.println(indention + "</security-role-mapping>");
        }
    }

    public List getUsers() {
        if (this.users == null) {
            return Collections.EMPTY_LIST;
        }
        return this.users;
    }

    public List getGroups() {
        if (this.groups == null) {
            return Collections.EMPTY_LIST;
        }
        return this.groups;
    }

    public void addGroup(String name) {
        if (name == null) {
            throw new NullPointerException("Null group name");
        }
        if (this.groups == null) {
            this.groups = new ArrayList();
        } else if (this.groups.contains(name)) {
            return;
        }
        this.groups.add(name);
    }

    public void addUser(String name) {
        if (this.users == null) {
            this.users = new ArrayList();
        } else if (this.users.contains(name)) {
            return;
        }
        this.users.add(name);
    }

    public void setUsers(Collection users) {
        this.users = new ArrayList(users);
    }

    public void setGroups(Collection groups) {
        this.groups = new ArrayList(groups);
    }

    public boolean impliesAll() {
        return this.impliesAll;
    }

    public void setImpliesAll(boolean impliesAll) {
        this.impliesAll = impliesAll;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("security-role: ");
        buf.append("\n");
        buf.append("  description: ");
        buf.append(this.getDescription());
        buf.append("\n");
        buf.append("  role-name: ");
        buf.append(this.getName());
        buf.append("\n");
        return buf.toString();
    }

    public AccessRegionSet getAccessMask() {
        return this.accessRegion;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof SecurityRole && this.getName().equals(((SecurityRole)other).getName());
    }
}

