/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.security.BasicUser;
import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.RoleUser;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.AbstractEJBObject;
import com.evermind.server.ejb.EJBTransactionManager;
import com.evermind.server.ejb.EntityEJBHome;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.ExposableBeanDescriptor;
import com.evermind.server.ejb.logging.EJBRuntimeMessages;
import java.security.Identity;
import java.security.Principal;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.ejb.EJBContext;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.TimerService;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import oracle.ias.container.timer.EJBTimerServiceImpl;
import oracle.oc4j.security.SecurityUtil;

public class AbstractEJBContext
implements EJBContext {
    public byte actionTaken = 1;
    public AbstractEJBObject remoteWrapper;
    public AbstractEJBHome remoteHome;
    public AbstractEJBObject localWrapper;
    public AbstractEJBHome localHome;
    protected TimerService timersvc = null;
    long poolTime;
    public boolean canBeReleased = true;
    private Object[] userInterceptorInstances = null;

    public BeanDescriptor getBeanDescriptor() {
        return this.getHome().getBeanDescriptor();
    }

    public EJBObject getEJBObject() {
        if (this.remoteWrapper == null && this.remoteHome != null || this.localWrapper == null && this.localHome != null) {
            throw new IllegalStateException("getEJBObject not allowed or not successful [1]");
        }
        if (this.actionTaken == 4 && (this.remoteHome != null || this.localHome != null)) {
            throw new IllegalStateException("getEJBObject cannot be called from setXXXContext");
        }
        if (this.remoteWrapper != null) {
            return (EJBObject)this.remoteWrapper;
        }
        this.localHome.getTheOtherLRWrappers(this);
        if (this.remoteWrapper == null) {
            throw new IllegalStateException("getEJBObject not allowed or not successful [2]");
        }
        return (EJBObject)this.remoteWrapper;
    }

    public void resetFields() {
        this.remoteWrapper = null;
        this.remoteHome = null;
        this.localWrapper = null;
        this.localHome = null;
        this.timersvc = null;
    }

    public EJBLocalObject getEJBLocalObject() {
        if (this.remoteWrapper == null && this.remoteHome != null || this.localWrapper == null && this.localHome != null) {
            throw new IllegalStateException("getEJBLocalObject not allowed or not successful [1] remoteWrapper " + this.remoteWrapper + " remoteHome " + this.remoteHome + " localWrapper " + this.localWrapper + " localHome " + this.localHome);
        }
        if (this.actionTaken == 4 && (this.remoteHome != null || this.localHome != null)) {
            throw new IllegalStateException("getEJBLocalObject cannot be called from setXXXContext");
        }
        if (this.localWrapper != null) {
            return (EJBLocalObject)this.localWrapper;
        }
        this.remoteHome.getTheOtherLRWrappers(this);
        if (this.localWrapper == null) {
            throw new IllegalStateException("getEJBLocalObject not allowed or not successful [2]");
        }
        return (EJBLocalObject)this.localWrapper;
    }

    public EJBHome getEJBHome() {
        if (this.remoteHome != null) {
            return (EJBHome)this.remoteHome;
        }
        this.localHome.getTheOtherLRWrappers(this);
        return (EJBHome)this.remoteHome;
    }

    public EJBLocalHome getEJBLocalHome() {
        if (this.localHome != null) {
            return (EJBLocalHome)this.localHome;
        }
        this.remoteHome.getTheOtherLRWrappers(this);
        return (EJBLocalHome)this.localHome;
    }

    public AbstractEJBHome getHome() {
        if (this.localHome != null) {
            return this.localHome;
        }
        if (this.remoteHome != null) {
            return this.remoteHome;
        }
        return null;
    }

    public Identity getCallerIdentity() {
        return new Identity(this.getCallerPrincipal().getName()){};
    }

    protected Application getApplication() {
        return this.getEvermindHome().getApplication();
    }

    public Principal getCallerPrincipal() {
        if (this.actionTaken == 4) {
            throw new IllegalStateException("Cannot call getCallerPrincipal() from within the setContext() method");
        }
        ThreadState state = ThreadState.getCurrentState();
        BasicUser user = state.getUser();
        if (user != null && user instanceof RoleUser) {
            if (state.shieldedUser) {
                user = ((RoleUser)user).getShieldedUser();
            } else {
                List usrList = ((RoleUser)user).getRole().getUsers();
                if (usrList != null && !usrList.isEmpty()) {
                    String usr1 = (String)usrList.get(0);
                    user = this.getApplication().getUserManager().getUser(usr1);
                }
                if (user == null) {
                    throw new IllegalStateException("Logical Security Role not mapped to physical users");
                }
            }
        }
        if (user == null) {
            user = ApplicationServer.getInstance().getAnonymousUser();
        }
        return SecurityUtil.shield(user);
    }

    public boolean isCallerInRole(Identity identity) {
        if (this.actionTaken == 4) {
            throw new IllegalStateException("Cannot call isCallerInRole() from within the set" + (this.getEvermindHome() instanceof EntityEJBHome ? "Entity" : "Session") + "Context(...) method");
        }
        return this.getEvermindHome().isCallerInRole(identity.getName(), null);
    }

    public boolean isCallerInRole(String role) {
        if (this.actionTaken == 4) {
            throw new IllegalStateException("Cannot call isCallerInRole() from within the set" + (this.getEvermindHome() instanceof EntityEJBHome ? "Entity" : "Session") + "Context(...) method");
        }
        return this.getEvermindHome().isCallerInRole(role, null);
    }

    public UserTransaction getUserTransaction() {
        AbstractEJBHome h;
        AbstractEJBHome abstractEJBHome = h = this.remoteHome != null ? this.remoteHome : this.localHome;
        if (h.containerManagedTransactions) {
            throw new IllegalStateException("Only beans with user-managed transactions can invoke getUserTransaction()");
        }
        if (this.actionTaken == 4) {
            throw new IllegalStateException("getUserTransaction() cannot be invoked from setSessionContext()");
        }
        return (UserTransaction)ApplicationServer.getInstance().getTransactionManager();
    }

    public boolean getRollbackOnly() {
        if (this.actionTaken == 4) {
            throw new IllegalStateException("cannot invoke getRollbackOnly within setEntityContext");
        }
        if (!this.getEvermindHome().containerManagedTransactions) {
            throw new IllegalStateException("Cannot call getRollbackOnly() when bean-managed transactions are specified");
        }
        Transaction transaction = null;
        try {
            transaction = ApplicationServer.getInstance().getTransactionManager().getTransaction();
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        if (transaction == null) {
            throw new IllegalStateException("Cannot call getRollbackOnly() when current thread is NOT associated with a transaction");
        }
        try {
            int status = transaction.getStatus();
            boolean aResult = status == 1 || status == 4 || status == 9;
            return aResult;
        }
        catch (SystemException e) {
            return true;
        }
    }

    public void setRollbackOnly() {
        if (!this.getEvermindHome().containerManagedTransactions) {
            throw new IllegalStateException("Cannot call setRollbackOnly() when bean-managed transactions are specified");
        }
        EJBTransactionManager.getInstance().setContainerRollbackOnly();
    }

    public Properties getEnvironment() {
        return new Properties();
    }

    public final boolean hasTimerService() {
        return this.timersvc != null;
    }

    public TimerService getTimerService() {
        if (this.getBeanDescriptor().isStateful()) {
            throw new RuntimeException("getTimerService() call is not allowed in stateful session bean");
        }
        if (this.actionTaken == 4) {
            throw new IllegalStateException("Cannot call getTimerService() from within the set" + (this.getEvermindHome() instanceof EntityEJBHome ? "Entity" : "Session") + "Context() method");
        }
        return this.getInternalTimerService();
    }

    protected TimerService getInternalTimerService() {
        if (this.timersvc == null) {
            this.timersvc = EJBTimerServiceImpl.create(this);
        }
        return this.timersvc;
    }

    public AbstractEJBHome getEvermindHome() {
        try {
            return (AbstractEJBHome)this.getEJBHome();
        }
        catch (Exception e) {
            return (AbstractEJBHome)this.getEJBLocalHome();
        }
    }

    public void setActionTaken(byte _actionTaken) {
        this.actionTaken = _actionTaken;
    }

    public byte getActionTaken() {
        return this.actionTaken;
    }

    public Object lookup(String name) {
        try {
            InitialContext ctx = new InitialContext();
            return ctx.lookup("java:comp/env/" + name);
        }
        catch (NamingException e) {
            EJBRuntimeMessages.fineNamingException(this.getHome().getBeanDescriptor(), name, e);
            return null;
        }
    }

    protected boolean isEJB30Compatible() {
        return this.getHome().getBeanDescriptor().getPackage().getCompatibility() >= 3;
    }

    protected Object getBeanInstanceByBusinessInterface(Class businessInterface) throws IllegalStateException {
        Set localIntfNames = ((ExposableBeanDescriptor)this.getBeanDescriptor()).getLocalInterfaceNames();
        Set remoteIntfNames = ((ExposableBeanDescriptor)this.getBeanDescriptor()).getRemoteInterfaceNames();
        if (localIntfNames.contains(businessInterface.getName())) {
            return this.getEJBLocalObject();
        }
        if (remoteIntfNames.contains(businessInterface.getName())) {
            return this.getEJBObject();
        }
        throw new IllegalStateException(this.getHome().getBeanDescriptor().getContextId() + " - The requested class: " + businessInterface.getName() + " is not one of the bean's business interfaces.");
    }

    protected Class getSessionBusinessInterfaceClass() throws IllegalStateException {
        throw new UnsupportedOperationException("The method getSessionBusinessInterfaceClass() is currently unsupported.");
    }

    public Object[] getUserInterceptorInstances() {
        return this.userInterceptorInstances;
    }

    public void setUserInterceptorInstances(Object[] interceptors) {
        this.userInterceptorInstances = interceptors;
    }
}

