/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ejb.deployment.EJBReference;
import com.oracle.naming.LookupFactory;
import java.util.Hashtable;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBObject;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;

public class BeanBinding
implements ObjectFactory {
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        Object bean;
        Reference ref = (Reference)obj;
        RefAddr location = ref.get("location");
        if (location == null) {
            throw new NamingException("No location found in reference " + ref);
        }
        Reference beanRef = LookupFactory.createBinding(EJBObject.class, (String)location.getContent());
        RefAddr remote = ref.get("remote-server-ref");
        if (remote != null && "true".equalsIgnoreCase((String)remote.getContent())) {
            beanRef.add(ref.get("remote-server-ref"));
            beanRef.add(ref.get("jndi-properties-file"));
        }
        if ((bean = NamingManager.getObjectInstance(beanRef, name, nameCtx, environment)) instanceof EJBHome || bean instanceof EJBLocalHome) {
            return bean.getClass().getMethod("create", null).invoke(bean, null);
        }
        return bean;
    }

    public static Reference createBinding(String location, EJBReference ejbReference) {
        Reference ref = new Reference(EJBObject.class.getName(), new StringRefAddr("location", location), BeanBinding.class.getName(), null);
        ref.add(new StringRefAddr("CachePolicy", "NEVER"));
        if (ejbReference != null && ejbReference.isRemoteServerRef()) {
            ref.add(new StringRefAddr("remote-server-ref", "true"));
            ref.add(new StringRefAddr("jndi-properties-file", ejbReference.getJndiPropertiesFile()));
        }
        return ref;
    }

    public static Reference createHomeBinding(Class type, String location, EJBReference ejbReference) {
        Reference ref = LookupFactory.createBinding(type, location);
        if (ejbReference != null && ejbReference.isRemoteServerRef()) {
            ref.add(new StringRefAddr("remote-server-ref", "true"));
            ref.add(new StringRefAddr("jndi-properties-file", ejbReference.getJndiPropertiesFile()));
        }
        return ref;
    }
}

