/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.EJBTransactionManager;
import com.evermind.server.ejb.InvocationContextPool;
import com.evermind.server.ejb.MessageDrivenContextImpl;
import com.evermind.server.ejb.MessageDrivenHome;
import com.evermind.server.ejb.deployment.MessageDrivenBeanDescriptor;
import com.evermind.server.ejb.logging.EJBRuntimeMessages;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.server.ejb.logging.EJBTransactionMessages;
import com.evermind.util.ServerProperties;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.jms.XATopicSession;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import oracle.j2ee.ra.jms.generic.api.NoEnlistmentXAResource;

public class MessageDrivenConsumer
implements Runnable {
    private static Logger m_logger = EJBTraceLogger.getLogger(MessageDrivenConsumer.class);
    private static final long DEFAULT_ORACLEAS_JMS_POLL_INTERVAL = 1000L;
    private static final long DEFAULT_OJMS_POLL_INTERVAL = 0L;
    private static final int QUEUE = 0;
    private static final int TOPIC = 1;
    private static final int UNIFIED = 2;
    private MessageDrivenHome home;
    private MessageDrivenBeanDescriptor descriptor;
    private EJBContainer container;
    private boolean transacted;
    private boolean finished;
    private boolean activeMessage;
    private final Object activeMessageLock = new Object();
    private long pollInterval;
    private int transactionTimeout;
    private int maxRetry;
    private Connection connection;
    private Session session;
    private MessageConsumer consumer;
    private XAResource xaResource;
    private int destinationType;
    private boolean isOracleASJMS;
    private boolean isOJMS;

    public MessageDrivenConsumer(MessageDrivenHome home) {
        this.home = home;
        this.container = home.container;
        this.descriptor = home.descriptor;
        this.isOracleASJMS = home.in_memory_jms;
        this.transacted = home.startsTransaction();
        this.transactionTimeout = this.descriptor.getTransactionTimeout();
        this.maxRetry = this.descriptor.getMaxDeliveryCount();
        this.pollInterval = this.isOracleASJMS ? 1000L : (long)(ServerProperties.getOracleMDBFastUndeploy() * 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFinished() {
        this.traceLog("setFinished(): Stopping message consumer thread");
        MessageDrivenConsumer messageDrivenConsumer = this;
        synchronized (messageDrivenConsumer) {
            this.finished = true;
        }
        if (this.isOJMS && this.pollInterval == 0L) {
            this.waitForMessage();
            this.markClosedForOJMS(this.session);
        }
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMessageFlag() {
        Object object = this.activeMessageLock;
        synchronized (object) {
            this.activeMessage = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearMessageFlag() {
        Object object = this.activeMessageLock;
        synchronized (object) {
            this.activeMessage = false;
            this.activeMessageLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForMessage() {
        Object object = this.activeMessageLock;
        synchronized (object) {
            if (this.activeMessage) {
                try {
                    this.activeMessageLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.traceLog("run(): begin message consumer thread");
        try {
            this.home.notifyListenerStart();
            this.home.waitForApplicationStartup();
            this.checkServerInitialized();
            this.home.checkRunningState();
            try {
                ThreadState state = null;
                try {
                    state = ThreadState.getCurrentState();
                    state.contextContainer = this.home;
                    this.processMessages(state);
                }
                finally {
                    if (state != null) {
                        state.reset();
                    }
                }
            }
            finally {
                this.destroyJMSResources();
            }
        }
        finally {
            this.home.notifyListenerStop();
        }
        this.traceLog("run(): end message consumer thread");
    }

    /*
     * Exception decompiling
     */
    public void processMessages(ThreadState state) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean beforeDelivery() {
        if (this.transacted) {
            try {
                EJBTransactionManager.getInstance().beginLocal(this.transactionTimeout);
                if (m_logger.isLoggable(Level.FINE)) {
                    this.traceLog("beforeDelivery(): begin transaction: " + EJBTransactionManager.getTransaction());
                }
                if (this.xaResource != null && !(this.xaResource instanceof NoEnlistmentXAResource)) {
                    EJBTransactionManager.getTransaction().enlistResource(this.xaResource);
                }
            }
            catch (Exception e) {
                m_logger.log(Level.WARNING, "Error beginning transaction", e);
                return false;
            }
            return true;
        }
        return false;
    }

    private void afterDelivery(boolean txCreated) {
        block8: {
            if (txCreated) {
                try {
                    Transaction tx = EJBTransactionManager.getTransaction();
                    if (tx.getStatus() == 1) {
                        tx.rollback();
                        break block8;
                    }
                    EJBTransactionManager.getInstance().end(true);
                }
                catch (Exception e) {
                    if (this.activeMessage) {
                        EJBTransactionMessages.warningTxEndError(this.descriptor.getName(), e);
                    }
                    break block8;
                }
            }
            Transaction tx = EJBTransactionManager.getTransaction();
            if (tx != null) {
                EJBTransactionMessages.severeUncommittedBeanManagedTransaction(this.descriptor, tx.toString());
                try {
                    tx.rollback();
                }
                catch (Exception e) {
                    EJBTransactionMessages.warningTxEndError(this.descriptor.getName(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ThreadState state, Message message) throws Exception {
        this.traceLog("onMessage(): begin");
        long deliveryPhaseEvent = 0L;
        try {
            deliveryPhaseEvent = this.home.messageDeliveryStarted();
            MessageDrivenContextImpl mdContext = null;
            try {
                block9: {
                    mdContext = this.home.getContextInstance();
                    try {
                        InvocationContextPool.invoke(state, this.home.getOnMessageMethodState(), mdContext.getBean(), mdContext, new Object[]{message}, null, null);
                    }
                    catch (Exception e) {
                        EJBRuntimeMessages.warningOnListenerMethodException(this.descriptor, e, "onMessage");
                        this.home.getContainer().getApplication().log("Error in executing MessageDrivenBean::onMessage method " + this.home.descriptor.getName() + ": " + e, e);
                        mdContext.setToBeDiscarded(true);
                        if (!this.transacted) break block9;
                        EJBTransactionManager.getInstance().setContainerRollbackOnly();
                    }
                }
                Object var8_6 = null;
                if (mdContext != null) {
                    this.home.releaseContextInstance(mdContext);
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (mdContext != null) {
                    this.home.releaseContextInstance(mdContext);
                }
                throw throwable;
            }
        }
        finally {
            this.home.messageDeliveryEnded(deliveryPhaseEvent);
        }
        this.traceLog("onMessage(): end");
    }

    private void logException(Exception exc) {
        JMSException jmsexc;
        Exception linkedException;
        if (this.isFinished()) {
            EJBRuntimeMessages.fineJMSProviderExceptionDuringShutdown(this.descriptor, exc);
            return;
        }
        this.traceLog("provider exception: (destroy=" + this.home.destroyed + ", in_memory_jms=" + this.isOracleASJMS + "): " + exc.getMessage(), exc);
        if (exc instanceof JMSException && (linkedException = (jmsexc = (JMSException)((Object)exc)).getLinkedException()) != null) {
            this.traceLog("provider exception: JMSException linked exception", jmsexc.getLinkedException());
            if (!this.isOracleASJMS && linkedException instanceof SQLException) {
                SQLException sql_ex = (SQLException)jmsexc.getLinkedException();
                this.traceLog("provider exception: SQL error code " + sql_ex.getErrorCode());
            }
        }
        this.home.updateFailureDMSCount();
        EJBRuntimeMessages.warningJMSProviderException(this.descriptor, exc);
        this.container.getApplication().log("Error in MessageDrivenBean '" + this.descriptor.getName() + "': " + exc, exc);
    }

    private Message receiveMessage() throws JMSException {
        long startTime = System.currentTimeMillis();
        Message message = null;
        if (this.pollInterval > 0L) {
            while (!(this.isFinished() || (message = this.consumer.receive(this.pollInterval)) != null || this.transacted && System.currentTimeMillis() - startTime > (long)(this.transactionTimeout * 1000))) {
            }
        } else {
            this.traceLog("receiveMessage(): blocking receive");
            message = this.consumer.receive();
        }
        return message;
    }

    private boolean exceedsMaxDeliveryCount(Message msg) {
        if (this.maxRetry <= 0) {
            return false;
        }
        try {
            return msg.getIntProperty("JMSXDeliveryCount") > this.maxRetry;
        }
        catch (JMSException e) {
            return false;
        }
    }

    private void checkServerInitialized() {
        ApplicationServer server = ApplicationServer.getInstance();
        if (server.isInitialized()) {
            return;
        }
        this.traceLog("checkServerInitialized(): waiting for server to initialize");
        while (!server.isInitialized()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        this.traceLog("checkServerInitialized(): server initialized");
    }

    private void initializeJMSResources() throws JMSException {
        ConnectionFactory factory = this.home.getConnectionFactory();
        if (this.transacted) {
            if (factory instanceof XAQueueConnectionFactory || factory instanceof XATopicConnectionFactory || factory instanceof XAConnectionFactory) {
                this.createXAResources(factory);
            } else {
                this.createNonXAResources(factory);
            }
        } else {
            this.createNonXAResources(factory);
        }
        if (this.session.getClass().getName().equals("oracle.jms.AQjmsSession") || this.session.getClass().getName().equals("oracle.jms.AQjmsXASession")) {
            this.isOJMS = true;
        }
        if (this.isOJMS && this.pollInterval == 0L) {
            int closeTimeout = ServerProperties.getOracleMDBFastUndeploy();
            this.setCloseCheckIntervalForOJMS(this.session, closeTimeout);
        }
        this.createMessageConsumer();
        if (this.isOJMS) {
            try {
                java.sql.Connection conn = this.getDBConnectionForOJMS(this.session);
                if (!conn.getAutoCommit()) {
                    conn.commit();
                }
            }
            catch (SQLException e) {
                EJBRuntimeMessages.warningJMSProviderException(this.descriptor, e);
            }
        }
    }

    private void createXAResources(ConnectionFactory factory) throws JMSException {
        if (factory instanceof XAQueueConnectionFactory) {
            this.connection = this.descriptor.getResUser() != null ? ((XAQueueConnectionFactory)factory).createXAQueueConnection(this.descriptor.getResUser(), this.descriptor.getResPassword()) : ((XAQueueConnectionFactory)factory).createXAQueueConnection();
            XAQueueSession xaSession = ((XAQueueConnection)this.connection).createXAQueueSession();
            this.session = xaSession.getQueueSession();
            this.xaResource = xaSession.getXAResource();
            this.destinationType = 0;
        } else if (factory instanceof XATopicConnectionFactory) {
            this.connection = this.descriptor.getResUser() != null ? ((XATopicConnectionFactory)factory).createXATopicConnection(this.descriptor.getResUser(), this.descriptor.getResPassword()) : ((XATopicConnectionFactory)factory).createXATopicConnection();
            XATopicSession xaSession = ((XATopicConnection)this.connection).createXATopicSession();
            this.session = xaSession.getTopicSession();
            this.xaResource = xaSession.getXAResource();
            this.destinationType = 1;
        } else {
            this.connection = this.descriptor.getResUser() != null ? ((XAConnectionFactory)factory).createXAConnection(this.descriptor.getResUser(), this.descriptor.getResPassword()) : ((XAConnectionFactory)factory).createXAConnection();
            XASession xaSession = ((XAConnection)this.connection).createXASession();
            this.session = xaSession.getSession();
            this.xaResource = xaSession.getXAResource();
            this.destinationType = 2;
        }
    }

    private void createNonXAResources(ConnectionFactory factory) throws JMSException {
        if (factory instanceof QueueConnectionFactory) {
            this.connection = this.descriptor.getResUser() != null ? ((QueueConnectionFactory)factory).createQueueConnection(this.descriptor.getResUser(), this.descriptor.getResPassword()) : ((QueueConnectionFactory)factory).createQueueConnection();
            this.session = ((QueueConnection)this.connection).createQueueSession(this.transacted, this.descriptor.getAcknowledgeMode());
            this.destinationType = 0;
        } else if (factory instanceof TopicConnectionFactory) {
            this.connection = this.descriptor.getResUser() != null ? ((TopicConnectionFactory)factory).createTopicConnection(this.descriptor.getResUser(), this.descriptor.getResPassword()) : ((TopicConnectionFactory)factory).createTopicConnection();
            this.session = ((TopicConnection)this.connection).createTopicSession(this.transacted, this.descriptor.getAcknowledgeMode());
            this.destinationType = 1;
        } else {
            this.connection = this.descriptor.getResUser() != null ? factory.createConnection(this.descriptor.getResUser(), this.descriptor.getResPassword()) : factory.createConnection();
            this.session = this.connection.createSession(false, this.descriptor.getAcknowledgeMode());
            this.destinationType = 2;
        }
    }

    private void createMessageConsumer() throws JMSException {
        Destination destination = this.home.getDestination();
        this.consumer = this.destinationType == 0 ? ((QueueSession)this.session).createReceiver((Queue)destination, this.descriptor.getMessageSelector()) : (this.descriptor.isDurable() ? ((TopicSession)this.session).createDurableSubscriber((Topic)destination, this.descriptor.getSubscriptionName(), this.descriptor.getMessageSelector(), false) : (this.destinationType == 1 ? ((TopicSession)this.session).createSubscriber((Topic)destination, this.descriptor.getMessageSelector(), false) : this.session.createConsumer(destination, this.descriptor.getMessageSelector())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyJMSResources() {
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (JMSException e) {
                EJBRuntimeMessages.warningJMSProviderException(this.descriptor, (Exception)((Object)e));
            }
            finally {
                this.consumer = null;
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                EJBRuntimeMessages.warningJMSProviderException(this.descriptor, (Exception)((Object)e));
            }
            finally {
                this.session = null;
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                EJBRuntimeMessages.warningJMSProviderException(this.descriptor, (Exception)((Object)e));
            }
            finally {
                this.connection = null;
            }
        }
    }

    private void traceLog(String message) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "[" + this.descriptor.getName() + ", " + ThreadState.getCurrentState().toString() + "] - " + message);
        }
    }

    private void traceLog(String message, Exception e) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "[" + this.descriptor.getName() + ", " + ThreadState.getCurrentState().toString() + "] - " + message, e);
        }
    }

    private void setCloseCheckIntervalForOJMS(Object ojmsSession, int closeTimeout) throws JMSException {
        try {
            Class<?> classAQjmsSession = ojmsSession.getClass();
            Method methodSetCloseCheckInterval = classAQjmsSession.getMethod("setCloseCheckInterval", Integer.TYPE);
            methodSetCloseCheckInterval.invoke(ojmsSession, new Integer(closeTimeout));
        }
        catch (Throwable t) {
            JMSException jmse = new JMSException("Error to setCloseCheckInterval for OJMS");
            jmse.initCause(t);
            throw jmse;
        }
    }

    private java.sql.Connection getDBConnectionForOJMS(Object ojmsSession) throws JMSException {
        try {
            Class<?> classAQjmsSession = ojmsSession.getClass();
            Method methodGetDBConnection = classAQjmsSession.getMethod("getDBConnection", new Class[0]);
            return (java.sql.Connection)methodGetDBConnection.invoke(ojmsSession, new Object[0]);
        }
        catch (Throwable t) {
            JMSException jmse = new JMSException("Error to getDBConnection for OJMS");
            jmse.initCause(t);
            throw jmse;
        }
    }

    private void markClosedForOJMS(Object ojmsSession) {
        try {
            Class<?> classAQjmsSession = ojmsSession.getClass();
            Method methodMarkClosed = classAQjmsSession.getMethod("markClosed", new Class[0]);
            methodMarkClosed.invoke(ojmsSession, new Object[0]);
        }
        catch (Exception e) {
            this.traceLog("Error to markClosed for OJMS");
            this.logException(e);
        }
    }
}

