/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.ContextContainer;
import com.evermind.server.ThreadState;
import com.evermind.server.administration.ApplicationResourceFinder;
import com.evermind.server.deployment.ClassUtils;
import com.evermind.server.ejb.BeanPool;
import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.EJBTransactionManager;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.InvocationContextPool;
import com.evermind.server.ejb.MessageDrivenConsumer;
import com.evermind.server.ejb.MessageDrivenContextImpl;
import com.evermind.server.ejb.MessageInflowArtifact;
import com.evermind.server.ejb.MessageInflowArtifactImpl;
import com.evermind.server.ejb.MessageInflowContract;
import com.evermind.server.ejb.deployment.EJBJ2EEContextDescriptor;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.MessageDrivenBeanDescriptor;
import com.evermind.server.ejb.interceptor.MethodState;
import com.evermind.server.ejb.logging.EJBRuntimeMessages;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.oracle.naming.J2EEContext;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import oracle.dms.instrument.EventIntf;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.dms.instrument.StateIntf;
import oracle.j2ee.connector.ResourceAdapterWrapper;
import oracle.j2ee.connector.messageinflow.MessageEndpointFactoryImpl;

public class MessageDrivenHome
implements ContextContainer,
MessageInflowContract {
    public static final int ACTIVE_DURABLE_SUBS_EXIST = 230;
    private static Logger m_logger = EJBTraceLogger.getLogger(MessageDrivenHome.class);
    private String endpointName;
    protected EJBContainer container;
    protected MessageDrivenBeanDescriptor descriptor;
    private MethodState onMessageMethodState;
    private long startTime;
    private int state;
    private final Object stateLock = new Object();
    private EJBPackage ejbPackage;
    private Destination destination;
    private String connectionFactoryLocation;
    private ConnectionFactory connectionFactory;
    private TransactionManager transactionManager;
    protected boolean startTX;
    protected Context environmentContext;
    protected boolean destroyed = true;
    protected boolean jcaServerDestroyed;
    int maxThreadInstances = 1;
    MessageDrivenConsumer[] listeners;
    int listenerCount = 0;
    boolean in_memory_jms = false;
    ResourceAdapterWrapper ra;
    ActivationSpec aSpec;
    MessageEndpointFactoryImpl endpointFactory;
    int activeHandlers = 0;
    protected NounIntf mdbNoun = null;
    protected PhaseEventIntf m_msgDeliveryCountPhaseEvent;
    protected EventIntf m_sucMsgDeliveryCountEvent;
    protected EventIntf m_failedDeliveryCountEvent;
    protected StateIntf m_startTimeStateEvent;
    static /* synthetic */ Class class$javax$jms$Message;

    public MessageDrivenHome(EJBContainer container, EJBPackage ejbpackage, MessageDrivenBeanDescriptor descriptor) {
        this.container = container;
        this.ejbPackage = ejbpackage;
        this.descriptor = descriptor;
        this.maxThreadInstances = descriptor.getListenerThreads();
        this.setState(3);
    }

    public int getState() {
        return this.state;
    }

    protected void setState(int state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws InstantiationException {
        Object object = this.stateLock;
        synchronized (object) {
            try {
                if (this.getState() == 1) {
                    return;
                }
                this.setState(0);
                this.startTime = 0L;
                this.initialize();
                this.startTime = System.currentTimeMillis();
                this.setState(1);
            }
            catch (InstantiationException e) {
                this.setState(4);
                throw e;
            }
            catch (RuntimeException e) {
                this.setState(4);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.stateLock;
        synchronized (object) {
            try {
                if (this.getState() == 3) {
                    return;
                }
                if (this.getState() == 4) {
                    this.startTime = 0L;
                    this.destroy();
                    return;
                }
                if (this.getState() != 1 && this.getState() != 2) {
                    throw new IllegalStateException("Cannot stop a message driven bean that is not RUNNING");
                }
                this.setState(2);
                this.startTime = 0L;
                this.destroy();
                this.setState(3);
            }
            catch (RuntimeException e) {
                this.setState(4);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.listeners != null) {
            Object object = this.stateLock;
            synchronized (object) {
                this.setState(2);
                for (int i = 0; i < this.listeners.length; ++i) {
                    this.listeners[i].setFinished();
                }
            }
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    protected void initialize() throws InstantiationException {
        ThreadState state = ThreadState.getCurrentState();
        ContextContainer previousContainer = state.contextContainer;
        state.contextContainer = this;
        this.destroyed = false;
        try {
            this.initializeDMSNoun();
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome(): initializeBeanPool");
            }
            this.descriptor.initialize(this);
            this.initializeDMSStartTime();
            if (this.descriptor.getResourceAdapter() == null) {
                boolean bl = this.startTX = this.descriptor.getTransactionType(this.getOnMessageMethodState().getBeanMethod(), false, false) == 1;
                if (this.startTX && this.descriptor.getTransactionType() == 1) {
                    throw new InstantiationException("message-driven bean '" + this.descriptor.getName() + "' declared with bean managed transaction but onMessage method has transaction declaration in the assembly descriptor");
                }
                this.initializeDMSMetrics();
                this.lookupJMSResources();
                this.initializeServerSessionPool();
            } else {
                this.transactionManager = ApplicationServer.getInstance().getTransactionManager();
                this.initializeJCAServer();
            }
        }
        catch (SecurityException e) {
            throw new InstantiationException("Authorization error for " + this.descriptor.getName() + ": " + e.getMessage());
        }
        finally {
            state.contextContainer = previousContainer;
        }
    }

    private void initializeDMSNoun() {
        if (ApplicationServer.DMS_GATE && this.mdbNoun == null) {
            this.mdbNoun = this.createMDBNoun(this.container.application.getName(), this.ejbPackage.getName(), this.descriptor.getName());
        }
    }

    private void initializeDMSMetrics() {
        if (ApplicationServer.DMS_GATE && this.mdbNoun != null) {
            this.m_msgDeliveryCountPhaseEvent = ApplicationServer.phaseEventFactory().create(this.mdbNoun, "messageDelivery", "Message delivery attempts");
            this.m_msgDeliveryCountPhaseEvent.deriveMetric(46);
            this.m_sucMsgDeliveryCountEvent = ApplicationServer.eventFactory().create(this.mdbNoun, "successfulMessageDeliveryCount", "number of successful message deliveries");
            this.m_failedDeliveryCountEvent = ApplicationServer.eventFactory().create(this.mdbNoun, "failedMessageDeliveryCount", "number of failed message deliveries");
        }
    }

    public PhaseEventIntf getMsgDeliveryCountPhaseEvent() {
        if (this.descriptor.getResourceAdapter() != null) {
            if (this.endpointFactory != null) {
                return this.endpointFactory.getMsgDeliveryCountPhaseEvent();
            }
            return null;
        }
        return this.m_msgDeliveryCountPhaseEvent;
    }

    public EventIntf getSucMsgDeliveryCountEvent() {
        return this.m_sucMsgDeliveryCountEvent;
    }

    public EventIntf getFailedDeliveryCountEvent() {
        return this.m_failedDeliveryCountEvent;
    }

    void lookupJMSResources() throws InstantiationException {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome(): lookup-1 destination location=" + this.descriptor.getDestinationLocation());
        }
        try {
            this.destination = (Destination)this.container.getApplication().getContext().lookup(this.descriptor.getDestinationLocation());
        }
        catch (NameNotFoundException e) {
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome(): NameNotFoundException=" + e.getMessage());
                e.printStackTrace();
            }
            throw new InstantiationException("No javax.jms.Destination found at the specified destination-location (" + this.descriptor.getDestinationLocation() + ") for MessageDrivenBean " + this.descriptor.getName());
        }
        catch (NamingException e) {
            throw new InstantiationException("Error looking up javax.jms.Destination at the specified destination-location (" + this.descriptor.getDestinationLocation() + ") for MessageDrivenBean " + this.descriptor.getName() + ": " + e.getMessage());
        }
        catch (ClassCastException e) {
            throw new InstantiationException("Namespace location javax.jms.Destination (" + this.descriptor.getDestinationLocation() + ") for MessageDrivenBean " + this.descriptor.getName() + " did not contain a javax.jms.Destination: " + e.getMessage());
        }
        String factoryLocation = this.descriptor.getConnectionFactoryLocation();
        if (factoryLocation == null) {
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome(): !factoryLocation; construct one");
            }
            factoryLocation = new ApplicationResourceFinder(this.container.application).getLocation("MessageDrivenBean " + this.descriptor.getDisplayName(), this.descriptor.getDestinationType().equals("javax.jms.Queue") ? "javax.jms.QueueConnectionFactory" : "javax.jms.TopicConnectionFactory");
        }
        this.connectionFactoryLocation = factoryLocation;
        ConnectionFactory factory = null;
        try {
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome(): factoryLocation=" + factoryLocation);
            }
            factory = (ConnectionFactory)this.container.getApplication().getContext().lookup(this.connectionFactoryLocation);
        }
        catch (NameNotFoundException e) {
            throw new InstantiationException("No javax.jms.ConnectionFactory found at the specified connection-factory-location (" + factoryLocation + ") for MessageDrivenBean " + this.descriptor.getName());
        }
        catch (NamingException e) {
            throw new InstantiationException("Error looking up javax.jms.ConnectionFactory at the specified destination-location (" + factoryLocation + ") for MessageDrivenBean " + this.descriptor.getName() + ": " + e.getMessage());
        }
        catch (ClassCastException e) {
            throw new InstantiationException("Namespace location javax.jms.ConnectionFactory (" + factoryLocation + ") for MessageDrivenBean " + this.descriptor.getName() + " did not contain a javax.jms.ConnectionFactory: " + e.getMessage());
        }
        if (this.descriptor.getDestinationType() == null) {
            if (this.destination instanceof Topic) {
                this.descriptor.setDestinationType("javax.jms.Topic");
            } else {
                this.descriptor.setDestinationType("javax.jms.Queue");
            }
        }
        if (this.descriptor.getDestinationType().equals("javax.jms.Queue") && !(factory instanceof QueueConnectionFactory)) {
            throw new InstantiationException("Destination and Connection mismatch for MessageDrivenBean " + this.descriptor.getName() + ": they must either both be Topic or both be Queue");
        }
        if (this.descriptor.getDestinationType().equals("javax.jms.Topic") && !(factory instanceof TopicConnectionFactory)) {
            throw new InstantiationException("Destination and Connection mismatch for MessageDrivenBean " + this.descriptor.getName() + ": they must either both be Topic or both be Queue");
        }
        this.connectionFactory = factory;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    private void initializeServerSessionPool() throws InstantiationException {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome(): JMS info::");
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "\n\t|  factoryLocation     =" + this.connectionFactoryLocation + "\n\t|  destinationLocation =" + this.descriptor.getDestinationLocation() + "\n\t|  factoryClassName    =" + this.connectionFactory.getClass().getName() + "\n\t|  destinationClassName=" + this.destination.getClass().getName() + "\n\t|  destinationType     =" + this.descriptor.getDestinationType());
        }
        if (this.connectionFactory.getClass().getName().equals("com.evermind.server.jms.EvermindQueueConnectionFactory") || this.connectionFactory.getClass().getName().equals("com.evermind.server.jms.EvermindXAQueueConnectionFactory") || this.connectionFactory.getClass().getName().equals("com.evermind.server.jms.EvermindTopicConnectionFactory") || this.connectionFactory.getClass().getName().equals("com.evermind.server.jms.EvermindXATopicConnectionFactory") || this.connectionFactory.getClass().getName().equals("com.evermind.server.jms.CMTConnectionFactory") || this.connectionFactory.getClass().getName().equals("com.evermind.server.jms.EvermindConnectionFactory") || this.connectionFactory.getClass().getName().equals("com.evermind.server.jms.EvermindXAConnectionFactory")) {
            this.in_memory_jms = true;
        }
        if (this.descriptor.getDestinationType().equalsIgnoreCase("javax.jms.Topic")) {
            if (this.in_memory_jms || !this.descriptor.isDurable()) {
                this.maxThreadInstances = 1;
            }
            if (this.descriptor.isDurable() && this.descriptor.getSubscriptionName() == null) {
                throw new InstantiationException("MessageDrivenBean '" + this.descriptor.getName() + "' has empty subscription name");
            }
        }
        ApplicationServer appserver = ApplicationServer.getInstance();
        this.listeners = new MessageDrivenConsumer[this.maxThreadInstances];
        for (int kk = 0; kk < this.maxThreadInstances; ++kk) {
            MessageDrivenConsumer listener;
            this.listeners[kk] = listener = new MessageDrivenConsumer(this);
            appserver.getConnectionThreadPool().launch(listener);
        }
    }

    public synchronized void notifyListenerStart() {
        ++this.listenerCount;
    }

    public synchronized void notifyListenerStop() {
        --this.listenerCount;
        if (this.listenerCount == 0) {
            if (this.state == 1) {
                EJBRuntimeMessages.warningAllConsumersFinished(this.descriptor);
                this.stop();
                this.setState(4);
            } else {
                this.notify();
            }
        }
    }

    private void stopListeners() {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].setFinished();
        }
        this.waitForListeners();
    }

    private synchronized void waitForListeners() {
        long waitTime;
        long startTime = System.currentTimeMillis();
        long maxWait = this.descriptor.getCallTimeout();
        while (this.listenerCount > 0 && (waitTime = maxWait - (System.currentTimeMillis() - startTime)) > 0L) {
            try {
                this.wait(waitTime);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        if (this.listenerCount > 0) {
            m_logger.warning("Timeout waiting for listener threads to finish");
        }
    }

    protected void initializeJCAServer() throws InstantiationException {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::initializeJCAServer(): begin");
        }
        String JCARaLocation = null;
        try {
            JCARaLocation = this.descriptor.getResourceAdapter();
            this.ra = this.container.getApplication().lookupResourceAdapter(JCARaLocation);
        }
        catch (NameNotFoundException e) {
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome(): NameNotFoundException=" + e.getMessage());
                e.printStackTrace();
            }
            throw new InstantiationException("No ResourceAdapterWrapper instance found at the specified resource-adapter (" + JCARaLocation + ") for MessageDrivenBean " + this.descriptor.getName());
        }
        catch (NamingException e) {
            throw new InstantiationException("Error looking up ResourceAdapterWrapper at the specified resource-adapter (" + JCARaLocation + ") for MessageDrivenBean " + this.descriptor.getName() + ": " + e.getMessage());
        }
        catch (ClassCastException e) {
            throw new InstantiationException("Namespace location (" + JCARaLocation + ") for MessageDrivenBean " + this.descriptor.getName() + " did not contain a a Resource Adapter Wrapper instance: " + e.getMessage());
        }
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "MessageDrivenHome::initializeJCAServer():  mdb = " + this.descriptor.getName() + " wrapper = " + this.descriptor.getWrapperClassName());
        }
        Class wrapperClass = null;
        try {
            wrapperClass = this.getWrapperClass();
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "MessageDrivenHome::initializeJCAServer(): Successfully load wrapper class = " + wrapperClass);
            }
        }
        catch (InstantiationException e) {
            m_logger.log(Level.INFO, "MessageDrivenHome::initializeJCAServer(): Failed to load wrapper class = " + this.descriptor.getWrapperClassName());
            throw e;
        }
        if (this.ra != null) {
            this.endpointName = this.descriptor.getName() + "/" + this.container.getApplication().getName();
            List configProperties = this.descriptor.getOracleActivationConfigs();
            this.aSpec = this.ra.getActivationSpec(this.descriptor.getMessagingType(), configProperties);
            this.endpointFactory = new MessageEndpointFactoryImpl(wrapperClass, this, this.mdbNoun, this.ra.getRmIdLocation(), this.endpointName);
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Activating endpoint = " + this.endpointName + " with ra = " + JCARaLocation);
                m_logger.log(Level.FINE, "\t\tActivationSpec = " + this.aSpec);
                m_logger.log(Level.FINE, "\t\tMessageEndpointFactory = " + this.endpointFactory);
            }
            try {
                this.ra.endpointActivation(this.endpointFactory, this.aSpec, this.endpointName, this.descriptor.getMessagingType());
            }
            catch (ResourceException e) {
                throw (InstantiationException)new InstantiationException("Resource exception(" + JCARaLocation + ") for MessageDrivenBean " + this.descriptor.getName() + " during endpoint activation: " + e.getMessage()).initCause(e);
            }
        }
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::initializeJCAServer(): end");
        }
        this.jcaServerDestroyed = false;
    }

    void markDestroyedJCAServer() {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::markDestroyedJCAServer(): begin");
        }
        this.endpointFactory.release();
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::markDestroyedJCAServer(): end");
        }
    }

    void destroyJCAServer() {
        if (this.jcaServerDestroyed) {
            return;
        }
        this.jcaServerDestroyed = true;
        this.waitUntilNoActiveHandler("destroyJCAServer()");
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::destroyJCAServer(): begin");
        }
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Deactivating endpoint = " + this.endpointName);
            m_logger.log(Level.FINE, "\t\tActivationSpec = " + this.aSpec);
            m_logger.log(Level.FINE, "\t\tEndpointFactory = " + this.endpointFactory);
        }
        this.ra.endpointDeactivation(this.endpointFactory, this.aSpec, this.endpointName);
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::destroyJCAServer(): end");
        }
    }

    public MessageDrivenContextImpl getContextInstance() {
        return (MessageDrivenContextImpl)this.descriptor.getBeanPool().allocateContext();
    }

    public void releaseContextInstance(MessageDrivenContextImpl context) {
        if (context != null) {
            this.descriptor.getBeanPool().releaseContext(context, context.isToBeDiscarded());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        if (this.destroyed) {
            return;
        }
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::destroy(): begin");
        }
        BeanPool beanPool = this.descriptor.getBeanPool();
        synchronized (beanPool) {
            this.destroyed = true;
        }
        if (this.ra != null) {
            this.markDestroyedJCAServer();
        }
        if (this.listeners != null) {
            this.stopListeners();
        }
        this.waitUntilNoActiveHandler("destroy()");
        this.descriptor.getBeanPool().shutdown();
        this.descriptor.setBeanPool(null);
        if (this.ra != null) {
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::destroy(): JCA");
            }
            this.destroyJCAServer();
        }
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::destroy(): end");
        }
    }

    public EJBContainer getContainer() {
        return this.container;
    }

    public Application getApplication() {
        return this.container.application;
    }

    public ClassLoader getClassLoader() {
        return this.container.getBeansClassLoader();
    }

    protected Class getWrapperClass() throws InstantiationException {
        return this.descriptor.getEndpointWrapper();
    }

    private ClassLoader getWrapperClassLoader() throws InstantiationException {
        return this.ejbPackage.getDeployment().getWrapperClassLoader();
    }

    public Context getEnvironmentContext() throws NamingException {
        try {
            if (this.environmentContext == null) {
                List mailSessions = null;
                if (this.container.getApplication() != null && this.container.getApplication().getConfig() != null) {
                    mailSessions = this.container.getApplication().getConfig().getAllMailSessions();
                }
                this.environmentContext = J2EEContext.create(new EJBJ2EEContextDescriptor(this.descriptor), new ApplicationResourceFinder(this.container.application), this.container.application.getContext(), mailSessions);
                if (this.getEJBPackage().getDeployment().getPersistenceUnitManager() != null) {
                    this.getEJBPackage().getDeployment().getPersistenceUnitManager().bindPersistenceReferences(this.getMessageDrivenBeanDescriptor(), (J2EEContext)this.environmentContext);
                }
            }
            return this.environmentContext;
        }
        catch (InstantiationException e) {
            throw new NamingException("Error instantation environment context for MessageDrivenBean " + this.descriptor.getName() + ": " + e.getMessage());
        }
    }

    public Context getAssemblyContext() {
        return this.descriptor.getPackage().getContext();
    }

    public EJBPackage getEJBPackage() {
        return this.ejbPackage;
    }

    public MessageDrivenBeanDescriptor getMessageDrivenBeanDescriptor() {
        return this.descriptor;
    }

    public boolean startsTransaction() {
        return this.startTX;
    }

    boolean hasStartTX(Method mthd) {
        boolean checkStartTX = false;
        try {
            checkStartTX = this.descriptor.getPackage().getTransactionType(this.descriptor.getName(), mthd, false, false) == 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return checkStartTX;
    }

    public MessageInflowArtifact beforeDelivery(Method mthd, XAResource xares) {
        MessageInflowArtifactImpl contextArtifact;
        block13: {
            this.waitForApplicationStartup();
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::beforeDelivery: begin");
            }
            contextArtifact = new MessageInflowArtifactImpl();
            ThreadState state = ThreadState.getCurrentState();
            contextArtifact.contextContainer = state.contextContainer;
            state.contextContainer = this;
            try {
                if (this.destroyed) {
                    throw new Exception("MDB container is already destroyed");
                }
                if (this.transactionManager.getTransaction() != null) {
                    contextArtifact.setTxnImported(true);
                    if (!this.hasStartTX(mthd)) {
                        contextArtifact.suspend(this.transactionManager);
                    }
                } else if (this.hasStartTX(mthd)) {
                    this.transactionManager.setTransactionTimeout(this.descriptor.getTransactionTimeout());
                    this.transactionManager.begin();
                    if (xares != null) {
                        this.transactionManager.getTransaction().enlistResource(xares);
                    }
                }
            }
            catch (NotSupportedException exc) {
                if (m_logger.isLoggable(Level.FINE)) {
                    m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::beforeDelivery: exc ");
                    exc.printStackTrace();
                }
            }
            catch (Exception exc) {
                if (m_logger.isLoggable(Level.FINE)) {
                    m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::beforeDelivery: exc ");
                    exc.printStackTrace();
                }
                if (this.destroyed) break block13;
                this.container.getApplication().log("Error in MessageDrivenHome:: beforeDelivery:", exc);
            }
        }
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::beforeDelivery: end");
        }
        return contextArtifact;
    }

    public Throwable afterInvocation(MessageInflowArtifact savedArtifact, Method mthd, Throwable t) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::afterInvocation: begin");
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::afterInvocation: deliveryMethod = " + mthd);
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::afterInvocation: Throwable = " + t);
        }
        EJBException e = null;
        if (t != null) {
            EJBRuntimeMessages.warningOnListenerMethodException(this.descriptor, t, mthd.getName());
            Class<?>[] declaredExceptions = mthd.getExceptionTypes();
            for (int i = 0; i < declaredExceptions.length; ++i) {
                if (!t.getClass().isAssignableFrom(declaredExceptions[i])) continue;
                return t;
            }
            MessageInflowArtifactImpl contextArtifact = (MessageInflowArtifactImpl)savedArtifact;
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::afterInvocation: Exception in " + this.descriptor.getName() + " MessageDrivenBean " + t);
            }
            contextArtifact.getMessageDrivenContext().setToBeDiscarded(true);
            if (this.hasStartTX(mthd) || this.descriptor.getTransactionType() == 1) {
                if (m_logger.isLoggable(Level.FINE)) {
                    m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::afterInvocation: mark transaction for rollback");
                }
                Transaction tx = null;
                try {
                    tx = this.transactionManager.getTransaction();
                }
                catch (SystemException ex) {
                    m_logger.log(Level.WARNING, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::run: SystemException while getting transaction " + (Object)((Object)ex));
                }
                if (tx != null) {
                    EJBTransactionManager.getInstance().setContainerRollbackOnly();
                }
            }
            e = t instanceof EJBException ? (EJBException)t : EJBUtils.createEJBException(new Exception(t));
        }
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::afterInvocation: end");
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDelivery(MessageInflowArtifact msgInflowArtifact) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::afterDelivery: begin");
        }
        MessageInflowArtifactImpl contextArtifact = (MessageInflowArtifactImpl)msgInflowArtifact;
        ThreadState state = ThreadState.getCurrentState();
        boolean releaseBean_flag = false;
        ApplicationServer appserver = this.container.getApplication().getServer();
        try {
            block15: {
                try {
                    ApplicationServerTransaction tx = (ApplicationServerTransaction)this.transactionManager.getTransaction();
                    if (contextArtifact.isStatusSuspended()) {
                        contextArtifact.resume(this.transactionManager);
                        break block15;
                    }
                    if (tx == null || contextArtifact.isTxnImported()) break block15;
                    if (tx.getStatus() == 4) {
                        if (m_logger.isLoggable(Level.FINE)) {
                            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::afterDelivery: rollback txn=" + tx);
                        }
                        try {
                            this.transactionManager.rollback();
                        }
                        catch (Throwable thre) {
                            if (m_logger.isLoggable(Level.FINE)) {
                                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::afterDelivery: exc=" + thre.getMessage());
                            }
                            break block15;
                        }
                    }
                    EJBTransactionManager.getInstance().end(true);
                }
                catch (Exception exc) {
                    if (m_logger.isLoggable(Level.FINE)) {
                        m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::afterDelivery: exc ");
                        exc.printStackTrace();
                    }
                    Object var9_10 = null;
                    if (m_logger.isLoggable(Level.FINE)) {
                        m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::afterDelivery: finally-2 Releasing bean instance");
                    }
                    this.releaseContextInstance(contextArtifact.getMessageDrivenContext());
                    state.contextContainer = contextArtifact.contextContainer;
                }
            }
            Object var9_9 = null;
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::afterDelivery: finally-2 Releasing bean instance");
            }
            this.releaseContextInstance(contextArtifact.getMessageDrivenContext());
            state.contextContainer = contextArtifact.contextContainer;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::afterDelivery: finally-2 Releasing bean instance");
            }
            this.releaseContextInstance(contextArtifact.getMessageDrivenContext());
            state.contextContainer = contextArtifact.contextContainer;
            throw throwable;
        }
    }

    public void beforeInvocation(MessageInflowArtifact savedArtifact) {
        this.checkRunningState();
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::beforeInvocation: begin");
        }
        MessageDrivenContextImpl mdContext = null;
        ThreadState state = ThreadState.getCurrentState();
        try {
            if (this.destroyed) {
                throw new JMSException("MDB container is already destroyed");
            }
            mdContext = this.getContextInstance();
        }
        catch (Exception exc) {
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::beforeInvocation: exc ");
                exc.printStackTrace();
            }
            if (!this.destroyed) {
                this.container.getApplication().log("Error in MessageDrivenHome:: beforeInvocation: ", exc);
            }
            Transaction tx = null;
            try {
                tx = this.transactionManager.getTransaction();
            }
            catch (SystemException e) {
                // empty catch block
            }
            if (tx != null) {
                EJBTransactionManager.getInstance().setContainerRollbackOnly();
            }
            if (exc instanceof EJBException) {
                throw (EJBException)((Object)exc);
            }
            throw EJBUtils.createEJBException(exc);
        }
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::beforeInvocation: end");
        }
        savedArtifact.setMessageDrivenContext(mdContext);
    }

    public boolean isDeliveryTransacted(Method method) {
        return this.hasStartTX(method);
    }

    private NounIntf createMDBNoun(String appName, String ejbJarName, String ejbName) {
        NounIntf earNoun = Application.getApplicationNoun(appName);
        NounIntf ejbNoun = ApplicationServer.nounFactory().create(earNoun, "EJBs", "oc4j_ejb");
        NounIntf ejbPkgNoun = ApplicationServer.nounFactory().create(ejbNoun, ejbJarName, "oc4j_ejb_pkg");
        NounIntf bNoun = ApplicationServer.nounFactory().create(ejbPkgNoun, ejbName, "oc4j_ejb_messagedriven_bean");
        return bNoun;
    }

    public long messageDeliveryStarted() {
        if (ApplicationServer.DMS_GATE && this.m_msgDeliveryCountPhaseEvent != null) {
            return this.m_msgDeliveryCountPhaseEvent.start();
        }
        return 0L;
    }

    public void messageDeliveryEnded(long token) {
        if (ApplicationServer.DMS_GATE && this.m_msgDeliveryCountPhaseEvent != null) {
            this.m_msgDeliveryCountPhaseEvent.stop(token);
        }
    }

    public void updateSuccessfulDMSCount() {
        if (ApplicationServer.DMS_GATE && this.m_sucMsgDeliveryCountEvent != null) {
            this.m_sucMsgDeliveryCountEvent.occurred();
        }
    }

    public void updateFailureDMSCount() {
        if (ApplicationServer.DMS_GATE && this.m_failedDeliveryCountEvent != null) {
            this.m_failedDeliveryCountEvent.occurred();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodState getMethodState(Method method) {
        MessageDrivenBeanDescriptor messageDrivenBeanDescriptor = this.descriptor;
        synchronized (messageDrivenBeanDescriptor) {
            MethodState mthState = new MethodState(13, this.descriptor, method).initialize();
            Method listenerMth = ClassUtils.getMethod(this.descriptor.getMessageListener(), method.getName(), method.getParameterTypes());
            if (listenerMth == null) {
                throw new RuntimeException("Message driven bean class " + this.descriptor.getEJBClassName() + " has no matching listener method " + method.toString());
            }
            mthState.setInterfaceMethod(listenerMth);
            return mthState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodState getOnMessageMethodState() {
        if (this.onMessageMethodState == null) {
            MessageDrivenBeanDescriptor messageDrivenBeanDescriptor = this.descriptor;
            synchronized (messageDrivenBeanDescriptor) {
                if (this.onMessageMethodState == null) {
                    Method[] methods = this.descriptor.getEJBClass().getMethods();
                    Method onMessageMethod = null;
                    for (int i = 0; i < methods.length; ++i) {
                        if (!methods[i].getName().equals("onMessage") || methods[i].getParameterTypes().length != 1 || !(class$javax$jms$Message == null ? MessageDrivenHome.class$("javax.jms.Message") : class$javax$jms$Message).isAssignableFrom(methods[i].getParameterTypes()[0])) continue;
                        onMessageMethod = methods[i];
                        break;
                    }
                    if (onMessageMethod == null) {
                        throw EJBUtils.createEJBException("message-driven bean '" + this.descriptor.getName() + "' that is not configured with JCA resource adapter must implements the onMessage method of the javax.jms.MessageListener interface");
                    }
                    try {
                        this.onMessageMethodState = new MethodState(13, this.descriptor, onMessageMethod).initialize();
                    }
                    catch (Exception e) {
                        throw EJBUtils.createEJBException(e);
                    }
                }
            }
        }
        return this.onMessageMethodState;
    }

    void waitForApplicationStartup() {
        while (this.getApplication().getstate() == 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                if (m_logger.isLoggable(Level.FINE)) {
                    m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome:: waitForApplicationStartup(), sleep interrupted; exc=" + e.getMessage());
                }
                return;
            }
        }
    }

    void checkRunningState() {
        if (this.getState() == 1 && this.getApplication().getstate() == 1) {
            return;
        }
        if (this.getApplication().getstate() != 1) {
            throw new IllegalStateException("MessageDrivenHome:: application state=" + this.getApplication().getstate() + " - Application: '" + this.getApplication().getName() + "' is not in RUNNING state.");
        }
    }

    private synchronized void waitUntilNoActiveHandler(String callerMethodName) {
        while (this.activeHandlers > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                if (m_logger.isLoggable(Level.FINE)) {
                    m_logger.log(Level.FINE, "Thr[" + ThreadState.getCurrentState().toString() + "]-" + "MessageDrivenHome::" + callerMethodName + " : sleep interrupted; exc=" + e.getMessage());
                }
                return;
            }
        }
    }

    public synchronized void incrementActiveHandlers(int num) {
        this.activeHandlers += num;
        if (this.activeHandlers == 0) {
            this.notify();
        }
    }

    private void initializeDMSStartTime() {
        if (ApplicationServer.DMS_GATE && this.mdbNoun != null) {
            this.m_startTimeStateEvent = ApplicationServer.stateFactory().create(this.mdbNoun, "startTime", (byte)2, "msecs", "The MDB available time for service");
            this.m_startTimeStateEvent.update(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeTimer(Timer timer) throws Exception {
        this.checkRunningState();
        try {
            this.incrementActiveHandlers(1);
            ThreadState thread = ThreadState.getCurrentState();
            ContextContainer oldContainer = thread.contextContainer;
            try {
                thread.contextContainer = this;
                MessageDrivenContextImpl context = this.getContextInstance();
                try {
                    InvocationContextPool.invoke(thread, this.descriptor.getTimeoutMethodState(), context.getBean(), context, new Object[]{timer}, null, null);
                }
                finally {
                    this.releaseContextInstance(context);
                }
            }
            finally {
                thread.contextContainer = oldContainer;
            }
        }
        finally {
            this.incrementActiveHandlers(-1);
        }
    }
}

