/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.DataSourceConnectionContainer;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.compilation.BeanMethodCompilation;
import com.evermind.server.ejb.compilation.EJBCompilationUtils;
import com.evermind.server.ejb.compilation.EntityHomeCompilation;
import com.evermind.server.ejb.compilation.FinderCacheCompilation;
import com.evermind.server.ejb.compilation.OrionQueryParameter;
import com.evermind.server.ejb.compilation.PersistenceManagerCompilation;
import com.evermind.server.ejb.database.TableIteration;
import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.FinderMethod;
import com.evermind.server.ejb.deployment.PrimaryKeyContext;
import com.evermind.server.ejb.logging.EJBCompilationMessages;
import com.evermind.server.ejb.logging.EJBDeploymentMessages;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.server.http.JSPPageCompilation;
import com.evermind.util.ArraySet;
import com.evermind.util.ByteString;
import com.evermind.util.CharString;
import com.evermind.util.ClassUtils;
import com.sun.ejb.sqlgen.SQLGenerator;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CustomFinderMethodCompilation
extends BeanMethodCompilation {
    protected EntityHomeCompilation compilation;
    protected FinderMethod finder;
    protected EntityBeanDescriptor bean;
    protected List preparedArgs = new ArrayList();
    protected String preparedStatementOnlyPK;
    protected String preparedStatementAllColumns;
    protected String definedColumnTypesShort;
    protected String definedColumnTypesLong;
    protected PersistenceManagerCompilation persistenceManager;
    private int uniqueIdx = CustomFinderMethodCompilation.getNextID();
    private final boolean addNonPrimaryKeyColumnsToSelectList = false;
    private static Logger m_logger = EJBTraceLogger.getLogger(CustomFinderMethodCompilation.class);

    public CustomFinderMethodCompilation(PersistenceManagerCompilation persistenceManager, EntityHomeCompilation compilation, EntityBeanDescriptor descriptor, Method method, FinderMethod finder, boolean local) throws CompilationException {
        super(compilation, descriptor, method, true, true, null, local);
        this.persistenceManager = persistenceManager;
        this.compilation = compilation;
        this.bean = descriptor;
        this.finder = finder;
        this.synced = false;
    }

    public FinderMethod getFinder() {
        return this.finder;
    }

    private final void append_boolean_lazyloading(ByteString _source) {
        _source.append("boolean doing_lazyloading_here;\n");
        if (!this.canBeTransaction()) {
            _source.append("// do not bother loading here because the data will be thrown away before returning from this finder\n");
            _source.append("doing_lazyloading_here = true;\n");
            return;
        }
        if (this.finder.isLazyLoading_specified()) {
            if (this.finder.isLazyLoading()) {
                _source.append("// customers specify lazy loading ON for this finder\ndoing_lazyloading_here = true;\n");
            } else {
                _source.append("// customers specify lazy loading OFF for this finder, still do lazy loading on if tx==null\ndoing_lazyloading_here = (transaction == null);\n");
            }
        } else {
            _source.append("// customers do NOT specify lazy loading flag for this finder, use system property value if tx==null\ndoing_lazyloading_here = (transaction == null) ? true : com.evermind.server.SystemProperties.CUSTOMFINDER_LAZYLOADING;\n");
        }
        if (this.transactionType == 1) {
            _source.append("// always doing lazy loading if a new tx is created\nif (created) doing_lazyloading_here = true;\n");
        }
    }

    private String get_database_hints(StringBuffer _stmt) {
        int _idx;
        if (_stmt == null) {
            return null;
        }
        String _stmt1 = new String(_stmt);
        if ((_stmt1 = _stmt1.toUpperCase().trim()).indexOf("\"") == 0) {
            _stmt1 = _stmt1.substring(1).trim();
        }
        if ((_idx = _stmt1.indexOf("SELECT")) != 0) {
            IllegalStateException _ise = new IllegalStateException("select statment [" + _stmt + "] does not start with select");
            throw _ise;
        }
        if ((_stmt1 = _stmt1.substring(6).trim()).indexOf("/*+") == 0) {
            _idx = _stmt1.indexOf("*/");
            return _stmt1.substring(0, _idx + 3);
        }
        return null;
    }

    private boolean contain_select_distinct(String _stmt) {
        int _idx;
        if (_stmt == null) {
            return false;
        }
        if ((_stmt = _stmt.toUpperCase().trim()).indexOf("\"") == 0) {
            _stmt = _stmt.substring(1).trim();
        }
        if ((_idx = _stmt.indexOf("SELECT")) != 0) {
            IllegalStateException _ise = new IllegalStateException("select statment [" + _stmt + "] does not start with select");
            throw _ise;
        }
        return _stmt.substring(6).trim().indexOf("DISTINCT") == 0;
    }

    private boolean contain_lob_column() {
        try {
            if (this.compilation.beanCompilation.persistenceManagerCompilation == null) {
                return false;
            }
            return this.compilation.beanCompilation.persistenceManagerCompilation.containLobColumns();
        }
        catch (Exception ce) {
            return false;
        }
    }

    private boolean skipOrionFinder() {
        QueryDescriptor qd;
        return EJBUtils.isOrionCmpForced() && this.finder.getOrionQuery() == null && (qd = ((EjbCMPEntityDescriptor)this.bean.getEjbqlDescriptor()).getPersistenceDescriptor().getQueryFor(this.method)) != null && (qd.getSQLAsPrintableString() == null || !SQLGenerator.isQueryWithObjectToken(qd.getSQLAsPrintableString()));
    }

    public void addEJBInvocation() throws CompilationException {
        String loadStateFunc;
        int i;
        if (this.skipOrionFinder()) {
            EJBDeploymentMessages.warningDisableFinder(this.bean, this.method);
            this.source.append("\nthrow new javax.ejb.FinderException(\"The ejb-ql defined for this finder is not supported by Orion CMP\");\n");
            return;
        }
        long callTimeout = this.compilation.descriptor.getCallTimeout();
        boolean exclusiveAccess = this.compilation.beanCompilation.descriptor.hasExclusiveWriteAccess();
        boolean singleFinder = this.getResponseTypeName().equals(this.local ? this.compilation.descriptor.getLocalInterfaceName() : this.compilation.descriptor.getRemoteInterfaceName());
        this.createSQLQuery();
        try {
            if (this.compilation.descriptor.getDataSourceContainer(this.compilation.beanCompilation.container).isOracleDatabase() && this.compilation.descriptor.getLockingMode() == 1 && this.contain_select_distinct(this.preparedStatementAllColumns)) {
                throw new CompilationException("Cannot specify DISTINCT in ejbql if locking mode is specified as PESSIMISTIC");
            }
        }
        catch (InstantiationException e) {
            throw new CompilationException("Caught exception " + e.getMessage() + " trying to get the datasource type");
        }
        this.finder.setOnlyPKSQLData(this.preparedStatementOnlyPK);
        this.finder.setAllColumnsSQLData(this.preparedStatementAllColumns);
        this.append_boolean_lazyloading(this.source);
        if (this.contain_select_distinct(this.preparedStatementAllColumns) && this.contain_lob_column()) {
            this.source.append("// select distinct does not work with lob db column\ndoing_lazyloading_here = true;\n");
        }
        this.source.append(this.bean.getPrimaryKeyClassName() + " key = null;\n");
        String finderCacheVariable = null;
        if (this.finder.getCacheTimeout() > 0) {
            finderCacheVariable = this.compilation.getFinderCacheVariable();
            FinderCacheCompilation finderCacheCompilation = new FinderCacheCompilation(this.method, "FinderCache");
            finderCacheCompilation.compile();
            this.compilation.beanCompilation.compilation.addGenerator(finderCacheCompilation);
            this.source.append("FinderCache comparationCache;\n\nif(" + EJBCompilationUtils.getTransactionEqualsNullString() + ")\n" + "{\n" + "comparationCache = new " + finderCacheCompilation.getName() + "(");
            Class<?>[] arguments = this.method.getParameterTypes();
            for (int i2 = 0; i2 < arguments.length; ++i2) {
                if (i2 > 0) {
                    this.source.append(", ");
                }
                this.source.append("argument" + i2);
            }
            this.source.append(");\nsynchronized(" + finderCacheVariable + ")\n" + "{\n" + "com.evermind.server.ejb.FinderCache finderCache = (com.evermind.server.ejb.FinderCache)" + finderCacheVariable + ".get(comparationCache);\n" + "if(finderCache != null)\n" + "{\n" + "response = (" + this.method.getReturnType().getName() + ")finderCache.result;\n" + "finderCache.lastUsed = OC4J_getCurrentTime();\n" + "}\n" + "}\n" + "}\n" + "else comparationCache = null;\n" + "\n" + "if(response == null)\n" + "{\n");
        }
        if (!singleFinder) {
            this.source.append("java.util.Collection collection = new ArrayList();\n");
        }
        this.source.append("String sqlStatement = \"\";\n");
        this.source.append("\nDataSourceConnection connection = " + EJBCompilationUtils.getTransactionEqualsNullString() + " ? dataSourceContainer.get" + (this.isLocal() ? "Local" : "") + "Connection() : " + EJBCompilationUtils.getSynchronizationString() + ".get" + (this.isLocal() ? "Local" : "") + "Connection(this.dataSourceContainer);\n" + "\n" + "Object[] statementResult = null;\n" + "try\n" + "{\n");
        this.source.append("if (doing_lazyloading_here) {\nstatementResult = getOnlyPKSet_" + this.uniqueIdx + "(connection ");
        for (i = 0; i < this.args.length; ++i) {
            this.source.append(", argument" + i);
        }
        this.source.append(");\n} else {\nstatementResult = getAllColumnsSet_" + this.uniqueIdx + "(connection ");
        for (i = 0; i < this.args.length; ++i) {
            this.source.append(", argument" + i);
        }
        this.source.append(");\n}\n\n");
        this.source.append("java.sql.ResultSet set = (java.sql.ResultSet) statementResult[0];\n");
        if (singleFinder) {
            this.source.append("if(!set.next())\n{\n");
            this.source.append("methodException = new javax.ejb.ObjectNotFoundException(\"Cannot find bean of type [" + this.bean.getName() + "] using finder [" + this.method.getName() + "] method\");\n");
            if (this.canBeTransaction()) {
                this.source.append("if(transaction == null) connection.release();\n");
            }
            this.source.append("connection = null;\n}\nelse\n{\n");
        } else {
            this.source.append("while(set.next())\n{\n");
        }
        this.source.append("\n");
        this.compilation.beanCompilation.getPKFromJDBCResultSet(this.source, "key", this.finder.isPartial());
        String myTx = this.canBeTransaction() ? "transaction" : "null";
        if (this.local) {
            this.source.append("try {\n");
        }
        String string = loadStateFunc = this.finder.isPartial() ? "loadStateCorePKPartial" : "loadStateCorePKNonPartial";
        if (this.getResponseTypeName().equals("java.util.Collection") || this.getResponseTypeName().equals("java.util.Enumeration")) {
            this.source.append("if (doing_lazyloading_here)\n");
            this.source.append("collection.add(getWrapperByPK(" + myTx + ", key));\n");
            this.source.append("else {\n");
            this.source.append(this.compilation.beanCompilation.getName() + " _w2 = (" + this.compilation.beanCompilation.getName() + ") getWrapperByPK(" + myTx + ", key);\n");
            this.source.append("if (_w2.context.isLazy())\n");
            this.source.append("_w2." + loadStateFunc + "(set, connection);\n");
            this.source.append("collection.add(_w2);\n");
            this.source.append("}\n");
        } else {
            this.source.append("if (doing_lazyloading_here)\n");
            this.source.append("response = (" + this.compilation.beanCompilation.getName() + ")getWrapperByPK(" + myTx + ", key);\n");
            this.source.append("else {\n");
            this.source.append("response = (" + this.compilation.beanCompilation.getName() + ")getWrapperByPK(" + myTx + ", key);\n");
            this.source.append("if (((" + this.compilation.beanCompilation.getName() + ")response).context.isLazy())\n");
            this.source.append("((" + this.compilation.beanCompilation.getName() + ")response)." + loadStateFunc + "(set, connection);\n");
            this.source.append("}\n");
        }
        if (this.local) {
            this.source.append("} catch (RemoteException ex) {\n");
            this.source.append("OC4J_log(ex);\n");
            this.source.append("throw new javax.ejb.FinderException(ex.getMessage());\n");
            this.source.append("}\n");
        }
        if (singleFinder) {
            this.source.append("if(set.next()) methodException = new javax.ejb.FinderException(\"Single object finder query matched more than one entity\");\n");
        }
        this.source.append("}\n");
        if (!singleFinder) {
            if (this.getResponseTypeName().equals("java.util.Collection")) {
                this.source.append("response = collection;\n");
            } else if (this.getResponseTypeName().equals("java.util.Enumeration")) {
                this.source.append("response = new com.evermind.util.CollectionEnumeration(collection);\n");
            } else {
                throw new CompilationException("Unknown return-type for custom finder method: " + this.getResponseTypeName());
            }
        }
        this.source.append("set.close();");
        this.source.append("}\n");
        this.source.append("catch(java.sql.SQLException e)\n");
        this.source.append("{\n" + BeanMethodCompilation.getRollbackTransaction("\"Database error: \" + e", "e") + "OC4J_log(\"Database Error\", e);\n" + "if(" + EJBCompilationUtils.getTransactionEqualsNullString() + " && connection != null) connection.close(true);\n" + "if (SystemProperties.SQLLOG) \n" + "{\n" + "methodException = new " + (this.isLocal() ? "javax.ejb.EJBException" : "oracle.oc4j.rmi.OracleRemoteException") + "(\"Database error: \" + e.getMessage()\n + sqlStatement, e);\n" + "}\n" + "else \n" + "{\n" + "methodException = new " + (this.isLocal() ? "javax.ejb.EJBException" : "oracle.oc4j.rmi.OracleRemoteException") + "(\"Database error: \" + e.getMessage(), e);\n" + "}\n" + "connection = null;\n" + "}\n");
        this.source.append("catch(java.lang.Throwable t)\n");
        this.source.append("{\nOC4J_log(t);\n" + BeanMethodCompilation.getRollbackTransaction("\"Internal error: \" + t", "t") + "if(" + EJBCompilationUtils.getTransactionEqualsNullString() + " && connection != null) connection.close(true);\n" + "connection = null;\n" + "methodException = t;\n" + "}\n" + "finally\n{" + "  if(statementResult != null) {\n" + "    try {\n" + "      ((java.sql.Statement) statementResult[1] ).close();\n" + "    } catch(java.sql.SQLException e) {}\n" + "  }\n" + "}\n" + "\n" + "if(" + EJBCompilationUtils.getTransactionEqualsNullString() + " && connection != null) connection.release();\n");
        if (finderCacheVariable != null) {
            this.source.append("}\n\nif(" + EJBCompilationUtils.getTransactionEqualsNullString() + " && methodException == null)\n" + "{\n" + "synchronized(" + finderCacheVariable + ")\n" + "{\n" + "comparationCache.result = response;\n" + "comparationCache.lastUsed = OC4J_getCurrentTime();\n" + finderCacheVariable + ".put(comparationCache, comparationCache);\n" + "}\n" + "}\n");
        }
    }

    public void createSQLQuery() throws CompilationException {
        boolean isTransformed;
        QueryDescriptor qd;
        StringBuffer localBuffer = new StringBuffer();
        ArraySet newSet = new ArraySet((Collection)this.persistenceManager.table.getFields());
        newSet.add(0, this.compilation.beanCompilation.descriptor.getPrimaryKey());
        this.persistenceManager.table.getDefinedColumnTypes(localBuffer, false, "statement", newSet);
        this.definedColumnTypesLong = localBuffer.toString();
        localBuffer = new StringBuffer();
        ArraySet newSet2 = new ArraySet();
        newSet2.add(0, this.compilation.beanCompilation.descriptor.getPrimaryKey());
        this.persistenceManager.table.getDefinedColumnTypes(localBuffer, false, "statement", newSet2);
        this.definedColumnTypesShort = localBuffer.toString();
        StringBuffer queryShort = new StringBuffer();
        StringBuffer queryLong = new StringBuffer();
        queryShort.append("\"select ");
        queryLong.append("\"select ");
        String finderQuery = this.finder.getOrionQuery();
        if (finderQuery == null && (qd = ((EjbCMPEntityDescriptor)this.bean.getEjbqlDescriptor()).getPersistenceDescriptor().getQueryFor(this.method)) != null) {
            this.finder.setQueryDescriptor(qd);
            finderQuery = qd.getSQLAsPrintableString();
        }
        boolean bl = isTransformed = finderQuery != null && SQLGenerator.isQueryWithObjectToken(finderQuery);
        if (isTransformed && m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "-- finderQuery: " + finderQuery);
        }
        TableIteration tableIteration = new TableIteration();
        StringBuffer selectListItemsShort = new StringBuffer();
        String anAliasName = this.finder.getAliasFor(this.compilation.beanCompilation.descriptor.getTableName());
        this.compilation.beanCompilation.descriptor.getPrimaryKey().appendFieldNames(selectListItemsShort, tableIteration, 0, !isTransformed, anAliasName, null);
        StringBuffer selectListItemsLong = new StringBuffer(selectListItemsShort.toString());
        Iterator iterator = this.persistenceManager.table.getFields().iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            if (field.isSynthetic() || field.isPersistedToAssociationTable()) continue;
            field.appendFieldNames(selectListItemsLong, tableIteration, 0, !isTransformed, anAliasName, null);
        }
        queryShort.append(selectListItemsShort.toString());
        queryShort.append(" from ");
        queryShort.append(this.bean.getTableName(true));
        queryLong.append(selectListItemsLong.toString());
        queryLong.append(" from ");
        queryLong.append(this.bean.getTableName(true));
        StringBuffer preparedStatementShort = new StringBuffer();
        preparedStatementShort.append(queryShort.toString());
        StringBuffer preparedStatementLong = new StringBuffer();
        preparedStatementLong.append(queryLong.toString());
        if (finderQuery != null && finderQuery.length() > 0) {
            if (isTransformed) {
                String assembledQueryShort = SQLGenerator.spliceSelectList(finderQuery, selectListItemsShort.toString());
                this.finder.setPartial(true);
                preparedStatementShort = new StringBuffer();
                preparedStatementShort.append("\"");
                preparedStatementShort.append(assembledQueryShort);
                String assembledQueryLong = SQLGenerator.spliceSelectList(finderQuery, selectListItemsLong.toString());
                preparedStatementLong = new StringBuffer();
                preparedStatementLong.append("\"");
                preparedStatementLong.append(assembledQueryLong);
                OrionQueryParameter.makeParametersForQLFinder(this);
            } else {
                if (finderQuery.toLowerCase().startsWith("select ") || !this.finder.isPartial()) {
                    this.finder.setPartial(false);
                    String from_clause = "FROM " + this.bean.getTableName(true).toUpperCase();
                    int _from = preparedStatementShort.toString().toUpperCase().indexOf(from_clause);
                    preparedStatementShort.delete(_from, preparedStatementShort.length());
                    _from = preparedStatementLong.toString().toUpperCase().indexOf(from_clause);
                    preparedStatementLong.delete(_from, preparedStatementLong.length());
                } else if (finderQuery.toLowerCase().startsWith("order ")) {
                    preparedStatementShort.append(" ");
                    preparedStatementLong.append(" ");
                } else {
                    preparedStatementShort.append(" where ");
                    preparedStatementLong.append(" where ");
                }
                StringBuffer wc = new StringBuffer();
                this.getQueryDecoded(wc);
                String hint = null;
                if (!this.finder.isPartial() && (hint = this.get_database_hints(wc)) != null) {
                    preparedStatementShort.insert(8, hint);
                    preparedStatementLong.insert(8, hint);
                }
                if (!this.finder.isPartial()) {
                    if (this.contain_select_distinct(wc.toString())) {
                        preparedStatementShort.insert(hint != null ? hint.length() + 7 : 7, " DISTINCT ");
                        preparedStatementLong.insert(hint != null ? hint.length() + 7 : 7, " DISTINCT ");
                    }
                    this.get_from_clause_and_everything_behind(wc);
                }
                preparedStatementShort.append(wc.toString());
                preparedStatementLong.append(wc.toString());
            }
        }
        try {
            if (this.compilation.descriptor.getLockingMode() == 1) {
                DataSourceConnectionContainer connContainer = this.compilation.descriptor.getDataSourceContainer(this.compilation.beanCompilation.container);
                if (connContainer.isOracleDatabase()) {
                    preparedStatementShort.append(" FOR UPDATE");
                    preparedStatementLong.append(" FOR UPDATE");
                } else if (connContainer.isDB2Database()) {
                    preparedStatementShort.append(" FOR UPDATE WITH RS");
                    preparedStatementLong.append(" FOR UPDATE WITH RS");
                }
            }
        }
        catch (InstantiationException e) {
            EJBCompilationMessages.severeGetDataSourceType(this.descriptor, e.getMessage());
            throw new CompilationException("Caught exception " + e.getMessage() + " trying to get the datasource type");
        }
        this.preparedStatementAllColumns = preparedStatementLong.toString();
        this.preparedStatementOnlyPK = preparedStatementShort.toString();
    }

    private void get_from_clause_and_everything_behind(StringBuffer _wc) {
        String from_clause = " FROM ";
        int _from = _wc.toString().toUpperCase().indexOf(from_clause);
        _wc.delete(0, _from).insert(0, " ");
    }

    public void getQueryDecoded(StringBuffer preparedBuffer) throws CompilationException {
        String query = JSPPageCompilation.javaSourceEncode(new CharString(this.finder.getOrionQuery().replace('$', '?'))).toString();
        this.getQueryDecoded(preparedBuffer, query);
    }

    public void getQueryDecoded(StringBuffer preparedBuffer, String query) throws CompilationException {
        int pos = 0;
        int found = 0;
        Object equalsContext = null;
        Object equalsField = null;
        while (pos < query.length()) {
            int searchPos;
            OrionQueryParameter parameter;
            found = query.indexOf(63, pos);
            if (found < 0) {
                preparedBuffer.append(query.substring(pos));
                pos = query.length();
                continue;
            }
            preparedBuffer.append(query.substring(pos, found));
            for (pos = ++found; pos < query.length() && (Character.isJavaIdentifierPart(query.charAt(pos)) && query.charAt(pos) != '(' && query.charAt(pos) != ')' || query.charAt(pos) == '.' || query.charAt(pos) == '@'); ++pos) {
            }
            if (pos < found) {
                throw new CompilationException("Standalone ? found in finder query");
            }
            String var = query.substring(found, pos);
            if (var.equals("@fields")) {
                Iterator iterator = this.persistenceManager.table.getFields().iterator();
                TableIteration tableIteration = new TableIteration();
                this.compilation.beanCompilation.descriptor.getPrimaryKey().appendFieldNames(preparedBuffer, tableIteration, 0, true);
                while (iterator.hasNext()) {
                    ((ContainerManagedField)iterator.next()).appendFieldNames(preparedBuffer, tableIteration, 0, true);
                }
                continue;
            }
            try {
                parameter = new OrionQueryParameter(var, this);
            }
            catch (CompilationException e) {
                throw new CompilationException(e.getMessage() + " at column " + pos + " in query '" + query + "'");
            }
            for (searchPos = pos; searchPos < query.length() && (query.charAt(searchPos) == ' ' || query.charAt(searchPos) == '\t' || query.charAt(searchPos) == '\n' || query.charAt(searchPos) == '\r' || query.charAt(searchPos) == '!'); ++searchPos) {
            }
            boolean notEquals = false;
            if (searchPos < query.length() && query.charAt(searchPos) == '=') {
                notEquals = query.charAt(searchPos - 1) == '!';
                ++searchPos;
                while (searchPos < query.length() && (query.charAt(searchPos) == ' ' || query.charAt(searchPos) == '\t' || query.charAt(searchPos) == '\n' || query.charAt(searchPos) == '\r')) {
                    ++searchPos;
                }
                if (searchPos < query.length() && query.charAt(searchPos) == '?') {
                    int startPos = pos = ++searchPos;
                    while (pos < query.length() && (Character.isJavaIdentifierPart(query.charAt(pos)) && query.charAt(pos) != '(' && query.charAt(pos) != ')' || query.charAt(pos) == '.')) {
                        ++pos;
                    }
                    OrionQueryParameter other = new OrionQueryParameter(query.substring(startPos, pos), this);
                    if (parameter.queryParameterID < 1 && parameter.field == null) {
                        parameter.field = parameter.context.getPrimaryKey();
                    }
                    if (other.queryParameterID < 1 && other.field == null) {
                        other.field = other.context.getPrimaryKey();
                    }
                    if (parameter.field == null && other.field == null) {
                        throw new CompilationException("Cannot compare finder method argument to finder method argument");
                    }
                    try {
                        if (parameter.field == null) {
                            other.field.appendComparation(preparedBuffer, parameter.field, true, notEquals ? "!=" : "=", null, !notEquals);
                            continue;
                        }
                        parameter.field.appendComparation(preparedBuffer, other.field, true, notEquals ? "!=" : "=", null, !notEquals);
                        continue;
                    }
                    catch (CompilationException e) {
                        throw new CompilationException(e.getMessage() + " at column " + pos + " in query '" + query + "'");
                    }
                }
            }
            if (parameter.queryParameterID > 0) {
                preparedBuffer.append("?");
                continue;
            }
            if (parameter.field != null) {
                parameter.field.appendFieldNames(preparedBuffer, new TableIteration(), 0, true);
                continue;
            }
            preparedBuffer.append(parameter.context.getTableName());
        }
    }

    public void addSupportingMethods() throws CompilationException {
        if (this.skipOrionFinder()) {
            return;
        }
        StringBuffer sb = new StringBuffer(this.uniqueIdx + " (DataSourceConnection _conn ");
        for (int i = 0; i < this.args.length; ++i) {
            sb.append(", ");
            sb.append(ClassUtils.getClassNameFromSourceNotation(this.args[i], 0));
            sb.append(" argument");
            sb.append(i);
        }
        sb.append(") throws java.sql.SQLException {\n");
        String _getSetArgs = sb.toString();
        this.addGetOnlyPKSet(_getSetArgs);
        this.addGetAllColumnsSet(_getSetArgs);
    }

    private void addGetOnlyPKSet(String _arg2) throws CompilationException {
        this.source.append("private Object[] getOnlyPKSet_" + _arg2);
        this.source.append("String sqlStatement = \"\";\ntry\n{\n");
        this.source.append("Flag statementCached = new Flag(false);\n java.sql.PreparedStatement statement = EJBPrivileged.getCustomStatement(_conn, statementCached,");
        this.source.append(this.preparedStatementOnlyPK, true);
        this.source.append(this.definedColumnTypesShort, true);
        Class<?>[] types = this.method.getParameterTypes();
        TableIteration queryTableIteration = new TableIteration();
        for (int i = 0; i < this.preparedArgs.size(); ++i) {
            int number = (Integer)this.preparedArgs.get(i);
            ContainerManagedField field = new ContainerManagedField(null, (PrimaryKeyContext)this.compilation.beanCompilation.descriptor, String.valueOf(i));
            try {
                field.init(this.compilation.beanCompilation.container, this.compilation.beanCompilation.schema, null, types[number]);
            }
            catch (InstantiationException e) {
                throw new CompilationException(e.getMessage());
            }
            this.persistenceManager.table.appendPreparedSet(this.source, true, "statement", types[number], queryTableIteration, "argument" + number, field, "wrapper.context", true);
        }
        this.source.append("sqlStatement = " + this.preparedStatementOnlyPK + "\";");
        if (this.finder.getPrefetchSize() > 0) {
            this.source.append("\nstatement.setFetchSize(" + this.finder.getPrefetchSize() + ");\n");
        }
        this.source.append("\njava.sql.ResultSet set = statement.executeQuery();\nObject[] result = {set, statement };\nreturn result;\n");
        this.source.append("}\n");
        this.source.append("catch (java.sql.SQLException e)\n{\nif (SystemProperties.SQLLOG)\nthrow new java.sql.SQLException(e.getMessage() + sqlStatement);\nthrow e;\n}\n");
        this.source.append("}\n\n");
    }

    private void addGetAllColumnsSet(String _arg2) throws CompilationException {
        this.source.append("private Object[] getAllColumnsSet_" + _arg2);
        this.source.append("String sqlStatement = \"\";\ntry\n{\n");
        this.source.append("Flag statementCached = new Flag(false);\n java.sql.PreparedStatement statement = EJBPrivileged.getCustomStatement(_conn, statementCached,");
        this.source.append(this.preparedStatementAllColumns, true);
        this.source.append(this.definedColumnTypesLong, true);
        Class<?>[] types = this.method.getParameterTypes();
        TableIteration queryTableIteration = new TableIteration();
        for (int i = 0; i < this.preparedArgs.size(); ++i) {
            int number = (Integer)this.preparedArgs.get(i);
            ContainerManagedField field = new ContainerManagedField(null, (PrimaryKeyContext)this.compilation.beanCompilation.descriptor, String.valueOf(i));
            try {
                field.init(this.compilation.beanCompilation.container, this.compilation.beanCompilation.schema, null, types[number]);
            }
            catch (InstantiationException e) {
                throw new CompilationException(e.getMessage());
            }
            this.persistenceManager.table.appendPreparedSet(this.source, true, "statement", types[number], queryTableIteration, "argument" + number, field, "wrapper.context", true);
        }
        this.source.append("sqlStatement = " + this.preparedStatementAllColumns + "\";");
        if (this.finder.getPrefetchSize() > 0) {
            this.source.append("\nstatement.setFetchSize(" + this.finder.getPrefetchSize() + ");\n");
        }
        this.source.append("\njava.sql.ResultSet set = statement.executeQuery();\nObject[] result = {set, statement };\nreturn result;\n");
        this.source.append("}\n");
        this.source.append("catch (java.sql.SQLException e)\n{\nif (SystemProperties.SQLLOG)\nthrow new java.sql.SQLException(e.getMessage() + sqlStatement);\nthrow e;\n}\n");
        this.source.append("}\n\n");
    }
}

