/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.database;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.DataSourceConnectionContainer;
import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.compilation.ClassCompilation;
import com.evermind.server.ejb.compilation.EntityBeanCompilation;
import com.evermind.server.ejb.database.DatabaseSchema;
import com.evermind.server.ejb.database.Table;
import com.evermind.server.ejb.database.TableIteration;
import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.ORMapping;
import com.evermind.server.ejb.deployment.PrimaryKeyContext;
import com.evermind.server.ejb.logging.EJBDatabaseMessages;
import com.evermind.util.ArraySet;
import com.evermind.util.ByteString;
import com.evermind.util.ClassUtils;
import com.evermind.util.EJBProperties;
import java.io.File;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.ejb.EJBLocalObject;
import javax.ejb.EntityContext;
import javax.mail.internet.InternetAddress;

public class TableView {
    public static final boolean DEFINE_COLUMN_TYPE = EJBProperties.getDefineColumnType();
    private Table table;
    private ContainerManagedField primaryKey;
    private Set fields = new ArraySet();
    private ArraySet allfields = null;
    private EntityBeanCompilation beanCompilation;
    private boolean explicitPrimaryKey;
    private EJBContainer container;
    private DatabaseSchema schema;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Set;

    public TableView(Table table, ContainerManagedField primaryKey, Set fields, boolean explicitPrimaryKey, EntityBeanCompilation beanCompilation) {
        this.table = table;
        this.primaryKey = primaryKey;
        this.fields = fields;
        this.explicitPrimaryKey = explicitPrimaryKey;
        this.beanCompilation = beanCompilation;
    }

    public void setEnvironment(EJBContainer container, DatabaseSchema schema) {
        this.container = container;
        this.schema = schema;
    }

    public void setPrimaryKey(ContainerManagedField key) {
        this.primaryKey = key;
    }

    public Table getTable() {
        return this.table;
    }

    public Set getFields() {
        return this.fields;
    }

    public DatabaseSchema getSchema() {
        return this.schema;
    }

    public EJBContainer getContainer() {
        return this.container;
    }

    public boolean isExplicitPrimaryKey() {
        return this.explicitPrimaryKey;
    }

    public void addFields(Collection fields) {
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            Object field = iterator.next();
            if (this.fields.contains(field)) continue;
            this.fields.add(field);
        }
    }

    public String getCreateTableStatement(boolean explicitCompositeKey) throws CompilationException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("create table ");
        buffer.append(this.table.getName());
        buffer.append(" (");
        TableIteration tableIteration = new TableIteration();
        this.primaryKey.appendDatabaseDefinition(buffer, tableIteration, this.primaryKey.getDatabaseFieldCount() > 1 || !this.explicitPrimaryKey, this.container, this.schema, true);
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            if (field.isSynthetic() || field.isPersistedToAssociationTable()) continue;
            field.appendDatabaseDefinition(buffer, tableIteration, this.primaryKey.getDatabaseFieldCount() > 1 || !this.explicitPrimaryKey, this.container, this.schema, false);
        }
        if (this.primaryKey.getDatabaseFieldCount() > 1 && explicitCompositeKey) {
            buffer.append(", " + this.schema.getPrimaryKey() + " (");
            this.primaryKey.appendFieldNames(buffer, new TableIteration(), 0, false);
            buffer.append(")");
        }
        buffer.append(")");
        return buffer.toString();
    }

    public String getPreparedInsertStatement(boolean tableNames) throws CompilationException {
        ContainerManagedField field;
        StringBuffer buffer = new StringBuffer();
        buffer.append("insert into ");
        buffer.append(this.table.getName());
        buffer.append(" (");
        TableIteration tableIteration = new TableIteration();
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            field = (ContainerManagedField)iterator.next();
            if (field.isSynthetic() || field.isPersistedToAssociationTable()) continue;
            field.appendFieldNames(buffer, tableIteration, 0, false);
        }
        this.primaryKey.appendFieldNames(buffer, tableIteration, 0, false);
        buffer.append(") VALUES (");
        iterator = this.fields.iterator();
        tableIteration = new TableIteration();
        while (iterator.hasNext()) {
            field = (ContainerManagedField)iterator.next();
            if (field.isSynthetic() || field.isPersistedToAssociationTable()) continue;
            field.appendFieldNames(buffer, tableIteration, 1, tableNames);
        }
        this.primaryKey.appendFieldNames(buffer, tableIteration, 1, true);
        buffer.append(")");
        return buffer.toString();
    }

    public StringBuffer appendFieldNameOrQuestionMark(String dirtyVariable, boolean appendFieldName) throws CompilationException {
        StringBuffer buffer = new StringBuffer();
        TableIteration tableIteration = new TableIteration();
        int appendMode = appendFieldName ? 0 : 1;
        this.primaryKey.appendFieldNames(buffer, tableIteration, appendMode, false);
        boolean priorFieldWithDirtyFlag = false;
        int currentIndex = -1;
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            if (dirtyVariable != null) {
                ++currentIndex;
            }
            if (field.isSynthetic() || field.isPersistedToAssociationTable() || field.isShared()) continue;
            if (dirtyVariable != null && field.getPersistenceType() != 4 && field.getPersistenceType() != 8 && field.getPersistenceType() != 7) {
                if (!priorFieldWithDirtyFlag) {
                    buffer.append("\"");
                }
                buffer.append(" + (" + dirtyVariable + ".get(" + currentIndex + ") ? \"");
                field.appendFieldNames(buffer, tableIteration, appendMode, false);
                buffer.append("\" : \"\")");
                priorFieldWithDirtyFlag = true;
                continue;
            }
            if (priorFieldWithDirtyFlag) {
                buffer.append(" + \"");
                priorFieldWithDirtyFlag = false;
            }
            field.appendFieldNames(buffer, tableIteration, appendMode, false);
        }
        if (priorFieldWithDirtyFlag) {
            buffer.append(" + \"");
        }
        return buffer;
    }

    public String getPreparedInsertStatementPKFirst(boolean tableNames, String dirtyVariable) throws CompilationException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("insert into ");
        buffer.append(this.table.getName());
        buffer.append(" (");
        buffer.append(this.appendFieldNameOrQuestionMark(dirtyVariable, true));
        buffer.append(") VALUES (");
        buffer.append(this.appendFieldNameOrQuestionMark(dirtyVariable, false));
        buffer.append(")");
        return buffer.toString();
    }

    public String getPreparedUpdateStatement(boolean tableNames) throws CompilationException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("update ");
        buffer.append(this.getTable().getName());
        buffer.append(" set ");
        TableIteration tableIteration = new TableIteration();
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            if (field.isSynthetic() || field.isPersistedToAssociationTable()) continue;
            field.appendFieldNames(buffer, tableIteration, 2, false);
        }
        buffer.append(" where ");
        this.primaryKey.appendFieldNames(buffer, new TableIteration(), 3, false);
        if (this.primaryKey.getDatabaseFieldCount() < 1) {
            throw new CompilationException("No direct database fields for primary key for " + this.primaryKey.getContext());
        }
        return buffer.toString();
    }

    public String getPreparedDeleteStatement(boolean tableNames) throws CompilationException {
        return this.getPreparedDeleteStatement(tableNames, false);
    }

    public String getPreparedDeleteStatement(boolean tableNames, boolean coming_from_OR) throws CompilationException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("delete from ");
        buffer.append(this.getTable().getName());
        buffer.append(" where (");
        if (coming_from_OR) {
            Iterator iterator = this.fields.iterator();
            TableIteration tableIteration2 = new TableIteration();
            while (iterator.hasNext()) {
                ContainerManagedField field = (ContainerManagedField)iterator.next();
                if (field.isSynthetic() || field.isPersistedToAssociationTable()) continue;
                field.appendFieldNames(buffer, tableIteration2, 3, false);
                buffer.append(" and ");
            }
        }
        TableIteration tableIteration = new TableIteration();
        this.primaryKey.appendFieldNames(buffer, tableIteration, 3, tableNames);
        buffer.append(")");
        return buffer.toString();
    }

    public String getPreparedOneToOneSelectStatement(boolean tableName, String stmtName, String cmfName) throws CompilationException {
        StringBuffer buffer = new StringBuffer("select ");
        this.primaryKey.appendFieldNames(buffer, new TableIteration(), 0, tableName);
        buffer.append(" from ");
        buffer.append(this.getTable().getName());
        buffer.append(" where (");
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            if (!cmfName.equals(field.getEJBReferenceHome() + "_" + field.getName())) continue;
            field.appendFieldNames(buffer, new TableIteration(), 3, tableName);
            break;
        }
        buffer.append(")");
        return buffer.toString();
    }

    public String getPreparedSelectStatement(boolean tableNames, String stmtName) throws CompilationException {
        return this.getPreparedSelectStatement(tableNames, stmtName, null, false);
    }

    public String getPreparedSelectStatement(boolean tableNames, String stmtName, List oneToOneFields, boolean allowForUpdate) throws CompilationException {
        List uniDirectionalOneToOneFields = this.getUniDirectionalOneToOneFields(oneToOneFields);
        if (uniDirectionalOneToOneFields != null && this.getUniDirectionalOneToOneIsJoined(uniDirectionalOneToOneFields)) {
            return this.getPreparedOneToOneJoinSelectStatement(stmtName, uniDirectionalOneToOneFields, allowForUpdate);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("select ");
        TableIteration tableIteration = new TableIteration();
        ArraySet localFields = new ArraySet();
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            if (field.isSynthetic() || field.isPersistedToAssociationTable()) continue;
            field.appendFieldNames(buffer, tableIteration, 0, tableNames);
            localFields.add(field);
        }
        if (tableIteration.getNextPos("<dummy>", 4) == 1) {
            buffer.append("*");
        }
        buffer.append(" from ");
        buffer.append(this.getTable().getName());
        buffer.append(" where (");
        tableIteration = new TableIteration();
        this.primaryKey.appendFieldNames(buffer, tableIteration, 3, tableNames);
        buffer.append(")");
        this.preparePessLockingStatement(buffer);
        if (stmtName != null) {
            this.getDefinedColumnTypes(buffer, tableNames, stmtName, localFields);
        }
        return buffer.toString();
    }

    public boolean getUniDirectionalOneToOneIsOuterJoin(List oneToOneFields) {
        boolean isOuterJoin = false;
        if (oneToOneFields != null && oneToOneFields.size() > 0) {
            ContainerManagedField cmr = null;
            Iterator itor = oneToOneFields.iterator();
            while (itor.hasNext()) {
                cmr = (ContainerManagedField)itor.next();
                if (!cmr.isOneToOne() || !cmr.getOneToOneOption().isOuterJoin()) continue;
                isOuterJoin = cmr.getOneToOneOption().isOuterJoin();
                break;
            }
        }
        return isOuterJoin;
    }

    public boolean getUniDirectionalOneToOneIsInnerJoin(List oneToOneFields) {
        boolean isInnerJoin = false;
        if (oneToOneFields != null && oneToOneFields.size() > 0) {
            ContainerManagedField cmr = null;
            Iterator itor = oneToOneFields.iterator();
            while (itor.hasNext()) {
                cmr = (ContainerManagedField)itor.next();
                if (!cmr.isOneToOne() || !cmr.getOneToOneOption().isInnerJoin()) continue;
                isInnerJoin = cmr.getOneToOneOption().isInnerJoin();
                break;
            }
        }
        return isInnerJoin;
    }

    public boolean getUniDirectionalOneToOneIsJoined(List oneToOneFields) {
        boolean isJoined = false;
        if (oneToOneFields != null && oneToOneFields.size() > 0) {
            ContainerManagedField cmr = null;
            Iterator itor = oneToOneFields.iterator();
            while (itor.hasNext()) {
                cmr = (ContainerManagedField)itor.next();
                if (!cmr.isOneToOne() || !cmr.getOneToOneOption().isJoined()) continue;
                isJoined = cmr.getOneToOneOption().isJoined();
                break;
            }
        }
        return isJoined;
    }

    public List getUniDirectionalOneToOneFields(List oneToOneFields) {
        ArrayList<ContainerManagedField> uniDirectionalFields = null;
        if (oneToOneFields != null && oneToOneFields.size() > 0) {
            ContainerManagedField cmr = null;
            Iterator itor = oneToOneFields.iterator();
            while (itor.hasNext()) {
                cmr = (ContainerManagedField)itor.next();
                if (!cmr.isMasterInUniDirectional() || cmr.isLazyLoading()) continue;
                if (uniDirectionalFields == null) {
                    uniDirectionalFields = new ArrayList<ContainerManagedField>();
                }
                uniDirectionalFields.add(cmr);
            }
        }
        return uniDirectionalFields;
    }

    private String getPreparedOneToOneJoinSelectStatement(String stmtName, List oneToOneFields, boolean allowForUpdate) throws CompilationException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("select ");
        TableIteration tableIteration = new TableIteration();
        ArraySet localFields = new ArraySet();
        this.appendValueFieldsToQuery(this.getOneToOneJoinValueFields(oneToOneFields), buffer, tableIteration, localFields);
        if (tableIteration.getNextPos("<dummy>", 4) == 1) {
            buffer.append("*");
        }
        buffer.append(" from ");
        if (this.getUniDirectionalOneToOneIsOuterJoin(oneToOneFields)) {
            this.appendOuterJoinClauses(buffer, oneToOneFields);
            buffer.append(" where ");
        } else if (this.getUniDirectionalOneToOneIsInnerJoin(oneToOneFields)) {
            this.appendInnerJoinClauses(buffer, oneToOneFields);
            buffer.append(" and ");
        }
        this.appendOneToOneJoinWhereClause(buffer);
        if (allowForUpdate) {
            this.appendPessimisticLockClause(oneToOneFields, buffer);
        }
        if (stmtName != null) {
            this.getDefinedColumnTypes(buffer, true, stmtName, localFields);
        }
        return buffer.toString();
    }

    private void appendPessimisticLockClause(List oneToOneFields, StringBuffer buffer) {
        try {
            DataSourceConnectionContainer connContainer = this.beanCompilation.descriptor.getDataSourceContainer(this.container);
            if (connContainer.isOracleDatabase() || connContainer.isDB2Database()) {
                StringBuffer updateColumns = new StringBuffer();
                EntityBeanDescriptor peerDescriptor = null;
                Iterator iterator = oneToOneFields.iterator();
                while (iterator.hasNext()) {
                    peerDescriptor = (EntityBeanDescriptor)this.getPeerPrimarykeyContext((ContainerManagedField)iterator.next());
                    if (peerDescriptor.getLockingMode() != 1) continue;
                    if (updateColumns.length() > 0) {
                        updateColumns.append(", ");
                    } else {
                        updateColumns.append(" for update of ");
                    }
                    ContainerManagedField peerField = peerDescriptor.getPrimaryKey();
                    updateColumns.append(peerField.getOwner().getTableName() + ".");
                    updateColumns.append(peerField.getDatabaseName());
                }
                if (updateColumns.length() > 0) {
                    buffer.append(updateColumns.toString());
                }
            }
        }
        catch (InstantiationException e) {
            EJBDatabaseMessages.warningGetDataSourceType(this.beanCompilation.descriptor, e);
        }
    }

    private void appendOneToOneJoinWhereClause(StringBuffer buffer) throws CompilationException {
        TableIteration tableIteration = new TableIteration();
        this.primaryKey.appendFieldNames(buffer, tableIteration, 3, true);
    }

    private Set getOneToOneJoinValueFields(List oneToOneFields) {
        ArraySet valueFields = new ArraySet((Collection)this.fields);
        ContainerManagedField cmrField = null;
        Iterator iterator = oneToOneFields.iterator();
        while (iterator.hasNext()) {
            cmrField = (ContainerManagedField)iterator.next();
            valueFields.addAll(this.getPeerContainerManagedFields(cmrField));
        }
        return valueFields;
    }

    private Set getPeerContainerManagedFields(ContainerManagedField cmrField) {
        return this.getPeerPrimarykeyContext(cmrField).getPrimaryKey().getEntity().getContainerManagedFields();
    }

    private void appendOuterJoinClauses(StringBuffer buffer, List oneToOneFields) {
        ArrayList<String> tables = new ArrayList<String>();
        PrimaryKeyContext pkCtx = null;
        buffer.append(this.getTable().getName());
        tables.add(this.getTable().getName());
        for (int i = 0; i < oneToOneFields.size(); ++i) {
            String aPeerAliasName;
            ContainerManagedField cmrField = (ContainerManagedField)oneToOneFields.get(i);
            pkCtx = this.getPeerPrimarykeyContext(cmrField);
            String string = aPeerAliasName = tables.contains(pkCtx.getTableName()) ? this.createTableAlias(tables.size()) : "";
            if (aPeerAliasName.equalsIgnoreCase("")) {
                tables.add(pkCtx.getTableName());
            } else {
                tables.add(aPeerAliasName);
            }
            buffer.append(" left outer join " + pkCtx.getTableName() + " " + aPeerAliasName + " on ");
            ContainerManagedField peerField = pkCtx.getPrimaryKey();
            String aTableName = cmrField.getOwner().getTableName().equalsIgnoreCase(pkCtx.getTableName()) ? aPeerAliasName : cmrField.getOwner().getTableName();
            buffer.append(aTableName + "." + cmrField.getDatabaseName() + " = ");
            buffer.append(peerField.getOwner().getTableName() + ".");
            buffer.append(peerField.getDatabaseName());
        }
    }

    private String createTableAlias(int anIndex) {
        return new String("A" + anIndex++);
    }

    private void appendInnerJoinClauses(StringBuffer buffer, List oneToOneFields) {
        buffer.append(this.getTable().getName());
        PrimaryKeyContext pkCtx = null;
        Iterator iterator = oneToOneFields.iterator();
        while (iterator.hasNext()) {
            ContainerManagedField cmrField = (ContainerManagedField)iterator.next();
            pkCtx = this.getPeerPrimarykeyContext(cmrField);
            buffer.append(" , " + pkCtx.getTableName() + " where ");
            ContainerManagedField peerField = pkCtx.getPrimaryKey();
            buffer.append(cmrField.getOwner().getTableName() + "." + cmrField.getDatabaseName() + " = ");
            buffer.append(peerField.getOwner().getTableName() + ".");
            buffer.append(peerField.getDatabaseName());
        }
    }

    private PrimaryKeyContext getPeerPrimarykeyContext(ContainerManagedField cmrField) {
        return cmrField.getPeer().getEJBRelationship().getSecondRole().getRoleSource().getResolved();
    }

    private void appendValueFieldsToQuery(Set cmpFields, StringBuffer buffer, TableIteration tableIteration, Set localFields) throws CompilationException {
        Iterator iterator = cmpFields.iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            if (field.isSynthetic() || field.isPersistedToAssociationTable()) continue;
            this.appendFieldWithColumnAlias(field, buffer, tableIteration);
            localFields.add(field);
        }
    }

    private void appendFieldWithColumnAlias(ContainerManagedField field, StringBuffer buffer, TableIteration tableIteration) throws CompilationException {
        EntityBeanDescriptor descriptor = field.getEntity();
        field.setDatabaseColumnAlias(descriptor.getName());
        field.appendFieldNames(buffer, tableIteration, 0, true);
        field.setDatabaseColumnAlias(null);
    }

    public String getCMREagerLoadSelectStatement(boolean tableNames, String stmtName, String targetBeanName, ContainerManagedField targetKeyField) throws CompilationException {
        String targetTable = this.getTable().getName();
        EntityBeanDescriptor targetDescriptor = this.getDescriptorForBean(targetBeanName);
        StringBuffer buffer = new StringBuffer();
        this.createSelectClause(buffer, targetDescriptor, targetKeyField, tableNames);
        if (this.isAssociationTableUsed()) {
            this.completeQueryWithJoin(buffer, targetDescriptor, targetTable, targetKeyField);
        } else {
            this.completeQueryWithoutJoin(buffer, targetDescriptor, targetTable, tableNames);
        }
        this.preparePessLockingStatement(buffer);
        buffer.append("\");\n");
        return buffer.toString();
    }

    private void preparePessLockingStatement(StringBuffer buffer) {
        try {
            if (this.beanCompilation.descriptor.getLockingMode() == 1) {
                DataSourceConnectionContainer connContainer = this.beanCompilation.descriptor.getDataSourceContainer(this.container);
                if (connContainer.isOracleDatabase()) {
                    buffer.append(" FOR UPDATE");
                } else if (connContainer.isDB2Database()) {
                    buffer.append(" FOR UPDATE WITH RS");
                }
            }
        }
        catch (InstantiationException e) {
            EJBDatabaseMessages.warningGetDataSourceType(this.beanCompilation.descriptor, e);
        }
    }

    private void createSelectClause(StringBuffer buffer, EntityBeanDescriptor targetDescriptor, ContainerManagedField targetKeyField, boolean tableNames) throws CompilationException {
        TableIteration tableIteration = new TableIteration();
        buffer.append("select ");
        if (this.isAssociationTableUsed() && targetKeyField != null) {
            tableNames = true;
            ORMapping mapping = (ORMapping)this.table.getTableNameContainer();
            String aTableName = mapping != null ? mapping.getTableName() : null;
            targetKeyField.appendFieldNames(buffer, tableIteration, 0, tableNames, null, aTableName);
        } else if (targetKeyField != null && !targetKeyField.isSynthetic()) {
            targetDescriptor.getPrimaryKey().appendFieldNames(buffer, tableIteration, 0, tableNames);
        }
        Iterator iterator = new ArrayList().iterator();
        if (targetDescriptor != null) {
            iterator = targetDescriptor.getContainerManagedFields().iterator();
        }
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            if (field.isSynthetic() || field.isPersistedToAssociationTable()) continue;
            field.appendFieldNames(buffer, tableIteration, 0, tableNames);
        }
        if (tableIteration.getNextPos("<dummy>", 4) == 1) {
            buffer.append(" * ");
        }
    }

    private void completeQueryWithoutJoin(StringBuffer buffer, EntityBeanDescriptor targetDescriptor, String targetTable, boolean tableNames) {
        buffer.append(" from ");
        buffer.append(targetTable);
        buffer.append(" where (");
        if (this.primaryKey.hasCompositePrimaryKeys()) {
            StringBuffer aBuffer = new StringBuffer();
            this.completeWhereClauseWithoutJoin(targetTable, this.primaryKey.getEJBReferenceField().getPropertyFields().toArray(), aBuffer);
            buffer.append(aBuffer);
            buffer.append(" )");
        } else {
            if (tableNames) {
                buffer.append(targetTable + ".");
            }
            buffer.append(this.primaryKey.getDatabaseName() + " =? )");
        }
    }

    private void completeQueryWithJoin(StringBuffer buffer, EntityBeanDescriptor targetDescriptor, String associationTable, ContainerManagedField targetKeyField) {
        String targetTable = targetDescriptor.getTableName();
        buffer.append(" from ");
        buffer.append(associationTable + ", " + targetTable);
        buffer.append(" where ");
        if (targetKeyField.hasCompositePrimaryKeys()) {
            StringBuffer aJoinBuffer = new StringBuffer();
            this.completeWhereClauseWithJoin(associationTable, targetTable, targetKeyField.getEJBReferenceField().getPropertyFields().toArray(), targetDescriptor.getPrimaryKey().getPropertyFields().toArray(), aJoinBuffer);
            buffer.append(aJoinBuffer);
            if (this.primaryKey.hasCompositePrimaryKeys()) {
                StringBuffer aBuffer = new StringBuffer();
                aBuffer.append(" and ");
                this.completeWhereClauseWithoutJoin(associationTable, this.primaryKey.getEJBReferenceField().getPropertyFields().toArray(), aBuffer);
                buffer.append(aBuffer);
            } else {
                buffer.append(" and (" + associationTable + "." + this.primaryKey.getDatabaseName() + " =? )");
            }
        } else {
            buffer.append("(");
            buffer.append(associationTable + "." + targetKeyField.getDatabaseName() + " =");
            buffer.append(targetTable + "." + targetDescriptor.getPrimaryKey().getDatabaseName() + ")");
            if (this.primaryKey != null && this.primaryKey.hasCompositePrimaryKeys()) {
                Object[] targetPrimaryKey = this.primaryKey.getEJBReferenceField().getPropertyFields().toArray();
                for (int i = 0; i < targetPrimaryKey.length; ++i) {
                    buffer.append("and");
                    buffer.append("(" + associationTable + "." + ((ContainerManagedField)targetPrimaryKey[i]).getDatabaseName() + " =? )");
                }
            } else {
                buffer.append(" and (" + associationTable + "." + this.primaryKey.getDatabaseName() + " =? )");
            }
        }
    }

    private void completeWhereClauseWithoutJoin(String targetTable, Object[] targetPrimaryKey, StringBuffer aBuffer) {
        for (int i = 0; i < targetPrimaryKey.length; ++i) {
            if (i > 0) {
                aBuffer.append("and");
            }
            aBuffer.append("(" + targetTable + "." + ((ContainerManagedField)targetPrimaryKey[i]).getDatabaseName() + " = ?)");
        }
    }

    private void completeWhereClauseWithJoin(String associationTable, String targetTable, Object[] targetKeyField, Object[] targetPrimaryKey, StringBuffer aJoinBuffer) {
        for (int i = 0; i < targetKeyField.length; ++i) {
            if (i > 0) {
                aJoinBuffer.append("and");
            }
            aJoinBuffer.append("(" + associationTable + "." + ((ContainerManagedField)targetKeyField[i]).getDatabaseName() + " =");
            aJoinBuffer.append(targetTable + "." + ((ContainerManagedField)targetPrimaryKey[i]).getDatabaseName() + ")");
        }
    }

    private boolean isAssociationTableUsed() {
        boolean joinRequired = false;
        if (this.table.getTableNameContainer() instanceof ORMapping) {
            ORMapping mapping = (ORMapping)this.table.getTableNameContainer();
            joinRequired = mapping.isAssociateUsingThirdTable();
        }
        return joinRequired;
    }

    private EntityBeanDescriptor getDescriptorForBean(String ejbName) throws CompilationException {
        return ((EntityBeanCompilation)this.beanCompilation.compilation.getCompilation((String)ejbName)).descriptor;
    }

    public String getPreparedSelectStatementOld(boolean tableNames) throws CompilationException {
        return this.getPreparedSelectStatementOld(tableNames, null, null, false);
    }

    public String getPreparedSelectStatementOld(boolean tableNames, String stmtName, List oneToOneFields, boolean allowForUpdate) throws CompilationException {
        List uniDirectionalOneToOneFields = this.getUniDirectionalOneToOneFields(oneToOneFields);
        if (uniDirectionalOneToOneFields != null && this.getUniDirectionalOneToOneIsJoined(uniDirectionalOneToOneFields)) {
            return this.getPreparedOneToOneJoinSelectStatement(stmtName, uniDirectionalOneToOneFields, allowForUpdate);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("select ");
        TableIteration tableIteration = new TableIteration();
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            if (field.isSynthetic() || field.isPersistedToAssociationTable()) continue;
            field.appendFieldNames(buffer, tableIteration, 0, tableNames);
        }
        if (tableIteration.getNextPos("<dummy>", 4) == 1) {
            buffer.append("*");
        }
        buffer.append(" from " + this.getTable().getName() + " where (");
        tableIteration = new TableIteration();
        this.primaryKey.appendFieldNames(buffer, tableIteration, 3, tableNames);
        buffer.append(")");
        return buffer.toString();
    }

    public String appendPreparedUpdateStatementSetSource(EJBContainer container, ByteString buffer, boolean home, String statementName, String objectName, String wrapperName, String contextName, boolean storeNonRelativeFields, boolean tableNames, String dirtyVariable, String bitIteratorVariable) throws CompilationException {
        ContainerManagedField field;
        TableIteration tableIteration = new TableIteration(bitIteratorVariable);
        Iterator iterator = this.fields.iterator();
        int currentIndex = -1;
        while (iterator.hasNext()) {
            field = (ContainerManagedField)iterator.next();
            ++currentIndex;
            if (field.isSynthetic() && field.getType() != (class$java$util$Collection == null ? TableView.class$("java.util.Collection") : class$java$util$Collection) && field.getType() != (class$java$util$Set == null ? TableView.class$("java.util.Set") : class$java$util$Set)) continue;
            if (bitIteratorVariable != null) {
                buffer.append("if((" + dirtyVariable + ".get(" + currentIndex + ")) == true)\n" + "{\n" + dirtyVariable + ".clear(" + currentIndex + ");\n");
            }
            this.appendPreparedSet(buffer, home, statementName, field.getType(), tableIteration, objectName + field.getName(), field, contextName, storeNonRelativeFields);
            if (bitIteratorVariable == null) continue;
            buffer.append("}\n");
        }
        if (bitIteratorVariable != null) {
            buffer.append("if(" + bitIteratorVariable + " != 1)\n" + "{\n");
        }
        if (this.primaryKey.getPersistenceType() == 2 || this.primaryKey.getPersistenceType() == 3) {
            iterator = this.primaryKey.getPropertyFields().iterator();
            while (iterator.hasNext()) {
                field = (ContainerManagedField)iterator.next();
                this.appendPreparedSet(buffer, home, statementName, field.getType(), tableIteration, objectName + field.getName(), field, contextName, storeNonRelativeFields);
            }
        } else if (this.primaryKey.getName().startsWith("<")) {
            this.appendPreparedSet(buffer, home, statementName, this.primaryKey.getType(), tableIteration, wrapperName, this.primaryKey, contextName, storeNonRelativeFields);
        } else {
            this.appendPreparedSet(buffer, home, statementName, this.primaryKey.getType(), tableIteration, objectName + this.primaryKey.getName(), this.primaryKey, contextName, storeNonRelativeFields);
        }
        if (bitIteratorVariable != null) {
            buffer.append("}\n");
        }
        return buffer.toString();
    }

    public String appendPreparedInsertStatementSetSource(EJBContainer container, ByteString buffer, boolean home, String statementName, String objectName, String wrapperName, String contextName, boolean storeNonRelativeFields, boolean tableNames, String dirtyVariable, String bitIteratorVariable) throws CompilationException {
        TableIteration tableIteration = new TableIteration(bitIteratorVariable, true);
        Iterator iterator = null;
        if (this.primaryKey.getPersistenceType() == 2 || this.primaryKey.getPersistenceType() == 3) {
            iterator = this.primaryKey.getPropertyFields().iterator();
            while (iterator.hasNext()) {
                ContainerManagedField field = (ContainerManagedField)iterator.next();
                this.appendPreparedSet(buffer, home, statementName, field.getType(), tableIteration, objectName + field.getName(), field, contextName, storeNonRelativeFields);
            }
        } else if (this.primaryKey.getName().startsWith("<")) {
            this.appendPreparedSet(buffer, home, statementName, this.primaryKey.getType(), tableIteration, wrapperName, this.primaryKey, contextName, storeNonRelativeFields);
        } else {
            this.appendPreparedSet(buffer, home, statementName, this.primaryKey.getType(), tableIteration, objectName + this.primaryKey.getName(), this.primaryKey, contextName, storeNonRelativeFields);
        }
        iterator = this.fields.iterator();
        int currentIndex = -1;
        ByteString aCmpBuffer = new ByteString();
        while (iterator.hasNext()) {
            boolean checkDirtyFlag;
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            ++currentIndex;
            if (field.isSynthetic() && field.getType() != (class$java$util$Collection == null ? TableView.class$("java.util.Collection") : class$java$util$Collection) && field.getType() != (class$java$util$Set == null ? TableView.class$("java.util.Set") : class$java$util$Set) || field.isPersistedToAssociationTable()) continue;
            boolean bl = checkDirtyFlag = bitIteratorVariable != null && field.getPersistenceType() != 4 && field.getPersistenceType() != 8 && field.getPersistenceType() != 7;
            if (checkDirtyFlag) {
                buffer.append("if((" + dirtyVariable + ".get(" + currentIndex + ")) == true)\n" + "{\n");
                buffer.append(dirtyVariable + ".clear(" + currentIndex + ");\n");
            } else if (this.beanCompilation.descriptor.getDataSynchronizationOption().isSynchronizedAtEjbPostCreate()) {
                buffer.append(dirtyVariable + ".clear(" + currentIndex + ");\n");
            }
            this.appendPreparedSet(buffer, home, statementName, field.getType(), tableIteration, objectName + field.getName(), field, contextName, storeNonRelativeFields);
            if (!checkDirtyFlag) continue;
            buffer.append("}\n");
        }
        return buffer.toString();
    }

    public void appendPreparedSet(ByteString buffer, boolean home, String statementName, Class propertyType, TableIteration iteration, String variableName, ContainerManagedField field, String entityContextName, boolean storeNonRelativeFields) throws CompilationException {
        this.appendPreparedSet(buffer, home, statementName, propertyType, iteration, variableName, field, entityContextName, storeNonRelativeFields, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void appendPreparedSet(ByteString buffer, boolean home, String statementName, Class propertyType, TableIteration iteration, String variableName, ContainerManagedField field, String entityContextName, boolean storeNonRelativeFields, boolean defineColumnType) throws CompilationException {
        if (variableName.indexOf(32) >= 0 && !variableName.startsWith("(")) {
            if (!new File("..\\emd-ejb.jar").exists()) throw new CompilationException("Variable contained illegal space for field '" + field.getName() + "': '" + variableName + "'");
            new Throwable().printStackTrace();
            throw new CompilationException("Variable contained illegal space for field '" + field.getName() + "': '" + variableName + "'");
        }
        if (field.getPersistenceManager() != null) {
            if (!storeNonRelativeFields) {
                return;
            }
            String varName = this.beanCompilation.getFieldPersistenceManagerReference(field.getCompoundName());
            Map names = field.getPersistenceManager().getColumns();
            int firstPos = -1;
            if (names != null) {
                Iterator iterator = names.keySet().iterator();
                while (iterator.hasNext()) {
                    if (firstPos < 0) {
                        firstPos = iteration.getNextPos(iterator.next().toString(), 1);
                        continue;
                    }
                    iteration.getNextPos(iterator.next().toString(), 1);
                }
            }
            if (field.getType().isPrimitive()) {
                Class type = field.getType();
                boolean hasPrimitiveGetter = false;
                try {
                    Method method = field.getPersistenceManager().getClass().getMethod("set", PreparedStatement.class, Integer.TYPE, field.getType());
                    if (type.isAssignableFrom(method.getReturnType())) {
                        hasPrimitiveGetter = true;
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (hasPrimitiveGetter) {
                    buffer.append(this.beanCompilation.home.getName() + "." + varName + ".set(" + statementName + ", " + firstPos + ", " + variableName + ");\n");
                    return;
                } else if (type == Boolean.TYPE) {
                    buffer.append(this.beanCompilation.home.getName() + "." + varName + ".set(" + statementName + ", " + firstPos + ", " + variableName + " ? Boolean.TRUE : Boolean.FALSE);\n");
                    return;
                } else if (type == Byte.TYPE) {
                    buffer.append(this.beanCompilation.home.getName() + "." + varName + ".set(" + statementName + ", " + firstPos + ", new Byte(" + variableName + "));\n");
                    return;
                } else if (type == Short.TYPE) {
                    buffer.append(this.beanCompilation.home.getName() + "." + varName + ".set(" + statementName + ", " + firstPos + ", new Short(" + variableName + "));\n");
                    return;
                } else if (type == Character.TYPE) {
                    buffer.append(this.beanCompilation.home.getName() + "." + varName + ".set(" + statementName + ", " + firstPos + ", new Character(" + variableName + "));\n");
                    return;
                } else if (type == Integer.TYPE) {
                    buffer.append(this.beanCompilation.home.getName() + "." + varName + ".set(" + statementName + ", " + firstPos + ", new Integer(" + variableName + "));\n");
                    return;
                } else if (type == Float.TYPE) {
                    buffer.append(this.beanCompilation.home.getName() + "." + varName + ".set(" + statementName + ", " + firstPos + ", new Float(" + variableName + "));\n");
                    return;
                } else if (type == Long.TYPE) {
                    buffer.append(this.beanCompilation.home.getName() + "." + varName + ".set(" + statementName + ", " + firstPos + ", new Long(" + variableName + "));\n");
                    return;
                } else {
                    if (type != Double.TYPE) throw new InternalError("Unsupported type: " + type);
                    buffer.append(this.beanCompilation.home.getName() + "." + varName + ".set(" + statementName + ", " + firstPos + ", new Double(" + variableName + "));\n");
                }
                return;
            }
            buffer.append(this.beanCompilation.home.getName() + "." + varName + ".set(" + statementName + ", " + firstPos + ", " + variableName + ");\n");
            return;
        }
        switch (field.getPersistenceType()) {
            case 2: {
                ContainerManagedField propertyField;
                if (!storeNonRelativeFields) {
                    return;
                }
                buffer.append("{\n");
                buffer.append("if(" + variableName + " == null)\n" + "{\n");
                int lastPos = iteration.getCurrentPos();
                List lastFields = iteration.getUsedNames();
                Iterator iterator = field.getPropertyFields().iterator();
                while (iterator.hasNext()) {
                    propertyField = (ContainerManagedField)iterator.next();
                    try {
                        Class<?> nonNativeType = Class.forName(ClassUtils.getNonPrimitiveName(propertyField.getType().getName()), true, propertyField.getType().getClassLoader());
                        this.appendPreparedSet(buffer, home, statementName, nonNativeType, iteration, "((" + ClassUtils.getSourceNotation(nonNativeType, 0) + ")null)", propertyField, entityContextName, true);
                    }
                    catch (ClassNotFoundException e) {
                        throw new CompilationException("Internal error, class not found: " + e.getMessage());
                    }
                }
                buffer.append("}\nelse\n{\n");
                iteration.setCurrentPos(lastPos, lastFields);
                iterator = field.getPropertyFields().iterator();
                while (iterator.hasNext()) {
                    propertyField = (ContainerManagedField)iterator.next();
                    this.appendPreparedSet(buffer, home, statementName, propertyField.getType(), iteration, variableName + "." + propertyField.getPropertyDescriptor().getReadMethod().getName() + "()", propertyField, entityContextName, true);
                }
                buffer.append("}\n");
                buffer.append("}\n");
                return;
            }
            case 3: {
                ContainerManagedField propertyField;
                if (!storeNonRelativeFields) {
                    return;
                }
                buffer.append("{\n");
                buffer.append("if(" + variableName + " == null)\n" + "{\n");
                int lastPos = iteration.getCurrentPos();
                List lastFields = iteration.getUsedNames();
                Iterator iterator = field.getPropertyFields().iterator();
                while (iterator.hasNext()) {
                    propertyField = (ContainerManagedField)iterator.next();
                    try {
                        Class<?> nonNativeType = Class.forName(ClassUtils.getNonPrimitiveName(propertyField.getType().getName()), true, propertyField.getType().getClassLoader());
                        this.appendPreparedSet(buffer, home, statementName, nonNativeType, iteration, "((" + ClassUtils.getSourceNotation(nonNativeType, 0) + ")null)", propertyField, entityContextName, true);
                    }
                    catch (ClassNotFoundException e) {
                        throw new CompilationException("Internal error, class not found: " + e.getMessage());
                    }
                }
                iteration.setCurrentPos(lastPos, lastFields);
                buffer.append("}\nelse\n{\n");
                iterator = field.getPropertyFields().iterator();
                while (iterator.hasNext()) {
                    propertyField = (ContainerManagedField)iterator.next();
                    this.appendPreparedSet(buffer, home, statementName, propertyField.getType(), iteration, variableName + "." + propertyField.getFieldDescriptor().getName(), propertyField, entityContextName, true);
                }
                buffer.append("}\n");
                buffer.append("}\n");
                return;
            }
            case 7: {
                buffer.append("if(!(" + variableName + " instanceof ORSet))\n" + "{\n" + "java.util.Collection oldSet = " + variableName + ";\n" + variableName + " = new " + field.getORMapping().getWrapperName() + "(" + entityContextName + ");\n" + "((" + field.getORMapping().getWrapperName() + ")" + variableName + ").deleteEntries(connection);\n" + "if(oldSet != null) " + variableName + ".addAll(oldSet);\n" + "}\n");
                buffer.append("if(((ORSet)" + variableName + ").isDirty()) ((ORSet)" + variableName + ").persist(connection);\n");
                return;
            }
            case 8: {
                buffer.append("if(!(" + variableName + " instanceof ORCollection))\n" + "{\n" + "java.util.Collection oldCollection = " + variableName + ";\n" + variableName + " = new " + field.getORMapping().getWrapperName() + "(" + entityContextName + ");\n" + "((" + field.getORMapping().getWrapperName() + ")" + variableName + ").deleteEntries(connection);\n" + "if(oldCollection != null) " + variableName + ".addAll(oldCollection);\n" + "}\n");
                buffer.append("if(((ORCollection)" + variableName + ").isDirty()) ((ORCollection)" + variableName + ").persist(connection);\n");
                return;
            }
            case 4: {
                if (!storeNonRelativeFields) {
                    return;
                }
                if (field.isPersistedToAssociationTable()) {
                    return;
                }
                buffer.append("try\n{\n");
                EntityBeanDescriptor descriptor = (EntityBeanDescriptor)this.container.getBeanByLocation(field.getEJBReferenceHome());
                Class primaryKeyClass = descriptor.getRuntimePrimaryKeyClass();
                String primaryKeyVar = "primaryKey" + ClassCompilation.getNextID();
                boolean hasRemoteException = false;
                if (!EJBLocalObject.class.isAssignableFrom(field.getType())) {
                    try {
                        Method method = field.getType().getMethod("getPrimaryKey", ClassUtils.CLASS_NOARGS);
                        if (method != null && ClassUtils.containsType(method.getExceptionTypes(), RemoteException.class)) {
                            hasRemoteException = true;
                        }
                    }
                    catch (NoSuchMethodException e) {
                        throw new CompilationException("Invalid entity reference type: " + field.getType().getName());
                    }
                }
                buffer.append(ClassUtils.getSourceNotation(primaryKeyClass, 0) + " " + primaryKeyVar + ";\n");
                String remoteExceptionVariable = null;
                if (hasRemoteException) {
                    remoteExceptionVariable = "__pkre" + ClassCompilation.getNextID();
                    buffer.append("try\n{\n");
                }
                buffer.append(primaryKeyVar + " = " + variableName + " == null ? " + ClassUtils.getDefaultValue(primaryKeyClass) + " : ");
                buffer.append(ClassUtils.getConvertSource("((" + descriptor.getRuntimePrimaryKeyClassName() + ")" + variableName + ".getPrimaryKey())", primaryKeyClass, primaryKeyClass));
                buffer.append(";\n");
                if (hasRemoteException) {
                    buffer.append("}\ncatch(java.rmi.RemoteException " + remoteExceptionVariable + ")\n" + "{\n" + "throw new java.sql.SQLException(" + remoteExceptionVariable + ".toString());\n" + "}\n");
                }
                this.appendPreparedSet(buffer, home, statementName, primaryKeyClass, iteration, primaryKeyVar, field.getEJBReferenceField(), entityContextName, true);
                buffer.append("}\nfinally\n{\n}\n");
                return;
            }
            case 1: {
                if (!storeNonRelativeFields) {
                    return;
                }
                TableView.appendPreparedSet(buffer, home, statementName, propertyType, iteration, variableName, field.getDatabaseName(), field);
                return;
            }
            case -1: {
                return;
            }
            default: {
                throw new CompilationException("Unknown persistence-type: " + field.getPersistenceType());
            }
        }
    }

    private static void appendPreparedSet(ByteString buffer, boolean home, String statementName, Class propertyType, TableIteration tableIteration, String variableName, String fieldName, ContainerManagedField _field) {
        if ((_field.isShared() || tableIteration.contains(fieldName, 1)) && (_field.isPersistedToAssociationTable() && !home || tableIteration.isInsert())) {
            return;
        }
        String iteratorVariable = tableIteration.getIterationVariable();
        String fieldID = null;
        if (iteratorVariable != null) {
            fieldID = iteratorVariable + "++";
            if (tableIteration.isInsert()) {
                tableIteration.getNextPos(fieldName, 1);
            }
        } else {
            fieldID = tableIteration.contains(fieldName, 1) && !_field.isPersistedToAssociationTable() && !home ? String.valueOf(tableIteration.getUsedNameSizePlusNetPos(fieldName, 1)) : String.valueOf(tableIteration.getNextPos(fieldName, 1));
        }
        if (propertyType == EntityContext.class) {
            return;
        }
        if (propertyType == Integer.TYPE) {
            buffer.append(statementName + ".setInt(" + fieldID + ", " + variableName + ");\n");
        } else if (propertyType == Character.TYPE) {
            buffer.append("com.evermind.server.ejb.EJBUtils.setChar(" + statementName + ", " + fieldID + ", " + variableName + ");\n");
        } else if (propertyType == Short.TYPE) {
            buffer.append(statementName + ".setShort(" + fieldID + ", " + variableName + ");\n");
        } else if (propertyType == Long.TYPE) {
            buffer.append(statementName + ".setLong(" + fieldID + ", " + variableName + ");\n");
        } else if (propertyType == Float.TYPE) {
            buffer.append(statementName + ".setFloat(" + fieldID + ", " + variableName + ");\n");
        } else if (propertyType == Double.TYPE) {
            buffer.append(statementName + ".setDouble(" + fieldID + ", " + variableName + ");\n");
        } else if (propertyType == Byte.TYPE) {
            buffer.append(statementName + ".setByte(" + fieldID + ", " + variableName + ");\n");
        } else if (propertyType == Boolean.TYPE) {
            buffer.append(statementName + ".setBoolean(" + fieldID + ", " + variableName + ");\n");
        } else if (propertyType == String.class) {
            if (_field.getColumnType() != null && _field.getColumnType().equalsIgnoreCase("NVARCHAR2")) {
                String str1 = fieldID;
                int idx = str1.indexOf("++");
                if (idx != -1) {
                    str1 = str1.substring(0, idx);
                }
                buffer.append("if(((com.evermind.server.ejb.DataSourceConnection) connection).getConnection() instanceof oracle.jdbc.internal.OracleConnection)\n");
                buffer.append("((oracle.jdbc.OraclePreparedStatement)" + statementName + ").setFormOfUse(" + str1 + ",oracle.jdbc.OraclePreparedStatement.FORM_NCHAR);\n");
            }
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + fieldID + ", java.sql.Types.VARCHAR);\n");
            if (_field.getColumnType() != null && _field.getColumnType().equalsIgnoreCase("CLOB")) {
                TableView.appendGetClob(buffer, statementName, fieldID, variableName, _field.getLobVariableName());
            } else {
                buffer.append("else " + statementName + ".setString(" + fieldID + ", " + variableName + ");\n");
            }
        } else if (propertyType == java.util.Date.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + fieldID + ", java.sql.Types.TIMESTAMP);\n");
            buffer.append("else " + statementName + ".setTimestamp(" + fieldID + ", new java.sql.Timestamp(" + variableName + ".getTime()));\n");
        } else if (propertyType == InternetAddress.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + fieldID + ", java.sql.Types.VARCHAR);\n");
            buffer.append("else " + statementName + ".setString(" + fieldID + ", " + variableName + ".getAddress());\n");
        } else if (propertyType == Timestamp.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + fieldID + ", java.sql.Types.TIMESTAMP);\n");
            buffer.append("else " + statementName + ".setTimestamp(" + fieldID + ", " + variableName + ");\n");
        } else if (propertyType == Time.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + fieldID + ", java.sql.Types.TIME);\n");
            buffer.append("else " + statementName + ".setTime(" + fieldID + ", " + variableName + ");\n");
        } else if (propertyType == Date.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + fieldID + ", java.sql.Types.DATE);\n");
            buffer.append("else " + statementName + ".setDate(" + fieldID + ", " + variableName + ");\n");
        } else if (propertyType == Locale.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + fieldID + ", java.sql.Types.VARCHAR);\n");
            buffer.append("else " + statementName + ".setString(" + fieldID + ", com.evermind.util.ObjectUtils.toString(" + variableName + "));\n");
        } else if (propertyType == BigDecimal.class) {
            buffer.append(statementName + ".setBigDecimal(" + fieldID + ", " + variableName + ");\n");
        } else if (propertyType == Blob.class) {
            buffer.append(statementName + ".setBlob(" + fieldID + ", " + variableName + ");\n");
        } else if (propertyType == Clob.class) {
            buffer.append(statementName + ".setClob(" + fieldID + ", " + variableName + ");\n");
        } else if (propertyType == BigInteger.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + fieldID + ", java.sql.Types.VARCHAR);\n");
            buffer.append("else " + statementName + ".setString(" + fieldID + ", " + variableName + ".toString());\n");
        } else if (propertyType == Integer.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + fieldID + ", java.sql.Types.BIGINT);\n");
            buffer.append("else " + statementName + ".setInt(" + fieldID + ", " + variableName + ".intValue());\n");
        } else if (propertyType == Character.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + fieldID + ", java.sql.Types.CHAR);\n");
            buffer.append("else com.evermind.server.ejb.EJBUtils.setChar(" + statementName + ", " + fieldID + ", " + variableName + " == null ? (char)0 : " + variableName + ".charValue());\n");
        } else if (propertyType == Short.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + fieldID + ", java.sql.Types.INTEGER);\n");
            buffer.append("else " + statementName + ".setShort(" + fieldID + ", " + variableName + ".shortValue());\n");
        } else if (propertyType == Long.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + fieldID + ", java.sql.Types.BIGINT);\n");
            buffer.append("else " + statementName + ".setLong(" + fieldID + ", " + variableName + ".longValue());\n");
        } else if (propertyType == Float.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + fieldID + ", java.sql.Types.FLOAT);\n");
            buffer.append("else " + statementName + ".setFloat(" + fieldID + ", " + variableName + ".floatValue());\n");
        } else if (propertyType == Double.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + fieldID + ", java.sql.Types.DOUBLE);\n");
            buffer.append("else " + statementName + ".setDouble(" + fieldID + ", " + variableName + ".doubleValue());\n");
        } else if (propertyType == Byte.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + fieldID + ", java.sql.Types.SMALLINT);\n");
            buffer.append("else " + statementName + ".setByte(" + fieldID + ", " + variableName + ".byteValue());\n");
        } else if (propertyType == Boolean.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + fieldID + ", java.sql.Types.BIT);\n");
            buffer.append("else " + statementName + ".setBoolean(" + fieldID + ", " + variableName + ".booleanValue());\n");
        } else if (propertyType == [B.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + fieldID + ", java.sql.Types.LONGVARBINARY);\n");
            if (_field.getColumnType() != null && _field.getColumnType().equalsIgnoreCase("BLOB")) {
                TableView.appendGetBlob(buffer, statementName, fieldID, variableName, _field.getLobVariableName());
            } else {
                buffer.append("else " + statementName + ".setBinaryStream(" + fieldID + ", new java.io.ByteArrayInputStream(" + variableName + "), " + variableName + ".length);\n");
            }
        } else if (propertyType == [C.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + fieldID + ", java.sql.Types.LONGVARCHAR);\n");
            if (_field.getColumnType() != null && _field.getColumnType().equalsIgnoreCase("CLOB")) {
                TableView.appendGetClob(buffer, statementName, fieldID, "String.copyValueOf(" + variableName + ")", _field.getLobVariableName());
            } else {
                buffer.append("else " + statementName + ".setCharacterStream(" + fieldID + ", new java.io.CharArrayReader(" + variableName + "), " + variableName + ".length);\n");
            }
        } else {
            buffer.append("EntityEJBObject.storeObject(" + statementName + ", " + fieldID + ", " + variableName + ");\n");
        }
    }

    private static void appendGetBlob(ByteString _buffer, String _statementName, String _fieldID, String _objectVarName, String _lobVarName) {
        _buffer.append("else { \n// tchou: ORACLE specific !!\n" + _lobVarName + " = oracle.sql.BLOB.createTemporary(((com.evermind.server.ejb.DataSourceConnection) connection).getConnection(), false, oracle.sql.BLOB.DURATION_SESSION);\n" + _lobVarName + ".putBytes(1, " + _objectVarName + ");\n" + _statementName + ".setBlob(" + _fieldID + ", " + _lobVarName + ");\n" + "}\n");
    }

    private static void appendGetClob(ByteString _buffer, String _statementName, String _fieldID, String _objectVarName, String _lobVarName) {
        _buffer.append("else { \n// tchou: ORACLE specific !!\n" + _lobVarName + " = oracle.sql.CLOB.createTemporary(((com.evermind.server.ejb.DataSourceConnection) connection).getConnection(), false, oracle.sql.CLOB.DURATION_SESSION);\n" + _lobVarName + ".putString(1, " + _objectVarName + ");\n" + _statementName + ".setClob(" + _fieldID + ", " + _lobVarName + ");\n" + "}\n");
    }

    public ContainerManagedField getPrimaryKey() {
        return this.primaryKey;
    }

    public int getFieldCount(boolean includeKey) {
        int count = 0;
        if (includeKey) {
            count += this.primaryKey.getDatabaseFieldCount();
        }
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            if (field.isSynthetic() || field.isPersistedToAssociationTable()) continue;
            count += field.getDatabaseFieldCount();
        }
        return count;
    }

    public ContainerManagedField getField(String name) {
        if (this.fields != null) {
            Iterator iterator = this.fields.iterator();
            while (iterator.hasNext()) {
                ContainerManagedField field = (ContainerManagedField)iterator.next();
                if (!field.getName().equals(name)) continue;
                return field;
            }
        }
        return null;
    }

    private void addField(ContainerManagedField field, ArraySet allFields) {
        switch (field.getPersistenceType()) {
            case 2: 
            case 3: {
                Iterator iterator = field.getPropertyFields().iterator();
                while (iterator.hasNext()) {
                    ContainerManagedField innerField = (ContainerManagedField)iterator.next();
                    this.addField(innerField, allFields);
                }
                break;
            }
            case -1: 
            case 7: 
            case 8: {
                allFields.add(field);
                break;
            }
            case 4: {
                this.addField(field.getEJBReferenceField(), allFields);
                break;
            }
            default: {
                allFields.add(field);
            }
        }
    }

    public ContainerManagedField getColumn(String name) {
        ContainerManagedField field;
        int count = 0;
        if (this.allfields == null) {
            this.allfields = new ArraySet();
            if (this.primaryKey != null) {
                this.addField(this.primaryKey, this.allfields);
                count = this.primaryKey.getDatabaseFieldCount();
            }
            Iterator iterator = this.fields.iterator();
            while (iterator.hasNext()) {
                field = (ContainerManagedField)iterator.next();
                count += field.getDatabaseFieldCount();
                this.addField(field, this.allfields);
            }
        }
        Iterator iter = this.allfields.iterator();
        while (iter.hasNext()) {
            field = (ContainerManagedField)iter.next();
            if (!field.getDatabaseName().equalsIgnoreCase(name)) continue;
            return field;
        }
        return null;
    }

    public Vector flattenCMPFields(ContainerManagedField field) {
        Vector<Cloneable> v = new Vector<Cloneable>();
        if (field.getPersistenceType() == 2 || field.getPersistenceType() == 3) {
            Iterator iterator = field.getPropertyFields().iterator();
            while (iterator.hasNext()) {
                ContainerManagedField internalField = (ContainerManagedField)iterator.next();
                if (internalField.getPersistenceType() == 2 || internalField.getPersistenceType() == 3 || internalField.getPersistenceType() == 4) {
                    v.add(this.flattenCMPFields(internalField));
                    continue;
                }
                v.add(internalField);
            }
        } else if (field.getPersistenceType() == 4) {
            ContainerManagedField ejbRefField = field.getEJBReferenceField();
            v.add(ejbRefField);
        }
        return v;
    }

    public void getDefinedColumnTypes(StringBuffer buffer, boolean tableNames, String stmtName, Set fields) throws CompilationException {
        if (!DEFINE_COLUMN_TYPE) {
            buffer.append("\");\n");
            return;
        }
        TableIteration tableIteration = new TableIteration();
        Iterator iterator = fields.iterator();
        int loop = 1;
        while (iterator.hasNext()) {
            if (loop == 1) {
                buffer.append("\");\n");
                buffer.append("if(!" + stmtName + "Cached.get()){\n");
                buffer.append("\ttry\n\t{\n");
                buffer.append("((oracle.jdbc.OracleStatement)" + stmtName + ").setFetchSize(5);");
            }
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            Vector v = null;
            if (field.getPersistenceType() == 2 || field.getPersistenceType() == 3 || field.getPersistenceType() == 4) {
                v = this.flattenCMPFields(field);
            }
            try {
                if (v == null) {
                    String dbType = field.getDefinedType();
                    if (dbType != null && (dbType.equalsIgnoreCase("Types.VARCHAR") || dbType.equalsIgnoreCase("Types.CHAR") || dbType.equalsIgnoreCase("Types.NVARCHAR") || dbType.equalsIgnoreCase("Types.NCHAR"))) {
                        if (field.getColumnType().equalsIgnoreCase("CHAR")) {
                            dbType = "Types.CHAR";
                        }
                        if (field.getColumnLength() != -1) {
                            buffer.append("((oracle.jdbc.OracleStatement)" + stmtName + ").defineColumnTypeChars(" + loop + ", " + dbType);
                            buffer.append(", " + field.getColumnLength());
                        } else {
                            buffer.append("((oracle.jdbc.OracleStatement)" + stmtName + ").defineColumnType(" + loop + ", " + dbType);
                        }
                    } else {
                        buffer.append("((oracle.jdbc.OracleStatement)" + stmtName + ").defineColumnType(" + loop + ", " + dbType);
                    }
                    buffer.append(");\n");
                    ++loop;
                    continue;
                }
                Enumeration e = v.elements();
                while (e.hasMoreElements()) {
                    ContainerManagedField internalField = (ContainerManagedField)e.nextElement();
                    String dbType = internalField.getDefinedType();
                    if (dbType != null && (dbType.equalsIgnoreCase("Types.VARCHAR") || dbType.equalsIgnoreCase("Types.CHAR") || dbType.equalsIgnoreCase("Types.NVARCHAR") || dbType.equalsIgnoreCase("Types.NCHAR"))) {
                        if (internalField.getColumnType().equalsIgnoreCase("CHAR")) {
                            dbType = "Types.CHAR";
                        }
                        if (internalField.getColumnLength() != -1) {
                            buffer.append("((oracle.jdbc.OracleStatement)" + stmtName + ").defineColumnTypeChars(" + loop + ", " + dbType);
                            buffer.append(", " + internalField.getColumnLength());
                        } else {
                            buffer.append("((oracle.jdbc.OracleStatement)" + stmtName + ").defineColumnType(" + loop + ", " + dbType);
                        }
                    } else {
                        buffer.append("((oracle.jdbc.OracleStatement)" + stmtName + ").defineColumnType(" + loop + ", " + dbType);
                    }
                    buffer.append(");\n");
                    ++loop;
                }
            }
            catch (NullPointerException exc) {
                System.err.println("Field " + field.getDatabaseName() + " " + field.getColumnType() + ":" + field.getType() + " Does not exist");
            }
        }
        if (loop == 1 && fields.size() == 0) {
            buffer.append("\");\n");
        } else {
            buffer.append("}catch(java.lang.ClassCastException cle){\n");
            buffer.append("}catch(java.sql.SQLException sqle) { System.err.println(\"Warning: \" + sqle + \" Flag=\" + " + stmtName + "Cached.get()); sqle.printStackTrace();}\n");
        }
        buffer.append("} // end if(!" + stmtName + "Cached){\n");
    }
}

