/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.ORMapping;
import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class CollectionORMapping
extends ORMapping {
    public CollectionORMapping(ContainerManagedField orField, int type) {
        super(orField, type);
    }

    public CollectionORMapping(Node parent, ContainerManagedField orField, int type, EJBPackage ejbPackage) throws InstantiationException {
        super(parent, orField, type, ejbPackage);
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        String typeName = this.orField.getPersistenceType() == 7 ? "set" : "collection";
        out.print(indention + "<" + typeName + "-mapping");
        out.println(" table=\"" + XMLUtils.encode(this.getTableName()) + "\">");
        if (this.keyField != null) {
            out.println(indention + "\t<primkey-mapping>");
            this.keyField.writeOrionXML(out, indention + "\t\t");
            out.println(indention + "\t</primkey-mapping>");
        }
        if (this.valueField != null) {
            out.print(indention + "\t<value-mapping type=\"" + XMLUtils.encode(this.typeName) + '\"');
            if (this.getPersistenceType() == 7) {
                if (!this.isValueImmutable()) {
                    out.print(" immutable=\"false\"");
                }
            } else if (this.isValueImmutable()) {
                out.print(" immutable=\"true\"");
            }
            out.println(">");
            this.valueField.writeOrionXML(out, indention + "\t\t");
            out.println(indention + "\t</value-mapping>");
        }
        out.println(indention + "</" + typeName + "-mapping>");
    }

    public String getWrapperName() {
        return this.compilation.getName();
    }
}

