/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.FieldPersistenceManager;
import com.evermind.server.ejb.database.DatabaseSchema;
import com.evermind.server.ejb.database.TableIteration;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.CollectionORMapping;
import com.evermind.server.ejb.deployment.EJBDeploymentContext;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.EJBRelationshipRole;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.InvalidEJBAssemblyException;
import com.evermind.server.ejb.deployment.ORMapping;
import com.evermind.server.ejb.deployment.ORNameMapper;
import com.evermind.server.ejb.deployment.OneToOneOptionDescriptor;
import com.evermind.server.ejb.deployment.PrimaryKeyContext;
import com.evermind.server.ejb.deployment.RoleSource;
import com.evermind.util.AbstractDescribable;
import com.evermind.util.ClassUtils;
import com.evermind.util.StringUtils;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.mail.internet.InternetAddress;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContainerManagedField
extends AbstractDescribable
implements XMLizable,
Cloneable,
Comparable {
    public static final int APPENDMODE_NAME = 0;
    public static final int APPENDMODE_QUESTIONMARK = 1;
    public static final int APPENDMODE_SETTER = 2;
    public static final int APPENDMODE_SETTER_AND = 3;
    public static final int APPENDMODE_DEFINED_COLUMN = 4;
    public static final byte PERSISTENCE_NONE = -1;
    public static final byte PERSISTENCE_DEFAULT = 0;
    public static final byte PERSISTENCE_SERIALIZED = 1;
    public static final byte PERSISTENCE_PROPERTIES = 2;
    public static final byte PERSISTENCE_FIELDS = 3;
    public static final byte PERSISTENCE_ENTITY_REFERENCE = 4;
    public static final byte PERSISTENCE_SET = 7;
    public static final byte PERSISTENCE_COLLECTION = 8;
    private ContainerManagedField parent;
    private String databaseColumnAlias;
    private boolean initialized = false;
    private DatabaseSchema schema;
    private ORNameMapper nameMapper;
    private Class type;
    private byte persistenceType;
    private byte explicitPersistenceType;
    private String databaseName;
    private String databaseType;
    private int columnLength;
    private String columnType;
    private ORMapping orMapping;
    private ContainerManagedField ejbReferenceField;
    private SortedSet propertyFields;
    private Field fieldDescriptor;
    private PropertyDescriptor propertyDescriptor;
    private String ejbReferenceHome;
    private PrimaryKeyContext owner;
    private EJBRelationshipRole relationshipRole;
    private EJBRelationshipRole peer;
    private FieldPersistenceManager persistenceManager;
    private boolean shared = false;
    private boolean lazyLoading;
    private Boolean isCompoundPKeyFieldFlag = null;
    private OneToOneOptionDescriptor oneToOneOption = new OneToOneOptionDescriptor(0);
    private boolean isOCA = false;
    private boolean defined_from_cmp_field = false;

    public ContainerManagedField(ContainerManagedField parentField, PrimaryKeyContext owner, String name, ORMapping anORMapping) {
        this(parentField, owner, name);
        this.orMapping = anORMapping;
    }

    public ContainerManagedField(ContainerManagedField parentField, PrimaryKeyContext owner, String name) {
        this.parent = parentField;
        this.owner = owner;
        this.columnLength = -1;
        this.columnType = null;
        if (name == null) {
            this.setName("");
        } else {
            this.setName(name);
        }
    }

    public ContainerManagedField(ContainerManagedField parentField, PrimaryKeyContext owner, Node parent, boolean _defined_from_cmp_field) throws InstantiationException {
        this(parentField, owner, parent);
        this.defined_from_cmp_field = true;
    }

    public ContainerManagedField(ContainerManagedField parentField, PrimaryKeyContext owner, Node parent) throws InstantiationException {
        this.parent = parentField;
        this.owner = owner;
        this.columnLength = -1;
        this.columnType = null;
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            String value = XMLUtils.getStringValue(node);
            if (name.equals("field-name")) {
                this.setName(value);
                continue;
            }
            if (name.equals("description")) {
                this.setDescription(value);
                continue;
            }
            throw new InvalidEJBAssemblyException("Illegal cmp-field subtag: " + name, "22.5");
        }
        if (this.getName() == null) {
            throw new InvalidEJBAssemblyException("cmp-field tag with missing field-name subtag", "22.5");
        }
    }

    public boolean isTrueCmp() {
        return this.defined_from_cmp_field;
    }

    public boolean isOneToOne() {
        return this.getPeer() != null && !this.getPeer().isMany() && !this.getPeer().getPeer().isMany() && this.getPeer().getRelation() != null;
    }

    public boolean isOneToMany_Many() {
        return this.getPeer() != null && !this.getPeer().isMany() && this.getPeer().getPeer().isMany() && this.getPeer().getRelation() != null;
    }

    public boolean isOneToMany_One() {
        return this.getPeer() != null && this.getPeer().isMany() && !this.getPeer().getPeer().isMany() && this.getPeer().getRelation() != null;
    }

    public boolean isManyToMany() {
        return this.getPeer() != null && this.getPeer().isMany() && this.getPeer().getPeer().isMany() && this.getPeer().getRelation() != null;
    }

    public boolean isCMR() {
        return this.relationshipRole != null;
    }

    public boolean isCMRPK() {
        return this.isCMR() && this.getOwner().getPrimaryKey().containsFieldMappedWith(this.getDatabaseName());
    }

    public boolean isCompositePrimaryKey() {
        return this.isPrimaryKey() && this.propertyFields != null && !this.propertyFields.isEmpty();
    }

    public boolean isPrimaryKey() {
        ContainerManagedField primaryKey = this.getEntity().getPrimaryKey();
        if (primaryKey == this) {
            return true;
        }
        if (primaryKey.getPropertyFields() != null) {
            Iterator keyIter = primaryKey.getPropertyFields().iterator();
            while (keyIter.hasNext()) {
                ContainerManagedField compoundPKField = (ContainerManagedField)keyIter.next();
                if (compoundPKField != this) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBiDirectional() {
        return this.getPeer() != null && !this.getPeer().getRelation().isSynthetic() && !this.getPeer().getPeer().getRelation().isSynthetic() && this.getPeer().getRelation() != null;
    }

    public boolean isUniDirectional() {
        return this.getPeer() != null && (this.getPeer().getRelation().isSynthetic() || this.getPeer().getPeer().getRelation().isSynthetic()) && this.getPeer().getRelation() != null;
    }

    public boolean isMasterInUniDirectional() {
        return this.getPeer() != null && this.getPeer().getRelation().isSynthetic() && !this.getPeer().getPeer().getRelation().isSynthetic() && this.getPeer().getRelation() != null;
    }

    public boolean isSlaveInUniDirectional() {
        return this.getPeer() != null && !this.getPeer().getRelation().isSynthetic() && this.getPeer().getPeer().getRelation().isSynthetic() && this.getPeer().getRelation() != null;
    }

    public boolean isAutomaticIdentity() {
        return this.getEntity().isAutomaticIdentity() && this.getEntity().getPrimaryKey() == this;
    }

    public void setName(String name) {
        super.setName(name);
    }

    public void checkName(DatabaseSchema schema) {
        if (this.databaseName != null) {
            while (!schema.isValid(this.databaseName)) {
                this.setDatabaseName(this.databaseName + "_");
            }
        }
    }

    private String getValueTypeName(ContainerManagedField field) {
        String valueTypeName = null;
        PrimaryKeyContext context = field.getContext();
        if (context instanceof EntityBeanDescriptor) {
            valueTypeName = ((EntityBeanDescriptor)context).getLocalInterfaceName() != null ? ((EntityBeanDescriptor)context).getLocalInterfaceName() : ((EntityBeanDescriptor)context).getRemoteInterfaceName();
        }
        return valueTypeName;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void init(EJBDeploymentContext container, DatabaseSchema schema, Class parentType, Class type) throws InstantiationException {
        this.init(container, null, schema, parentType, type);
    }

    public void init(EJBDeploymentContext container, ORNameMapper nameMapper, DatabaseSchema schema, Class parentType, Class type) throws InstantiationException {
        block53: {
            block52: {
                if (this.initialized) {
                    return;
                }
                this.type = type;
                this.schema = schema;
                this.nameMapper = nameMapper;
                this.peer = this.getPeer();
                EntityBeanDescriptor entity = this.getEntity();
                this.initializeDatabaseName(container);
                if (this.persistenceType == 0 && this.databaseType == null) {
                    if ((EJBObject.class.isAssignableFrom(this.type) || EJBLocalObject.class.isAssignableFrom(this.type)) && container != null) {
                        this.persistenceType = (byte)4;
                    } else if (this.type == Collection.class || this.type == Set.class) {
                        String valueTypeName = null;
                        if (this.peer != null && !this.peer.isMany()) {
                            this.peer = null;
                        }
                        if (this.peer != null) {
                            PrimaryKeyContext context = entity.getPackage().getPeer(this.peer, container);
                            if (context instanceof EntityBeanDescriptor) {
                                valueTypeName = ((EntityBeanDescriptor)context).getLocalInterfaceName() != null ? ((EntityBeanDescriptor)context).getLocalInterfaceName() : ((EntityBeanDescriptor)context).getRemoteInterfaceName();
                            }
                        } else if (parentType != null) {
                            try {
                                Class valueType;
                                Field valueField = parentType.getField(this.getName() + "_type");
                                if (valueField.getType() == Class.class && Modifier.isStatic(valueField.getModifiers()) && (valueType = (Class)valueField.get(null)) != null) {
                                    valueTypeName = valueType.getName();
                                }
                            }
                            catch (NoSuchFieldException e) {
                            }
                            catch (IllegalAccessException e) {
                                // empty catch block
                            }
                        }
                        if (valueTypeName != null) {
                            this.orMapping = new CollectionORMapping(this, type == Set.class ? 7 : 8);
                            this.orMapping.setValueTypeName(valueTypeName);
                            this.orMapping.peer = this.peer;
                            if (this.type == Set.class) {
                                this.persistenceType = (byte)7;
                            } else if (this.type == Collection.class) {
                                this.persistenceType = (byte)8;
                            }
                        }
                    }
                }
                if (this.persistenceType == 0) {
                    this.persistenceType = 1;
                }
                if (this.persistenceType == 7) break block52;
                if (this.persistenceType != 8) break block53;
            }
            this.orMapping.peer = this.getPeer();
            if (this.persistenceType == 7) {
                if (this.type != Set.class && this.type != Collection.class) {
                    throw new InstantiationException("<set-mapping> can only be used on the type java.util.Set or java.util.Collection (not " + type.getName() + ")");
                }
            } else if (this.persistenceType == 8 && this.type != Collection.class) {
                throw new InstantiationException("<collection-mapping> can only be used on the type java.util.Collection (not " + type.getName() + ")");
            }
            this.orMapping.peer.getPeer().getRelation().getResolved().orMapping = this.orMapping;
            ContainerManagedField resolved = this.orMapping.peer.getRelation().getResolved();
            resolved = ((EntityBeanDescriptor)resolved.owner).getContainerManagedField(resolved.getName(), resolved.owner);
            this.orMapping.peer.getRelation().setResolved(resolved);
            if (resolved.owner.getPrimaryKey() == null) {
                ((EntityBeanDescriptor)resolved.owner).getPrimaryKey(container, schema);
            }
            if (resolved.orMapping == null) {
                try {
                    Class ownerType = ((BeanDescriptor)((Object)resolved.owner)).getEJBClass();
                    Class resolvedType = ((EntityBeanDescriptor)resolved.owner).isCMP2_0() ? ((EntityBeanDescriptor)resolved.owner).getPropertyType(resolved.getName(), resolved) : ownerType.getField(resolved.getName()).getType();
                    resolved.init(container, nameMapper, schema, ownerType, resolvedType);
                }
                catch (NoSuchFieldException e) {
                    throw new InstantiationException("\ncmr-field '" + resolved.getName() + "' not found in class " + ((BeanDescriptor)((Object)resolved.owner)).getEJBClassName());
                }
            }
            this.orMapping.init(this, container, nameMapper, schema, null);
        }
        if (this.persistenceType == 4) {
            this.initializeEJBReferenceHome(container);
        } else if (this.persistenceType == 2) {
            this.initProperties(container);
        } else if (this.persistenceType == 3) {
            Field[] descriptors = type.getFields();
            if (this.propertyFields == null) {
                this.propertyFields = new TreeSet();
            }
            for (int i = 0; i < descriptors.length; ++i) {
                Field descriptor = descriptors[i];
                if (Modifier.isStatic(descriptor.getModifiers()) || !Modifier.isPublic(descriptor.getModifiers()) || Modifier.isFinal(descriptor.getModifiers())) continue;
                ContainerManagedField field = this.getPropertyField(descriptor.getName());
                if (field == null) {
                    ContainerManagedField cmf;
                    field = new ContainerManagedField(this, this.owner, descriptor.getName());
                    String aDatabaseName = null;
                    if (field.parent != null && field.parent.parent != null && field.parent.parent.isCMR()) {
                        aDatabaseName = field.parent.parent.getName() + "_" + descriptor.getName();
                        field.setDatabaseName(aDatabaseName);
                        ((EntityBeanDescriptor)field.owner).addFieldToMap(descriptor.getName(), aDatabaseName);
                    } else if (field.parent != null && field.parent.parent != null) {
                        if (this.parent.orMapping != null) {
                            ContainerManagedField aKeyField = this.parent.orMapping.getKeyField();
                            ContainerManagedField aValueField = this.parent.orMapping.getValueField();
                            if (aKeyField == this.parent) {
                                if (this.parent.orMapping.isOneToManyBiSlave()) {
                                    EntityBeanDescriptor aPeerDescriptor = this.parent.orMapping.getPeerDescriptor();
                                    aDatabaseName = (String)aPeerDescriptor.getFieldsMap().get(descriptor.getName());
                                } else {
                                    aDatabaseName = this.parent.getName() + "_" + descriptor.getName();
                                }
                                field.setDatabaseName(aDatabaseName);
                            } else if (aValueField == this.parent) {
                                aDatabaseName = this.parent.getORMapping().isOneToManyBiSlave() ? descriptor.getName() : this.parent.getName() + "_" + descriptor.getName();
                                field.setDatabaseName(aDatabaseName);
                            }
                        }
                    } else {
                        aDatabaseName = (String)((EntityBeanDescriptor)field.owner).getFieldsMap().get(descriptor.getName());
                        field.setDatabaseName(aDatabaseName);
                    }
                    if (field.databaseName == null && (cmf = ((EntityBeanDescriptor)this.owner).getContainerManagedField(descriptor.getName(), this.owner)) != null && field.databaseName == null) {
                        aDatabaseName = cmf.getDatabaseName();
                        ((EntityBeanDescriptor)field.owner).addFieldToMap(descriptor.getName(), aDatabaseName);
                        field.setDatabaseName(aDatabaseName);
                    }
                }
                field.init(container, nameMapper, schema, this.getType(), descriptor.getType());
                field.setFieldDescriptor(descriptor);
                this.propertyFields.add(field);
            }
        }
        if (this.persistenceType == 3 && (this.getName().trim().equals("") || this.getName() == null) && this.isPrimaryKey() && !this.isCompositePrimaryKey()) {
            throw new InstantiationException("A primary key cmp-field of type '" + this.getType().getName() + "' does not have a name. It is possible that 'primkey-field' element in ejb-jar.xml was not specified.");
        }
        if (this.persistenceType == 3 || this.persistenceType == 2) {
            try {
                this.getType().getConstructor(ClassUtils.CLASS_NOARGS);
            }
            catch (NoSuchMethodException e) {
                throw new InstantiationException("cmp-field of type '" + this.getType().getName() + "' does not have a no-arg constructor which is needed for properties/fields based mapping");
            }
        }
        this.checkName(this.schema);
        this.initialized = true;
    }

    private void initializeDatabaseName(EJBDeploymentContext container) throws InstantiationException {
        if (this.databaseName != null) {
            return;
        }
        if (this.getName().equals("")) {
            return;
        }
        String aDatabaseFieldName = null;
        try {
            if (this.isPrimaryKey() && this.databaseName == null && this.getEntity().isAutomaticIdentity()) {
                aDatabaseFieldName = "autoid";
            } else if (this.isCMR() && this.databaseName == null) {
                EntityBeanDescriptor aPeerDescriptor = (EntityBeanDescriptor)this.getEntity().getPackage().getBean(this.peer.getRoleSource().getName());
                ContainerManagedField aPeerPrimaryKey = aPeerDescriptor.getPrimaryKey(container, this.schema);
                String peerPrimaryKeyName = aPeerPrimaryKey.getDatabaseName();
                if (this.getEntity().getFieldsMap().contains(this.getName())) {
                    aDatabaseFieldName = (String)this.getEntity().getFieldsMap().get(this.getName());
                    this.setDatabaseName(aDatabaseFieldName);
                    return;
                }
                aDatabaseFieldName = this.getName() + "_" + peerPrimaryKeyName;
            }
            if (this.databaseName == null && aDatabaseFieldName == null) {
                if (this.getEntity().getFieldsMap().contains(this.getName())) {
                    aDatabaseFieldName = (String)this.getEntity().getFieldsMap().get(this.getName());
                    this.setDatabaseName(aDatabaseFieldName);
                    return;
                }
                aDatabaseFieldName = this.getName();
            }
            this.getEntity().addFieldToMap(this.getName(), aDatabaseFieldName);
            this.setDatabaseName(aDatabaseFieldName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InstantiationException(e.getMessage());
        }
    }

    public void setEJBReferenceHome(String homeName) {
        this.ejbReferenceHome = homeName;
    }

    public boolean initializeEJBReferenceHome(EJBDeploymentContext container) throws InstantiationException {
        BeanDescriptor genericFieldBean;
        if (this.ejbReferenceHome != null) {
            genericFieldBean = container.getBeanByLocation(this.ejbReferenceHome);
        } else {
            Collection result = container.getBeansByInterface(null, this.type.getName(), "Entity", null, EJBLocalObject.class.isAssignableFrom(this.type));
            genericFieldBean = !result.isEmpty() ? (BeanDescriptor)result.iterator().next() : null;
        }
        if (genericFieldBean instanceof EntityBeanDescriptor) {
            EntityBeanDescriptor fieldBean = (EntityBeanDescriptor)genericFieldBean;
            this.ejbReferenceHome = fieldBean.getLocation();
            if (this.ejbReferenceField == null) {
                this.ejbReferenceField = new ContainerManagedField(this, this.owner, this.getName());
                if (this.databaseName != null) {
                    this.ejbReferenceField.setDatabaseName(this.getDatabaseName());
                }
            }
            if (fieldBean.getPrimaryKeyFieldName() == null && !fieldBean.isAutomaticIdentity()) {
                this.ejbReferenceField.setPersistenceType(3);
            }
            fieldBean.setDataSourceName(container.getProperCMTSourceName(fieldBean.getDataSourceName()));
            DatabaseSchema itsSchema = container.getDatabaseSchema(fieldBean.getDataSourceName());
            this.ejbReferenceField.init(container, this.nameMapper, this.schema, null, fieldBean.getPrimaryKey(container, itsSchema).getType());
            return true;
        }
        this.persistenceType = 1;
        return false;
    }

    protected void removeUnusedPropertyFields() {
        Iterator iterator = this.propertyFields.iterator();
        while (iterator.hasNext()) {
            if (((ContainerManagedField)iterator.next()).getType() != null) continue;
            iterator.remove();
        }
    }

    public void setPersistenceType(int persistenceType) {
        this.persistenceType = this.explicitPersistenceType = (byte)persistenceType;
        if (this.persistenceType == -1) {
            this.databaseType = "[NONE]";
        }
        this.firePropertyChangeEvent("persistenceType", null, null);
    }

    public ContainerManagedField getPropertyField(String name) {
        if (this.propertyFields == null) {
            return null;
        }
        Iterator iterator = this.propertyFields.iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    protected void setType(Class fieldType) {
        this.type = fieldType;
    }

    public static String getDatabaseType(Class fieldType, boolean primaryKey, DatabaseSchema schema) throws CompilationException {
        String nullPart = primaryKey ? schema.getNotNull() : schema.getNull();
        if (Boolean.class == fieldType || Boolean.TYPE == fieldType) {
            nullPart = "";
        }
        try {
            return DatabaseSchema.getDatabaseType(fieldType) + (nullPart.equals("") ? "" : " " + nullPart);
        }
        catch (InstantiationException e) {
            throw new CompilationException(e.getMessage());
        }
    }

    public String getName() {
        return super.getName();
    }

    private boolean isCompoundPKeyField() {
        if (this.isCompoundPKeyFieldFlag == null) {
            this.isCompoundPKeyFieldFlag = this.parent != null && !this.parent.getName().equalsIgnoreCase("") && !this.getName().equalsIgnoreCase("") && !this.getName().equalsIgnoreCase(this.parent.getName()) && this.parent.propertyFields != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.isCompoundPKeyFieldFlag == Boolean.TRUE;
    }

    public String getCanonicalName() {
        if (this.isCompoundPKeyField()) {
            if (this.parent != null && this.parent.parent != null && this.parent.parent.getORMapping() != null && (this.parent.parent.getORMapping().isManyToMany() || this.parent.parent.getORMapping().isOneToMany() && ORMapping.ASSOC_TABLES_USER_PREF)) {
                return ContainerManagedField.getAssocTableFieldCanonicalName(((EntityBeanDescriptor)this.getOwner()).getName(), this.parent.getName(), this.getName());
            }
            if (this.parent.propertyFields.size() == 1) {
                return this.parent.getName();
            }
            return this.parent.getName() + "_" + this.getName();
        }
        return this.getName();
    }

    public static String getAssocTableFieldCanonicalName(String beanname, String cmrname, String pkname) {
        return "" + beanname + "_" + pkname;
    }

    public String getPureName() {
        String _name = this.getName();
        if (_name.startsWith(this.getEJBReferenceHome() + "_")) {
            return _name.substring(this.getEJBReferenceHome().length() + 1);
        }
        return _name;
    }

    public String getDatabaseColumnAlias() {
        return this.databaseColumnAlias;
    }

    public void setDatabaseColumnAlias(String databaseColumnAlias) {
        this.databaseColumnAlias = databaseColumnAlias;
    }

    public String getDatabaseName() {
        if (this.databaseName == null) {
            if (this.getName() == null) {
                throw new InternalError("Unnamed field: " + this);
            }
            this.getEntity().addFieldToMap(this.getName(), this.getName());
            this.setDatabaseName(this.getName());
        }
        return this.databaseName;
    }

    public String getSetDatabaseTypeX() {
        String _databaseType = this.getSetDatabaseType();
        String _prefix = _databaseType.substring(0, 4).toUpperCase();
        if (_prefix.equals("CLOB") || _prefix.equals("BLOB")) {
            return _prefix;
        }
        return _databaseType;
    }

    public String getSetDatabaseType() {
        return this.databaseType;
    }

    public Class getType() {
        return this.type;
    }

    private String getTableName() {
        if (this.getEntity() != null) {
            return this.getEntity().getTableName();
        }
        return null;
    }

    public int getColumnLength() {
        return this.columnLength;
    }

    public void setColumnLength(int val) {
        this.columnLength = val;
    }

    public String getColumnType() {
        if (this.columnType == null) {
            if (this.databaseType == null) {
                return null;
            }
            int idx = this.databaseType.indexOf("(");
            if (idx == -1) {
                this.columnType = this.databaseType.trim().toUpperCase();
            } else {
                String dType = this.databaseType;
                if ((dType = dType.trim().toUpperCase()).startsWith("TIMESTAMP")) {
                    if (dType.endsWith("WITH LOCAL TIME ZONE")) {
                        this.columnType = "TIMESTAMP WITH LOCAL TIME ZONE";
                        return this.columnType;
                    }
                    if (dType.endsWith("WITH TIME ZONE")) {
                        this.columnType = "TIMESTAMP WITH TIME ZONE";
                        return this.columnType;
                    }
                }
                this.columnType = this.databaseType.substring(0, this.databaseType.indexOf("(")).trim().toUpperCase();
            }
        }
        return this.columnType;
    }

    public String getDefinedType() {
        String atype = null;
        try {
            atype = DatabaseSchema.getDatabaseDefinedType(this.type);
        }
        catch (InstantiationException instexc) {
            System.err.println("Unknown JDBC sql define-type for field " + this.getName() + ": " + this.getPersistenceType());
        }
        return atype;
    }

    public void setColumnType(String val) {
        this.columnType = val;
    }

    public void writeXML(PrintWriter out, String indention) {
        if (this.relationshipRole == null) {
            out.println(indention + "<cmp-field>");
            if (this.getDescription() != null) {
                out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
            }
            if (this.getName() != null) {
                out.println(indention + "\t<field-name>" + XMLUtils.encode(this.getName()) + "</field-name>");
            }
            out.println(indention + "</cmp-field>");
        }
    }

    public void parseOrionXML(Node parent, EJBPackage ejbPackage) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        String databaseName = XMLUtils.getNodeAttribute(parent, "persistence-name");
        if (databaseName != null) {
            this.setDatabaseName(databaseName);
        }
        this.databaseType = XMLUtils.getNodeAttribute(parent, "persistence-type");
        this.ejbReferenceHome = XMLUtils.getNodeAttribute(parent, "ejb-reference-home");
        boolean aShared = Boolean.valueOf(XMLUtils.getNodeAttribute(parent, "shared"));
        if (aShared) {
            this.setShared(aShared);
        }
        this.lazyLoading = XMLUtils.getBooleanNodeAttribute(parent, "load-lazily") == 1;
        String oneToOneJoin = XMLUtils.getNodeAttribute(parent, "one-to-one-join");
        if (oneToOneJoin != null) {
            this.setOneToOneOption(new OneToOneOptionDescriptor(oneToOneJoin));
        }
        if (this.databaseType != null && this.databaseType.equalsIgnoreCase("[NONE]")) {
            this.setPersistenceType(-1);
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            String value = XMLUtils.getStringValue(node);
            if (name.equals("persistence-type")) {
                this.databaseType = value;
                continue;
            }
            if (name.equals("persistence-name")) {
                this.setDatabaseName(value);
                continue;
            }
            if (name.equals("ejb-reference-home")) {
                this.ejbReferenceHome = value;
                continue;
            }
            if (name.equals("collection-mapping") && this.orMapping == null) {
                this.orMapping = new CollectionORMapping(node, this, 8, ejbPackage);
                this.persistenceType = (byte)8;
                continue;
            }
            if (name.equals("set-mapping") && this.orMapping == null) {
                this.orMapping = new CollectionORMapping(node, this, 7, ejbPackage);
                this.persistenceType = (byte)7;
                continue;
            }
            if (name.equals("properties")) {
                this.parsePropertyFields(node, false, ejbPackage);
                continue;
            }
            if (name.equals("fields")) {
                this.parsePropertyFields(node, true, ejbPackage);
                continue;
            }
            if (name.equals("entity-ref")) {
                this.parseEntityReference(node, ejbPackage);
                continue;
            }
            if (!name.equals("field-persistence-manager")) continue;
            this.parsePersistenceManagerNode(node, ejbPackage);
        }
    }

    public void parsePersistenceManagerNode(Node parent, EJBPackage ejbPackage) throws InstantiationException {
        String className = XMLUtils.getNodeAttribute(parent, "class");
        if (className == null) {
            throw new InstantiationException("No class attribute specified for field-persistence-manager tag");
        }
        try {
            NodeList list;
            Class<?> type = Class.forName(className, true, ejbPackage.getEJBClassLoader());
            Properties properties = new Properties();
            properties.put("name", this.getName());
            String databaseType = this.getSetDatabaseType();
            if (this.getDatabaseName() != null) {
                properties.put("persistenceName", this.getDatabaseName());
            }
            if (databaseType != null) {
                properties.put("persistenceType", databaseType);
            }
            if ((list = parent.getChildNodes()) != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    Node node = list.item(i);
                    if (XMLUtils.isCommentOrID(node.getNodeName()) || !node.getNodeName().equals("property")) continue;
                    String name = XMLUtils.getNodeAttribute(node, "name");
                    String value = XMLUtils.getNodeAttribute(node, "value");
                    if (name == null) {
                        throw new InstantiationException("property tag with missing name attribute");
                    }
                    if (value == null) {
                        throw new InstantiationException("property tag '" + name + "' is missing a value attribute");
                    }
                    properties.setProperty(name, value);
                }
            }
            if (!FieldPersistenceManager.class.isAssignableFrom(type)) {
                throw new InstantiationException("Class '" + className + "' was not a com.evermind.server.ejb.FieldPersistenceManager");
            }
            try {
                FieldPersistenceManager manager = (FieldPersistenceManager)type.newInstance();
                manager.init(properties);
                this.persistenceManager = manager;
            }
            catch (InstantiationException e) {
                throw new InstantiationException("Error initializing field-persistence-manager for cmp-field '" + this.getName() + "': " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new InstantiationException("Unable to instantiate field-persistence-manager '" + className + "': " + e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException("Unable to find field-persistence-manager class '" + className + "'");
        }
    }

    public void parseEntityReference(Node parent, EJBPackage ejbPackage) throws InstantiationException {
        this.persistenceType = (byte)4;
        Node node = XMLUtils.getSubnode(parent, "cmp-field-mapping");
        this.ejbReferenceHome = XMLUtils.getNodeAttribute(parent, "home");
        if (node != null) {
            ContainerManagedField field = new ContainerManagedField(this, this.owner, XMLUtils.getNodeAttribute(node, "name"));
            field.parseOrionXML(node, ejbPackage);
            if (field.getName() == null) {
                throw new InstantiationException("Missing 'name' attribute in <cmp-field-mapping> tag");
            }
            if (this.databaseName == null && field.databaseName != null) {
                this.databaseName = field.databaseName;
            }
            this.ejbReferenceField = field;
        }
    }

    public void parsePropertyFields(Node parent, boolean fields, EJBPackage ejbPackage) throws InstantiationException {
        this.persistenceType = (byte)(fields ? 3 : 2);
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                if (name == null || XMLUtils.isCommentOrID(name) || !name.equals("cmp-field-mapping")) continue;
                if (this.propertyFields == null) {
                    this.propertyFields = new TreeSet();
                }
                ContainerManagedField field = new ContainerManagedField(this, this.owner, XMLUtils.getNodeAttribute(node, "name"));
                field.parseOrionXML(node, ejbPackage);
                if (field.getName() == null) {
                    throw new InstantiationException("Missing 'name' attribute in <cmp-field-mapping> tag");
                }
                this.propertyFields.add(field);
            }
        }
    }

    public void writeOrionXML(PrintWriter out, String indention) throws IOException {
        if (this.isOCA()) {
            return;
        }
        out.print(indention + "<cmp-field-mapping");
        if (this.getName() != null && !this.getName().equals("")) {
            out.print(" name=\"" + XMLUtils.encode(this.getName()) + "\"");
        }
        if (this.isShared()) {
            out.print(" shared=\"" + String.valueOf(this.isShared()) + "\"");
        }
        if ((this.persistenceType == 1 || this.persistenceType == 0) && this.getDatabaseName() != null) {
            out.print(" persistence-name=\"" + XMLUtils.encode(this.getDatabaseName()) + "\"");
        }
        if (this.getPersistenceType() == -1) {
            out.print(" persistence-type=\"[NONE]\"");
        } else if (this.getSetDatabaseType() != null) {
            out.print(" persistence-type=\"" + XMLUtils.encode(this.getSetDatabaseType()) + "\"");
        }
        if (this.persistenceManager != null) {
            out.println(">");
            Properties properties = this.persistenceManager.getProperties();
            out.print(indention + "\t<field-persistence-manager class=\"" + this.persistenceManager.getClass().getName() + "\"");
            if (properties != null) {
                if ((properties = (Properties)properties.clone()).get("persistenceType") != null) {
                    this.setDatabaseType(properties.getProperty("persistenceType"));
                    properties.remove("persistenceType");
                }
                properties.remove("name");
                if (properties.get("persistenceName") != null) {
                    this.setDatabaseName(properties.getProperty("persistenceName"));
                    properties.remove("persistenceName");
                }
            }
            if (properties != null && !properties.isEmpty()) {
                out.println(">");
                Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, Object> entry = iterator.next();
                    out.println(indention + "\t\t<property name=\"" + XMLUtils.encode(entry.getKey().toString()) + "\" value=\"" + XMLUtils.encode(entry.getValue().toString()) + "\" />");
                }
                out.println(indention + "\t</field-persistence-manager>");
            } else {
                out.println(" />");
            }
            out.println(indention + "</cmp-field-mapping>");
        } else if (this.ejbReferenceHome != null) {
            if (this.isOneToOne() && !this.getOneToOneOption().isJoined()) {
                out.println(" one-to-one-join=\"" + this.getOneToOneOption() + "\"");
            }
            out.println(">");
            out.println(indention + "\t<entity-ref home=\"" + XMLUtils.encode(this.ejbReferenceHome) + "\">");
            this.ejbReferenceField.writeOrionXML(out, indention + "\t\t");
            out.println(indention + "\t</entity-ref>");
            out.println(indention + "</cmp-field-mapping>");
        } else if (this.propertyFields != null) {
            out.println(">");
            out.println(indention + "\t<" + (this.persistenceType == 2 ? "properties" : "fields") + ">");
            Iterator iterator = this.propertyFields.iterator();
            while (iterator.hasNext()) {
                ((ContainerManagedField)iterator.next()).writeOrionXML(out, indention + "\t\t");
            }
            out.println(indention + "\t</" + (this.persistenceType == 2 ? "properties" : "fields") + ">");
            out.println(indention + "</cmp-field-mapping>");
        } else if (this.orMapping != null) {
            out.println(">");
            this.orMapping.writeXML(out, indention + "\t");
            out.println(indention + "</cmp-field-mapping>");
        } else {
            out.println(" />");
        }
    }

    public String toString() {
        return this.owner + "." + this.getName() + ": " + this.databaseName + " " + (this.ejbReferenceField != null ? this.ejbReferenceField.toString() : (this.propertyFields == null ? "" : "{" + this.propertyFields + "}"));
    }

    public String getEJBReferenceHome() {
        return this.ejbReferenceHome;
    }

    public void appendDatabaseDefinition(StringBuffer buffer, TableIteration tableIteration, boolean multiplePK, EJBDeploymentContext container, DatabaseSchema schema, boolean primaryKey) throws CompilationException {
        if (this.persistenceManager != null) {
            Map columns = this.persistenceManager.getColumns();
            if (columns != null) {
                Iterator iterator = columns.entrySet().iterator();
                while (iterator.hasNext()) {
                    String type;
                    Map.Entry entry = iterator.next();
                    String name = entry.getKey().toString();
                    String string = type = entry.getValue() == null ? "" : entry.getValue().toString();
                    if (type.equals("")) {
                        String string2 = this.databaseType == null ? ContainerManagedField.getDatabaseType(this.type, primaryKey, schema) : (type = this.getSetDatabaseType());
                    }
                    if (tableIteration.contains(name, 3)) continue;
                    if (tableIteration.getNextPos(name, 3) != 1) {
                        buffer.append(", ");
                    }
                    if (this.schema != null && this.schema.getUseBrackets()) {
                        buffer.append('[');
                    }
                    buffer.append(name);
                    if (this.schema != null && this.schema.getUseBrackets()) {
                        buffer.append(']');
                    }
                    buffer.append(' ');
                    buffer.append(type);
                    if (!primaryKey || multiplePK) continue;
                    buffer.append(" " + schema.getPrimaryKey());
                }
            }
            return;
        }
        switch (this.persistenceType) {
            case 2: 
            case 3: {
                Iterator iterator = this.propertyFields.iterator();
                while (iterator.hasNext()) {
                    ContainerManagedField field = (ContainerManagedField)iterator.next();
                    field.appendDatabaseDefinition(buffer, tableIteration, multiplePK, container, schema, primaryKey);
                }
                break;
            }
            case -1: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                this.ejbReferenceField.appendDatabaseDefinition(buffer, tableIteration, multiplePK, container, schema, primaryKey);
                break;
            }
            case 1: {
                if (tableIteration.contains(this.getDatabaseName(), 3)) break;
                if (tableIteration.getNextPos(this.getDatabaseName(), 3) != 1) {
                    buffer.append(", ");
                }
                if (this.schema != null && this.schema.getUseBrackets()) {
                    buffer.append('[');
                }
                buffer.append(this.getDatabaseName());
                if (this.schema != null && this.schema.getUseBrackets()) {
                    buffer.append(']');
                }
                buffer.append(' ');
                buffer.append(this.databaseType == null ? ContainerManagedField.getDatabaseType(this.type, primaryKey, schema) : this.getSetDatabaseTypeX());
                if (!primaryKey || multiplePK) break;
                buffer.append(" " + schema.getPrimaryKey());
                break;
            }
            default: {
                throw new CompilationException("Internal error, unset persistence type for " + this.getName() + ": " + this.persistenceType);
            }
        }
    }

    public ORMapping getORMapping() {
        return this.orMapping;
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof ContainerManagedField)) {
            return false;
        }
        ContainerManagedField other = (ContainerManagedField)otherObject;
        return other.getName().equals(this.getName()) && this.owner.equals(other.owner);
    }

    public int hashCode() {
        return this.getName().hashCode() + (this.owner == null ? 0 : this.owner.hashCode());
    }

    public PrimaryKeyContext getContext() {
        return this.owner;
    }

    public void setDatabaseName(String aName) {
        if (aName != null && aName.length() > 30) {
            aName = StringUtils.getShortName(aName, 30);
        }
        this.databaseName = aName;
    }

    public void setFieldDescriptor(Field field) {
        this.fieldDescriptor = field;
    }

    public void setPropertyDescriptor(PropertyDescriptor descriptor) {
        this.propertyDescriptor = descriptor;
    }

    public Field getFieldDescriptor() {
        return this.fieldDescriptor;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public Set getPropertyFields() {
        return this.propertyFields;
    }

    public boolean containLobColumns() {
        switch (this.persistenceType) {
            case 2: 
            case 3: {
                Iterator iterator = this.propertyFields.iterator();
                while (iterator.hasNext()) {
                    ContainerManagedField field = (ContainerManagedField)iterator.next();
                    if (!field.containLobColumns()) continue;
                    return true;
                }
                break;
            }
            case 0: 
            case 1: {
                if (this.getColumnType() != null) {
                    if (!this.getColumnType().equalsIgnoreCase("CLOB") && !this.getColumnType().equalsIgnoreCase("BLOB")) break;
                    return true;
                }
                return this.type != Integer.TYPE && this.type != Character.TYPE && this.type != Short.TYPE && this.type != Long.TYPE && this.type != Float.TYPE && this.type != Double.TYPE && this.type != Byte.TYPE && this.type != Boolean.TYPE && this.type != String.class && this.type != java.util.Date.class && this.type != InternetAddress.class && this.type != Date.class && this.type != Timestamp.class && this.type != Time.class && this.type != BigDecimal.class && this.type != Blob.class && this.type != Clob.class && this.type != Locale.class && this.type != BigInteger.class && this.type != Integer.class && this.type != Character.class && this.type != Short.class && this.type != Long.class && this.type != Float.class && this.type != Double.class && this.type != Byte.class && this.type != Boolean.class;
            }
        }
        return false;
    }

    public void appendLOBVariable(StringBuffer source, Vector _lobVariables) throws CompilationException {
        switch (this.persistenceType) {
            case 2: 
            case 3: {
                Iterator iterator = this.propertyFields.iterator();
                while (iterator.hasNext()) {
                    ContainerManagedField field = (ContainerManagedField)iterator.next();
                    field.appendLOBVariable(source, _lobVariables);
                }
                break;
            }
            case 0: 
            case 1: {
                if (this.getColumnType() == null) break;
                if (this.getColumnType().equalsIgnoreCase("CLOB")) {
                    if (this.type != String.class && this.type != [C.class) break;
                    source.append("oracle.sql.CLOB " + this.getLobVariableName() + " = null;\n");
                    _lobVariables.add(this.getLobVariableName());
                    break;
                }
                if (!this.getColumnType().equalsIgnoreCase("BLOB") || this.type != [B.class) break;
                source.append("oracle.sql.BLOB " + this.getLobVariableName() + " = null;\n");
                _lobVariables.add(this.getLobVariableName());
                break;
            }
        }
    }

    public String getLobVariableName() {
        if (this.getColumnType() != null) {
            return "_" + this.getColumnType() + "_" + this.getName();
        }
        return null;
    }

    public ContainerManagedField getEJBReferenceField() {
        if (this.ejbReferenceField != null) {
            this.ejbReferenceField.setDatabaseColumnAlias(this.databaseColumnAlias);
        }
        return this.ejbReferenceField;
    }

    public void setEJBReferenceField(ContainerManagedField ejbReferenceField) {
        this.ejbReferenceField = ejbReferenceField;
    }

    public void appendFieldNames(StringBuffer buffer, TableIteration tableIteration, int appendMode, boolean writeTableName) throws CompilationException {
        this.appendFieldNames(buffer, tableIteration, appendMode, writeTableName, null, null);
    }

    public void appendFieldNames(StringBuffer buffer, TableIteration tableIteration, int appendMode, boolean writeTableName, String anAliasName, String aTableName) throws CompilationException {
        block1 : switch (this.persistenceType) {
            case 2: 
            case 3: {
                Iterator iterator = this.propertyFields.iterator();
                while (iterator.hasNext()) {
                    ContainerManagedField field = (ContainerManagedField)iterator.next();
                    field.appendFieldNames(buffer, tableIteration, appendMode, writeTableName, anAliasName, aTableName);
                }
                break;
            }
            case -1: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                this.getEJBReferenceField().appendFieldNames(buffer, tableIteration, appendMode, writeTableName, anAliasName, aTableName);
                break;
            }
            case 0: 
            case 1: {
                String aComposedColumnName;
                String string = aComposedColumnName = this.getTableName() != null ? this.getTableName() + "." + this.getDatabaseName() : this.getDatabaseName();
                if (tableIteration.contains(aComposedColumnName, 4)) break;
                if (tableIteration.getNextPos(aComposedColumnName, 4) != 1) {
                    buffer.append(appendMode == 3 ? " and " : ", ");
                }
                switch (appendMode) {
                    case 0: {
                        if (writeTableName) {
                            if (this.schema != null && this.schema.getUseBrackets()) {
                                buffer.append('[');
                            }
                            if (anAliasName == null) {
                                if (aTableName == null) {
                                    buffer.append(this.owner.getTableName());
                                } else {
                                    buffer.append(aTableName);
                                }
                            } else {
                                buffer.append(anAliasName);
                            }
                            if (this.schema != null && this.schema.getUseBrackets()) {
                                buffer.append(']');
                            }
                            buffer.append('.');
                        }
                        if (this.schema != null && this.schema.getUseBrackets()) {
                            buffer.append('[');
                        }
                        buffer.append(this.getDatabaseName());
                        if (this.schema != null && this.schema.getUseBrackets()) {
                            buffer.append(']');
                        }
                        if (this.databaseColumnAlias == null) break block1;
                        buffer.append(" as " + this.createDatabaseColumnAlias());
                        break block1;
                    }
                    case 1: {
                        buffer.append("?");
                        break block1;
                    }
                    case 2: 
                    case 3: {
                        if (writeTableName && this.databaseColumnAlias == null) {
                            if (aTableName == null) {
                                buffer.append(this.owner.getTableName());
                            } else {
                                buffer.append(aTableName);
                            }
                            buffer.append('.');
                        }
                        if (this.databaseColumnAlias != null) {
                            buffer.append(this.createDatabaseColumnAlias());
                        } else {
                            buffer.append(this.getDatabaseName());
                        }
                        buffer.append(" = ?");
                        break block1;
                    }
                    case 4: {
                        try {
                            buffer.append(DatabaseSchema.getDatabaseDefinedType(this.type));
                            break block1;
                        }
                        catch (InstantiationException instexc) {
                            throw new CompilationException("Unknown JDBC sql define-type for field " + this.getName() + ": " + this.getPersistenceType());
                        }
                    }
                    default: {
                        throw new CompilationException("Internal error: invalid append-mode: " + appendMode);
                    }
                }
            }
            default: {
                throw new CompilationException("Unknown persistence-type for field " + this.getName() + ": " + this.getPersistenceType());
            }
        }
    }

    public String createDatabaseColumnAlias() {
        String alias = this.databaseColumnAlias + "_" + this.getDatabaseName();
        if (alias.length() > 30) {
            alias = StringUtils.getShortName(alias, 30);
        }
        return alias;
    }

    public int getPersistenceType() {
        return this.persistenceType;
    }

    public int getDatabaseFieldCount() {
        if (this.persistenceManager != null) {
            Map names = this.persistenceManager.getColumns();
            return names == null ? 0 : names.size();
        }
        switch (this.persistenceType) {
            case 2: 
            case 3: {
                int count = 0;
                Iterator iterator = this.propertyFields.iterator();
                while (iterator.hasNext()) {
                    ContainerManagedField field = (ContainerManagedField)iterator.next();
                    count += field.getDatabaseFieldCount();
                }
                return count;
            }
            case 7: 
            case 8: {
                return 0;
            }
            case 4: {
                return this.ejbReferenceField.getDatabaseFieldCount();
            }
            case -1: {
                return 0;
            }
        }
        return 1;
    }

    public String getHashCodeExpression(String name) {
        if (this.propertyFields == null || this.propertyFields.size() == 0) {
            return name + "hashCode()";
        }
        String[] fieldNames = new String[this.propertyFields.size()];
        Class[] fieldTypes = new Class[this.propertyFields.size()];
        Iterator iterator = this.propertyFields.iterator();
        for (int i = 0; i < this.propertyFields.size(); ++i) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            fieldNames[i] = field.getName();
            fieldTypes[i] = field.getType();
        }
        int dotIndex = name.lastIndexOf(46);
        String prefixName = dotIndex < 0 ? name : name.substring(0, dotIndex);
        return prefixName + " == null ? 0 : (" + ClassUtils.getHashCodeExpression(name, fieldNames, fieldTypes) + ")";
    }

    public String getComparationExpression(String nameA, String nameB) {
        String[] fieldNames = new String[this.propertyFields.size()];
        Class[] fieldTypes = new Class[this.propertyFields.size()];
        Iterator iterator = this.propertyFields.iterator();
        for (int i = 0; i < this.propertyFields.size(); ++i) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            fieldNames[i] = field.getName();
            fieldTypes[i] = field.getType();
        }
        return ClassUtils.getComparationExpression(nameA, nameB, fieldNames, fieldTypes);
    }

    public void setFields(SortedSet fields) {
        this.propertyFields = fields;
        this.persistenceType = (byte)3;
    }

    public void setProperties(SortedSet properties) {
        this.propertyFields = properties;
        this.persistenceType = (byte)2;
    }

    public void setDatabaseType(String type) {
        if (type != null && type.equals("")) {
            type = null;
        }
        this.databaseType = type;
    }

    public boolean appendComparation(StringBuffer buffer, ContainerManagedField other, boolean first, String comparation, String secondTableOverride, boolean useAND) throws CompilationException {
        if (this.getPersistenceType() == 4) {
            return this.getEJBReferenceField().appendComparation(buffer, other, first, comparation, secondTableOverride, useAND);
        }
        if (other != null && other.getPersistenceType() == 4) {
            other = other.getEJBReferenceField();
        }
        if (this.persistenceManager != null) {
            Iterator iterator;
            Map columns = this.persistenceManager.getColumns();
            Iterator iterator2 = iterator = columns == null ? null : columns.keySet().iterator();
            while (iterator != null && iterator.hasNext()) {
                String name = iterator.next().toString();
                if (!first) {
                    if (useAND) {
                        buffer.append(" and ");
                    } else {
                        buffer.append(" or ");
                    }
                }
                buffer.append(this.owner.getTableName() + "." + name);
                buffer.append(' ');
                buffer.append(comparation);
                buffer.append(' ');
                buffer.append("?");
            }
            return first;
        }
        switch (this.persistenceType) {
            case -1: {
                break;
            }
            case 1: {
                if (!first) {
                    buffer.append(" and ");
                }
                buffer.append(this.owner.getTableName() + "." + this.getDatabaseName());
                buffer.append(' ');
                buffer.append(comparation);
                buffer.append(' ');
                if (other == null) {
                    buffer.append("?");
                } else {
                    if (other.getPersistenceType() == 4) {
                        other = other.getEJBReferenceField();
                    }
                    if (other.getPersistenceType() == 3 && other.getPropertyFields().size() == 1) {
                        other = (ContainerManagedField)other.getPropertyFields().iterator().next();
                    }
                    switch (other.getPersistenceType()) {
                        case 1: {
                            buffer.append((secondTableOverride == null ? other.owner.getTableName() : secondTableOverride) + "." + other.getDatabaseName());
                            break;
                        }
                        default: {
                            throw new CompilationException("Illegal comparation type to " + other.getName() + " (" + other.getPersistenceType() + ") (" + other.getPropertyFields() + ")");
                        }
                    }
                }
                return false;
            }
            case 7: 
            case 8: {
                throw new CompilationException("Cannot compare to OR-mapped field");
            }
            case 4: {
                return this.getEJBReferenceField().appendComparation(buffer, other, first, comparation, secondTableOverride, useAND);
            }
            case 2: 
            case 3: {
                if (other != null && other.getPersistenceType() == 4) {
                    other = other.getEJBReferenceField();
                }
                Iterator iterator = this.getPropertyFields().iterator();
                while (iterator.hasNext()) {
                    ContainerManagedField field = (ContainerManagedField)iterator.next();
                    if (other != null) {
                        ContainerManagedField otherProperty;
                        if (other.getPersistenceType() == 4) {
                            other = other.getEJBReferenceField();
                        }
                        if ((otherProperty = other.getPropertyField(field.getName())) == null) {
                            throw new CompilationException("No match found for property field '" + field.getName() + "' in field '" + this.getName() + "' in comparation to field '" + other.getName() + "'");
                        }
                        first = field.appendComparation(buffer, otherProperty, first, comparation, secondTableOverride, useAND);
                        continue;
                    }
                    field.appendComparation(buffer, other, first, comparation, secondTableOverride, useAND);
                    first = false;
                }
                break;
            }
            default: {
                throw new CompilationException("Illegal comparation type for field " + this.getName());
            }
        }
        return first;
    }

    public PrimaryKeyContext getOwner() {
        return this.owner;
    }

    public EntityBeanDescriptor getEntity() {
        ContainerManagedField field = this;
        while (field.parent != null) {
            field = field.parent;
        }
        if (field.owner instanceof EntityBeanDescriptor) {
            return (EntityBeanDescriptor)this.owner;
        }
        return null;
    }

    public EJBRelationshipRole getPeer() {
        if (this.relationshipRole != null) {
            return this.relationshipRole.getPeer();
        }
        if (this.peer != null) {
            return this.peer;
        }
        if (this.owner instanceof EntityBeanDescriptor && (this.parent == null || this.parent == ((EntityBeanDescriptor)this.owner).getPrimaryKey())) {
            return ((EntityBeanDescriptor)this.owner).getPackage().getPeer((EntityBeanDescriptor)this.owner, this.getName());
        }
        return null;
    }

    public FieldPersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    public String getCompoundName() {
        if (this.parent != null) {
            return this.parent.getCompoundName() + ":" + this.getName();
        }
        return this.getName();
    }

    public int compareTo(Object other) {
        if (other instanceof ContainerManagedField) {
            ContainerManagedField otherField = (ContainerManagedField)other;
            if (this.getName() == null) {
                return otherField.getName() == null ? 0 : -1;
            }
            return otherField.getName() == null ? 1 : this.getName().compareTo(otherField.getName());
        }
        return 0;
    }

    public void initProperties(EJBDeploymentContext container) throws InstantiationException {
        try {
            if (this.propertyFields == null) {
                this.propertyFields = new TreeSet();
            }
            BeanInfo info = Introspector.getBeanInfo(this.type);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                PropertyDescriptor descriptor = descriptors[i];
                if (descriptor.getReadMethod() == null || descriptor.getWriteMethod() == null) continue;
                ContainerManagedField field = this.getPropertyField(descriptor.getName());
                if (field == null) {
                    field = new ContainerManagedField(this, this.owner, descriptor.getName());
                    this.propertyFields.add(field);
                }
                field.init(container, this.nameMapper, this.schema, this.getType(), descriptor.getPropertyType());
                field.setPropertyDescriptor(descriptor);
            }
        }
        catch (IntrospectionException e) {
            throw (InstantiationException)new InstantiationException("Error introspecting bean properties: " + e.getMessage()).initCause(e);
        }
        finally {
            Introspector.flushFromCaches(this.type);
        }
        this.removeUnusedPropertyFields();
    }

    public void setEJBRelationshipRole(EJBRelationshipRole role) {
        this.relationshipRole = role;
    }

    public EJBRelationshipRole getEJBRelationshipRole() {
        return this.relationshipRole;
    }

    public boolean isPersistedToAssociationTable() {
        if (!this.isCMR()) {
            return false;
        }
        if (this.isSynthetic()) {
            return false;
        }
        if (this.isManyToMany()) {
            return true;
        }
        return ORMapping.ASSOC_TABLES_USER_PREF && (this.isOneToMany_One() || this.isOneToMany_Many());
    }

    public boolean isSynthetic() {
        return this.relationshipRole != null && this.relationshipRole.getRelation() != null && this.relationshipRole.getRelation().isSynthetic();
    }

    public boolean hasCompositePrimaryKeys() {
        return this.getEJBReferenceField() != null && this.getEJBReferenceField().propertyFields != null && !this.getEJBReferenceField().propertyFields.isEmpty();
    }

    public boolean containsFieldMappedWith(String aDatabaseName) {
        if (this.getPropertyFields() == null) {
            return false;
        }
        Iterator iterator = this.getPropertyFields().iterator();
        while (iterator.hasNext()) {
            ContainerManagedField aField = (ContainerManagedField)iterator.next();
            String dbName = aField.getDatabaseName();
            if (dbName == null) {
                return false;
            }
            if (!dbName.equalsIgnoreCase(aDatabaseName)) continue;
            return true;
        }
        return false;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean aShared) {
        this.shared = aShared;
    }

    public boolean isLazyLoading() {
        return this.lazyLoading;
    }

    public boolean isOCA() {
        return this.isOCA;
    }

    public void isOCA(boolean b) {
        this.isOCA = b;
    }

    public String getPeerName() {
        RoleSource rs;
        EJBRelationshipRole p = this.getPeer();
        if (p != null && (rs = p.getRoleSource()) != null) {
            return rs.getName();
        }
        return null;
    }

    protected String internalGetDatabaseName() {
        return this.databaseName;
    }

    public OneToOneOptionDescriptor getOneToOneOption() {
        return this.oneToOneOption;
    }

    public void setOneToOneOption(OneToOneOptionDescriptor newOneToOneOption) {
        this.oneToOneOption = newOneToOneOption;
    }
}

